/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public class RayTraceContext {
    private final Vector3d field_222254_a;
    private final Vector3d field_222255_b;
    private final BlockMode field_222256_c;
    private final FluidMode field_222257_d;
    private final ISelectionContext field_222258_e;

    public RayTraceContext(Vector3d vector3d, Vector3d vector3d2, BlockMode blockMode, FluidMode fluidMode, Entity entity) {
        this.field_222254_a = vector3d;
        this.field_222255_b = vector3d2;
        this.field_222256_c = blockMode;
        this.field_222257_d = fluidMode;
        this.field_222258_e = ISelectionContext.func_216374_a(entity);
    }

    public Vector3d func_222250_a() {
        return this.field_222255_b;
    }

    public Vector3d func_222253_b() {
        return this.field_222254_a;
    }

    public VoxelShape func_222251_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return this.field_222256_c.get(blockState, iBlockReader, blockPos, this.field_222258_e);
    }

    public VoxelShape func_222252_a(FluidState fluidState, IBlockReader iBlockReader, BlockPos blockPos) {
        return this.field_222257_d.func_222248_a(fluidState) ? fluidState.func_215676_d(iBlockReader, blockPos) : VoxelShapes.func_197880_a();
    }

    public static enum FluidMode {
        NONE(fluidState -> false),
        SOURCE_ONLY(FluidState::func_206889_d),
        ANY(fluidState -> !fluidState.func_206888_e());

        private final Predicate<FluidState> field_222249_d;

        private FluidMode(Predicate<FluidState> predicate) {
            this.field_222249_d = predicate;
        }

        public boolean func_222248_a(FluidState fluidState) {
            return this.field_222249_d.test(fluidState);
        }
    }

    public static interface IVoxelProvider {
        public VoxelShape get(BlockState var1, IBlockReader var2, BlockPos var3, ISelectionContext var4);
    }

    public static enum BlockMode implements IVoxelProvider
    {
        COLLIDER(AbstractBlock.AbstractBlockState::func_215685_b),
        OUTLINE(AbstractBlock.AbstractBlockState::func_215700_a),
        VISUAL(AbstractBlock.AbstractBlockState::func_199611_f);

        private final IVoxelProvider field_222245_c;

        private BlockMode(IVoxelProvider iVoxelProvider) {
            this.field_222245_c = iVoxelProvider;
        }

        @Override
        public VoxelShape get(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
            return this.field_222245_c.get(blockState, iBlockReader, blockPos, iSelectionContext);
        }
    }
}

