/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.SaveFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldOptimizer {
    private static final Logger field_212219_a = LogManager.getLogger();
    private static final ThreadFactory field_212220_b = new ThreadFactoryBuilder().setDaemon(true).build();
    private final ImmutableSet<RegistryKey<World>> field_233529_c_;
    private final boolean field_219957_d;
    private final SaveFormat.LevelSave field_212221_c;
    private final Thread field_212223_e;
    private final DataFixer field_233530_g_;
    private volatile boolean field_212224_f = true;
    private volatile boolean field_212225_g;
    private volatile float field_212232_n;
    private volatile int field_212233_o;
    private volatile int field_212234_p;
    private volatile int field_212235_q;
    private final Object2FloatMap<RegistryKey<World>> field_212544_m = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(Util.func_212443_g()));
    private volatile ITextComponent field_212236_r = new TranslationTextComponent("optimizeWorld.stage.counting");
    private static final Pattern field_219959_p = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final DimensionSavedDataManager field_219960_q;

    public WorldOptimizer(SaveFormat.LevelSave levelSave, DataFixer dataFixer, ImmutableSet<RegistryKey<World>> immutableSet, boolean bl) {
        this.field_233529_c_ = immutableSet;
        this.field_219957_d = bl;
        this.field_233530_g_ = dataFixer;
        this.field_212221_c = levelSave;
        this.field_219960_q = new DimensionSavedDataManager(new File(this.field_212221_c.func_237291_a_(World.field_234918_g_), "data"), dataFixer);
        this.field_212223_e = field_212220_b.newThread(this::func_212216_o);
        this.field_212223_e.setUncaughtExceptionHandler((thread, throwable) -> {
            field_212219_a.error("Error upgrading world", throwable);
            this.field_212236_r = new TranslationTextComponent("optimizeWorld.stage.failed");
            this.field_212225_g = true;
        });
        this.field_212223_e.start();
    }

    public void func_212217_a() {
        this.field_212224_f = false;
        try {
            this.field_212223_e.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void func_212216_o() {
        ImmutableMap.Builder \u26033;
        RegistryKey \u260322;
        this.field_212233_o = 0;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (RegistryKey \u260322 : this.field_233529_c_) {
            \u26033 = this.func_233532_b_(\u260322);
            builder.put((Object)\u260322, \u26033.listIterator());
            this.field_212233_o += \u26033.size();
        }
        if (this.field_212233_o == 0) {
            this.field_212225_g = true;
            return;
        }
        float f = this.field_212233_o;
        \u260322 = builder.build();
        \u26033 = ImmutableMap.builder();
        for (RegistryKey registryKey : this.field_233529_c_) {
            File file = this.field_212221_c.func_237291_a_(registryKey);
            \u26033.put((Object)registryKey, (Object)new ChunkLoader(new File(file, "region"), this.field_233530_g_, true));
        }
        ImmutableMap immutableMap = \u26033.build();
        long \u26034 = Util.func_211177_b();
        this.field_212236_r = new TranslationTextComponent("optimizeWorld.stage.upgrading");
        while (this.field_212224_f) {
            boolean bl = false;
            float \u26035 = 0.0f;
            for (RegistryKey registryKey : this.field_233529_c_) {
                ListIterator listIterator = (ListIterator)\u260322.get(registryKey);
                ChunkLoader \u26036 = (ChunkLoader)immutableMap.get((Object)registryKey);
                if (listIterator.hasNext()) {
                    ChunkPos chunkPos = (ChunkPos)listIterator.next();
                    boolean \u26037 = false;
                    try {
                        CompoundNBT compoundNBT = \u26036.func_227078_e_(chunkPos);
                        if (compoundNBT != null) {
                            boolean bl2;
                            int n = ChunkLoader.func_219165_a(compoundNBT);
                            CompoundNBT \u26038 = \u26036.func_235968_a_(registryKey, () -> this.field_219960_q, compoundNBT);
                            CompoundNBT \u26039 = \u26038.func_74775_l("Level");
                            ChunkPos \u260310 = new ChunkPos(\u26039.func_74762_e("xPos"), \u26039.func_74762_e("zPos"));
                            if (!\u260310.equals(chunkPos)) {
                                field_212219_a.warn("Chunk {} has invalid position {}", (Object)chunkPos, (Object)\u260310);
                            }
                            boolean bl3 = bl2 = n < SharedConstants.func_215069_a().getWorldVersion();
                            if (this.field_219957_d) {
                                bl2 = bl2 || \u26039.func_74764_b("Heightmaps");
                                \u26039.func_82580_o("Heightmaps");
                                bl2 = bl2 || \u26039.func_74764_b("isLightOn");
                                \u26039.func_82580_o("isLightOn");
                            }
                            if (bl2) {
                                \u26036.func_219100_a(chunkPos, \u26038);
                                \u26037 = true;
                            }
                        }
                    }
                    catch (ReportedException reportedException) {
                        Throwable throwable = reportedException.getCause();
                        if (throwable instanceof IOException) {
                            field_212219_a.error("Error upgrading chunk {}", (Object)chunkPos, (Object)throwable);
                        }
                        throw reportedException;
                    }
                    catch (IOException iOException) {
                        field_212219_a.error("Error upgrading chunk {}", (Object)chunkPos, (Object)iOException);
                    }
                    if (\u26037) {
                        ++this.field_212234_p;
                    } else {
                        ++this.field_212235_q;
                    }
                    bl = true;
                }
                float \u260311 = (float)listIterator.nextIndex() / f;
                this.field_212544_m.put((Object)registryKey, \u260311);
                \u26035 += \u260311;
            }
            this.field_212232_n = \u26035;
            if (bl) continue;
            this.field_212224_f = false;
        }
        this.field_212236_r = new TranslationTextComponent("optimizeWorld.stage.finished");
        for (ChunkLoader chunkLoader : immutableMap.values()) {
            try {
                chunkLoader.close();
            }
            catch (IOException iOException) {
                field_212219_a.error("Error upgrading chunk", (Throwable)iOException);
            }
        }
        this.field_219960_q.func_212775_b();
        \u26034 = Util.func_211177_b() - \u26034;
        field_212219_a.info("World optimizaton finished after {} ms", (Object)\u26034);
        this.field_212225_g = true;
    }

    private List<ChunkPos> func_233532_b_(RegistryKey<World> registryKey) {
        File file2 = this.field_212221_c.func_237291_a_(registryKey);
        \u2603 = new File(file2, "region");
        File[] \u26032 = \u2603.listFiles((file, string) -> string.endsWith(".mca"));
        if (\u26032 == null) {
            return ImmutableList.of();
        }
        ArrayList \u26033 = Lists.newArrayList();
        for (File file3 : \u26032) {
            Matcher matcher = field_219959_p.matcher(file3.getName());
            if (!matcher.matches()) continue;
            int \u26034 = Integer.parseInt(matcher.group(1)) << 5;
            int \u26035 = Integer.parseInt(matcher.group(2)) << 5;
            try (RegionFile regionFile = new RegionFile(file3, \u2603, true);){
                for (int i = 0; i < 32; ++i) {
                    for (\u2603 = 0; \u2603 < 32; ++\u2603) {
                        ChunkPos chunkPos = new ChunkPos(i + \u26034, \u2603 + \u26035);
                        if (!regionFile.func_222662_b(chunkPos)) continue;
                        \u26033.add(chunkPos);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return \u26033;
    }

    public boolean func_212218_b() {
        return this.field_212225_g;
    }

    public int func_212211_j() {
        return this.field_212233_o;
    }

    public int func_212208_k() {
        return this.field_212234_p;
    }

    public int func_212209_l() {
        return this.field_212235_q;
    }

    public ITextComponent func_212215_m() {
        return this.field_212236_r;
    }
}

