/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;

public interface ITagCollection<T> {
    public Map<ResourceLocation, ITag<T>> func_241833_a();

    @Nullable
    default public ITag<T> func_199910_a(ResourceLocation resourceLocation) {
        return this.func_241833_a().get(resourceLocation);
    }

    public ITag<T> func_241834_b(ResourceLocation var1);

    @Nullable
    public ResourceLocation func_232973_a_(ITag<T> var1);

    default public ResourceLocation func_232975_b_(ITag<T> iTag) {
        ResourceLocation resourceLocation = this.func_232973_a_(iTag);
        if (resourceLocation == null) {
            throw new IllegalStateException("Unrecognized tag");
        }
        return resourceLocation;
    }

    default public Collection<ResourceLocation> func_199908_a() {
        return this.func_241833_a().keySet();
    }

    default public void func_242203_a(PacketBuffer packetBuffer, DefaultedRegistry<T> defaultedRegistry) {
        Map<ResourceLocation, ITag<T>> map = this.func_241833_a();
        packetBuffer.func_150787_b(map.size());
        for (Map.Entry<ResourceLocation, ITag<T>> entry : map.entrySet()) {
            packetBuffer.func_192572_a(entry.getKey());
            packetBuffer.func_150787_b(entry.getValue().func_230236_b_().size());
            for (T t : entry.getValue().func_230236_b_()) {
                packetBuffer.func_150787_b(defaultedRegistry.func_148757_b(t));
            }
        }
    }

    public static <T> ITagCollection<T> func_242204_a(PacketBuffer packetBuffer, Registry<T> registry) {
        HashMap hashMap = Maps.newHashMap();
        int \u26032 = packetBuffer.func_150792_a();
        for (int i = 0; i < \u26032; ++i) {
            ResourceLocation resourceLocation = packetBuffer.func_192575_l();
            int \u26033 = packetBuffer.func_150792_a();
            ImmutableSet.Builder \u26034 = ImmutableSet.builder();
            for (int j = 0; j < \u26033; ++j) {
                \u26034.add(registry.func_148745_a(packetBuffer.func_150792_a()));
            }
            hashMap.put(resourceLocation, ITag.func_232946_a_(\u26034.build()));
        }
        return ITagCollection.func_242202_a(hashMap);
    }

    public static <T> ITagCollection<T> func_242205_c() {
        return ITagCollection.func_242202_a(ImmutableBiMap.of());
    }

    public static <T> ITagCollection<T> func_242202_a(Map<ResourceLocation, ITag<T>> map) {
        ImmutableBiMap immutableBiMap = ImmutableBiMap.copyOf(map);
        return new ITagCollection<T>((BiMap)immutableBiMap){
            private final ITag<T> field_242207_b = Tag.func_241284_a_();
            final /* synthetic */ BiMap field_242206_a;
            {
                this.field_242206_a = biMap;
            }

            @Override
            public ITag<T> func_241834_b(ResourceLocation resourceLocation) {
                return (ITag)this.field_242206_a.getOrDefault((Object)resourceLocation, this.field_242207_b);
            }

            @Override
            @Nullable
            public ResourceLocation func_232973_a_(ITag<T> iTag) {
                if (iTag instanceof ITag.INamedTag) {
                    return ((ITag.INamedTag)iTag).func_230234_a_();
                }
                return (ResourceLocation)this.field_242206_a.inverse().get(iTag);
            }

            @Override
            public Map<ResourceLocation, ITag<T>> func_241833_a() {
                return this.field_242206_a;
            }
        };
    }
}

