/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Collection;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.CreeperSwellGoal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CreeperEntity
extends MonsterEntity {
    private static final DataParameter<Integer> field_184713_a = EntityDataManager.func_187226_a(CreeperEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184714_b = EntityDataManager.func_187226_a(CreeperEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_184715_c = EntityDataManager.func_187226_a(CreeperEntity.class, DataSerializers.field_187198_h);
    private int field_70834_e;
    private int field_70833_d;
    private int field_82225_f = 30;
    private int field_82226_g = 3;
    private int field_175494_bm;

    public CreeperEntity(EntityType<? extends CreeperEntity> entityType, World world) {
        super((EntityType<? extends MonsterEntity>)entityType, world);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(2, new CreeperSwellGoal(this));
        this.field_70714_bg.func_75776_a(3, new AvoidEntityGoal<OcelotEntity>(this, OcelotEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, new AvoidEntityGoal<CatEntity>(this, CatEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, new MeleeAttackGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, new WaterAvoidingRandomWalkingGoal(this, 0.8));
        this.field_70714_bg.func_75776_a(6, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, new LookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, new HurtByTargetGoal(this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute func_234278_m_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    @Override
    public int func_82143_as() {
        if (this.func_70638_az() == null) {
            return 3;
        }
        return 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    @Override
    public boolean func_225503_b_(float f, float f2) {
        boolean bl = super.func_225503_b_(f, f2);
        this.field_70833_d = (int)((float)this.field_70833_d + f * 1.5f);
        if (this.field_70833_d > this.field_82225_f - 5) {
            this.field_70833_d = this.field_82225_f - 5;
        }
        return bl;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184713_a, -1);
        this.field_70180_af.func_187214_a(field_184714_b, false);
        this.field_70180_af.func_187214_a(field_184715_c, false);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        if (this.field_70180_af.func_187225_a(field_184714_b).booleanValue()) {
            compoundNBT.func_74757_a("powered", true);
        }
        compoundNBT.func_74777_a("Fuse", (short)this.field_82225_f);
        compoundNBT.func_74774_a("ExplosionRadius", (byte)this.field_82226_g);
        compoundNBT.func_74757_a("ignited", this.func_146078_ca());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.field_70180_af.func_187227_b(field_184714_b, compoundNBT.func_74767_n("powered"));
        if (compoundNBT.func_150297_b("Fuse", 99)) {
            this.field_82225_f = compoundNBT.func_74765_d("Fuse");
        }
        if (compoundNBT.func_150297_b("ExplosionRadius", 99)) {
            this.field_82226_g = compoundNBT.func_74771_c("ExplosionRadius");
        }
        if (compoundNBT.func_74767_n("ignited")) {
            this.func_146079_cb();
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int n;
            this.field_70834_e = this.field_70833_d;
            if (this.func_146078_ca()) {
                this.func_70829_a(1);
            }
            if ((n = this.func_70832_p()) > 0 && this.field_70833_d == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.field_70833_d += n;
            if (this.field_70833_d < 0) {
                this.field_70833_d = 0;
            }
            if (this.field_70833_d >= this.field_82225_f) {
                this.field_70833_d = this.field_82225_f;
                this.func_146077_cc();
            }
        }
        super.func_70071_h_();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187570_aq;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    @Override
    protected void func_213333_a(DamageSource damageSource, int n, boolean bl) {
        super.func_213333_a(damageSource, n, bl);
        Entity entity = damageSource.func_76346_g();
        if (entity != this && entity instanceof CreeperEntity && (\u2603 = (CreeperEntity)entity).func_70650_aV()) {
            \u2603.func_175493_co();
            this.func_199703_a(Items.field_196185_dy);
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        return true;
    }

    public boolean func_225509_J__() {
        return this.field_70180_af.func_187225_a(field_184714_b);
    }

    public int func_70832_p() {
        return this.field_70180_af.func_187225_a(field_184713_a);
    }

    public void func_70829_a(int n) {
        this.field_70180_af.func_187227_b(field_184713_a, n);
    }

    @Override
    public void func_241841_a(ServerWorld serverWorld, LightningBoltEntity lightningBoltEntity) {
        super.func_241841_a(serverWorld, lightningBoltEntity);
        this.field_70180_af.func_187227_b(field_184714_b, true);
    }

    @Override
    protected ActionResultType func_230254_b_(PlayerEntity playerEntity2, Hand hand) {
        ItemStack itemStack = playerEntity2.func_184586_b(hand);
        if (itemStack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(playerEntity2, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            if (!this.field_70170_p.field_72995_K) {
                this.func_146079_cb();
                itemStack.func_222118_a(1, playerEntity2, playerEntity -> playerEntity.func_213334_d(hand));
            }
            return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(playerEntity2, hand);
    }

    private void func_146077_cc() {
        if (!this.field_70170_p.field_72995_K) {
            Explosion.Mode mode = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
            float \u26032 = this.func_225509_J__() ? 2.0f : 1.0f;
            this.field_70729_aU = true;
            this.field_70170_p.func_217385_a(this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (float)this.field_82226_g * \u26032, mode);
            this.func_70106_y();
            this.func_190741_do();
        }
    }

    private void func_190741_do() {
        Collection<EffectInstance> collection = this.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaEffectCloudEntity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            areaEffectCloudEntity.func_184483_a(2.5f);
            areaEffectCloudEntity.func_184495_b(-0.5f);
            areaEffectCloudEntity.func_184485_d(10);
            areaEffectCloudEntity.func_184486_b(areaEffectCloudEntity.func_184489_o() / 2);
            areaEffectCloudEntity.func_184487_c(-areaEffectCloudEntity.func_184490_j() / (float)areaEffectCloudEntity.func_184489_o());
            for (EffectInstance effectInstance : collection) {
                areaEffectCloudEntity.func_184496_a(new EffectInstance(effectInstance));
            }
            this.field_70170_p.func_217376_c(areaEffectCloudEntity);
        }
    }

    public boolean func_146078_ca() {
        return this.field_70180_af.func_187225_a(field_184715_c);
    }

    public void func_146079_cb() {
        this.field_70180_af.func_187227_b(field_184715_c, true);
    }

    public boolean func_70650_aV() {
        return this.func_225509_J__() && this.field_175494_bm < 1;
    }

    public void func_175493_co() {
        ++this.field_175494_bm;
    }
}

