/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.client.CSteerBoatPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class BoatEntity
extends Entity {
    private static final DataParameter<Integer> field_184460_a = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184462_b = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Float> field_184464_c = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184466_d = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_199704_e = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_199705_f = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_203064_g = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187192_b);
    private final float[] field_184470_f = new float[2];
    private float field_184472_g;
    private float field_184474_h;
    private float field_184475_as;
    private int field_184476_at;
    private double field_70281_h;
    private double field_184477_av;
    private double field_184478_aw;
    private double field_70273_g;
    private double field_184479_ay;
    private boolean field_184480_az;
    private boolean field_184459_aA;
    private boolean field_184461_aB;
    private boolean field_184463_aC;
    private double field_184465_aD;
    private float field_184467_aE;
    private Status field_184469_aF;
    private Status field_184471_aG;
    private double field_184473_aH;
    private boolean field_203059_aM;
    private boolean field_203060_aN;
    private float field_203061_aO;
    private float field_203062_aP;
    private float field_203063_aQ;

    public BoatEntity(EntityType<? extends BoatEntity> entityType, World world) {
        super(entityType, world);
        this.field_70156_m = true;
    }

    public BoatEntity(World world, double d, double d2, double d3) {
        this((EntityType<? extends BoatEntity>)EntityType.field_200793_g, world);
        this.func_70107_b(d, d2, d3);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = d;
        this.field_70167_r = d2;
        this.field_70166_s = d3;
    }

    @Override
    protected float func_213316_a(Pose pose, EntitySize entitySize) {
        return entitySize.field_220316_b;
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184460_a, 0);
        this.field_70180_af.func_187214_a(field_184462_b, 1);
        this.field_70180_af.func_187214_a(field_184464_c, Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(field_184466_d, Type.OAK.ordinal());
        this.field_70180_af.func_187214_a(field_199704_e, false);
        this.field_70180_af.func_187214_a(field_199705_f, false);
        this.field_70180_af.func_187214_a(field_203064_g, 0);
    }

    @Override
    public boolean func_241849_j(Entity entity) {
        return BoatEntity.func_242378_a(this, entity);
    }

    public static boolean func_242378_a(Entity entity, Entity entity2) {
        return (entity2.func_241845_aY() || entity2.func_70104_M()) && !entity.func_184223_x(entity2);
    }

    @Override
    public boolean func_241845_aY() {
        return true;
    }

    @Override
    public boolean func_70104_M() {
        return true;
    }

    @Override
    protected Vector3d func_241839_a(Direction.Axis axis, TeleportationRepositioner.Result result) {
        return LivingEntity.func_242288_h(super.func_241839_a(axis, result));
    }

    @Override
    public double func_70042_X() {
        return -0.1;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        this.func_70269_c(-this.func_70267_i());
        this.func_70265_b(10);
        this.func_70266_a(this.func_70271_g() + f * 10.0f);
        this.func_70018_K();
        boolean bl = \u2603 = damageSource.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)damageSource.func_76346_g()).field_71075_bZ.field_75098_d;
        if (\u2603 || this.func_70271_g() > 40.0f) {
            if (!\u2603 && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                this.func_199703_a(this.func_184455_j());
            }
            this.func_70106_y();
        }
        return true;
    }

    @Override
    public void func_203002_i(boolean bl) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_203059_aM = true;
            this.field_203060_aN = bl;
            if (this.func_203058_B() == 0) {
                this.func_203055_e(60);
            }
        }
        this.field_70170_p.func_195594_a(ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)this.field_70146_Z.nextFloat(), this.func_226278_cu_() + 0.7, this.func_226281_cx_() + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0);
        if (this.field_70146_Z.nextInt(20) == 0) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_184181_aa(), this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat(), false);
        }
    }

    @Override
    public void func_70108_f(Entity entity) {
        if (entity instanceof BoatEntity) {
            if (entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entity);
            }
        } else if (entity.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entity);
        }
    }

    public Item func_184455_j() {
        switch (this.func_184453_r()) {
            default: {
                return Items.field_151124_az;
            }
            case SPRUCE: {
                return Items.field_185150_aH;
            }
            case BIRCH: {
                return Items.field_185151_aI;
            }
            case JUNGLE: {
                return Items.field_185152_aJ;
            }
            case ACACIA: {
                return Items.field_185153_aK;
            }
            case DARK_OAK: 
        }
        return Items.field_185154_aL;
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Override
    public Direction func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    @Override
    public void func_70071_h_() {
        this.field_184471_aG = this.field_184469_aF;
        this.field_184469_aF = this.func_184449_t();
        this.field_184474_h = this.field_184469_aF == Status.UNDER_WATER || this.field_184469_aF == Status.UNDER_FLOWING_WATER ? (this.field_184474_h += 1.0f) : 0.0f;
        if (!this.field_70170_p.field_72995_K && this.field_184474_h >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.func_70268_h() > 0) {
            this.func_70265_b(this.func_70268_h() - 1);
        }
        if (this.func_70271_g() > 0.0f) {
            this.func_70266_a(this.func_70271_g() - 1.0f);
        }
        super.func_70071_h_();
        this.func_184447_s();
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof PlayerEntity)) {
                this.func_184445_a(false, false);
            }
            this.func_184450_w();
            if (this.field_70170_p.field_72995_K) {
                this.func_184443_x();
                this.field_70170_p.func_184135_a(new CSteerBoatPacket(this.func_184457_a(0), this.func_184457_a(1)));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.func_203057_r();
        for (int i = 0; i <= 1; ++i) {
            if (this.func_184457_a(i)) {
                if (!this.func_174814_R() && (double)(this.field_184470_f[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.field_184470_f[i] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (\u2603 = this.func_193047_k()) != null) {
                    Vector3d vector3d = this.func_70676_i(1.0f);
                    double \u26032 = i == 1 ? -vector3d.field_72449_c : vector3d.field_72449_c;
                    double \u26033 = i == 1 ? vector3d.field_72450_a : -vector3d.field_72450_a;
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_() + \u26032, this.func_226278_cu_(), this.func_226281_cx_() + \u26033, \u2603, this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
                }
                int n = i;
                this.field_184470_f[n] = (float)((double)this.field_184470_f[n] + (double)0.3926991f);
                continue;
            }
            this.field_184470_f[i] = 0.0f;
        }
        this.func_145775_I();
        List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ().func_72314_b(0.2f, -0.01f, 0.2f), EntityPredicates.func_200823_a(this));
        if (!list.isEmpty()) {
            boolean bl = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof PlayerEntity);
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = list.get(i);
                if (entity.func_184196_w(this)) continue;
                if (bl && this.func_184188_bt().size() < 2 && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof LivingEntity && !(entity instanceof WaterMobEntity) && !(entity instanceof PlayerEntity)) {
                    entity.func_184220_m(this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    private void func_203057_r() {
        if (this.field_70170_p.field_72995_K) {
            int n = this.func_203058_B();
            this.field_203061_aO = n > 0 ? (this.field_203061_aO += 0.05f) : (this.field_203061_aO -= 0.1f);
            this.field_203061_aO = MathHelper.func_76131_a(this.field_203061_aO, 0.0f, 1.0f);
            this.field_203063_aQ = this.field_203062_aP;
            this.field_203062_aP = 10.0f * (float)Math.sin(0.5f * (float)this.field_70170_p.func_82737_E()) * this.field_203061_aO;
        } else {
            int n;
            if (!this.field_203059_aM) {
                this.func_203055_e(0);
            }
            if ((n = this.func_203058_B()) > 0) {
                this.func_203055_e(--n);
                \u2603 = 60 - n - 1;
                if (\u2603 > 0 && n == 0) {
                    this.func_203055_e(0);
                    Vector3d vector3d = this.func_213322_ci();
                    if (this.field_203060_aN) {
                        this.func_213317_d(vector3d.func_72441_c(0.0, -0.7, 0.0));
                        this.func_184226_ay();
                    } else {
                        this.func_213293_j(vector3d.field_72450_a, this.func_205708_a(PlayerEntity.class) ? 2.7 : 0.6, vector3d.field_72449_c);
                    }
                }
                this.field_203059_aM = false;
            }
        }
    }

    @Nullable
    protected SoundEvent func_193047_k() {
        switch (this.func_184449_t()) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return SoundEvents.field_193779_I;
            }
            case ON_LAND: {
                return SoundEvents.field_193778_H;
            }
        }
        return null;
    }

    private void func_184447_s() {
        if (this.func_184186_bw()) {
            this.field_184476_at = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.field_184476_at <= 0) {
            return;
        }
        double d = this.func_226277_ct_() + (this.field_70281_h - this.func_226277_ct_()) / (double)this.field_184476_at;
        \u2603 = this.func_226278_cu_() + (this.field_184477_av - this.func_226278_cu_()) / (double)this.field_184476_at;
        \u2603 = this.func_226281_cx_() + (this.field_184478_aw - this.func_226281_cx_()) / (double)this.field_184476_at;
        \u2603 = MathHelper.func_76138_g(this.field_70273_g - (double)this.field_70177_z);
        this.field_70177_z = (float)((double)this.field_70177_z + \u2603 / (double)this.field_184476_at);
        this.field_70125_A = (float)((double)this.field_70125_A + (this.field_184479_ay - (double)this.field_70125_A) / (double)this.field_184476_at);
        --this.field_184476_at;
        this.func_70107_b(d, \u2603, \u2603);
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
    }

    public void func_184445_a(boolean bl, boolean bl2) {
        this.field_70180_af.func_187227_b(field_199704_e, bl);
        this.field_70180_af.func_187227_b(field_199705_f, bl2);
    }

    private Status func_184449_t() {
        Status status = this.func_184444_v();
        if (status != null) {
            this.field_184465_aD = this.func_174813_aQ().field_72337_e;
            return status;
        }
        if (this.func_184446_u()) {
            return Status.IN_WATER;
        }
        float \u26032 = this.func_184441_l();
        if (\u26032 > 0.0f) {
            this.field_184467_aE = \u26032;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float func_184451_k() {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
        int \u26032 = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        int \u26033 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        int \u26034 = MathHelper.func_76128_c(axisAlignedBB.field_72337_e);
        int \u26035 = MathHelper.func_76143_f(axisAlignedBB.field_72337_e - this.field_184473_aH);
        int \u26036 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        int \u26037 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f);
        BlockPos.Mutable \u26038 = new BlockPos.Mutable();
        block0: for (int i = \u26034; i < \u26035; ++i) {
            float f = 0.0f;
            for (int j = \u26032; j < \u26033; ++j) {
                for (\u2603 = \u26036; \u2603 < \u26037; ++\u2603) {
                    \u26038.func_181079_c(j, i, \u2603);
                    FluidState fluidState = this.field_70170_p.func_204610_c(\u26038);
                    if (fluidState.func_206884_a(FluidTags.field_206959_a)) {
                        f = Math.max(f, fluidState.func_215679_a(this.field_70170_p, \u26038));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)\u26038.func_177956_o() + f;
        }
        return \u26035 + 1;
    }

    public float func_184441_l() {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
        \u2603 = new AxisAlignedBB(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b - 0.001, axisAlignedBB.field_72339_c, axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f);
        int \u26032 = MathHelper.func_76128_c(\u2603.field_72340_a) - 1;
        int \u26033 = MathHelper.func_76143_f(\u2603.field_72336_d) + 1;
        int \u26034 = MathHelper.func_76128_c(\u2603.field_72338_b) - 1;
        int \u26035 = MathHelper.func_76143_f(\u2603.field_72337_e) + 1;
        int \u26036 = MathHelper.func_76128_c(\u2603.field_72339_c) - 1;
        int \u26037 = MathHelper.func_76143_f(\u2603.field_72334_f) + 1;
        VoxelShape \u26038 = VoxelShapes.func_197881_a(\u2603);
        float \u26039 = 0.0f;
        int \u260310 = 0;
        BlockPos.Mutable \u260311 = new BlockPos.Mutable();
        for (int i = \u26032; i < \u26033; ++i) {
            for (\u2603 = \u26036; \u2603 < \u26037; ++\u2603) {
                \u2603 = (i == \u26032 || i == \u26033 - 1 ? 1 : 0) + (\u2603 == \u26036 || \u2603 == \u26037 - 1 ? 1 : 0);
                if (\u2603 == 2) continue;
                for (\u2603 = \u26034; \u2603 < \u26035; ++\u2603) {
                    if (\u2603 > 0 && (\u2603 == \u26034 || \u2603 == \u26035 - 1)) continue;
                    \u260311.func_181079_c(i, \u2603, \u2603);
                    BlockState blockState = this.field_70170_p.func_180495_p(\u260311);
                    if (blockState.func_177230_c() instanceof LilyPadBlock || !VoxelShapes.func_197879_c(blockState.func_196952_d(this.field_70170_p, \u260311).func_197751_a(i, \u2603, \u2603), \u26038, IBooleanFunction.field_223238_i_)) continue;
                    \u26039 += blockState.func_177230_c().func_208618_m();
                    ++\u260310;
                }
            }
        }
        return \u26039 / (float)\u260310;
    }

    private boolean func_184446_u() {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
        int \u26032 = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        int \u26033 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        int \u26034 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b);
        int \u26035 = MathHelper.func_76143_f(axisAlignedBB.field_72338_b + 0.001);
        int \u26036 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        int \u26037 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f);
        boolean \u26038 = false;
        this.field_184465_aD = Double.MIN_VALUE;
        BlockPos.Mutable \u26039 = new BlockPos.Mutable();
        for (int i = \u26032; i < \u26033; ++i) {
            for (\u2603 = \u26034; \u2603 < \u26035; ++\u2603) {
                for (\u2603 = \u26036; \u2603 < \u26037; ++\u2603) {
                    \u26039.func_181079_c(i, \u2603, \u2603);
                    FluidState fluidState = this.field_70170_p.func_204610_c(\u26039);
                    if (!fluidState.func_206884_a(FluidTags.field_206959_a)) continue;
                    float \u260310 = (float)\u2603 + fluidState.func_215679_a(this.field_70170_p, \u26039);
                    this.field_184465_aD = Math.max((double)\u260310, this.field_184465_aD);
                    \u26038 |= axisAlignedBB.field_72338_b < (double)\u260310;
                }
            }
        }
        return \u26038;
    }

    @Nullable
    private Status func_184444_v() {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
        double \u26032 = axisAlignedBB.field_72337_e + 0.001;
        int \u26033 = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        int \u26034 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        int \u26035 = MathHelper.func_76128_c(axisAlignedBB.field_72337_e);
        int \u26036 = MathHelper.func_76143_f(\u26032);
        int \u26037 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        int \u26038 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f);
        boolean \u26039 = false;
        BlockPos.Mutable \u260310 = new BlockPos.Mutable();
        for (int i = \u26033; i < \u26034; ++i) {
            for (\u2603 = \u26035; \u2603 < \u26036; ++\u2603) {
                for (\u2603 = \u26037; \u2603 < \u26038; ++\u2603) {
                    \u260310.func_181079_c(i, \u2603, \u2603);
                    FluidState fluidState = this.field_70170_p.func_204610_c(\u260310);
                    if (!fluidState.func_206884_a(FluidTags.field_206959_a) || !(\u26032 < (double)((float)\u260310.func_177956_o() + fluidState.func_215679_a(this.field_70170_p, \u260310)))) continue;
                    if (fluidState.func_206889_d()) {
                        \u26039 = true;
                        continue;
                    }
                    return Status.UNDER_FLOWING_WATER;
                }
            }
        }
        return \u26039 ? Status.UNDER_WATER : null;
    }

    private void func_184450_w() {
        double d = -0.04f;
        \u2603 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        \u2603 = 0.0;
        this.field_184472_g = 0.05f;
        if (this.field_184471_aG == Status.IN_AIR && this.field_184469_aF != Status.IN_AIR && this.field_184469_aF != Status.ON_LAND) {
            this.field_184465_aD = this.func_226283_e_(1.0);
            this.func_70107_b(this.func_226277_ct_(), (double)(this.func_184451_k() - this.func_213302_cg()) + 0.101, this.func_226281_cx_());
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            this.field_184473_aH = 0.0;
            this.field_184469_aF = Status.IN_WATER;
        } else {
            if (this.field_184469_aF == Status.IN_WATER) {
                \u2603 = (this.field_184465_aD - this.func_226278_cu_()) / (double)this.func_213302_cg();
                this.field_184472_g = 0.9f;
            } else if (this.field_184469_aF == Status.UNDER_FLOWING_WATER) {
                \u2603 = -7.0E-4;
                this.field_184472_g = 0.9f;
            } else if (this.field_184469_aF == Status.UNDER_WATER) {
                \u2603 = 0.01f;
                this.field_184472_g = 0.45f;
            } else if (this.field_184469_aF == Status.IN_AIR) {
                this.field_184472_g = 0.9f;
            } else if (this.field_184469_aF == Status.ON_LAND) {
                this.field_184472_g = this.field_184467_aE;
                if (this.func_184179_bs() instanceof PlayerEntity) {
                    this.field_184467_aE /= 2.0f;
                }
            }
            Vector3d vector3d = this.func_213322_ci();
            this.func_213293_j(vector3d.field_72450_a * (double)this.field_184472_g, vector3d.field_72448_b + \u2603, vector3d.field_72449_c * (double)this.field_184472_g);
            this.field_184475_as *= this.field_184472_g;
            if (\u2603 > 0.0) {
                \u2603 = this.func_213322_ci();
                this.func_213293_j(\u2603.field_72450_a, (\u2603.field_72448_b + \u2603 * 0.06153846016296973) * 0.75, \u2603.field_72449_c);
            }
        }
    }

    private void func_184443_x() {
        if (!this.func_184207_aI()) {
            return;
        }
        float f = 0.0f;
        if (this.field_184480_az) {
            this.field_184475_as -= 1.0f;
        }
        if (this.field_184459_aA) {
            this.field_184475_as += 1.0f;
        }
        if (this.field_184459_aA != this.field_184480_az && !this.field_184461_aB && !this.field_184463_aC) {
            f += 0.005f;
        }
        this.field_70177_z += this.field_184475_as;
        if (this.field_184461_aB) {
            f += 0.04f;
        }
        if (this.field_184463_aC) {
            f -= 0.005f;
        }
        this.func_213317_d(this.func_213322_ci().func_72441_c(MathHelper.func_76126_a(-this.field_70177_z * ((float)Math.PI / 180)) * f, 0.0, MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)) * f));
        this.func_184445_a(this.field_184459_aA && !this.field_184480_az || this.field_184461_aB, this.field_184480_az && !this.field_184459_aA || this.field_184461_aB);
    }

    @Override
    public void func_184232_k(Entity entity) {
        if (!this.func_184196_w(entity)) {
            return;
        }
        float \u26032 = 0.0f;
        \u2603 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + entity.func_70033_W());
        if (this.func_184188_bt().size() > 1) {
            int n = this.func_184188_bt().indexOf(entity);
            \u26032 = n == 0 ? 0.2f : -0.6f;
            if (entity instanceof AnimalEntity) {
                \u26032 = (float)((double)\u26032 + 0.2);
            }
        }
        Vector3d vector3d = new Vector3d(\u26032, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
        entity.func_70107_b(this.func_226277_ct_() + vector3d.field_72450_a, this.func_226278_cu_() + (double)\u2603, this.func_226281_cx_() + vector3d.field_72449_c);
        entity.field_70177_z += this.field_184475_as;
        entity.func_70034_d(entity.func_70079_am() + this.field_184475_as);
        this.func_184454_a(entity);
        if (entity instanceof AnimalEntity && this.func_184188_bt().size() > 1) {
            int n = entity.func_145782_y() % 2 == 0 ? 90 : 270;
            entity.func_181013_g(((AnimalEntity)entity).field_70761_aq + (float)n);
            entity.func_70034_d(entity.func_70079_am() + (float)n);
        }
    }

    @Override
    public Vector3d func_230268_c_(LivingEntity livingEntity2) {
        LivingEntity livingEntity2;
        Vector3d vector3d = BoatEntity.func_233559_a_(this.func_213311_cf() * MathHelper.field_180189_a, livingEntity2.func_213311_cf(), this.field_70177_z);
        double \u26032 = this.func_226277_ct_() + vector3d.field_72450_a;
        BlockPos \u26033 = new BlockPos(\u26032, this.func_174813_aQ().field_72337_e, \u2603 = this.func_226281_cx_() + vector3d.field_72449_c);
        BlockPos \u26034 = \u26033.func_177977_b();
        if (!this.field_70170_p.func_201671_F(\u26034)) {
            double d = (double)\u26033.func_177956_o() + this.field_70170_p.func_242403_h(\u26033);
            \u2603 = (double)\u26033.func_177956_o() + this.field_70170_p.func_242403_h(\u26034);
            for (Pose pose : livingEntity2.func_230297_ef_()) {
                Vector3d vector3d2 = TransportationHelper.func_242381_a(this.field_70170_p, \u26032, d, \u2603, livingEntity2, pose);
                if (vector3d2 != null) {
                    livingEntity2.func_213301_b(pose);
                    return vector3d2;
                }
                \u2603 = TransportationHelper.func_242381_a(this.field_70170_p, \u26032, \u2603, \u2603, livingEntity2, pose);
                if (\u2603 == null) continue;
                livingEntity2.func_213301_b(pose);
                return \u2603;
            }
        }
        return super.func_230268_c_(livingEntity2);
    }

    protected void func_184454_a(Entity entity) {
        entity.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g(entity.field_70177_z - this.field_70177_z);
        \u2603 = MathHelper.func_76131_a(f, -105.0f, 105.0f);
        entity.field_70126_B += \u2603 - f;
        entity.field_70177_z += \u2603 - f;
        entity.func_70034_d(entity.field_70177_z);
    }

    @Override
    protected void func_213281_b(CompoundNBT compoundNBT) {
        compoundNBT.func_74778_a("Type", this.func_184453_r().func_184980_a());
    }

    @Override
    protected void func_70037_a(CompoundNBT compoundNBT) {
        if (compoundNBT.func_150297_b("Type", 8)) {
            this.func_184458_a(Type.func_184981_a(compoundNBT.func_74779_i("Type")));
        }
    }

    @Override
    public ActionResultType func_184230_a(PlayerEntity playerEntity, Hand hand) {
        if (playerEntity.func_226563_dT_()) {
            return ActionResultType.PASS;
        }
        if (this.field_184474_h < 60.0f) {
            if (!this.field_70170_p.field_72995_K) {
                return playerEntity.func_184220_m(this) ? ActionResultType.CONSUME : ActionResultType.PASS;
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    protected void func_184231_a(double d2, boolean bl, BlockState blockState, BlockPos blockPos) {
        double d2;
        this.field_184473_aH = this.func_213322_ci().field_72448_b;
        if (this.func_184218_aH()) {
            return;
        }
        if (bl) {
            if (this.field_70143_R > 3.0f) {
                if (this.field_184469_aF != Status.ON_LAND) {
                    this.field_70143_R = 0.0f;
                    return;
                }
                this.func_225503_b_(this.field_70143_R, 1.0f);
                if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                    this.func_70106_y();
                    if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                        int n;
                        for (n = 0; n < 3; ++n) {
                            this.func_199703_a(this.func_184453_r().func_195933_b());
                        }
                        for (n = 0; n < 2; ++n) {
                            this.func_199703_a(Items.field_151055_y);
                        }
                    }
                }
            }
            this.field_70143_R = 0.0f;
        } else if (!this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177977_b()).func_206884_a(FluidTags.field_206959_a) && d2 < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - d2);
        }
    }

    public boolean func_184457_a(int n) {
        return this.field_70180_af.func_187225_a(n == 0 ? field_199704_e : field_199705_f) != false && this.func_184179_bs() != null;
    }

    public void func_70266_a(float f) {
        this.field_70180_af.func_187227_b(field_184464_c, Float.valueOf(f));
    }

    public float func_70271_g() {
        return this.field_70180_af.func_187225_a(field_184464_c).floatValue();
    }

    public void func_70265_b(int n) {
        this.field_70180_af.func_187227_b(field_184460_a, n);
    }

    public int func_70268_h() {
        return this.field_70180_af.func_187225_a(field_184460_a);
    }

    private void func_203055_e(int n) {
        this.field_70180_af.func_187227_b(field_203064_g, n);
    }

    private int func_203058_B() {
        return this.field_70180_af.func_187225_a(field_203064_g);
    }

    public void func_70269_c(int n) {
        this.field_70180_af.func_187227_b(field_184462_b, n);
    }

    public int func_70267_i() {
        return this.field_70180_af.func_187225_a(field_184462_b);
    }

    public void func_184458_a(Type type) {
        this.field_70180_af.func_187227_b(field_184466_d, type.ordinal());
    }

    public Type func_184453_r() {
        return Type.func_184979_a(this.field_70180_af.func_187225_a(field_184466_d));
    }

    @Override
    protected boolean func_184219_q(Entity entity) {
        return this.func_184188_bt().size() < 2 && !this.func_208600_a(FluidTags.field_206959_a);
    }

    @Override
    @Nullable
    public Entity func_184179_bs() {
        List<Entity> list = this.func_184188_bt();
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket(this);
    }

    @Override
    public boolean func_204231_K() {
        return this.field_184469_aF == Status.UNDER_WATER || this.field_184469_aF == Status.UNDER_FLOWING_WATER;
    }

    public static enum Type {
        OAK(Blocks.field_196662_n, "oak"),
        SPRUCE(Blocks.field_196664_o, "spruce"),
        BIRCH(Blocks.field_196666_p, "birch"),
        JUNGLE(Blocks.field_196668_q, "jungle"),
        ACACIA(Blocks.field_196670_r, "acacia"),
        DARK_OAK(Blocks.field_196672_s, "dark_oak");

        private final String field_184990_g;
        private final Block field_195934_h;

        private Type(Block block, String string2) {
            this.field_184990_g = string2;
            this.field_195934_h = block;
        }

        public String func_184980_a() {
            return this.field_184990_g;
        }

        public Block func_195933_b() {
            return this.field_195934_h;
        }

        public String toString() {
            return this.field_184990_g;
        }

        public static Type func_184979_a(int n2) {
            Type[] typeArray = Type.values();
            if (n2 < 0 || n2 >= typeArray.length) {
                int n2 = 0;
            }
            return typeArray[n2];
        }

        public static Type func_184981_a(String string) {
            Type[] typeArray = Type.values();
            for (int i = 0; i < typeArray.length; ++i) {
                if (!typeArray[i].func_184980_a().equals(string)) continue;
                return typeArray[i];
            }
            return typeArray[0];
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

