/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.LocationInput;
import net.minecraft.command.arguments.RotationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;

public class TeleportCommand {
    private static final SimpleCommandExceptionType field_241077_a_ = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.teleport.invalidPosition"));

    public static void func_198809_a(CommandDispatcher<CommandSource> commandDispatcher) {
        LiteralCommandNode literalCommandNode = commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("teleport").requires(commandSource -> commandSource.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a("targets", EntityArgument.func_197093_b()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("location", Vec3Argument.func_197301_a()).executes(commandContext -> TeleportCommand.func_200559_a((CommandSource)commandContext.getSource(), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets"), ((CommandSource)commandContext.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext<CommandSource>)commandContext, "location"), null, null))).then(Commands.func_197056_a("rotation", RotationArgument.func_197288_a()).executes(commandContext -> TeleportCommand.func_200559_a((CommandSource)commandContext.getSource(), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets"), ((CommandSource)commandContext.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext<CommandSource>)commandContext, "location"), RotationArgument.func_200384_a((CommandContext<CommandSource>)commandContext, "rotation"), null)))).then(((LiteralArgumentBuilder)Commands.func_197057_a("facing").then(Commands.func_197057_a("entity").then(((RequiredArgumentBuilder)Commands.func_197056_a("facingEntity", EntityArgument.func_197086_a()).executes(commandContext -> TeleportCommand.func_200559_a((CommandSource)commandContext.getSource(), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets"), ((CommandSource)commandContext.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext<CommandSource>)commandContext, "location"), null, new Facing(EntityArgument.func_197088_a((CommandContext<CommandSource>)commandContext, "facingEntity"), EntityAnchorArgument.Type.FEET)))).then(Commands.func_197056_a("facingAnchor", EntityAnchorArgument.func_201024_a()).executes(commandContext -> TeleportCommand.func_200559_a((CommandSource)commandContext.getSource(), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets"), ((CommandSource)commandContext.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext<CommandSource>)commandContext, "location"), null, new Facing(EntityArgument.func_197088_a((CommandContext<CommandSource>)commandContext, "facingEntity"), EntityAnchorArgument.func_201023_a((CommandContext<CommandSource>)commandContext, "facingAnchor")))))))).then(Commands.func_197056_a("facingLocation", Vec3Argument.func_197301_a()).executes(commandContext -> TeleportCommand.func_200559_a((CommandSource)commandContext.getSource(), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets"), ((CommandSource)commandContext.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext<CommandSource>)commandContext, "location"), null, new Facing(Vec3Argument.func_197300_a((CommandContext<CommandSource>)commandContext, "facingLocation")))))))).then(Commands.func_197056_a("destination", EntityArgument.func_197086_a()).executes(commandContext -> TeleportCommand.func_201126_a((CommandSource)commandContext.getSource(), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets"), EntityArgument.func_197088_a((CommandContext<CommandSource>)commandContext, "destination")))))).then(Commands.func_197056_a("location", Vec3Argument.func_197301_a()).executes(commandContext -> TeleportCommand.func_200559_a((CommandSource)commandContext.getSource(), Collections.singleton(((CommandSource)commandContext.getSource()).func_197027_g()), ((CommandSource)commandContext.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext<CommandSource>)commandContext, "location"), LocationInput.func_200383_d(), null)))).then(Commands.func_197056_a("destination", EntityArgument.func_197086_a()).executes(commandContext -> TeleportCommand.func_201126_a((CommandSource)commandContext.getSource(), Collections.singleton(((CommandSource)commandContext.getSource()).func_197027_g()), EntityArgument.func_197088_a((CommandContext<CommandSource>)commandContext, "destination")))));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("tp").requires(commandSource -> commandSource.func_197034_c(2))).redirect((CommandNode)literalCommandNode));
    }

    private static int func_201126_a(CommandSource commandSource, Collection<? extends Entity> collection, Entity entity) throws CommandSyntaxException {
        for (Entity entity2 : collection) {
            TeleportCommand.func_201127_a(commandSource, entity2, (ServerWorld)entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class), entity.field_70177_z, entity.field_70125_A, null);
        }
        if (collection.size() == 1) {
            commandSource.func_197030_a(new TranslationTextComponent("commands.teleport.success.entity.single", collection.iterator().next().func_145748_c_(), entity.func_145748_c_()), true);
        } else {
            commandSource.func_197030_a(new TranslationTextComponent("commands.teleport.success.entity.multiple", collection.size(), entity.func_145748_c_()), true);
        }
        return collection.size();
    }

    private static int func_200559_a(CommandSource commandSource, Collection<? extends Entity> collection2, ServerWorld serverWorld, ILocationArgument iLocationArgument, @Nullable ILocationArgument iLocationArgument2, @Nullable Facing facing) throws CommandSyntaxException {
        Vector3d vector3d = iLocationArgument.func_197281_a(commandSource);
        Vector2f \u26032 = iLocationArgument2 == null ? null : iLocationArgument2.func_197282_b(commandSource);
        EnumSet<SPlayerPositionLookPacket.Flags> \u26033 = EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class);
        if (iLocationArgument.func_200380_a()) {
            \u26033.add(SPlayerPositionLookPacket.Flags.X);
        }
        if (iLocationArgument.func_200381_b()) {
            \u26033.add(SPlayerPositionLookPacket.Flags.Y);
        }
        if (iLocationArgument.func_200382_c()) {
            \u26033.add(SPlayerPositionLookPacket.Flags.Z);
        }
        if (iLocationArgument2 == null) {
            \u26033.add(SPlayerPositionLookPacket.Flags.X_ROT);
            \u26033.add(SPlayerPositionLookPacket.Flags.Y_ROT);
        } else {
            if (iLocationArgument2.func_200380_a()) {
                \u26033.add(SPlayerPositionLookPacket.Flags.X_ROT);
            }
            if (iLocationArgument2.func_200381_b()) {
                \u26033.add(SPlayerPositionLookPacket.Flags.Y_ROT);
            }
        }
        for (Entity entity : collection2) {
            if (iLocationArgument2 == null) {
                TeleportCommand.func_201127_a(commandSource, entity, serverWorld, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, \u26033, entity.field_70177_z, entity.field_70125_A, facing);
                continue;
            }
            TeleportCommand.func_201127_a(commandSource, entity, serverWorld, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, \u26033, \u26032.field_189983_j, \u26032.field_189982_i, facing);
        }
        if (collection2.size() == 1) {
            commandSource.func_197030_a(new TranslationTextComponent("commands.teleport.success.location.single", collection2.iterator().next().func_145748_c_(), vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c), true);
        } else {
            commandSource.func_197030_a(new TranslationTextComponent("commands.teleport.success.location.multiple", collection2.size(), vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c), true);
        }
        return collection2.size();
    }

    private static void func_201127_a(CommandSource commandSource, Entity entity, ServerWorld serverWorld, double d, double d2, double d3, Set<SPlayerPositionLookPacket.Flags> set, float f3, float f2, @Nullable Facing facing2) throws CommandSyntaxException {
        Facing facing2;
        BlockPos blockPos = new BlockPos(d, d2, d3);
        if (!World.func_234935_k_(blockPos)) {
            throw field_241077_a_.create();
        }
        if (entity instanceof ServerPlayerEntity) {
            ChunkPos chunkPos = new ChunkPos(new BlockPos(d, d2, d3));
            serverWorld.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkPos, 1, entity.func_145782_y());
            entity.func_184210_p();
            if (((ServerPlayerEntity)entity).func_70608_bn()) {
                ((ServerPlayerEntity)entity).func_225652_a_(true, true);
            }
            if (serverWorld == entity.field_70170_p) {
                ((ServerPlayerEntity)entity).field_71135_a.func_175089_a(d, d2, d3, f3, f2, set);
            } else {
                ((ServerPlayerEntity)entity).func_200619_a(serverWorld, d, d2, d3, f3, f2);
            }
            entity.func_70034_d(f3);
        } else {
            float f3;
            \u2603 = MathHelper.func_76142_g(f3);
            \u2603 = MathHelper.func_76142_g(f2);
            \u2603 = MathHelper.func_76131_a(\u2603, -90.0f, 90.0f);
            if (serverWorld == entity.field_70170_p) {
                entity.func_70012_b(d, d2, d3, \u2603, \u2603);
                entity.func_70034_d(\u2603);
            } else {
                entity.func_213319_R();
                Entity entity2 = entity;
                entity = entity2.func_200600_R().func_200721_a(serverWorld);
                if (entity != null) {
                    entity.func_180432_n(entity2);
                    entity.func_70012_b(d, d2, d3, \u2603, \u2603);
                    entity.func_70034_d(\u2603);
                    serverWorld.func_217460_e(entity);
                    entity2.field_70128_L = true;
                } else {
                    return;
                }
            }
        }
        if (facing2 != null) {
            facing2.func_201124_a(commandSource, entity);
        }
        if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).func_184613_cA()) {
            entity.func_213317_d(entity.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            entity.func_230245_c_(true);
        }
        if (entity instanceof CreatureEntity) {
            ((CreatureEntity)entity).func_70661_as().func_75499_g();
        }
    }

    static class Facing {
        private final Vector3d field_200549_a;
        private final Entity field_200550_b;
        private final EntityAnchorArgument.Type field_201125_c;

        public Facing(Entity entity, EntityAnchorArgument.Type type) {
            this.field_200550_b = entity;
            this.field_201125_c = type;
            this.field_200549_a = type.func_201017_a(entity);
        }

        public Facing(Vector3d vector3d) {
            this.field_200550_b = null;
            this.field_200549_a = vector3d;
            this.field_201125_c = null;
        }

        public void func_201124_a(CommandSource commandSource, Entity entity) {
            if (this.field_200550_b != null) {
                if (entity instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)entity).func_200618_a(commandSource.func_201008_k(), this.field_200550_b, this.field_201125_c);
                } else {
                    entity.func_200602_a(commandSource.func_201008_k(), this.field_200549_a);
                }
            } else {
                entity.func_200602_a(commandSource.func_201008_k(), this.field_200549_a);
            }
        }
    }
}

