/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ItemPredicate {
    public static final ItemPredicate field_192495_a = new ItemPredicate();
    @Nullable
    private final ITag<Item> field_200018_b;
    @Nullable
    private final Item field_192496_b;
    private final MinMaxBounds.IntBound field_192498_d;
    private final MinMaxBounds.IntBound field_193444_e;
    private final EnchantmentPredicate[] field_192499_e;
    private final EnchantmentPredicate[] field_226656_g_;
    @Nullable
    private final Potion field_192500_f;
    private final NBTPredicate field_193445_h;

    public ItemPredicate() {
        this.field_200018_b = null;
        this.field_192496_b = null;
        this.field_192500_f = null;
        this.field_192498_d = MinMaxBounds.IntBound.field_211347_e;
        this.field_193444_e = MinMaxBounds.IntBound.field_211347_e;
        this.field_192499_e = EnchantmentPredicate.field_226534_b_;
        this.field_226656_g_ = EnchantmentPredicate.field_226534_b_;
        this.field_193445_h = NBTPredicate.field_193479_a;
    }

    public ItemPredicate(@Nullable ITag<Item> iTag, @Nullable Item item, MinMaxBounds.IntBound intBound, MinMaxBounds.IntBound intBound2, EnchantmentPredicate[] enchantmentPredicateArray, EnchantmentPredicate[] enchantmentPredicateArray2, @Nullable Potion potion, NBTPredicate nBTPredicate) {
        this.field_200018_b = iTag;
        this.field_192496_b = item;
        this.field_192498_d = intBound;
        this.field_193444_e = intBound2;
        this.field_192499_e = enchantmentPredicateArray;
        this.field_226656_g_ = enchantmentPredicateArray2;
        this.field_192500_f = potion;
        this.field_193445_h = nBTPredicate;
    }

    public boolean func_192493_a(ItemStack itemStack2) {
        ItemStack itemStack2;
        Map<Enchantment, Integer> \u26032;
        if (this == field_192495_a) {
            return true;
        }
        if (this.field_200018_b != null && !this.field_200018_b.func_230235_a_(itemStack2.func_77973_b())) {
            return false;
        }
        if (this.field_192496_b != null && itemStack2.func_77973_b() != this.field_192496_b) {
            return false;
        }
        if (!this.field_192498_d.func_211339_d(itemStack2.func_190916_E())) {
            return false;
        }
        if (!this.field_193444_e.func_211335_c() && !itemStack2.func_77984_f()) {
            return false;
        }
        if (!this.field_193444_e.func_211339_d(itemStack2.func_77958_k() - itemStack2.func_77952_i())) {
            return false;
        }
        if (!this.field_193445_h.func_193478_a(itemStack2)) {
            return false;
        }
        if (this.field_192499_e.length > 0) {
            \u26032 = EnchantmentHelper.func_226652_a_(itemStack2.func_77986_q());
            for (EnchantmentPredicate enchantmentPredicate : this.field_192499_e) {
                if (enchantmentPredicate.func_192463_a(\u26032)) continue;
                return false;
            }
        }
        if (this.field_226656_g_.length > 0) {
            \u26032 = EnchantmentHelper.func_226652_a_(EnchantedBookItem.func_92110_g(itemStack2));
            for (EnchantmentPredicate enchantmentPredicate : this.field_226656_g_) {
                if (enchantmentPredicate.func_192463_a(\u26032)) continue;
                return false;
            }
        }
        \u26032 = PotionUtils.func_185191_c(itemStack2);
        return this.field_192500_f == null || this.field_192500_f == \u26032;
    }

    public static ItemPredicate func_192492_a(@Nullable JsonElement jsonElement) {
        EnchantmentPredicate[] \u26038;
        Object \u26037;
        ITag<Item> \u26036;
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return field_192495_a;
        }
        JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "item");
        MinMaxBounds.IntBound \u26032 = MinMaxBounds.IntBound.func_211344_a(jsonObject.get("count"));
        MinMaxBounds.IntBound \u26033 = MinMaxBounds.IntBound.func_211344_a(jsonObject.get("durability"));
        if (jsonObject.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        NBTPredicate \u26034 = NBTPredicate.func_193476_a(jsonObject.get("nbt"));
        Item \u26035 = null;
        if (jsonObject.has("item")) {
            \u26036 = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "item"));
            \u26035 = Registry.field_212630_s.func_241873_b((ResourceLocation)((Object)\u26036)).orElseThrow(() -> ItemPredicate.func_218004_b((ResourceLocation)((Object)\u26036)));
        }
        \u26036 = null;
        if (jsonObject.has("tag")) {
            \u26037 = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "tag"));
            \u26036 = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a((ResourceLocation)\u26037);
            if (\u26036 == null) {
                throw new JsonSyntaxException("Unknown item tag '" + \u26037 + "'");
            }
        }
        \u26037 = null;
        if (jsonObject.has("potion")) {
            \u26038 = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "potion"));
            \u26037 = Registry.field_212621_j.func_241873_b((ResourceLocation)\u26038).orElseThrow(() -> ItemPredicate.func_218005_a((ResourceLocation)\u26038));
        }
        \u26038 = EnchantmentPredicate.func_192465_b(jsonObject.get("enchantments"));
        EnchantmentPredicate[] \u26039 = EnchantmentPredicate.func_192465_b(jsonObject.get("stored_enchantments"));
        return new ItemPredicate(\u26036, \u26035, \u26032, \u26033, \u26038, \u26039, (Potion)\u26037, \u26034);
    }

    public JsonElement func_200319_a() {
        JsonArray jsonArray;
        if (this == field_192495_a) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.field_192496_b != null) {
            jsonObject.addProperty("item", Registry.field_212630_s.func_177774_c(this.field_192496_b).toString());
        }
        if (this.field_200018_b != null) {
            jsonObject.addProperty("tag", TagCollectionManager.func_242178_a().func_241836_b().func_232975_b_(this.field_200018_b).toString());
        }
        jsonObject.add("count", this.field_192498_d.func_200321_c());
        jsonObject.add("durability", this.field_193444_e.func_200321_c());
        jsonObject.add("nbt", this.field_193445_h.func_200322_a());
        if (this.field_192499_e.length > 0) {
            jsonArray = new JsonArray();
            for (EnchantmentPredicate enchantmentPredicate : this.field_192499_e) {
                jsonArray.add(enchantmentPredicate.func_200306_a());
            }
            jsonObject.add("enchantments", (JsonElement)jsonArray);
        }
        if (this.field_226656_g_.length > 0) {
            jsonArray = new JsonArray();
            for (EnchantmentPredicate enchantmentPredicate : this.field_226656_g_) {
                jsonArray.add(enchantmentPredicate.func_200306_a());
            }
            jsonObject.add("stored_enchantments", (JsonElement)jsonArray);
        }
        if (this.field_192500_f != null) {
            jsonObject.addProperty("potion", Registry.field_212621_j.func_177774_c(this.field_192500_f).toString());
        }
        return jsonObject;
    }

    public static ItemPredicate[] func_192494_b(@Nullable JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return new ItemPredicate[0];
        }
        JsonArray jsonArray = JSONUtils.func_151207_m(jsonElement, "items");
        ItemPredicate[] \u26032 = new ItemPredicate[jsonArray.size()];
        for (int i = 0; i < \u26032.length; ++i) {
            \u26032[i] = ItemPredicate.func_192492_a(jsonArray.get(i));
        }
        return \u26032;
    }

    private static /* synthetic */ JsonSyntaxException func_218005_a(ResourceLocation resourceLocation) {
        return new JsonSyntaxException("Unknown potion '" + resourceLocation + "'");
    }

    private static /* synthetic */ JsonSyntaxException func_218004_b(ResourceLocation resourceLocation) {
        return new JsonSyntaxException("Unknown item id '" + resourceLocation + "'");
    }

    public static class Builder {
        private final List<EnchantmentPredicate> field_200312_a = Lists.newArrayList();
        private final List<EnchantmentPredicate> field_226657_b_ = Lists.newArrayList();
        @Nullable
        private Item field_200313_b;
        @Nullable
        private ITag<Item> field_200314_c;
        private MinMaxBounds.IntBound field_200315_d = MinMaxBounds.IntBound.field_211347_e;
        private MinMaxBounds.IntBound field_200316_e = MinMaxBounds.IntBound.field_211347_e;
        @Nullable
        private Potion field_200317_f;
        private NBTPredicate field_200318_g = NBTPredicate.field_193479_a;

        private Builder() {
        }

        public static Builder func_200309_a() {
            return new Builder();
        }

        public Builder func_200308_a(IItemProvider iItemProvider) {
            this.field_200313_b = iItemProvider.func_199767_j();
            return this;
        }

        public Builder func_200307_a(ITag<Item> iTag) {
            this.field_200314_c = iTag;
            return this;
        }

        public Builder func_218002_a(CompoundNBT compoundNBT) {
            this.field_200318_g = new NBTPredicate(compoundNBT);
            return this;
        }

        public Builder func_218003_a(EnchantmentPredicate enchantmentPredicate) {
            this.field_200312_a.add(enchantmentPredicate);
            return this;
        }

        public ItemPredicate func_200310_b() {
            return new ItemPredicate(this.field_200314_c, this.field_200313_b, this.field_200315_d, this.field_200316_e, this.field_200312_a.toArray(EnchantmentPredicate.field_226534_b_), this.field_226657_b_.toArray(EnchantmentPredicate.field_226534_b_), this.field_200317_f, this.field_200318_g);
        }
    }
}

