/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.base.Charsets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.util.LWJGLMemoryUntracker;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public final class NativeImage
implements AutoCloseable {
    private static final Logger field_227785_a_ = LogManager.getLogger();
    private static final Set<StandardOpenOption> field_209272_a = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    private final PixelFormat field_211680_b;
    private final int field_195719_a;
    private final int field_195720_b;
    private final boolean field_195721_c;
    private long field_195722_d;
    private final long field_195723_e;

    public NativeImage(int p_i48122_1_, int p_i48122_2_, boolean p_i48122_3_) {
        this(PixelFormat.RGBA, p_i48122_1_, p_i48122_2_, p_i48122_3_);
    }

    public NativeImage(PixelFormat p_i49763_1_, int p_i49763_2_, int p_i49763_3_, boolean p_i49763_4_) {
        this.field_211680_b = p_i49763_1_;
        this.field_195719_a = p_i49763_2_;
        this.field_195720_b = p_i49763_3_;
        this.field_195723_e = (long)p_i49763_2_ * (long)p_i49763_3_ * (long)p_i49763_1_.func_211651_a();
        this.field_195721_c = false;
        this.field_195722_d = p_i49763_4_ ? MemoryUtil.nmemCalloc((long)1L, (long)this.field_195723_e) : MemoryUtil.nmemAlloc((long)this.field_195723_e);
    }

    private NativeImage(PixelFormat p_i49764_1_, int p_i49764_2_, int p_i49764_3_, boolean p_i49764_4_, long p_i49764_5_) {
        this.field_211680_b = p_i49764_1_;
        this.field_195719_a = p_i49764_2_;
        this.field_195720_b = p_i49764_3_;
        this.field_195721_c = p_i49764_4_;
        this.field_195722_d = p_i49764_5_;
        this.field_195723_e = p_i49764_2_ * p_i49764_3_ * p_i49764_1_.func_211651_a();
    }

    public String toString() {
        return "NativeImage[" + (Object)((Object)this.field_211680_b) + " " + this.field_195719_a + "x" + this.field_195720_b + "@" + this.field_195722_d + (this.field_195721_c ? "S" : "N") + "]";
    }

    public static NativeImage func_195713_a(InputStream p_195713_0_) throws IOException {
        return NativeImage.func_211679_a(PixelFormat.RGBA, p_195713_0_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeImage func_211679_a(@Nullable PixelFormat p_211679_0_, InputStream p_211679_1_) throws IOException {
        NativeImage nativeimage;
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.func_225684_a_((InputStream)p_211679_1_);
            ((Buffer)bytebuffer).rewind();
            nativeimage = NativeImage.func_211677_a(p_211679_0_, bytebuffer);
        }
        finally {
            MemoryUtil.memFree((Buffer)bytebuffer);
            IOUtils.closeQuietly((InputStream)p_211679_1_);
        }
        return nativeimage;
    }

    public static NativeImage func_195704_a(ByteBuffer p_195704_0_) throws IOException {
        return NativeImage.func_211677_a(PixelFormat.RGBA, p_195704_0_);
    }

    public static NativeImage func_211677_a(@Nullable PixelFormat p_211677_0_, ByteBuffer p_211677_1_) throws IOException {
        NativeImage nativeimage;
        if (p_211677_0_ != null && !p_211677_0_.func_211654_w()) {
            throw new UnsupportedOperationException("Don't know how to read format " + (Object)((Object)p_211677_0_));
        }
        if (MemoryUtil.memAddress((ByteBuffer)p_211677_1_) == 0L) {
            throw new IllegalArgumentException("Invalid buffer");
        }
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            ByteBuffer bytebuffer = STBImage.stbi_load_from_memory((ByteBuffer)p_211677_1_, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2, (int)(p_211677_0_ == null ? 0 : p_211677_0_.field_211659_e));
            if (bytebuffer == null) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            nativeimage = new NativeImage(p_211677_0_ == null ? PixelFormat.func_211646_b(intbuffer2.get(0)) : p_211677_0_, intbuffer.get(0), intbuffer1.get(0), true, MemoryUtil.memAddress((ByteBuffer)bytebuffer));
        }
        return nativeimage;
    }

    private static void func_195707_b(boolean p_195707_0_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (p_195707_0_) {
            GlStateManager.func_227677_b_(3553, 10242, 10496);
            GlStateManager.func_227677_b_(3553, 10243, 10496);
        } else {
            GlStateManager.func_227677_b_(3553, 10242, 10497);
            GlStateManager.func_227677_b_(3553, 10243, 10497);
        }
    }

    private static void func_195705_a(boolean p_195705_0_, boolean p_195705_1_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (p_195705_0_) {
            GlStateManager.func_227677_b_(3553, 10241, p_195705_1_ ? 9987 : 9729);
            GlStateManager.func_227677_b_(3553, 10240, 9729);
        } else {
            GlStateManager.func_227677_b_(3553, 10241, p_195705_1_ ? 9986 : 9728);
            GlStateManager.func_227677_b_(3553, 10240, 9728);
        }
    }

    private void func_195696_g() {
        if (this.field_195722_d == 0L) {
            throw new IllegalStateException("Image is not allocated.");
        }
    }

    @Override
    public void close() {
        if (this.field_195722_d != 0L) {
            if (this.field_195721_c) {
                STBImage.nstbi_image_free((long)this.field_195722_d);
            } else {
                MemoryUtil.nmemFree((long)this.field_195722_d);
            }
        }
        this.field_195722_d = 0L;
    }

    public int func_195702_a() {
        return this.field_195719_a;
    }

    public int func_195714_b() {
        return this.field_195720_b;
    }

    public PixelFormat func_211678_c() {
        return this.field_211680_b;
    }

    public int func_195709_a(int p_195709_1_, int p_195709_2_) {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.field_211680_b}));
        }
        if (p_195709_1_ >= 0 && p_195709_2_ >= 0 && p_195709_1_ < this.field_195719_a && p_195709_2_ < this.field_195720_b) {
            this.func_195696_g();
            long i = (p_195709_1_ + p_195709_2_ * this.field_195719_a) * 4;
            return MemoryUtil.memGetInt((long)(this.field_195722_d + i));
        }
        throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", p_195709_1_, p_195709_2_, this.field_195719_a, this.field_195720_b));
    }

    public void func_195700_a(int p_195700_1_, int p_195700_2_, int p_195700_3_) {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.field_211680_b}));
        }
        if (p_195700_1_ < 0 || p_195700_2_ < 0 || p_195700_1_ >= this.field_195719_a || p_195700_2_ >= this.field_195720_b) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", p_195700_1_, p_195700_2_, this.field_195719_a, this.field_195720_b));
        }
        this.func_195696_g();
        long i = (p_195700_1_ + p_195700_2_ * this.field_195719_a) * 4;
        MemoryUtil.memPutInt((long)(this.field_195722_d + i), (int)p_195700_3_);
    }

    public byte func_211675_e(int p_211675_1_, int p_211675_2_) {
        if (!this.field_211680_b.func_211653_r()) {
            throw new IllegalArgumentException(String.format("no luminance or alpha in %s", new Object[]{this.field_211680_b}));
        }
        if (p_211675_1_ >= 0 && p_211675_2_ >= 0 && p_211675_1_ < this.field_195719_a && p_211675_2_ < this.field_195720_b) {
            int i = (p_211675_1_ + p_211675_2_ * this.field_195719_a) * this.field_211680_b.func_211651_a() + this.field_211680_b.func_211647_v() / 8;
            return MemoryUtil.memGetByte((long)(this.field_195722_d + (long)i));
        }
        throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", p_211675_1_, p_211675_2_, this.field_195719_a, this.field_195720_b));
    }

    @Deprecated
    public int[] func_195716_c() {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new UnsupportedOperationException("can only call makePixelArray for RGBA images.");
        }
        this.func_195696_g();
        int[] aint = new int[this.func_195702_a() * this.func_195714_b()];
        for (int i = 0; i < this.func_195714_b(); ++i) {
            for (int j = 0; j < this.func_195702_a(); ++j) {
                int l1;
                int k = this.func_195709_a(j, i);
                int l = NativeImage.func_227786_a_(k);
                int i1 = NativeImage.func_227795_d_(k);
                int j1 = NativeImage.func_227793_c_(k);
                int k1 = NativeImage.func_227791_b_(k);
                aint[j + i * this.func_195702_a()] = l1 = l << 24 | k1 << 16 | j1 << 8 | i1;
            }
        }
        return aint;
    }

    public void func_195697_a(int p_195697_1_, int p_195697_2_, int p_195697_3_, boolean p_195697_4_) {
        this.func_227788_a_(p_195697_1_, p_195697_2_, p_195697_3_, 0, 0, this.field_195719_a, this.field_195720_b, false, p_195697_4_);
    }

    public void func_227788_a_(int p_227788_1_, int p_227788_2_, int p_227788_3_, int p_227788_4_, int p_227788_5_, int p_227788_6_, int p_227788_7_, boolean p_227788_8_, boolean p_227788_9_) {
        this.func_227789_a_(p_227788_1_, p_227788_2_, p_227788_3_, p_227788_4_, p_227788_5_, p_227788_6_, p_227788_7_, false, false, p_227788_8_, p_227788_9_);
    }

    public void func_227789_a_(int p_227789_1_, int p_227789_2_, int p_227789_3_, int p_227789_4_, int p_227789_5_, int p_227789_6_, int p_227789_7_, boolean p_227789_8_, boolean p_227789_9_, boolean p_227789_10_, boolean p_227789_11_) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.func_227792_b_(p_227789_1_, p_227789_2_, p_227789_3_, p_227789_4_, p_227789_5_, p_227789_6_, p_227789_7_, p_227789_8_, p_227789_9_, p_227789_10_, p_227789_11_));
        } else {
            this.func_227792_b_(p_227789_1_, p_227789_2_, p_227789_3_, p_227789_4_, p_227789_5_, p_227789_6_, p_227789_7_, p_227789_8_, p_227789_9_, p_227789_10_, p_227789_11_);
        }
    }

    private void func_227792_b_(int p_227792_1_, int p_227792_2_, int p_227792_3_, int p_227792_4_, int p_227792_5_, int p_227792_6_, int p_227792_7_, boolean p_227792_8_, boolean p_227792_9_, boolean p_227792_10_, boolean p_227792_11_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.func_195696_g();
        NativeImage.func_195705_a(p_227792_8_, p_227792_10_);
        NativeImage.func_195707_b(p_227792_9_);
        if (p_227792_6_ == this.func_195702_a()) {
            GlStateManager.func_227748_o_(3314, 0);
        } else {
            GlStateManager.func_227748_o_(3314, this.func_195702_a());
        }
        GlStateManager.func_227748_o_(3316, p_227792_4_);
        GlStateManager.func_227748_o_(3315, p_227792_5_);
        this.field_211680_b.func_211658_c();
        GlStateManager.func_227646_a_(3553, p_227792_1_, p_227792_2_, p_227792_3_, p_227792_6_, p_227792_7_, this.field_211680_b.func_211650_d(), 5121, this.field_195722_d);
        if (p_227792_11_) {
            this.close();
        }
    }

    public void func_195717_a(int p_195717_1_, boolean p_195717_2_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        this.func_195696_g();
        this.field_211680_b.func_211656_b();
        GlStateManager.func_227649_a_(3553, p_195717_1_, this.field_211680_b.func_211650_d(), 5121, this.field_195722_d);
        if (p_195717_2_ && this.field_211680_b.func_211645_i()) {
            for (int i = 0; i < this.func_195714_b(); ++i) {
                for (int j = 0; j < this.func_195702_a(); ++j) {
                    this.func_195700_a(j, i, this.func_195709_a(j, i) | 255 << this.field_211680_b.func_211648_n());
                }
            }
        }
    }

    public void func_209271_a(File p_209271_1_) throws IOException {
        this.func_209270_a(p_209271_1_.toPath());
    }

    public void func_211676_a(STBTTFontinfo p_211676_1_, int p_211676_2_, int p_211676_3_, int p_211676_4_, float p_211676_5_, float p_211676_6_, float p_211676_7_, float p_211676_8_, int p_211676_9_, int p_211676_10_) {
        if (p_211676_9_ >= 0 && p_211676_9_ + p_211676_3_ <= this.func_195702_a() && p_211676_10_ >= 0 && p_211676_10_ + p_211676_4_ <= this.func_195714_b()) {
            if (this.field_211680_b.func_211651_a() != 1) {
                throw new IllegalArgumentException("Can only write fonts into 1-component images.");
            }
        } else {
            throw new IllegalArgumentException(String.format("Out of bounds: start: (%s, %s) (size: %sx%s); size: %sx%s", p_211676_9_, p_211676_10_, p_211676_3_, p_211676_4_, this.func_195702_a(), this.func_195714_b()));
        }
        STBTruetype.nstbtt_MakeGlyphBitmapSubpixel((long)p_211676_1_.address(), (long)(this.field_195722_d + (long)p_211676_9_ + (long)(p_211676_10_ * this.func_195702_a())), (int)p_211676_3_, (int)p_211676_4_, (int)this.func_195702_a(), (float)p_211676_5_, (float)p_211676_6_, (float)p_211676_7_, (float)p_211676_8_, (int)p_211676_2_);
    }

    public void func_209270_a(Path p_209270_1_) throws IOException {
        if (!this.field_211680_b.func_211654_w()) {
            throw new UnsupportedOperationException("Don't know how to write format " + (Object)((Object)this.field_211680_b));
        }
        this.func_195696_g();
        try (SeekableByteChannel writablebytechannel = Files.newByteChannel(p_209270_1_, field_209272_a, new FileAttribute[0]);){
            if (!this.func_227790_a_(writablebytechannel)) {
                throw new IOException("Could not write image to the PNG file \"" + p_209270_1_.toAbsolutePath() + "\": " + STBImage.stbi_failure_reason());
            }
        }
    }

    public byte[] func_227796_e_() throws IOException {
        byte[] abyte;
        try (ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
             WritableByteChannel writablebytechannel = Channels.newChannel(bytearrayoutputstream);){
            if (!this.func_227790_a_(writablebytechannel)) {
                throw new IOException("Could not write image to byte array: " + STBImage.stbi_failure_reason());
            }
            abyte = bytearrayoutputstream.toByteArray();
        }
        return abyte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean func_227790_a_(WritableByteChannel p_227790_1_) throws IOException {
        boolean flag;
        WriteCallback nativeimage$writecallback = new WriteCallback(p_227790_1_);
        try {
            int i = Math.min(this.func_195714_b(), Integer.MAX_VALUE / this.func_195702_a() / this.field_211680_b.func_211651_a());
            if (i < this.func_195714_b()) {
                field_227785_a_.warn("Dropping image height from {} to {} to fit the size into 32-bit signed int", (Object)this.func_195714_b(), (Object)i);
            }
            if (STBImageWrite.nstbi_write_png_to_func((long)nativeimage$writecallback.address(), (long)0L, (int)this.func_195702_a(), (int)i, (int)this.field_211680_b.func_211651_a(), (long)this.field_195722_d, (int)0) != 0) {
                nativeimage$writecallback.func_209267_a();
                boolean bl = true;
                return bl;
            }
            flag = false;
        }
        finally {
            nativeimage$writecallback.free();
        }
        return flag;
    }

    public void func_195703_a(NativeImage p_195703_1_) {
        if (p_195703_1_.func_211678_c() != this.field_211680_b) {
            throw new UnsupportedOperationException("Image formats don't match.");
        }
        int i = this.field_211680_b.func_211651_a();
        this.func_195696_g();
        p_195703_1_.func_195696_g();
        if (this.field_195719_a == p_195703_1_.field_195719_a) {
            MemoryUtil.memCopy((long)p_195703_1_.field_195722_d, (long)this.field_195722_d, (long)Math.min(this.field_195723_e, p_195703_1_.field_195723_e));
        } else {
            int j = Math.min(this.func_195702_a(), p_195703_1_.func_195702_a());
            int k = Math.min(this.func_195714_b(), p_195703_1_.func_195714_b());
            for (int l = 0; l < k; ++l) {
                int i1 = l * p_195703_1_.func_195702_a() * i;
                int j1 = l * this.func_195702_a() * i;
                MemoryUtil.memCopy((long)(p_195703_1_.field_195722_d + (long)i1), (long)(this.field_195722_d + (long)j1), (long)j);
            }
        }
    }

    public void func_195715_a(int p_195715_1_, int p_195715_2_, int p_195715_3_, int p_195715_4_, int p_195715_5_) {
        for (int i = p_195715_2_; i < p_195715_2_ + p_195715_4_; ++i) {
            for (int j = p_195715_1_; j < p_195715_1_ + p_195715_3_; ++j) {
                this.func_195700_a(j, i, p_195715_5_);
            }
        }
    }

    public void func_195699_a(int p_195699_1_, int p_195699_2_, int p_195699_3_, int p_195699_4_, int p_195699_5_, int p_195699_6_, boolean p_195699_7_, boolean p_195699_8_) {
        for (int i = 0; i < p_195699_6_; ++i) {
            for (int j = 0; j < p_195699_5_; ++j) {
                int k = p_195699_7_ ? p_195699_5_ - 1 - j : j;
                int l = p_195699_8_ ? p_195699_6_ - 1 - i : i;
                int i1 = this.func_195709_a(p_195699_1_ + j, p_195699_2_ + i);
                this.func_195700_a(p_195699_1_ + p_195699_3_ + k, p_195699_2_ + p_195699_4_ + l, i1);
            }
        }
    }

    public void func_195710_e() {
        this.func_195696_g();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            int i = this.field_211680_b.func_211651_a();
            int j = this.func_195702_a() * i;
            long k = memorystack.nmalloc(j);
            for (int l = 0; l < this.func_195714_b() / 2; ++l) {
                int i1 = l * this.func_195702_a() * i;
                int j1 = (this.func_195714_b() - 1 - l) * this.func_195702_a() * i;
                MemoryUtil.memCopy((long)(this.field_195722_d + (long)i1), (long)k, (long)j);
                MemoryUtil.memCopy((long)(this.field_195722_d + (long)j1), (long)(this.field_195722_d + (long)i1), (long)j);
                MemoryUtil.memCopy((long)k, (long)(this.field_195722_d + (long)j1), (long)j);
            }
        }
    }

    public void func_195708_a(int p_195708_1_, int p_195708_2_, int p_195708_3_, int p_195708_4_, NativeImage p_195708_5_) {
        this.func_195696_g();
        if (p_195708_5_.func_211678_c() != this.field_211680_b) {
            throw new UnsupportedOperationException("resizeSubRectTo only works for images of the same format.");
        }
        int i = this.field_211680_b.func_211651_a();
        STBImageResize.nstbir_resize_uint8((long)(this.field_195722_d + (long)((p_195708_1_ + p_195708_2_ * this.func_195702_a()) * i)), (int)p_195708_3_, (int)p_195708_4_, (int)(this.func_195702_a() * i), (long)p_195708_5_.field_195722_d, (int)p_195708_5_.func_195702_a(), (int)p_195708_5_.func_195714_b(), (int)0, (int)i);
    }

    public void func_195711_f() {
        LWJGLMemoryUntracker.func_197933_a((long)this.field_195722_d);
    }

    public static NativeImage func_216511_b(String p_216511_0_) throws IOException {
        NativeImage nativeimage;
        byte[] abyte = Base64.getDecoder().decode(p_216511_0_.replaceAll("\n", "").getBytes(Charsets.UTF_8));
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(abyte.length);
            bytebuffer.put(abyte);
            ((Buffer)bytebuffer).rewind();
            nativeimage = NativeImage.func_195704_a(bytebuffer);
        }
        return nativeimage;
    }

    public static int func_227786_a_(int p_227786_0_) {
        return p_227786_0_ >> 24 & 0xFF;
    }

    public static int func_227791_b_(int p_227791_0_) {
        return p_227791_0_ >> 0 & 0xFF;
    }

    public static int func_227793_c_(int p_227793_0_) {
        return p_227793_0_ >> 8 & 0xFF;
    }

    public static int func_227795_d_(int p_227795_0_) {
        return p_227795_0_ >> 16 & 0xFF;
    }

    public static int func_227787_a_(int p_227787_0_, int p_227787_1_, int p_227787_2_, int p_227787_3_) {
        return (p_227787_0_ & 0xFF) << 24 | (p_227787_1_ & 0xFF) << 16 | (p_227787_2_ & 0xFF) << 8 | (p_227787_3_ & 0xFF) << 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class WriteCallback
    extends STBIWriteCallback {
        private final WritableByteChannel field_209268_a;
        @Nullable
        private IOException field_209269_b;

        private WriteCallback(WritableByteChannel p_i49388_1_) {
            this.field_209268_a = p_i49388_1_;
        }

        public void invoke(long p_invoke_1_, long p_invoke_3_, int p_invoke_5_) {
            ByteBuffer bytebuffer = WriteCallback.getData((long)p_invoke_3_, (int)p_invoke_5_);
            try {
                this.field_209268_a.write(bytebuffer);
            }
            catch (IOException ioexception) {
                this.field_209269_b = ioexception;
            }
        }

        public void func_209267_a() throws IOException {
            if (this.field_209269_b != null) {
                throw this.field_209269_b;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum PixelFormatGLCode {
        RGBA(6408),
        RGB(6407),
        LUMINANCE_ALPHA(6410),
        LUMINANCE(6409),
        INTENSITY(32841);

        private final int field_211673_f;

        private PixelFormatGLCode(int p_i49761_3_) {
            this.field_211673_f = p_i49761_3_;
        }

        int func_211672_a() {
            return this.field_211673_f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum PixelFormat {
        RGBA(4, 6408, true, true, true, false, true, 0, 8, 16, 255, 24, true),
        RGB(3, 6407, true, true, true, false, false, 0, 8, 16, 255, 255, true),
        LUMINANCE_ALPHA(2, 6410, false, false, false, true, true, 255, 255, 255, 0, 8, true),
        LUMINANCE(1, 6409, false, false, false, true, false, 0, 0, 0, 0, 255, true);

        private final int field_211659_e;
        private final int field_211660_f;
        private final boolean field_211661_g;
        private final boolean field_211662_h;
        private final boolean field_211663_i;
        private final boolean field_211664_j;
        private final boolean field_211665_k;
        private final int field_211666_l;
        private final int field_211667_m;
        private final int field_211668_n;
        private final int field_211669_o;
        private final int field_211670_p;
        private final boolean field_211671_q;

        private PixelFormat(int p_i49762_3_, int p_i49762_4_, boolean p_i49762_5_, boolean p_i49762_6_, boolean p_i49762_7_, boolean p_i49762_8_, boolean p_i49762_9_, int p_i49762_10_, int p_i49762_11_, int p_i49762_12_, int p_i49762_13_, int p_i49762_14_, boolean p_i49762_15_) {
            this.field_211659_e = p_i49762_3_;
            this.field_211660_f = p_i49762_4_;
            this.field_211661_g = p_i49762_5_;
            this.field_211662_h = p_i49762_6_;
            this.field_211663_i = p_i49762_7_;
            this.field_211664_j = p_i49762_8_;
            this.field_211665_k = p_i49762_9_;
            this.field_211666_l = p_i49762_10_;
            this.field_211667_m = p_i49762_11_;
            this.field_211668_n = p_i49762_12_;
            this.field_211669_o = p_i49762_13_;
            this.field_211670_p = p_i49762_14_;
            this.field_211671_q = p_i49762_15_;
        }

        public int func_211651_a() {
            return this.field_211659_e;
        }

        public void func_211656_b() {
            RenderSystem.assertThread(RenderSystem::isOnRenderThread);
            GlStateManager.func_227748_o_(3333, this.func_211651_a());
        }

        public void func_211658_c() {
            RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
            GlStateManager.func_227748_o_(3317, this.func_211651_a());
        }

        public int func_211650_d() {
            return this.field_211660_f;
        }

        public boolean func_211645_i() {
            return this.field_211665_k;
        }

        public int func_211648_n() {
            return this.field_211670_p;
        }

        public boolean func_211653_r() {
            return this.field_211664_j || this.field_211665_k;
        }

        public int func_211647_v() {
            return this.field_211664_j ? this.field_211669_o : this.field_211670_p;
        }

        public boolean func_211654_w() {
            return this.field_211671_q;
        }

        private static PixelFormat func_211646_b(int p_211646_0_) {
            switch (p_211646_0_) {
                case 1: {
                    return LUMINANCE;
                }
                case 2: {
                    return LUMINANCE_ALPHA;
                }
                case 3: {
                    return RGB;
                }
            }
            return RGBA;
        }
    }
}

