/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.network.play.server.STagsListPacket;
import net.minecraft.network.play.server.STeamsPacket;
import net.minecraft.network.play.server.SUpdateRecipesPacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.network.play.server.SUpdateViewDistancePacket;
import net.minecraft.network.play.server.SWorldBorderPacket;
import net.minecraft.network.play.server.SWorldSpawnChangedPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.BanList;
import net.minecraft.server.management.DemoPlayerInteractionManager;
import net.minecraft.server.management.IPBanEntry;
import net.minecraft.server.management.IPBanList;
import net.minecraft.server.management.OpEntry;
import net.minecraft.server.management.OpList;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.ProfileBanEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.WhiteList;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraft.world.storage.PlayerData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PlayerList {
    public static final File field_152613_a = new File("banned-players.json");
    public static final File field_152614_b = new File("banned-ips.json");
    public static final File field_152615_c = new File("ops.json");
    public static final File field_152616_d = new File("whitelist.json");
    private static final Logger field_148546_d = LogManager.getLogger();
    private static final SimpleDateFormat field_72403_e = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer field_72400_f;
    private final List<ServerPlayerEntity> field_72404_b = Lists.newArrayList();
    private final Map<UUID, ServerPlayerEntity> field_177454_f = Maps.newHashMap();
    private final BanList field_72401_g = new BanList(field_152613_a);
    private final IPBanList field_72413_h = new IPBanList(field_152614_b);
    private final OpList field_72414_i = new OpList(field_152615_c);
    private final WhiteList field_72411_j = new WhiteList(field_152616_d);
    private final Map<UUID, ServerStatisticsManager> field_148547_k = Maps.newHashMap();
    private final Map<UUID, PlayerAdvancements> field_192055_p = Maps.newHashMap();
    private final PlayerData field_72412_k;
    private boolean field_72409_l;
    private final DynamicRegistries.Impl field_232639_s_;
    protected final int field_72405_c;
    private int field_72402_d;
    private GameType field_72410_m;
    private boolean field_72407_n;
    private int field_72408_o;
    private final List<ServerPlayerEntity> playersView = Collections.unmodifiableList(this.field_72404_b);

    public PlayerList(MinecraftServer p_i231425_1_, DynamicRegistries.Impl p_i231425_2_, PlayerData p_i231425_3_, int p_i231425_4_) {
        this.field_72400_f = p_i231425_1_;
        this.field_232639_s_ = p_i231425_2_;
        this.field_72405_c = p_i231425_4_;
        this.field_72412_k = p_i231425_3_;
    }

    public void func_72355_a(NetworkManager p_72355_1_, ServerPlayerEntity p_72355_2_) {
        CompoundNBT compoundnbt1;
        Entity entity1;
        ServerWorld serverworld1;
        GameProfile gameprofile = p_72355_2_.func_146103_bH();
        PlayerProfileCache playerprofilecache = this.field_72400_f.func_152358_ax();
        GameProfile gameprofile1 = playerprofilecache.func_152652_a(gameprofile.getId());
        String s = gameprofile1 == null ? gameprofile.getName() : gameprofile1.getName();
        playerprofilecache.func_152649_a(gameprofile);
        CompoundNBT compoundnbt = this.func_72380_a(p_72355_2_);
        RegistryKey<World> registrykey = compoundnbt != null ? DimensionType.func_236025_a_((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compoundnbt.func_74781_a("Dimension"))).resultOrPartial(arg_0 -> ((Logger)field_148546_d).error(arg_0)).orElse(World.field_234918_g_) : World.field_234918_g_;
        ServerWorld serverworld = this.field_72400_f.func_71218_a(registrykey);
        if (serverworld == null) {
            field_148546_d.warn("Unknown respawn dimension {}, defaulting to overworld", registrykey);
            serverworld1 = this.field_72400_f.func_241755_D_();
        } else {
            serverworld1 = serverworld;
        }
        p_72355_2_.func_70029_a(serverworld1);
        p_72355_2_.field_71134_c.func_73080_a((ServerWorld)p_72355_2_.field_70170_p);
        String s1 = "local";
        if (p_72355_1_.func_74430_c() != null) {
            s1 = p_72355_1_.func_74430_c().toString();
        }
        field_148546_d.info("{}[{}] logged in with entity id {} at ({}, {}, {})", (Object)p_72355_2_.func_200200_C_().getString(), (Object)s1, (Object)p_72355_2_.func_145782_y(), (Object)p_72355_2_.func_226277_ct_(), (Object)p_72355_2_.func_226278_cu_(), (Object)p_72355_2_.func_226281_cx_());
        IWorldInfo iworldinfo = serverworld1.func_72912_H();
        this.func_72381_a(p_72355_2_, null, serverworld1);
        ServerPlayNetHandler serverplaynethandler = new ServerPlayNetHandler(this.field_72400_f, p_72355_1_, p_72355_2_);
        NetworkHooks.sendMCRegistryPackets((NetworkManager)p_72355_1_, (String)"PLAY_TO_CLIENT");
        GameRules gamerules = serverworld1.func_82736_K();
        boolean flag = gamerules.func_223586_b(GameRules.field_226683_z_);
        boolean flag1 = gamerules.func_223586_b(GameRules.field_223612_o);
        serverplaynethandler.func_147359_a((IPacket<?>)new SJoinGamePacket(p_72355_2_.func_145782_y(), p_72355_2_.field_71134_c.func_73081_b(), p_72355_2_.field_71134_c.func_241815_c_(), BiomeManager.func_235200_a_((long)serverworld1.func_72905_C()), iworldinfo.func_76093_s(), this.field_72400_f.func_240770_D_(), this.field_232639_s_, serverworld1.func_230315_m_(), serverworld1.func_234923_W_(), this.func_72352_l(), this.field_72402_d, flag1, !flag, serverworld1.func_234925_Z_(), serverworld1.func_241109_A_()));
        serverplaynethandler.func_147359_a(new SCustomPayloadPlayPacket(SCustomPayloadPlayPacket.field_209911_b, new PacketBuffer(Unpooled.buffer()).func_180714_a(this.func_72365_p().getServerModName())));
        serverplaynethandler.func_147359_a((IPacket<?>)new SServerDifficultyPacket(iworldinfo.func_176130_y(), iworldinfo.func_176123_z()));
        serverplaynethandler.func_147359_a((IPacket<?>)new SPlayerAbilitiesPacket(p_72355_2_.field_71075_bZ));
        serverplaynethandler.func_147359_a((IPacket<?>)new SHeldItemChangePacket(p_72355_2_.field_71071_by.field_70461_c));
        MinecraftForge.EVENT_BUS.post((Event)new OnDatapackSyncEvent(this, p_72355_2_));
        serverplaynethandler.func_147359_a((IPacket<?>)new SUpdateRecipesPacket(this.field_72400_f.func_199529_aN().func_199510_b()));
        serverplaynethandler.func_147359_a((IPacket<?>)new STagsListPacket(this.field_72400_f.func_244266_aF()));
        NetworkHooks.syncCustomTagTypes((ServerPlayerEntity)p_72355_2_, (ITagCollectionSupplier)this.field_72400_f.func_244266_aF());
        this.func_187243_f(p_72355_2_);
        p_72355_2_.func_147099_x().func_150877_d();
        p_72355_2_.func_192037_E().func_192826_c(p_72355_2_);
        this.func_96456_a(serverworld1.func_96441_U(), p_72355_2_);
        this.field_72400_f.func_147132_au();
        TranslationTextComponent iformattabletextcomponent = p_72355_2_.func_146103_bH().getName().equalsIgnoreCase(s) ? new TranslationTextComponent("multiplayer.player.joined", p_72355_2_.func_145748_c_()) : new TranslationTextComponent("multiplayer.player.joined.renamed", p_72355_2_.func_145748_c_(), s);
        this.func_232641_a_((ITextComponent)iformattabletextcomponent.func_240699_a_(TextFormatting.YELLOW), ChatType.SYSTEM, Util.field_240973_b_);
        serverplaynethandler.func_147364_a(p_72355_2_.func_226277_ct_(), p_72355_2_.func_226278_cu_(), p_72355_2_.func_226281_cx_(), p_72355_2_.field_70177_z, p_72355_2_.field_70125_A);
        this.addPlayer(p_72355_2_);
        this.field_177454_f.put(p_72355_2_.func_110124_au(), p_72355_2_);
        this.func_148540_a((IPacket<?>)new SPlayerListItemPacket(SPlayerListItemPacket.Action.ADD_PLAYER, new ServerPlayerEntity[]{p_72355_2_}));
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            p_72355_2_.field_71135_a.func_147359_a((IPacket<?>)new SPlayerListItemPacket(SPlayerListItemPacket.Action.ADD_PLAYER, new ServerPlayerEntity[]{this.field_72404_b.get(i)}));
        }
        serverworld1.func_217435_c(p_72355_2_);
        this.field_72400_f.func_201300_aS().func_201383_a(p_72355_2_);
        this.func_72354_b(p_72355_2_, serverworld1);
        if (!this.field_72400_f.func_147133_T().isEmpty()) {
            p_72355_2_.func_175397_a(this.field_72400_f.func_147133_T(), this.field_72400_f.func_175581_ab());
        }
        for (EffectInstance effectinstance : p_72355_2_.func_70651_bq()) {
            serverplaynethandler.func_147359_a((IPacket<?>)new SPlayEntityEffectPacket(p_72355_2_.func_145782_y(), effectinstance));
        }
        if (compoundnbt != null && compoundnbt.func_150297_b("RootVehicle", 10) && (entity1 = EntityType.func_220335_a((compoundnbt1 = compoundnbt.func_74775_l("RootVehicle")).func_74775_l("Entity"), serverworld1, p_217885_1_ -> !serverworld1.func_217470_d((Entity)((Object)p_217885_1_)) ? null : p_217885_1_)) != null) {
            UUID uuid = compoundnbt1.func_186855_b("Attach") ? compoundnbt1.func_186857_a("Attach") : null;
            if (entity1.func_110124_au().equals(uuid)) {
                p_72355_2_.func_184205_a(entity1, true);
            } else {
                for (Entity entity : entity1.func_184182_bu()) {
                    if (!entity.func_110124_au().equals(uuid)) continue;
                    p_72355_2_.func_184205_a(entity, true);
                    break;
                }
            }
            if (!p_72355_2_.func_184218_aH()) {
                field_148546_d.warn("Couldn't reattach entity to player");
                serverworld1.func_217467_h(entity1);
                for (Entity entity2 : entity1.func_184182_bu()) {
                    serverworld1.func_217467_h(entity2);
                }
            }
        }
        p_72355_2_.func_71116_b();
        BasicEventHooks.firePlayerLoggedIn((PlayerEntity)p_72355_2_);
    }

    protected void func_96456_a(ServerScoreboard p_96456_1_, ServerPlayerEntity p_96456_2_) {
        HashSet set = Sets.newHashSet();
        for (ScorePlayerTeam scoreplayerteam : p_96456_1_.func_96525_g()) {
            p_96456_2_.field_71135_a.func_147359_a((IPacket<?>)new STeamsPacket(scoreplayerteam, 0));
        }
        for (int i = 0; i < 19; ++i) {
            ScoreObjective scoreobjective = p_96456_1_.func_96539_a(i);
            if (scoreobjective == null || set.contains(scoreobjective)) continue;
            for (IPacket ipacket : p_96456_1_.func_96550_d(scoreobjective)) {
                p_96456_2_.field_71135_a.func_147359_a(ipacket);
            }
            set.add(scoreobjective);
        }
    }

    public void func_212504_a(ServerWorld p_212504_1_) {
        p_212504_1_.func_175723_af().func_177737_a(new IBorderListener(){

            public void func_177694_a(WorldBorder p_177694_1_, double p_177694_2_) {
                PlayerList.this.func_148540_a((IPacket<?>)new SWorldBorderPacket(p_177694_1_, SWorldBorderPacket.Action.SET_SIZE));
            }

            public void func_177692_a(WorldBorder p_177692_1_, double p_177692_2_, double p_177692_4_, long p_177692_6_) {
                PlayerList.this.func_148540_a((IPacket<?>)new SWorldBorderPacket(p_177692_1_, SWorldBorderPacket.Action.LERP_SIZE));
            }

            public void func_177693_a(WorldBorder p_177693_1_, double p_177693_2_, double p_177693_4_) {
                PlayerList.this.func_148540_a((IPacket<?>)new SWorldBorderPacket(p_177693_1_, SWorldBorderPacket.Action.SET_CENTER));
            }

            public void func_177691_a(WorldBorder p_177691_1_, int p_177691_2_) {
                PlayerList.this.func_148540_a((IPacket<?>)new SWorldBorderPacket(p_177691_1_, SWorldBorderPacket.Action.SET_WARNING_TIME));
            }

            public void func_177690_b(WorldBorder p_177690_1_, int p_177690_2_) {
                PlayerList.this.func_148540_a((IPacket<?>)new SWorldBorderPacket(p_177690_1_, SWorldBorderPacket.Action.SET_WARNING_BLOCKS));
            }

            public void func_177696_b(WorldBorder p_177696_1_, double p_177696_2_) {
            }

            public void func_177695_c(WorldBorder p_177695_1_, double p_177695_2_) {
            }
        });
    }

    @Nullable
    public CompoundNBT func_72380_a(ServerPlayerEntity p_72380_1_) {
        CompoundNBT compoundnbt1;
        CompoundNBT compoundnbt = this.field_72400_f.func_240793_aU_().func_230416_x_();
        if (p_72380_1_.func_200200_C_().getString().equals(this.field_72400_f.func_71214_G()) && compoundnbt != null) {
            compoundnbt1 = compoundnbt;
            p_72380_1_.func_70020_e(compoundnbt);
            field_148546_d.debug("loading single player");
            ForgeEventFactory.firePlayerLoadingEvent((PlayerEntity)p_72380_1_, (PlayerData)this.field_72412_k, (String)p_72380_1_.func_110124_au().toString());
        } else {
            compoundnbt1 = this.field_72412_k.func_237336_b_(p_72380_1_);
        }
        return compoundnbt1;
    }

    protected void func_72391_b(ServerPlayerEntity p_72391_1_) {
        PlayerAdvancements playeradvancements;
        if (p_72391_1_.field_71135_a == null) {
            return;
        }
        this.field_72412_k.func_237335_a_(p_72391_1_);
        ServerStatisticsManager serverstatisticsmanager = this.field_148547_k.get(p_72391_1_.func_110124_au());
        if (serverstatisticsmanager != null) {
            serverstatisticsmanager.func_150883_b();
        }
        if ((playeradvancements = this.field_192055_p.get(p_72391_1_.func_110124_au())) != null) {
            playeradvancements.func_192749_b();
        }
    }

    public void func_72367_e(ServerPlayerEntity p_72367_1_) {
        Entity entity;
        BasicEventHooks.firePlayerLoggedOut((PlayerEntity)p_72367_1_);
        ServerWorld serverworld = p_72367_1_.func_71121_q();
        p_72367_1_.func_195066_a(Stats.field_75947_j);
        this.func_72391_b(p_72367_1_);
        if (p_72367_1_.func_184218_aH() && (entity = p_72367_1_.func_184208_bv()).func_200601_bK()) {
            field_148546_d.debug("Removing player mount");
            p_72367_1_.func_184210_p();
            serverworld.func_217467_h(entity);
            entity.field_70128_L = true;
            for (Entity entity1 : entity.func_184182_bu()) {
                serverworld.func_217467_h(entity1);
                entity1.field_70128_L = true;
            }
            serverworld.func_212866_a_(p_72367_1_.field_70176_ah, p_72367_1_.field_70164_aj).func_76630_e();
        }
        p_72367_1_.func_213319_R();
        serverworld.func_217434_e(p_72367_1_);
        p_72367_1_.func_192039_O().func_192745_a();
        this.removePlayer(p_72367_1_);
        this.field_72400_f.func_201300_aS().func_201382_b(p_72367_1_);
        UUID uuid = p_72367_1_.func_110124_au();
        ServerPlayerEntity serverplayerentity = this.field_177454_f.get(uuid);
        if (serverplayerentity == p_72367_1_) {
            this.field_177454_f.remove(uuid);
            this.field_148547_k.remove(uuid);
            this.field_192055_p.remove(uuid);
        }
        this.func_148540_a((IPacket<?>)new SPlayerListItemPacket(SPlayerListItemPacket.Action.REMOVE_PLAYER, new ServerPlayerEntity[]{p_72367_1_}));
    }

    @Nullable
    public ITextComponent func_206258_a(SocketAddress p_206258_1_, GameProfile p_206258_2_) {
        if (this.field_72401_g.func_152702_a(p_206258_2_)) {
            ProfileBanEntry profilebanentry = (ProfileBanEntry)this.field_72401_g.func_152683_b((Object)p_206258_2_);
            TranslationTextComponent iformattabletextcomponent1 = new TranslationTextComponent("multiplayer.disconnect.banned.reason", profilebanentry.func_73686_f());
            if (profilebanentry.func_73680_d() != null) {
                iformattabletextcomponent1.func_230529_a_((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.banned.expiration", field_72403_e.format(profilebanentry.func_73680_d())));
            }
            return iformattabletextcomponent1;
        }
        if (!this.func_152607_e(p_206258_2_)) {
            return new TranslationTextComponent("multiplayer.disconnect.not_whitelisted");
        }
        if (this.field_72413_h.func_152708_a(p_206258_1_)) {
            IPBanEntry ipbanentry = this.field_72413_h.func_152709_b(p_206258_1_);
            TranslationTextComponent iformattabletextcomponent = new TranslationTextComponent("multiplayer.disconnect.banned_ip.reason", ipbanentry.func_73686_f());
            if (ipbanentry.func_73680_d() != null) {
                iformattabletextcomponent.func_230529_a_((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.banned_ip.expiration", field_72403_e.format(ipbanentry.func_73680_d())));
            }
            return iformattabletextcomponent;
        }
        return this.field_72404_b.size() >= this.field_72405_c && !this.func_183023_f(p_206258_2_) ? new TranslationTextComponent("multiplayer.disconnect.server_full") : null;
    }

    public ServerPlayerEntity func_148545_a(GameProfile p_148545_1_) {
        UUID uuid = PlayerEntity.func_146094_a(p_148545_1_);
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            Object serverplayerentity = this.field_72404_b.get(i);
            if (!serverplayerentity.func_110124_au().equals(uuid)) continue;
            list.add(serverplayerentity);
        }
        ServerPlayerEntity serverplayerentity2 = this.field_177454_f.get(p_148545_1_.getId());
        if (serverplayerentity2 != null && !list.contains((Object)serverplayerentity2)) {
            list.add(serverplayerentity2);
        }
        for (ServerPlayerEntity serverplayerentity1 : list) {
            serverplayerentity1.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.duplicate_login"));
        }
        ServerWorld serverworld = this.field_72400_f.func_241755_D_();
        Object playerinteractionmanager = this.field_72400_f.func_71242_L() ? new DemoPlayerInteractionManager(serverworld) : new PlayerInteractionManager(serverworld);
        return new ServerPlayerEntity(this.field_72400_f, serverworld, p_148545_1_, (PlayerInteractionManager)playerinteractionmanager);
    }

    public ServerPlayerEntity func_232644_a_(ServerPlayerEntity p_232644_1_, boolean p_232644_2_) {
        this.removePlayer(p_232644_1_);
        p_232644_1_.func_71121_q().removePlayer(p_232644_1_, true);
        BlockPos blockpos = p_232644_1_.func_241140_K_();
        float f = p_232644_1_.func_242109_L();
        boolean flag = p_232644_1_.func_241142_M_();
        ServerWorld serverworld = this.field_72400_f.func_71218_a(p_232644_1_.func_241141_L_());
        Optional<Object> optional = serverworld != null && blockpos != null ? PlayerEntity.func_242374_a(serverworld, blockpos, f, flag, p_232644_2_) : Optional.empty();
        ServerWorld serverworld1 = serverworld != null && optional.isPresent() ? serverworld : this.field_72400_f.func_241755_D_();
        Object playerinteractionmanager = this.field_72400_f.func_71242_L() ? new DemoPlayerInteractionManager(serverworld1) : new PlayerInteractionManager(serverworld1);
        ServerPlayerEntity serverplayerentity = new ServerPlayerEntity(this.field_72400_f, serverworld1, p_232644_1_.func_146103_bH(), (PlayerInteractionManager)playerinteractionmanager);
        serverplayerentity.field_71135_a = p_232644_1_.field_71135_a;
        serverplayerentity.func_193104_a(p_232644_1_, p_232644_2_);
        p_232644_1_.remove(false);
        serverplayerentity.func_145769_d(p_232644_1_.func_145782_y());
        serverplayerentity.func_184819_a(p_232644_1_.func_184591_cq());
        for (String s : p_232644_1_.func_184216_O()) {
            serverplayerentity.func_184211_a(s);
        }
        this.func_72381_a(serverplayerentity, p_232644_1_, serverworld1);
        boolean flag2 = false;
        if (optional.isPresent()) {
            float f1;
            BlockState blockstate = serverworld1.func_180495_p(blockpos);
            boolean flag1 = blockstate.func_203425_a(Blocks.field_235400_nj_);
            Vector3d vector3d = (Vector3d)optional.get();
            if (!blockstate.func_235714_a_(BlockTags.field_219747_F) && !flag1) {
                f1 = f;
            } else {
                Vector3d vector3d1 = Vector3d.func_237492_c_((Vector3i)blockpos).func_178788_d(vector3d).func_72432_b();
                f1 = (float)MathHelper.func_76138_g((double)(MathHelper.func_181159_b((double)vector3d1.field_72449_c, (double)vector3d1.field_72450_a) * 57.2957763671875 - 90.0));
            }
            serverplayerentity.func_70012_b(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, f1, 0.0f);
            serverplayerentity.func_242111_a(serverworld1.func_234923_W_(), blockpos, f, flag, false);
            flag2 = !p_232644_2_ && flag1;
        } else if (blockpos != null) {
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241764_a_, 0.0f));
        }
        while (!serverworld1.func_226669_j_(serverplayerentity) && serverplayerentity.func_226278_cu_() < 256.0) {
            serverplayerentity.func_70107_b(serverplayerentity.func_226277_ct_(), serverplayerentity.func_226278_cu_() + 1.0, serverplayerentity.func_226281_cx_());
        }
        IWorldInfo iworldinfo = serverplayerentity.field_70170_p.func_72912_H();
        serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SRespawnPacket(serverplayerentity.field_70170_p.func_230315_m_(), serverplayerentity.field_70170_p.func_234923_W_(), BiomeManager.func_235200_a_((long)serverplayerentity.func_71121_q().func_72905_C()), serverplayerentity.field_71134_c.func_73081_b(), serverplayerentity.field_71134_c.func_241815_c_(), serverplayerentity.func_71121_q().func_234925_Z_(), serverplayerentity.func_71121_q().func_241109_A_(), p_232644_2_));
        serverplayerentity.field_71135_a.func_147364_a(serverplayerentity.func_226277_ct_(), serverplayerentity.func_226278_cu_(), serverplayerentity.func_226281_cx_(), serverplayerentity.field_70177_z, serverplayerentity.field_70125_A);
        serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SWorldSpawnChangedPacket(serverworld1.func_241135_u_(), serverworld1.func_242107_v()));
        serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SServerDifficultyPacket(iworldinfo.func_176130_y(), iworldinfo.func_176123_z()));
        serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SSetExperiencePacket(serverplayerentity.field_71106_cc, serverplayerentity.field_71067_cb, serverplayerentity.field_71068_ca));
        this.func_72354_b(serverplayerentity, serverworld1);
        this.func_187243_f(serverplayerentity);
        serverworld1.func_217433_d(serverplayerentity);
        this.addPlayer(serverplayerentity);
        this.field_177454_f.put(serverplayerentity.func_110124_au(), serverplayerentity);
        serverplayerentity.func_71116_b();
        serverplayerentity.func_70606_j(serverplayerentity.func_110143_aJ());
        BasicEventHooks.firePlayerRespawnEvent((PlayerEntity)serverplayerentity, (boolean)p_232644_2_);
        if (flag2) {
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SPlaySoundEffectPacket(SoundEvents.field_232818_ms_, SoundCategory.BLOCKS, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), 1.0f, 1.0f));
        }
        return serverplayerentity;
    }

    public void func_187243_f(ServerPlayerEntity p_187243_1_) {
        GameProfile gameprofile = p_187243_1_.func_146103_bH();
        int i = this.field_72400_f.func_211833_a(gameprofile);
        this.func_187245_a(p_187243_1_, i);
    }

    public void func_72374_b() {
        if (++this.field_72408_o > 600) {
            this.func_148540_a((IPacket<?>)new SPlayerListItemPacket(SPlayerListItemPacket.Action.UPDATE_LATENCY, this.field_72404_b));
            this.field_72408_o = 0;
        }
    }

    public void func_148540_a(IPacket<?> p_148540_1_) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.field_72404_b.get((int)i).field_71135_a.func_147359_a(p_148540_1_);
        }
    }

    public void func_232642_a_(IPacket<?> p_232642_1_, RegistryKey<World> p_232642_2_) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            ServerPlayerEntity serverplayerentity = this.field_72404_b.get(i);
            if (serverplayerentity.field_70170_p.func_234923_W_() != p_232642_2_) continue;
            serverplayerentity.field_71135_a.func_147359_a(p_232642_1_);
        }
    }

    public void func_177453_a(PlayerEntity p_177453_1_, ITextComponent p_177453_2_) {
        Team team = p_177453_1_.func_96124_cp();
        if (team != null) {
            for (String s : team.func_96670_d()) {
                ServerPlayerEntity serverplayerentity = this.func_152612_a(s);
                if (serverplayerentity == null || serverplayerentity == p_177453_1_) continue;
                serverplayerentity.func_145747_a(p_177453_2_, p_177453_1_.func_110124_au());
            }
        }
    }

    public void func_177452_b(PlayerEntity p_177452_1_, ITextComponent p_177452_2_) {
        Team team = p_177452_1_.func_96124_cp();
        if (team == null) {
            this.func_232641_a_(p_177452_2_, ChatType.SYSTEM, p_177452_1_.func_110124_au());
        } else {
            for (int i = 0; i < this.field_72404_b.size(); ++i) {
                ServerPlayerEntity serverplayerentity = this.field_72404_b.get(i);
                if (serverplayerentity.func_96124_cp() == team) continue;
                serverplayerentity.func_145747_a(p_177452_2_, p_177452_1_.func_110124_au());
            }
        }
    }

    public String[] func_72369_d() {
        String[] astring = new String[this.field_72404_b.size()];
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            astring[i] = this.field_72404_b.get(i).func_146103_bH().getName();
        }
        return astring;
    }

    public BanList func_152608_h() {
        return this.field_72401_g;
    }

    public IPBanList func_72363_f() {
        return this.field_72413_h;
    }

    public void func_152605_a(GameProfile p_152605_1_) {
        this.field_72414_i.func_152687_a((UserListEntry)new OpEntry(p_152605_1_, this.field_72400_f.func_110455_j(), this.field_72414_i.func_183026_b(p_152605_1_)));
        ServerPlayerEntity serverplayerentity = this.func_177451_a(p_152605_1_.getId());
        if (serverplayerentity != null) {
            this.func_187243_f(serverplayerentity);
        }
    }

    public void func_152610_b(GameProfile p_152610_1_) {
        this.field_72414_i.func_152684_c((Object)p_152610_1_);
        ServerPlayerEntity serverplayerentity = this.func_177451_a(p_152610_1_.getId());
        if (serverplayerentity != null) {
            this.func_187243_f(serverplayerentity);
        }
    }

    private void func_187245_a(ServerPlayerEntity p_187245_1_, int p_187245_2_) {
        if (p_187245_1_.field_71135_a != null) {
            byte b0 = p_187245_2_ <= 0 ? (byte)24 : (p_187245_2_ >= 4 ? (byte)28 : (byte)((byte)(24 + p_187245_2_)));
            p_187245_1_.field_71135_a.func_147359_a((IPacket<?>)new SEntityStatusPacket((Entity)p_187245_1_, b0));
        }
        this.field_72400_f.func_195571_aL().func_197051_a(p_187245_1_);
    }

    public boolean func_152607_e(GameProfile p_152607_1_) {
        return !this.field_72409_l || this.field_72414_i.func_152692_d((Object)p_152607_1_) || this.field_72411_j.func_152692_d((Object)p_152607_1_);
    }

    public boolean func_152596_g(GameProfile p_152596_1_) {
        return this.field_72414_i.func_152692_d((Object)p_152596_1_) || this.field_72400_f.func_213199_b(p_152596_1_) && this.field_72400_f.func_240793_aU_().func_76086_u() || this.field_72407_n;
    }

    @Nullable
    public ServerPlayerEntity func_152612_a(String p_152612_1_) {
        for (ServerPlayerEntity serverplayerentity : this.field_72404_b) {
            if (!serverplayerentity.func_146103_bH().getName().equalsIgnoreCase(p_152612_1_)) continue;
            return serverplayerentity;
        }
        return null;
    }

    public void func_148543_a(@Nullable PlayerEntity p_148543_1_, double p_148543_2_, double p_148543_4_, double p_148543_6_, double p_148543_8_, RegistryKey<World> p_148543_10_, IPacket<?> p_148543_11_) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            double d2;
            double d1;
            double d0;
            ServerPlayerEntity serverplayerentity = this.field_72404_b.get(i);
            if (serverplayerentity == p_148543_1_ || serverplayerentity.field_70170_p.func_234923_W_() != p_148543_10_ || !((d0 = p_148543_2_ - serverplayerentity.func_226277_ct_()) * d0 + (d1 = p_148543_4_ - serverplayerentity.func_226278_cu_()) * d1 + (d2 = p_148543_6_ - serverplayerentity.func_226281_cx_()) * d2 < p_148543_8_ * p_148543_8_)) continue;
            serverplayerentity.field_71135_a.func_147359_a(p_148543_11_);
        }
    }

    public void func_72389_g() {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.func_72391_b(this.field_72404_b.get(i));
        }
    }

    public WhiteList func_152599_k() {
        return this.field_72411_j;
    }

    public String[] func_152598_l() {
        return this.field_72411_j.func_152685_a();
    }

    public OpList func_152603_m() {
        return this.field_72414_i;
    }

    public String[] func_152606_n() {
        return this.field_72414_i.func_152685_a();
    }

    public void func_187244_a() {
    }

    public void func_72354_b(ServerPlayerEntity p_72354_1_, ServerWorld p_72354_2_) {
        WorldBorder worldborder = this.field_72400_f.func_241755_D_().func_175723_af();
        p_72354_1_.field_71135_a.func_147359_a((IPacket<?>)new SWorldBorderPacket(worldborder, SWorldBorderPacket.Action.INITIALIZE));
        p_72354_1_.field_71135_a.func_147359_a((IPacket<?>)new SUpdateTimePacket(p_72354_2_.func_82737_E(), p_72354_2_.func_72820_D(), p_72354_2_.func_82736_K().func_223586_b(GameRules.field_223607_j)));
        p_72354_1_.field_71135_a.func_147359_a((IPacket<?>)new SWorldSpawnChangedPacket(p_72354_2_.func_241135_u_(), p_72354_2_.func_242107_v()));
        if (p_72354_2_.func_72896_J()) {
            p_72354_1_.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241765_b_, 0.0f));
            p_72354_1_.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241771_h_, p_72354_2_.func_72867_j(1.0f)));
            p_72354_1_.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241772_i_, p_72354_2_.func_72819_i(1.0f)));
        }
    }

    public void func_72385_f(ServerPlayerEntity p_72385_1_) {
        p_72385_1_.func_71120_a(p_72385_1_.field_71069_bz);
        p_72385_1_.func_71118_n();
        p_72385_1_.field_71135_a.func_147359_a((IPacket<?>)new SHeldItemChangePacket(p_72385_1_.field_71071_by.field_70461_c));
    }

    public int func_72394_k() {
        return this.field_72404_b.size();
    }

    public int func_72352_l() {
        return this.field_72405_c;
    }

    public boolean func_72383_n() {
        return this.field_72409_l;
    }

    public void func_72371_a(boolean p_72371_1_) {
        this.field_72409_l = p_72371_1_;
    }

    public List<ServerPlayerEntity> func_72382_j(String p_72382_1_) {
        ArrayList list = Lists.newArrayList();
        for (ServerPlayerEntity serverplayerentity : this.field_72404_b) {
            if (!serverplayerentity.func_71114_r().equals(p_72382_1_)) continue;
            list.add(serverplayerentity);
        }
        return list;
    }

    public int func_72395_o() {
        return this.field_72402_d;
    }

    public MinecraftServer func_72365_p() {
        return this.field_72400_f;
    }

    public CompoundNBT func_72378_q() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_152604_a(GameType p_152604_1_) {
        this.field_72410_m = p_152604_1_;
    }

    private void func_72381_a(ServerPlayerEntity p_72381_1_, @Nullable ServerPlayerEntity p_72381_2_, ServerWorld p_72381_3_) {
        if (p_72381_2_ != null) {
            p_72381_1_.field_71134_c.func_241820_a(p_72381_2_.field_71134_c.func_73081_b(), p_72381_2_.field_71134_c.func_241815_c_());
        } else if (this.field_72410_m != null) {
            p_72381_1_.field_71134_c.func_241820_a(this.field_72410_m, GameType.NOT_SET);
        }
        p_72381_1_.field_71134_c.func_73077_b(p_72381_3_.func_73046_m().func_240793_aU_().func_76077_q());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_72387_b(boolean p_72387_1_) {
        this.field_72407_n = p_72387_1_;
    }

    public void func_72392_r() {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.field_72404_b.get((int)i).field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.server_shutdown"));
        }
    }

    public void func_232641_a_(ITextComponent p_232641_1_, ChatType p_232641_2_, UUID p_232641_3_) {
        this.field_72400_f.func_145747_a(p_232641_1_, p_232641_3_);
        this.func_148540_a((IPacket<?>)new SChatPacket(p_232641_1_, p_232641_2_, p_232641_3_));
    }

    public ServerStatisticsManager func_152602_a(PlayerEntity p_152602_1_) {
        ServerStatisticsManager serverstatisticsmanager;
        UUID uuid = p_152602_1_.func_110124_au();
        ServerStatisticsManager serverStatisticsManager = serverstatisticsmanager = uuid == null ? null : this.field_148547_k.get(uuid);
        if (serverstatisticsmanager == null) {
            File file1 = this.field_72400_f.func_240776_a_(FolderName.field_237246_b_).toFile();
            File file2 = new File(file1, uuid + ".json");
            serverstatisticsmanager = new ServerStatisticsManager(this.field_72400_f, file2);
            this.field_148547_k.put(uuid, serverstatisticsmanager);
        }
        return serverstatisticsmanager;
    }

    public PlayerAdvancements func_192054_h(ServerPlayerEntity p_192054_1_) {
        UUID uuid = p_192054_1_.func_110124_au();
        PlayerAdvancements playeradvancements = this.field_192055_p.get(uuid);
        if (playeradvancements == null) {
            File file1 = this.field_72400_f.func_240776_a_(FolderName.field_237245_a_).toFile();
            File file2 = new File(file1, uuid + ".json");
            playeradvancements = new PlayerAdvancements(this.field_72400_f.func_195563_aC(), this, this.field_72400_f.func_191949_aK(), file2, p_192054_1_);
            this.field_192055_p.put(uuid, playeradvancements);
        }
        if (!(p_192054_1_ instanceof FakePlayer)) {
            playeradvancements.func_192739_a(p_192054_1_);
        }
        return playeradvancements;
    }

    public void func_217884_a(int p_217884_1_) {
        this.field_72402_d = p_217884_1_;
        this.func_148540_a((IPacket<?>)new SUpdateViewDistancePacket(p_217884_1_));
        for (ServerWorld serverworld : this.field_72400_f.func_212370_w()) {
            if (serverworld == null) continue;
            serverworld.func_72863_F().func_217219_a(p_217884_1_);
        }
    }

    public List<ServerPlayerEntity> func_181057_v() {
        return this.playersView;
    }

    @Nullable
    public ServerPlayerEntity func_177451_a(UUID p_177451_1_) {
        return this.field_177454_f.get(p_177451_1_);
    }

    public boolean func_183023_f(GameProfile p_183023_1_) {
        return false;
    }

    public void func_193244_w() {
        for (PlayerAdvancements playeradvancements : this.field_192055_p.values()) {
            playeradvancements.func_240918_a_(this.field_72400_f.func_191949_aK());
        }
        MinecraftForge.EVENT_BUS.post((Event)new OnDatapackSyncEvent(this, null));
        this.func_148540_a((IPacket<?>)new STagsListPacket(this.field_72400_f.func_244266_aF()));
        NetworkHooks.syncCustomTagTypes((ITagCollectionSupplier)this.field_72400_f.func_244266_aF());
        SUpdateRecipesPacket supdaterecipespacket = new SUpdateRecipesPacket(this.field_72400_f.func_199529_aN().func_199510_b());
        for (ServerPlayerEntity serverplayerentity : this.field_72404_b) {
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)supdaterecipespacket);
            serverplayerentity.func_192037_E().func_192826_c(serverplayerentity);
        }
    }

    public boolean func_206257_x() {
        return this.field_72407_n;
    }

    public boolean addPlayer(ServerPlayerEntity player) {
        return this.field_72404_b.add(player);
    }

    public boolean removePlayer(ServerPlayerEntity player) {
        return this.field_72404_b.remove((Object)player);
    }
}

