/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.OverlayRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class GameRenderer
implements IResourceManagerReloadListener,
AutoCloseable {
    private static final ResourceLocation field_243496_c = new ResourceLocation("textures/misc/nausea.png");
    private static final Logger field_147710_q = LogManager.getLogger();
    private final Minecraft field_78531_r;
    private final IResourceManager field_147711_ac;
    private final Random field_78537_ab = new Random();
    private float field_78530_s;
    public final FirstPersonRenderer field_78516_c;
    private final MapItemRenderer field_147709_v;
    private final RenderTypeBuffers field_228374_i_;
    private int field_78529_t;
    private float field_78507_R;
    private float field_78506_S;
    private float field_82831_U;
    private float field_82832_V;
    private boolean field_175074_C = true;
    private boolean field_175073_D = true;
    private long field_184374_E;
    private long field_78508_Y = Util.func_211177_b();
    private final LightTexture field_78513_d;
    private final OverlayTexture field_228375_t_ = new OverlayTexture();
    private boolean field_175078_W;
    private float field_78503_V = 1.0f;
    private float field_228376_w_;
    private float field_228377_x_;
    @Nullable
    private ItemStack field_190566_ab;
    private int field_190567_ac;
    private float field_190568_ad;
    private float field_190569_ae;
    @Nullable
    private ShaderGroup field_147707_d;
    private static final ResourceLocation[] field_147712_ad = new ResourceLocation[]{new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/fxaa.json"), new ResourceLocation("shaders/post/art.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/blobs2.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("shaders/post/color_convolve.json"), new ResourceLocation("shaders/post/deconverge.json"), new ResourceLocation("shaders/post/flip.json"), new ResourceLocation("shaders/post/invert.json"), new ResourceLocation("shaders/post/ntsc.json"), new ResourceLocation("shaders/post/outline.json"), new ResourceLocation("shaders/post/phosphor.json"), new ResourceLocation("shaders/post/scan_pincushion.json"), new ResourceLocation("shaders/post/sobel.json"), new ResourceLocation("shaders/post/bits.json"), new ResourceLocation("shaders/post/desaturate.json"), new ResourceLocation("shaders/post/green.json"), new ResourceLocation("shaders/post/blur.json"), new ResourceLocation("shaders/post/wobble.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/antialias.json"), new ResourceLocation("shaders/post/creeper.json"), new ResourceLocation("shaders/post/spider.json")};
    public static final int field_147708_e = field_147712_ad.length;
    private int field_147713_ae = field_147708_e;
    private boolean field_175083_ad;
    private final ActiveRenderInfo field_215317_L = new ActiveRenderInfo();

    public GameRenderer(Minecraft p_i225966_1_, IResourceManager p_i225966_2_, RenderTypeBuffers p_i225966_3_) {
        this.field_78531_r = p_i225966_1_;
        this.field_147711_ac = p_i225966_2_;
        this.field_78516_c = p_i225966_1_.func_175597_ag();
        this.field_147709_v = new MapItemRenderer(p_i225966_1_.func_110434_K());
        this.field_78513_d = new LightTexture(this, p_i225966_1_);
        this.field_228374_i_ = p_i225966_3_;
        this.field_147707_d = null;
    }

    @Override
    public void close() {
        this.field_78513_d.close();
        this.field_147709_v.close();
        this.field_228375_t_.close();
        this.func_181022_b();
    }

    public void func_181022_b() {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        this.field_147713_ae = field_147708_e;
    }

    public void func_175071_c() {
        this.field_175083_ad = !this.field_175083_ad;
    }

    public void func_175066_a(@Nullable Entity p_175066_1_) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        if (p_175066_1_ instanceof CreeperEntity) {
            this.func_175069_a(new ResourceLocation("shaders/post/creeper.json"));
        } else if (p_175066_1_ instanceof SpiderEntity) {
            this.func_175069_a(new ResourceLocation("shaders/post/spider.json"));
        } else if (p_175066_1_ instanceof EndermanEntity) {
            this.func_175069_a(new ResourceLocation("shaders/post/invert.json"));
        } else {
            ForgeHooksClient.loadEntityShader((Entity)p_175066_1_, (GameRenderer)this);
        }
    }

    public void func_175069_a(ResourceLocation p_175069_1_) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        try {
            this.field_147707_d = new ShaderGroup(this.field_78531_r.func_110434_K(), this.field_147711_ac, this.field_78531_r.func_147110_a(), p_175069_1_);
            this.field_147707_d.func_148026_a(this.field_78531_r.func_228018_at_().func_198109_k(), this.field_78531_r.func_228018_at_().func_198091_l());
            this.field_175083_ad = true;
        }
        catch (IOException ioexception) {
            field_147710_q.warn("Failed to load shader: {}", (Object)p_175069_1_, (Object)ioexception);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            field_147710_q.warn("Failed to parse shader: {}", (Object)p_175069_1_, (Object)jsonsyntaxexception);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
    }

    @Override
    public void func_195410_a(IResourceManager p_195410_1_) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        if (this.field_147713_ae == field_147708_e) {
            this.func_175066_a(this.field_78531_r.func_175606_aa());
        } else {
            this.func_175069_a(field_147712_ad[this.field_147713_ae]);
        }
    }

    public void func_78464_a() {
        this.func_78477_e();
        this.field_78513_d.func_205107_a();
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a(this.field_78531_r.field_71439_g);
        }
        this.field_215317_L.func_216783_a();
        ++this.field_78529_t;
        this.field_78516_c.func_78441_a();
        this.field_78531_r.field_71438_f.func_228436_a_(this.field_215317_L);
        this.field_82832_V = this.field_82831_U;
        if (this.field_78531_r.field_71456_v.func_184046_j().func_184053_e()) {
            this.field_82831_U += 0.05f;
            if (this.field_82831_U > 1.0f) {
                this.field_82831_U = 1.0f;
            }
        } else if (this.field_82831_U > 0.0f) {
            this.field_82831_U -= 0.0125f;
        }
        if (this.field_190567_ac > 0) {
            --this.field_190567_ac;
            if (this.field_190567_ac == 0) {
                this.field_190566_ab = null;
            }
        }
    }

    @Nullable
    public ShaderGroup func_147706_e() {
        return this.field_147707_d;
    }

    public void func_147704_a(int p_147704_1_, int p_147704_2_) {
        if (this.field_147707_d != null) {
            this.field_147707_d.func_148026_a(p_147704_1_, p_147704_2_);
        }
        this.field_78531_r.field_71438_f.func_72720_a(p_147704_1_, p_147704_2_);
    }

    public void func_78473_a(float p_78473_1_) {
        Entity entity = this.field_78531_r.func_175606_aa();
        if (entity != null && this.field_78531_r.field_71441_e != null) {
            this.field_78531_r.func_213239_aq().func_76320_a("pick");
            this.field_78531_r.field_147125_j = null;
            double d0 = this.field_78531_r.field_71442_b.func_78757_d();
            this.field_78531_r.field_71476_x = entity.func_213324_a(d0, p_78473_1_, false);
            Vector3d vector3d = entity.func_174824_e(p_78473_1_);
            boolean flag = false;
            int i = 3;
            double d1 = d0;
            if (this.field_78531_r.field_71442_b.func_78749_i()) {
                d0 = d1 = 6.0;
            } else if (d0 > 3.0) {
                flag = true;
            }
            d1 *= d1;
            if (this.field_78531_r.field_71476_x != null) {
                d1 = this.field_78531_r.field_71476_x.func_216347_e().func_72436_e(vector3d);
            }
            Vector3d vector3d1 = entity.func_70676_i(1.0f);
            Vector3d vector3d2 = vector3d.func_72441_c(vector3d1.field_72450_a * d0, vector3d1.field_72448_b * d0, vector3d1.field_72449_c * d0);
            float f = 1.0f;
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_216361_a(vector3d1.func_186678_a(d0)).func_72314_b(1.0, 1.0, 1.0);
            EntityRayTraceResult entityraytraceresult = ProjectileHelper.func_221273_a(entity, vector3d, vector3d2, axisalignedbb, p_215312_0_ -> !p_215312_0_.func_175149_v() && p_215312_0_.func_70067_L(), d1);
            if (entityraytraceresult != null) {
                Entity entity1 = entityraytraceresult.func_216348_a();
                Vector3d vector3d3 = entityraytraceresult.func_216347_e();
                double d2 = vector3d.func_72436_e(vector3d3);
                if (flag && d2 > 9.0) {
                    this.field_78531_r.field_71476_x = BlockRayTraceResult.func_216352_a((Vector3d)vector3d3, (Direction)Direction.func_210769_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c), (BlockPos)new BlockPos(vector3d3));
                } else if (d2 < d1 || this.field_78531_r.field_71476_x == null) {
                    this.field_78531_r.field_71476_x = entityraytraceresult;
                    if (entity1 instanceof LivingEntity || entity1 instanceof ItemFrameEntity) {
                        this.field_78531_r.field_147125_j = entity1;
                    }
                }
            }
            this.field_78531_r.func_213239_aq().func_76319_b();
        }
    }

    private void func_78477_e() {
        float f = 1.0f;
        if (this.field_78531_r.func_175606_aa() instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity abstractclientplayerentity = (AbstractClientPlayerEntity)this.field_78531_r.func_175606_aa();
            f = abstractclientplayerentity.func_175156_o();
        }
        this.field_78506_S = this.field_78507_R;
        this.field_78507_R += (f - this.field_78507_R) * 0.5f;
        if (this.field_78507_R > 1.5f) {
            this.field_78507_R = 1.5f;
        }
        if (this.field_78507_R < 0.1f) {
            this.field_78507_R = 0.1f;
        }
    }

    private double func_215311_a(ActiveRenderInfo p_215311_1_, float p_215311_2_, boolean p_215311_3_) {
        FluidState fluidstate;
        if (this.field_175078_W) {
            return 90.0;
        }
        double d0 = 70.0;
        if (p_215311_3_) {
            d0 = this.field_78531_r.field_71474_y.field_74334_X;
            d0 *= (double)MathHelper.func_219799_g((float)p_215311_2_, (float)this.field_78506_S, (float)this.field_78507_R);
        }
        if (p_215311_1_.func_216773_g() instanceof LivingEntity && ((LivingEntity)p_215311_1_.func_216773_g()).func_233643_dh_()) {
            float f = Math.min((float)((LivingEntity)p_215311_1_.func_216773_g()).field_70725_aQ + p_215311_2_, 20.0f);
            d0 /= (double)((1.0f - 500.0f / (f + 500.0f)) * 2.0f + 1.0f);
        }
        if (!(fluidstate = p_215311_1_.func_216771_k()).func_206888_e()) {
            d0 = d0 * 60.0 / 70.0;
        }
        return ForgeHooksClient.getFOVModifier((GameRenderer)this, (ActiveRenderInfo)p_215311_1_, (double)p_215311_2_, (double)d0);
    }

    private void func_228380_a_(MatrixStack p_228380_1_, float p_228380_2_) {
        if (this.field_78531_r.func_175606_aa() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)this.field_78531_r.func_175606_aa();
            float f = (float)livingentity.field_70737_aN - p_228380_2_;
            if (livingentity.func_233643_dh_()) {
                float f1 = Math.min((float)livingentity.field_70725_aQ + p_228380_2_, 20.0f);
                p_228380_1_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(40.0f - 8000.0f / (f1 + 200.0f)));
            }
            if (f < 0.0f) {
                return;
            }
            f /= (float)livingentity.field_70738_aO;
            f = MathHelper.func_76126_a((float)(f * f * f * f * (float)Math.PI));
            float f2 = livingentity.field_70739_aP;
            p_228380_1_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f2));
            p_228380_1_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-f * 14.0f));
            p_228380_1_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f2));
        }
    }

    private void func_228383_b_(MatrixStack p_228383_1_, float p_228383_2_) {
        if (this.field_78531_r.func_175606_aa() instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)this.field_78531_r.func_175606_aa();
            float f = playerentity.field_70140_Q - playerentity.field_70141_P;
            float f1 = -(playerentity.field_70140_Q + f * p_228383_2_);
            float f2 = MathHelper.func_219799_g((float)p_228383_2_, (float)playerentity.field_71107_bF, (float)playerentity.field_71109_bG);
            p_228383_1_.func_227861_a_((double)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.5f), (double)(-Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f2)), 0.0);
            p_228383_1_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 3.0f));
            p_228383_1_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f));
        }
    }

    private void func_228381_a_(MatrixStack p_228381_1_, ActiveRenderInfo p_228381_2_, float p_228381_3_) {
        if (!this.field_175078_W) {
            boolean flag;
            this.func_228379_a_(this.func_228382_a_(p_228381_2_, p_228381_3_, false));
            MatrixStack.Entry matrixstack$entry = p_228381_1_.func_227866_c_();
            matrixstack$entry.func_227870_a_().func_226591_a_();
            matrixstack$entry.func_227872_b_().func_226119_c_();
            p_228381_1_.func_227860_a_();
            this.func_228380_a_(p_228381_1_, p_228381_3_);
            if (this.field_78531_r.field_71474_y.field_74336_f) {
                this.func_228383_b_(p_228381_1_, p_228381_3_);
            }
            boolean bl = flag = this.field_78531_r.func_175606_aa() instanceof LivingEntity && ((LivingEntity)this.field_78531_r.func_175606_aa()).func_70608_bn();
            if (this.field_78531_r.field_71474_y.func_243230_g().func_243192_a() && !flag && !this.field_78531_r.field_71474_y.field_74319_N && this.field_78531_r.field_71442_b.func_178889_l() != GameType.SPECTATOR) {
                this.field_78513_d.func_205109_c();
                this.field_78516_c.func_228396_a_(p_228381_3_, p_228381_1_, this.field_228374_i_.func_228487_b_(), this.field_78531_r.field_71439_g, this.field_78531_r.func_175598_ae().func_229085_a_(this.field_78531_r.field_71439_g, p_228381_3_));
                this.field_78513_d.func_205108_b();
            }
            p_228381_1_.func_227865_b_();
            if (this.field_78531_r.field_71474_y.func_243230_g().func_243192_a() && !flag) {
                OverlayRenderer.func_228734_a_(this.field_78531_r, p_228381_1_);
                this.func_228380_a_(p_228381_1_, p_228381_3_);
            }
            if (this.field_78531_r.field_71474_y.field_74336_f) {
                this.func_228383_b_(p_228381_1_, p_228381_3_);
            }
        }
    }

    public void func_228379_a_(Matrix4f p_228379_1_) {
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix((Matrix4f)p_228379_1_);
        RenderSystem.matrixMode((int)5888);
    }

    public Matrix4f func_228382_a_(ActiveRenderInfo p_228382_1_, float p_228382_2_, boolean p_228382_3_) {
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227866_c_().func_227870_a_().func_226591_a_();
        if (this.field_78503_V != 1.0f) {
            matrixstack.func_227861_a_((double)this.field_228376_w_, (double)(-this.field_228377_x_), 0.0);
            matrixstack.func_227862_a_(this.field_78503_V, this.field_78503_V, 1.0f);
        }
        matrixstack.func_227866_c_().func_227870_a_().func_226595_a_(Matrix4f.func_195876_a(this.func_215311_a(p_228382_1_, p_228382_2_, p_228382_3_), (float)this.field_78531_r.func_228018_at_().func_198109_k() / (float)this.field_78531_r.func_228018_at_().func_198091_l(), 0.05f, this.field_78530_s * 4.0f));
        return matrixstack.func_227866_c_().func_227870_a_();
    }

    public static float func_180438_a(LivingEntity p_180438_0_, float p_180438_1_) {
        int i = p_180438_0_.func_70660_b(Effects.field_76439_r).func_76459_b();
        return i > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)(((float)i - p_180438_1_) * (float)Math.PI * 0.2f)) * 0.3f;
    }

    public void func_195458_a(float p_195458_1_, long p_195458_2_, boolean p_195458_4_) {
        if (!(this.field_78531_r.func_195544_aj() || !this.field_78531_r.field_71474_y.field_82881_y || this.field_78531_r.field_71474_y.field_85185_A && this.field_78531_r.field_71417_B.func_198031_d())) {
            if (Util.func_211177_b() - this.field_78508_Y > 500L) {
                this.field_78531_r.func_71385_j(false);
            }
        } else {
            this.field_78508_Y = Util.func_211177_b();
        }
        if (!this.field_78531_r.field_71454_w) {
            int i = (int)(this.field_78531_r.field_71417_B.func_198024_e() * (double)this.field_78531_r.func_228018_at_().func_198107_o() / (double)this.field_78531_r.func_228018_at_().func_198105_m());
            int j = (int)(this.field_78531_r.field_71417_B.func_198026_f() * (double)this.field_78531_r.func_228018_at_().func_198087_p() / (double)this.field_78531_r.func_228018_at_().func_198083_n());
            RenderSystem.viewport((int)0, (int)0, (int)this.field_78531_r.func_228018_at_().func_198109_k(), (int)this.field_78531_r.func_228018_at_().func_198091_l());
            if (p_195458_4_ && this.field_78531_r.field_71441_e != null) {
                this.field_78531_r.func_213239_aq().func_76320_a("level");
                this.func_228378_a_(p_195458_1_, p_195458_2_, new MatrixStack());
                if (this.field_78531_r.func_71356_B() && this.field_184374_E < Util.func_211177_b() - 1000L) {
                    this.field_184374_E = Util.func_211177_b();
                    if (!this.field_78531_r.func_71401_C().func_184106_y()) {
                        this.func_184373_n();
                    }
                }
                this.field_78531_r.field_71438_f.func_174975_c();
                if (this.field_147707_d != null && this.field_175083_ad) {
                    RenderSystem.disableBlend();
                    RenderSystem.disableDepthTest();
                    RenderSystem.disableAlphaTest();
                    RenderSystem.enableTexture();
                    RenderSystem.matrixMode((int)5890);
                    RenderSystem.pushMatrix();
                    RenderSystem.loadIdentity();
                    this.field_147707_d.func_148018_a(p_195458_1_);
                    RenderSystem.popMatrix();
                    RenderSystem.enableTexture();
                }
                this.field_78531_r.func_147110_a().func_147610_a(true);
            }
            MainWindow mainwindow = this.field_78531_r.func_228018_at_();
            RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
            RenderSystem.matrixMode((int)5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)((double)mainwindow.func_198109_k() / mainwindow.func_198100_s()), (double)((double)mainwindow.func_198091_l() / mainwindow.func_198100_s()), (double)0.0, (double)1000.0, (double)ForgeHooksClient.getGuiFarPlane());
            RenderSystem.matrixMode((int)5888);
            RenderSystem.loadIdentity();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)(1000.0f - ForgeHooksClient.getGuiFarPlane()));
            RenderHelper.func_227784_d_();
            MatrixStack matrixstack = new MatrixStack();
            if (p_195458_4_ && this.field_78531_r.field_71441_e != null) {
                float f;
                this.field_78531_r.func_213239_aq().func_219895_b("gui");
                if (this.field_78531_r.field_71439_g != null && (f = MathHelper.func_219799_g((float)p_195458_1_, (float)this.field_78531_r.field_71439_g.field_71080_cy, (float)this.field_78531_r.field_71439_g.field_71086_bY)) > 0.0f && this.field_78531_r.field_71439_g.func_70644_a(Effects.field_76431_k) && this.field_78531_r.field_71474_y.field_243226_aM < 1.0f) {
                    this.func_243497_c(f * (1.0f - this.field_78531_r.field_71474_y.field_243226_aM));
                }
                if (!this.field_78531_r.field_71474_y.field_74319_N || this.field_78531_r.field_71462_r != null) {
                    RenderSystem.defaultAlphaFunc();
                    this.func_190563_a(this.field_78531_r.func_228018_at_().func_198107_o(), this.field_78531_r.func_228018_at_().func_198087_p(), p_195458_1_);
                    this.field_78531_r.field_71456_v.func_238445_a_(matrixstack, p_195458_1_);
                    RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
                }
                this.field_78531_r.func_213239_aq().func_76319_b();
            }
            if (this.field_78531_r.field_213279_p != null) {
                try {
                    this.field_78531_r.field_213279_p.func_230430_a_(matrixstack, i, j, this.field_78531_r.func_193989_ak());
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport = CrashReport.func_85055_a(throwable1, "Rendering overlay");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Overlay render details");
                    crashreportcategory.func_189529_a("Overlay name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_78531_r.field_213279_p.getClass().getCanonicalName()));
                    throw new ReportedException(crashreport);
                }
            }
            if (this.field_78531_r.field_71462_r != null) {
                try {
                    ForgeHooksClient.drawScreen((Screen)this.field_78531_r.field_71462_r, (MatrixStack)matrixstack, (int)i, (int)j, (float)this.field_78531_r.func_193989_ak());
                }
                catch (Throwable throwable) {
                    CrashReport crashreport1 = CrashReport.func_85055_a(throwable, "Rendering screen");
                    CrashReportCategory crashreportcategory1 = crashreport1.func_85058_a("Screen render details");
                    crashreportcategory1.func_189529_a("Screen name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> ((Object)((Object)this.field_78531_r.field_71462_r)).getClass().getCanonicalName()));
                    crashreportcategory1.func_189529_a("Mouse location", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%f, %f)", i, j, this.field_78531_r.field_71417_B.func_198024_e(), this.field_78531_r.field_71417_B.func_198026_f())));
                    crashreportcategory1.func_189529_a("Screen size", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%d, %d). Scale factor of %f", this.field_78531_r.func_228018_at_().func_198107_o(), this.field_78531_r.func_228018_at_().func_198087_p(), this.field_78531_r.func_228018_at_().func_198109_k(), this.field_78531_r.func_228018_at_().func_198091_l(), this.field_78531_r.func_228018_at_().func_198100_s())));
                    throw new ReportedException(crashreport1);
                }
            }
        }
    }

    private void func_184373_n() {
        if (this.field_78531_r.field_71438_f.func_184382_g() > 10 && this.field_78531_r.field_71438_f.func_184384_n() && !this.field_78531_r.func_71401_C().func_184106_y()) {
            NativeImage nativeimage = ScreenShotHelper.func_198052_a(this.field_78531_r.func_228018_at_().func_198109_k(), this.field_78531_r.func_228018_at_().func_198091_l(), this.field_78531_r.func_147110_a());
            Util.func_240992_g_().execute(() -> {
                int i = nativeimage.func_195702_a();
                int j = nativeimage.func_195714_b();
                int k = 0;
                int l = 0;
                if (i > j) {
                    k = (i - j) / 2;
                    i = j;
                } else {
                    l = (j - i) / 2;
                    j = i;
                }
                try (NativeImage nativeimage1 = new NativeImage(64, 64, false);){
                    nativeimage.func_195708_a(k, l, i, j, nativeimage1);
                    nativeimage1.func_209271_a(this.field_78531_r.func_71401_C().func_184109_z());
                }
                catch (IOException ioexception) {
                    field_147710_q.warn("Couldn't save auto screenshot", (Throwable)ioexception);
                }
                finally {
                    nativeimage.close();
                }
            });
        }
    }

    private boolean func_175070_n() {
        boolean flag;
        if (!this.field_175073_D) {
            return false;
        }
        Entity entity = this.field_78531_r.func_175606_aa();
        boolean bl = flag = entity instanceof PlayerEntity && !this.field_78531_r.field_71474_y.field_74319_N;
        if (flag && !((PlayerEntity)entity).field_71075_bZ.field_75099_e) {
            ItemStack itemstack = ((LivingEntity)entity).func_184614_ca();
            RayTraceResult raytraceresult = this.field_78531_r.field_71476_x;
            if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockRayTraceResult)raytraceresult).func_216350_a();
                BlockState blockstate = this.field_78531_r.field_71441_e.func_180495_p(blockpos);
                if (this.field_78531_r.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
                    flag = blockstate.func_215699_b(this.field_78531_r.field_71441_e, blockpos) != null;
                } else {
                    CachedBlockInfo cachedblockinfo = new CachedBlockInfo((IWorldReader)((Object)this.field_78531_r.field_71441_e), blockpos, false);
                    flag = !itemstack.func_190926_b() && (itemstack.func_206848_a(this.field_78531_r.field_71441_e.func_205772_D(), cachedblockinfo) || itemstack.func_206847_b(this.field_78531_r.field_71441_e.func_205772_D(), cachedblockinfo));
                }
            }
        }
        return flag;
    }

    public void func_228378_a_(float p_228378_1_, long p_228378_2_, MatrixStack p_228378_4_) {
        float f;
        this.field_78513_d.func_205106_a(p_228378_1_);
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a(this.field_78531_r.field_71439_g);
        }
        this.func_78473_a(p_228378_1_);
        this.field_78531_r.func_213239_aq().func_76320_a("center");
        boolean flag = this.func_175070_n();
        this.field_78531_r.func_213239_aq().func_219895_b("camera");
        ActiveRenderInfo activerenderinfo = this.field_215317_L;
        this.field_78530_s = this.field_78531_r.field_71474_y.field_151451_c * 16;
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227866_c_().func_227870_a_().func_226595_a_(this.func_228382_a_(activerenderinfo, p_228378_1_, true));
        this.func_228380_a_(matrixstack, p_228378_1_);
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_228383_b_(matrixstack, p_228378_1_);
        }
        if ((f = MathHelper.func_219799_g((float)p_228378_1_, (float)this.field_78531_r.field_71439_g.field_71080_cy, (float)this.field_78531_r.field_71439_g.field_71086_bY) * this.field_78531_r.field_71474_y.field_243226_aM * this.field_78531_r.field_71474_y.field_243226_aM) > 0.0f) {
            int i = this.field_78531_r.field_71439_g.func_70644_a(Effects.field_76431_k) ? 7 : 20;
            float f1 = 5.0f / (f * f + 5.0f) - f * 0.04f;
            f1 *= f1;
            Vector3f vector3f = new Vector3f(0.0f, MathHelper.field_180189_a / 2.0f, MathHelper.field_180189_a / 2.0f);
            matrixstack.func_227863_a_(vector3f.func_229187_a_(((float)this.field_78529_t + p_228378_1_) * (float)i));
            matrixstack.func_227862_a_(1.0f / f1, 1.0f, 1.0f);
            float f2 = -((float)this.field_78529_t + p_228378_1_) * (float)i;
            matrixstack.func_227863_a_(vector3f.func_229187_a_(f2));
        }
        Matrix4f matrix4f = matrixstack.func_227866_c_().func_227870_a_();
        this.func_228379_a_(matrix4f);
        activerenderinfo.func_216772_a((IBlockReader)((Object)this.field_78531_r.field_71441_e), this.field_78531_r.func_175606_aa() == null ? this.field_78531_r.field_71439_g : this.field_78531_r.func_175606_aa(), !this.field_78531_r.field_71474_y.func_243230_g().func_243192_a(), this.field_78531_r.field_71474_y.func_243230_g().func_243193_b(), p_228378_1_);
        EntityViewRenderEvent.CameraSetup cameraSetup = ForgeHooksClient.onCameraSetup((GameRenderer)this, (ActiveRenderInfo)activerenderinfo, (float)p_228378_1_);
        activerenderinfo.setAnglesInternal(cameraSetup.getYaw(), cameraSetup.getPitch());
        p_228378_4_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(cameraSetup.getRoll()));
        p_228378_4_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(activerenderinfo.func_216777_e()));
        p_228378_4_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(activerenderinfo.func_216778_f() + 180.0f));
        this.field_78531_r.field_71438_f.func_228426_a_(p_228378_4_, p_228378_1_, p_228378_2_, flag, activerenderinfo, this, this.field_78513_d, matrix4f);
        this.field_78531_r.func_213239_aq().func_219895_b("forge_render_last");
        ForgeHooksClient.dispatchRenderLast((WorldRenderer)this.field_78531_r.field_71438_f, (MatrixStack)p_228378_4_, (float)p_228378_1_, (Matrix4f)matrix4f, (long)p_228378_2_);
        this.field_78531_r.func_213239_aq().func_219895_b("hand");
        if (this.field_175074_C) {
            RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
            this.func_228381_a_(p_228378_4_, activerenderinfo, p_228378_1_);
        }
        this.field_78531_r.func_213239_aq().func_76319_b();
    }

    public void func_190564_k() {
        this.field_190566_ab = null;
        this.field_147709_v.func_148249_a();
        this.field_215317_L.func_216781_o();
    }

    public MapItemRenderer func_147701_i() {
        return this.field_147709_v;
    }

    public void func_190565_a(ItemStack p_190565_1_) {
        this.field_190566_ab = p_190565_1_;
        this.field_190567_ac = 40;
        this.field_190568_ad = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
        this.field_190569_ae = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
    }

    private void func_190563_a(int p_190563_1_, int p_190563_2_, float p_190563_3_) {
        if (this.field_190566_ab != null && this.field_190567_ac > 0) {
            int i = 40 - this.field_190567_ac;
            float f = ((float)i + p_190563_3_) / 40.0f;
            float f1 = f * f;
            float f2 = f * f1;
            float f3 = 10.25f * f2 * f1 - 24.95f * f1 * f1 + 25.5f * f2 - 13.8f * f1 + 4.0f * f;
            float f4 = f3 * (float)Math.PI;
            float f5 = this.field_190568_ad * (float)(p_190563_1_ / 4);
            float f6 = this.field_190569_ae * (float)(p_190563_2_ / 4);
            RenderSystem.enableAlphaTest();
            RenderSystem.pushMatrix();
            RenderSystem.pushLightingAttributes();
            RenderSystem.enableDepthTest();
            RenderSystem.disableCull();
            MatrixStack matrixstack = new MatrixStack();
            matrixstack.func_227860_a_();
            matrixstack.func_227861_a_((double)((float)(p_190563_1_ / 2) + f5 * MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)(f4 * 2.0f)))), (double)((float)(p_190563_2_ / 2) + f6 * MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)(f4 * 2.0f)))), -50.0);
            float f7 = 50.0f + 175.0f * MathHelper.func_76126_a((float)f4);
            matrixstack.func_227862_a_(f7, -f7, f7);
            matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(900.0f * MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)f4))));
            matrixstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(6.0f * MathHelper.func_76134_b((float)(f * 8.0f))));
            matrixstack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(6.0f * MathHelper.func_76134_b((float)(f * 8.0f))));
            IRenderTypeBuffer.Impl irendertypebuffer$impl = this.field_228374_i_.func_228487_b_();
            this.field_78531_r.func_175599_af().func_229110_a_(this.field_190566_ab, ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl);
            matrixstack.func_227865_b_();
            irendertypebuffer$impl.func_228461_a_();
            RenderSystem.popAttributes();
            RenderSystem.popMatrix();
            RenderSystem.enableCull();
            RenderSystem.disableDepthTest();
        }
    }

    private void func_243497_c(float p_243497_1_) {
        int i = this.field_78531_r.func_228018_at_().func_198107_o();
        int j = this.field_78531_r.func_228018_at_().func_198087_p();
        double d0 = MathHelper.func_219803_d((double)p_243497_1_, (double)2.0, (double)1.0);
        float f = 0.2f * p_243497_1_;
        float f1 = 0.4f * p_243497_1_;
        float f2 = 0.2f * p_243497_1_;
        double d1 = (double)i * d0;
        double d2 = (double)j * d0;
        double d3 = ((double)i - d1) / 2.0;
        double d4 = ((double)j - d2) / 2.0;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.color4f((float)f, (float)f1, (float)f2, (float)1.0f);
        this.field_78531_r.func_110434_K().func_110577_a(field_243496_c);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(d3, d4 + d2, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(d3 + d1, d4 + d2, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(d3 + d1, d4, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(d3, d4, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    public float func_205002_d(float p_205002_1_) {
        return MathHelper.func_219799_g((float)p_205002_1_, (float)this.field_82832_V, (float)this.field_82831_U);
    }

    public float func_205001_m() {
        return this.field_78530_s;
    }

    public ActiveRenderInfo func_215316_n() {
        return this.field_215317_L;
    }

    public LightTexture func_228384_l_() {
        return this.field_78513_d;
    }

    public OverlayTexture func_228385_m_() {
        return this.field_228375_t_;
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.SHADERS;
    }
}

