/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.DummyWorldSaveData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DimensionSavedDataManager {
    private static final Logger field_212776_a = LogManager.getLogger();
    private final Map<String, WorldSavedData> field_212778_c = Maps.newHashMap();
    private final DataFixer field_215758_c;
    private final File field_215759_d;

    public DimensionSavedDataManager(File dataFolder, DataFixer dataFixerIn) {
        this.field_215758_c = dataFixerIn;
        this.field_215759_d = dataFolder;
    }

    private File func_215754_a(String name) {
        return new File(this.field_215759_d, name + ".dat");
    }

    public <T extends WorldSavedData> T func_215752_a(Supplier<T> defaultSupplier, String name) {
        T t = this.func_215753_b(defaultSupplier, name);
        if (t != null) {
            return t;
        }
        WorldSavedData t1 = (WorldSavedData)defaultSupplier.get();
        this.func_215757_a(t1);
        return (T)t1;
    }

    @Nullable
    public <T extends WorldSavedData> T func_215753_b(Supplier<T> defaultSupplier, String name) {
        WorldSavedData worldsaveddata = this.field_212778_c.get(name);
        if (worldsaveddata == DummyWorldSaveData.DUMMY) {
            return null;
        }
        if (worldsaveddata == null && !this.field_212778_c.containsKey(name)) {
            worldsaveddata = this.func_223409_c(defaultSupplier, name);
            this.field_212778_c.put(name, worldsaveddata);
        } else if (worldsaveddata == null) {
            this.field_212778_c.put(name, (WorldSavedData)DummyWorldSaveData.DUMMY);
            return null;
        }
        return (T)worldsaveddata;
    }

    @Nullable
    private <T extends WorldSavedData> T func_223409_c(Supplier<T> defaultSupplier, String name) {
        try {
            File file1 = this.func_215754_a(name);
            if (file1.exists()) {
                WorldSavedData t = (WorldSavedData)defaultSupplier.get();
                CompoundNBT compoundnbt = this.func_215755_a(name, SharedConstants.func_215069_a().getWorldVersion());
                t.func_76184_a(compoundnbt.func_74775_l("data"));
                return (T)t;
            }
        }
        catch (Exception exception) {
            field_212776_a.error("Error loading saved data: {}", (Object)name, (Object)exception);
        }
        return (T)((WorldSavedData)null);
    }

    public void func_215757_a(WorldSavedData data) {
        this.field_212778_c.put(data.func_195925_e(), data);
    }

    public CompoundNBT func_215755_a(String name, int worldVersion) throws IOException {
        CompoundNBT compoundnbt1;
        File file1 = this.func_215754_a(name);
        try (FileInputStream fileinputstream = new FileInputStream(file1);
             PushbackInputStream pushbackinputstream = new PushbackInputStream(fileinputstream, 2);){
            CompoundNBT compoundnbt;
            if (this.func_215756_a(pushbackinputstream)) {
                compoundnbt = CompressedStreamTools.func_74796_a(pushbackinputstream);
            } else {
                try (DataInputStream datainputstream = new DataInputStream(pushbackinputstream);){
                    compoundnbt = CompressedStreamTools.func_74794_a(datainputstream);
                }
            }
            int i = compoundnbt.func_150297_b("DataVersion", 99) ? compoundnbt.func_74762_e("DataVersion") : 1343;
            compoundnbt1 = NBTUtil.func_210821_a((DataFixer)this.field_215758_c, (DefaultTypeReferences)DefaultTypeReferences.SAVED_DATA, (CompoundNBT)compoundnbt, (int)i, (int)worldVersion);
        }
        return compoundnbt1;
    }

    private boolean func_215756_a(PushbackInputStream inputStream) throws IOException {
        int j;
        byte[] abyte = new byte[2];
        boolean flag = false;
        int i = inputStream.read(abyte, 0, 2);
        if (i == 2 && (j = (abyte[1] & 0xFF) << 8 | abyte[0] & 0xFF) == 35615) {
            flag = true;
        }
        if (i != 0) {
            inputStream.unread(abyte, 0, i);
        }
        return flag;
    }

    public void func_212775_b() {
        for (WorldSavedData worldsaveddata : this.field_212778_c.values()) {
            if (worldsaveddata == null) continue;
            worldsaveddata.func_215158_a(this.func_215754_a(worldsaveddata.func_195925_e()));
        }
    }
}

