/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryKeyCodec;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Biome
extends ForgeRegistryEntry.UncheckedRegistryEntry<Biome> {
    public static final Logger field_150586_aC = LogManager.getLogger();
    public static final Codec<Biome> field_242418_b = RecordCodecBuilder.create(p_235064_0_ -> p_235064_0_.group((App)Climate.field_242459_a.forGetter(p_242446_0_ -> p_242446_0_.field_242423_j), (App)Category.field_235102_r_.fieldOf("category").forGetter(p_235087_0_ -> p_235087_0_.field_201877_au), (App)Codec.FLOAT.fieldOf("depth").forGetter(p_235086_0_ -> Float.valueOf(p_235086_0_.field_76748_D)), (App)Codec.FLOAT.fieldOf("scale").forGetter(p_235085_0_ -> Float.valueOf(p_235085_0_.field_76749_E)), (App)BiomeAmbience.field_235204_a_.fieldOf("effects").forGetter(p_242444_0_ -> p_242444_0_.field_235052_p_), (App)BiomeGenerationSettings.field_242481_c.forGetter(p_242443_0_ -> p_242443_0_.field_242424_k), (App)MobSpawnInfo.field_242552_c.forGetter(p_242442_0_ -> p_242442_0_.field_242425_l), (App)ResourceLocation.field_240908_a_.optionalFieldOf("forge:registry_name").forGetter(b -> Optional.ofNullable(b.getRegistryName()))).apply((Applicative)p_235064_0_, (climate, category, depth, scale, effects, gen, spawns, name) -> ForgeHooks.enhanceBiome((ResourceLocation)name.orElse(null), (Climate)climate, (Category)((Object)((Object)category)), (Float)depth, (Float)scale, (BiomeAmbience)effects, (BiomeGenerationSettings)gen, (MobSpawnInfo)spawns, (RecordCodecBuilder.Instance)p_235064_0_, Biome::new)));
    public static final Codec<Biome> field_242419_c = RecordCodecBuilder.create(p_242432_0_ -> p_242432_0_.group((App)Climate.field_242459_a.forGetter(p_242441_0_ -> p_242441_0_.field_242423_j), (App)Category.field_235102_r_.fieldOf("category").forGetter(p_242439_0_ -> p_242439_0_.field_201877_au), (App)Codec.FLOAT.fieldOf("depth").forGetter(p_242438_0_ -> Float.valueOf(p_242438_0_.field_76748_D)), (App)Codec.FLOAT.fieldOf("scale").forGetter(p_242434_0_ -> Float.valueOf(p_242434_0_.field_76749_E)), (App)BiomeAmbience.field_235204_a_.fieldOf("effects").forGetter(p_242429_0_ -> p_242429_0_.field_235052_p_)).apply((Applicative)p_242432_0_, (p_242428_0_, p_242428_1_, p_242428_2_, p_242428_3_, p_242428_4_) -> new Biome((Climate)p_242428_0_, (Category)((Object)((Object)p_242428_1_)), p_242428_2_.floatValue(), p_242428_3_.floatValue(), (BiomeAmbience)p_242428_4_, BiomeGenerationSettings.field_242480_b, MobSpawnInfo.field_242551_b)));
    public static final Codec<Supplier<Biome>> field_235051_b_ = RegistryKeyCodec.func_241794_a_(Registry.field_239720_u_, field_242418_b);
    public static final Codec<List<Supplier<Biome>>> field_242420_e = RegistryKeyCodec.func_244328_b(Registry.field_239720_u_, field_242418_b);
    private final Map<Integer, List<Structure<?>>> field_242421_g = Registry.field_218361_B.func_201756_e().collect(Collectors.groupingBy(p_242435_0_ -> p_242435_0_.func_236396_f_().ordinal()));
    private static final PerlinNoiseGenerator field_150605_ac = new PerlinNoiseGenerator(new SharedSeedRandom(1234L), (List)ImmutableList.of((Object)0));
    private static final PerlinNoiseGenerator field_242422_i = new PerlinNoiseGenerator(new SharedSeedRandom(3456L), (List)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
    public static final PerlinNoiseGenerator field_180281_af = new PerlinNoiseGenerator(new SharedSeedRandom(2345L), (List)ImmutableList.of((Object)0));
    private final Climate field_242423_j;
    private final BiomeGenerationSettings field_242424_k;
    private final MobSpawnInfo field_242425_l;
    private final float field_76748_D;
    private final float field_76749_E;
    private final Category field_201877_au;
    private final BiomeAmbience field_235052_p_;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> field_225488_v = ThreadLocal.withInitial(() -> Util.func_199748_a(() -> {
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int p_rehash_1_) {
            }
        };
        long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
        return long2floatlinkedopenhashmap;
    }));

    private Biome(Climate climate, Category category, float depth, float scale, BiomeAmbience effects, BiomeGenerationSettings biomeGenerationSettings, MobSpawnInfo mobSpawnInfo) {
        this.field_242423_j = climate;
        this.field_242424_k = biomeGenerationSettings;
        this.field_242425_l = mobSpawnInfo;
        this.field_201877_au = category;
        this.field_76748_D = depth;
        this.field_76749_E = scale;
        this.field_235052_p_ = effects;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_225529_c_() {
        return this.field_235052_p_.func_242527_d();
    }

    public MobSpawnInfo func_242433_b() {
        return this.field_242425_l;
    }

    public RainType func_201851_b() {
        return this.field_242423_j.field_242460_b;
    }

    public boolean func_76736_e() {
        return this.func_76727_i() > 0.85f;
    }

    private float func_242437_b(BlockPos pos) {
        float f = this.field_242423_j.field_242462_d.func_241852_a(pos, this.func_242445_k());
        if (pos.func_177956_o() > 64) {
            float f1 = (float)(field_150605_ac.func_215464_a((double)((float)pos.func_177958_n() / 8.0f), (double)((float)pos.func_177952_p() / 8.0f), false) * 4.0);
            return f - (f1 + (float)pos.func_177956_o() - 64.0f) * 0.05f / 30.0f;
        }
        return f;
    }

    public final float func_225486_c(BlockPos pos) {
        long i = pos.func_218275_a();
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = this.field_225488_v.get();
        float f = long2floatlinkedopenhashmap.get(i);
        if (!Float.isNaN(f)) {
            return f;
        }
        float f1 = this.func_242437_b(pos);
        if (long2floatlinkedopenhashmap.size() == 1024) {
            long2floatlinkedopenhashmap.removeFirstFloat();
        }
        long2floatlinkedopenhashmap.put(i, f1);
        return f1;
    }

    public boolean func_201848_a(IWorldReader worldIn, BlockPos pos) {
        return this.func_201854_a(worldIn, pos, true);
    }

    public boolean func_201854_a(IWorldReader worldIn, BlockPos water, boolean mustBeAtEdge) {
        if (this.func_225486_c(water) >= 0.15f) {
            return false;
        }
        if (water.func_177956_o() >= 0 && water.func_177956_o() < 256 && worldIn.func_226658_a_(LightType.BLOCK, water) < 10) {
            BlockState blockstate = worldIn.func_180495_p(water);
            FluidState fluidstate = worldIn.func_204610_c(water);
            if (fluidstate.func_206886_c() == Fluids.field_204546_a && blockstate.func_177230_c() instanceof FlowingFluidBlock) {
                boolean flag;
                if (!mustBeAtEdge) {
                    return true;
                }
                boolean bl = flag = worldIn.func_201671_F(water.func_177976_e()) && worldIn.func_201671_F(water.func_177974_f()) && worldIn.func_201671_F(water.func_177978_c()) && worldIn.func_201671_F(water.func_177968_d());
                if (!flag) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_201850_b(IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate;
        if (this.func_225486_c(pos) >= 0.15f) {
            return false;
        }
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && worldIn.func_226658_a_(LightType.BLOCK, pos) < 10 && (blockstate = worldIn.func_180495_p(pos)).isAir((IBlockReader)((Object)worldIn), pos) && Blocks.field_150433_aE.func_176223_P().func_196955_c(worldIn, pos);
    }

    public BiomeGenerationSettings func_242440_e() {
        return this.field_242424_k;
    }

    public void func_242427_a(StructureManager structureManager, ChunkGenerator chunkGenerator, WorldGenRegion worldGenRegion, long seed, SharedSeedRandom rand, BlockPos pos) {
        List<List<Supplier<ConfiguredFeature<?, ?>>>> list = this.field_242424_k.func_242498_c();
        int i = GenerationStage.Decoration.values().length;
        for (int j = 0; j < i; ++j) {
            int k = 0;
            if (structureManager.func_235005_a_()) {
                for (Structure structure : this.field_242421_g.getOrDefault(j, Collections.emptyList())) {
                    rand.func_202426_b(seed, k, j);
                    int l = pos.func_177958_n() >> 4;
                    int i1 = pos.func_177952_p() >> 4;
                    int j1 = l << 4;
                    int k1 = i1 << 4;
                    try {
                        structureManager.func_235011_a_(SectionPos.func_218167_a((BlockPos)pos), structure).forEach(p_242426_8_ -> p_242426_8_.func_230366_a_(worldGenRegion, structureManager, chunkGenerator, (Random)rand, new MutableBoundingBox(j1, k1, j1 + 15, k1 + 15), new ChunkPos(l, i1)));
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.func_85055_a(exception, "Feature placement");
                        crashreport.func_85058_a("Feature").func_71507_a("Id", Registry.field_218361_B.func_177774_c(structure)).func_189529_a("Description", (ICrashReportDetail<String>)((ICrashReportDetail)() -> ((Object)((Object)structure)).toString()));
                        throw new ReportedException(crashreport);
                    }
                    ++k;
                }
            }
            if (list.size() <= j) continue;
            for (Supplier supplier : list.get(j)) {
                ConfiguredFeature configuredfeature = (ConfiguredFeature)supplier.get();
                rand.func_202426_b(seed, k, j);
                try {
                    configuredfeature.func_242765_a((ISeedReader)worldGenRegion, chunkGenerator, (Random)rand, pos);
                }
                catch (Exception exception1) {
                    CrashReport crashreport1 = CrashReport.func_85055_a(exception1, "Feature placement");
                    crashreport1.func_85058_a("Feature").func_71507_a("Id", Registry.field_218379_q.func_177774_c(configuredfeature.field_222737_a)).func_71507_a("Config", configuredfeature.field_222738_b).func_189529_a("Description", (ICrashReportDetail<String>)((ICrashReportDetail)() -> ((Object)((Object)configuredfeature.field_222737_a)).toString()));
                    throw new ReportedException(crashreport1);
                }
                ++k;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_235080_i_() {
        return this.field_235052_p_.func_235213_a_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_225528_a_(double posX, double posZ) {
        int i = this.field_235052_p_.func_242529_f().orElseGet(this::func_242448_v);
        return this.field_235052_p_.func_242531_g().func_241853_a(posX, posZ, i);
    }

    @OnlyIn(value=Dist.CLIENT)
    private int func_242448_v() {
        double d0 = MathHelper.func_76131_a((float)this.field_242423_j.field_242461_c, (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)this.field_242423_j.field_242463_e, (float)0.0f, (float)1.0f);
        return GrassColors.func_77480_a((double)d0, (double)d1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_225527_a_() {
        return this.field_235052_p_.func_242528_e().orElseGet(this::func_242449_w);
    }

    @OnlyIn(value=Dist.CLIENT)
    private int func_242449_w() {
        double d0 = MathHelper.func_76131_a((float)this.field_242423_j.field_242461_c, (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)this.field_242423_j.field_242463_e, (float)0.0f, (float)1.0f);
        return FoliageColors.func_77470_a((double)d0, (double)d1);
    }

    public void func_206854_a(Random random, IChunk chunkIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed) {
        ConfiguredSurfaceBuilder<?> configuredsurfacebuilder = this.field_242424_k.func_242500_d().get();
        configuredsurfacebuilder.func_215451_a(seed);
        configuredsurfacebuilder.func_215450_a(random, chunkIn, this, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed);
    }

    public final float func_185355_j() {
        return this.field_76748_D;
    }

    public final float func_76727_i() {
        return this.field_242423_j.field_242463_e;
    }

    public final float func_185360_m() {
        return this.field_76749_E;
    }

    public final float func_242445_k() {
        return this.field_242423_j.field_242461_c;
    }

    public BiomeAmbience func_235089_q_() {
        return this.field_235052_p_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final int func_185361_o() {
        return this.field_235052_p_.func_235216_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public final int func_204274_p() {
        return this.field_235052_p_.func_235218_c_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<ParticleEffectAmbience> func_235090_t_() {
        return this.field_235052_p_.func_235220_d_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<SoundEvent> func_235091_u_() {
        return this.field_235052_p_.func_235222_e_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<MoodSoundAmbience> func_235092_v_() {
        return this.field_235052_p_.func_235224_f_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<SoundAdditionsAmbience> func_235093_w_() {
        return this.field_235052_p_.func_235226_g_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<BackgroundMusicSelector> func_235094_x_() {
        return this.field_235052_p_.func_235228_h_();
    }

    public final Category func_201856_r() {
        return this.field_201877_au;
    }

    public String toString() {
        ResourceLocation resourcelocation = WorldGenRegistries.field_243657_i.func_177774_c(this);
        return resourcelocation == null ? super.toString() : resourcelocation.toString();
    }

    public static enum TemperatureModifier implements IStringSerializable
    {
        NONE("none"){

            @Override
            public float func_241852_a(BlockPos pos, float temperature) {
                return temperature;
            }
        }
        ,
        FROZEN("frozen"){

            @Override
            public float func_241852_a(BlockPos pos, float temperature) {
                double d3;
                double d1;
                double d0 = field_242422_i.func_215464_a((double)pos.func_177958_n() * 0.05, (double)pos.func_177952_p() * 0.05, false) * 7.0;
                double d2 = d0 + (d1 = field_180281_af.func_215464_a((double)pos.func_177958_n() * 0.2, (double)pos.func_177952_p() * 0.2, false));
                if (d2 < 0.3 && (d3 = field_180281_af.func_215464_a((double)pos.func_177958_n() * 0.09, (double)pos.func_177952_p() * 0.09, false)) < 0.8) {
                    return 0.2f;
                }
                return temperature;
            }
        };

        private final String field_242474_d;
        public static final Codec<TemperatureModifier> field_242473_c;
        private static final Map<String, TemperatureModifier> field_242475_e;

        public abstract float func_241852_a(BlockPos var1, float var2);

        private TemperatureModifier(String name) {
            this.field_242474_d = name;
        }

        public String func_242478_b() {
            return this.field_242474_d;
        }

        public String func_176610_l() {
            return this.field_242474_d;
        }

        public static TemperatureModifier func_242477_a(String name) {
            return field_242475_e.get(name);
        }

        static {
            field_242473_c = IStringSerializable.func_233023_a_(TemperatureModifier::values, TemperatureModifier::func_242477_a);
            field_242475_e = Arrays.stream(TemperatureModifier.values()).collect(Collectors.toMap(TemperatureModifier::func_242478_b, p_242476_0_ -> p_242476_0_));
        }
    }

    public static enum RainType implements IStringSerializable
    {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow");

        public static final Codec<RainType> field_235121_d_;
        private static final Map<String, RainType> field_222362_d;
        private final String field_222363_e;

        private RainType(String name) {
            this.field_222363_e = name;
        }

        public String func_222361_a() {
            return this.field_222363_e;
        }

        public static RainType func_235122_a_(String name) {
            return field_222362_d.get(name);
        }

        public String func_176610_l() {
            return this.field_222363_e;
        }

        static {
            field_235121_d_ = IStringSerializable.func_233023_a_(RainType::values, RainType::func_235122_a_);
            field_222362_d = Arrays.stream(RainType.values()).collect(Collectors.toMap(RainType::func_222361_a, p_222360_0_ -> p_222360_0_));
        }
    }

    public static class Climate {
        public static final MapCodec<Climate> field_242459_a = RecordCodecBuilder.mapCodec(p_242465_0_ -> p_242465_0_.group((App)RainType.field_235121_d_.fieldOf("precipitation").forGetter(p_242472_0_ -> p_242472_0_.field_242460_b), (App)Codec.FLOAT.fieldOf("temperature").forGetter(p_242471_0_ -> Float.valueOf(p_242471_0_.field_242461_c)), (App)TemperatureModifier.field_242473_c.optionalFieldOf("temperature_modifier", (Object)TemperatureModifier.NONE).forGetter(p_242470_0_ -> p_242470_0_.field_242462_d), (App)Codec.FLOAT.fieldOf("downfall").forGetter(p_242469_0_ -> Float.valueOf(p_242469_0_.field_242463_e))).apply((Applicative)p_242465_0_, Climate::new));
        public final RainType field_242460_b;
        public final float field_242461_c;
        public final TemperatureModifier field_242462_d;
        public final float field_242463_e;

        public Climate(RainType precipitation, float temperature, TemperatureModifier temperatureModifier, float downfall) {
            this.field_242460_b = precipitation;
            this.field_242461_c = temperature;
            this.field_242462_d = temperatureModifier;
            this.field_242463_e = downfall;
        }
    }

    public static enum Category implements IStringSerializable
    {
        NONE("none"),
        TAIGA("taiga"),
        EXTREME_HILLS("extreme_hills"),
        JUNGLE("jungle"),
        MESA("mesa"),
        PLAINS("plains"),
        SAVANNA("savanna"),
        ICY("icy"),
        THEEND("the_end"),
        BEACH("beach"),
        FOREST("forest"),
        OCEAN("ocean"),
        DESERT("desert"),
        RIVER("river"),
        SWAMP("swamp"),
        MUSHROOM("mushroom"),
        NETHER("nether");

        public static final Codec<Category> field_235102_r_;
        private static final Map<String, Category> field_222354_r;
        private final String field_222355_s;

        private Category(String name) {
            this.field_222355_s = name;
        }

        public String func_222352_a() {
            return this.field_222355_s;
        }

        public static Category func_235103_a_(String name) {
            return field_222354_r.get(name);
        }

        public String func_176610_l() {
            return this.field_222355_s;
        }

        static {
            field_235102_r_ = IStringSerializable.func_233023_a_(Category::values, Category::func_235103_a_);
            field_222354_r = Arrays.stream(Category.values()).collect(Collectors.toMap(Category::func_222352_a, p_222353_0_ -> p_222353_0_));
        }
    }

    public static class Builder {
        @Nullable
        private RainType field_205423_b;
        @Nullable
        private Category field_205424_c;
        @Nullable
        private Float field_205425_d;
        @Nullable
        private Float field_205426_e;
        @Nullable
        private Float field_205427_f;
        private TemperatureModifier field_242452_f = TemperatureModifier.NONE;
        @Nullable
        private Float field_205428_g;
        @Nullable
        private BiomeAmbience field_235096_j_;
        @Nullable
        private MobSpawnInfo field_242453_i;
        @Nullable
        private BiomeGenerationSettings field_242454_j;

        public Builder func_205415_a(RainType precipitationIn) {
            this.field_205423_b = precipitationIn;
            return this;
        }

        public Builder func_205419_a(Category biomeCategory) {
            this.field_205424_c = biomeCategory;
            return this;
        }

        public Builder func_205421_a(float depthIn) {
            this.field_205425_d = Float.valueOf(depthIn);
            return this;
        }

        public Builder func_205420_b(float scaleIn) {
            this.field_205426_e = Float.valueOf(scaleIn);
            return this;
        }

        public Builder func_205414_c(float temperatureIn) {
            this.field_205427_f = Float.valueOf(temperatureIn);
            return this;
        }

        public Builder func_205417_d(float downfallIn) {
            this.field_205428_g = Float.valueOf(downfallIn);
            return this;
        }

        public Builder func_235097_a_(BiomeAmbience effects) {
            this.field_235096_j_ = effects;
            return this;
        }

        public Builder func_242458_a(MobSpawnInfo mobSpawnSettings) {
            this.field_242453_i = mobSpawnSettings;
            return this;
        }

        public Builder func_242457_a(BiomeGenerationSettings generationSettings) {
            this.field_242454_j = generationSettings;
            return this;
        }

        public Builder func_242456_a(TemperatureModifier temperatureSettings) {
            this.field_242452_f = temperatureSettings;
            return this;
        }

        public Biome func_242455_a() {
            if (this.field_205423_b != null && this.field_205424_c != null && this.field_205425_d != null && this.field_205426_e != null && this.field_205427_f != null && this.field_205428_g != null && this.field_235096_j_ != null && this.field_242453_i != null && this.field_242454_j != null) {
                return new Biome(new Climate(this.field_205423_b, this.field_205427_f.floatValue(), this.field_242452_f, this.field_205428_g.floatValue()), this.field_205424_c, this.field_205425_d.floatValue(), this.field_205426_e.floatValue(), this.field_235096_j_, this.field_242454_j, this.field_242453_i);
            }
            throw new IllegalStateException("You are missing parameters to build a proper biome\n" + this);
        }

        public String toString() {
            return "BiomeBuilder{\nprecipitation=" + (Object)((Object)this.field_205423_b) + ",\nbiomeCategory=" + (Object)((Object)this.field_205424_c) + ",\ndepth=" + this.field_205425_d + ",\nscale=" + this.field_205426_e + ",\ntemperature=" + this.field_205427_f + ",\ntemperatureModifier=" + (Object)((Object)this.field_242452_f) + ",\ndownfall=" + this.field_205428_g + ",\nspecialEffects=" + this.field_235096_j_ + ",\nmobSpawnSettings=" + this.field_242453_i + ",\ngenerationSettings=" + this.field_242454_j + ",\n" + '}';
        }
    }

    public static class Attributes {
        public static final Codec<Attributes> field_235104_a_ = RecordCodecBuilder.create(p_235111_0_ -> p_235111_0_.group((App)Codec.floatRange((float)-2.0f, (float)2.0f).fieldOf("temperature").forGetter(p_235116_0_ -> Float.valueOf(p_235116_0_.field_235105_b_)), (App)Codec.floatRange((float)-2.0f, (float)2.0f).fieldOf("humidity").forGetter(p_235115_0_ -> Float.valueOf(p_235115_0_.field_235106_c_)), (App)Codec.floatRange((float)-2.0f, (float)2.0f).fieldOf("altitude").forGetter(p_235114_0_ -> Float.valueOf(p_235114_0_.field_235107_d_)), (App)Codec.floatRange((float)-2.0f, (float)2.0f).fieldOf("weirdness").forGetter(p_235113_0_ -> Float.valueOf(p_235113_0_.field_235108_e_)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("offset").forGetter(p_235112_0_ -> Float.valueOf(p_235112_0_.field_235109_f_))).apply((Applicative)p_235111_0_, Attributes::new));
        private final float field_235105_b_;
        private final float field_235106_c_;
        private final float field_235107_d_;
        private final float field_235108_e_;
        private final float field_235109_f_;

        public Attributes(float temperature, float humidity, float altitude, float weirdness, float offset) {
            this.field_235105_b_ = temperature;
            this.field_235106_c_ = humidity;
            this.field_235107_d_ = altitude;
            this.field_235108_e_ = weirdness;
            this.field_235109_f_ = offset;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                Attributes biome$attributes = (Attributes)p_equals_1_;
                if (Float.compare(biome$attributes.field_235105_b_, this.field_235105_b_) != 0) {
                    return false;
                }
                if (Float.compare(biome$attributes.field_235106_c_, this.field_235106_c_) != 0) {
                    return false;
                }
                if (Float.compare(biome$attributes.field_235107_d_, this.field_235107_d_) != 0) {
                    return false;
                }
                return Float.compare(biome$attributes.field_235108_e_, this.field_235108_e_) == 0;
            }
            return false;
        }

        public int hashCode() {
            int i = this.field_235105_b_ != 0.0f ? Float.floatToIntBits(this.field_235105_b_) : 0;
            i = 31 * i + (this.field_235106_c_ != 0.0f ? Float.floatToIntBits(this.field_235106_c_) : 0);
            i = 31 * i + (this.field_235107_d_ != 0.0f ? Float.floatToIntBits(this.field_235107_d_) : 0);
            return 31 * i + (this.field_235108_e_ != 0.0f ? Float.floatToIntBits(this.field_235108_e_) : 0);
        }

        public float func_235110_a_(Attributes attributes) {
            return (this.field_235105_b_ - attributes.field_235105_b_) * (this.field_235105_b_ - attributes.field_235105_b_) + (this.field_235106_c_ - attributes.field_235106_c_) * (this.field_235106_c_ - attributes.field_235106_c_) + (this.field_235107_d_ - attributes.field_235107_d_) * (this.field_235107_d_ - attributes.field_235107_d_) + (this.field_235108_e_ - attributes.field_235108_e_) * (this.field_235108_e_ - attributes.field_235108_e_) + (this.field_235109_f_ - attributes.field_235109_f_) * (this.field_235109_f_ - attributes.field_235109_f_);
        }
    }
}

