/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DelegatingDynamicOps;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldGenSettingsExport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldSettingsImport<T>
extends DelegatingDynamicOps<T> {
    private static final Logger field_240870_b_ = LogManager.getLogger();
    private final IResourceAccess field_244332_c;
    private final DynamicRegistries.Impl field_240872_d_;
    private final Map<RegistryKey<? extends Registry<?>>, ResultMap<?>> field_240873_e_;
    private final WorldSettingsImport<JsonElement> field_244333_f;

    public static <T> WorldSettingsImport<T> func_244335_a(DynamicOps<T> ops, IResourceManager resourceManager, DynamicRegistries.Impl dynamicRegistries) {
        return WorldSettingsImport.func_244336_a(ops, IResourceAccess.func_244345_a(resourceManager), dynamicRegistries);
    }

    public static <T> WorldSettingsImport<T> func_244336_a(DynamicOps<T> ops, IResourceAccess resourceAccess, DynamicRegistries.Impl dynamicRegistries) {
        WorldSettingsImport<T> worldsettingsimport = new WorldSettingsImport<T>(ops, resourceAccess, dynamicRegistries, Maps.newIdentityHashMap());
        DynamicRegistries.func_243608_a(dynamicRegistries, worldsettingsimport);
        return worldsettingsimport;
    }

    private WorldSettingsImport(DynamicOps<T> ops, IResourceAccess resourceAccess, DynamicRegistries.Impl dynamicRegistries, IdentityHashMap<RegistryKey<? extends Registry<?>>, ResultMap<?>> registryToResultMap) {
        super(ops);
        this.field_244332_c = resourceAccess;
        this.field_240872_d_ = dynamicRegistries;
        this.field_240873_e_ = registryToResultMap;
        this.field_244333_f = ops == JsonOps.INSTANCE ? this : new WorldSettingsImport<T>(JsonOps.INSTANCE, resourceAccess, dynamicRegistries, (IdentityHashMap<RegistryKey<Registry<?>>, ResultMap<?>>)registryToResultMap);
    }

    protected <E> DataResult<Pair<java.util.function.Supplier<E>, T>> func_241802_a_(T input, RegistryKey<? extends Registry<E>> registryKey, Codec<E> mapCodec, boolean allowInlineDefinitions) {
        Optional optional = this.field_240872_d_.func_230521_a_(registryKey);
        if (!optional.isPresent()) {
            return DataResult.error((String)("Unknown registry: " + registryKey));
        }
        MutableRegistry mutableregistry = optional.get();
        DataResult dataresult = ResourceLocation.field_240908_a_.decode(this.field_240857_a_, input);
        if (!dataresult.result().isPresent()) {
            return !allowInlineDefinitions ? DataResult.error((String)"Inline definitions not allowed here") : mapCodec.decode((DynamicOps)this, input).map(p_240874_0_ -> p_240874_0_.mapFirst(p_240891_0_ -> () -> p_240891_0_));
        }
        Pair pair = (Pair)dataresult.result().get();
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        return this.func_241805_a_(registryKey, mutableregistry, mapCodec, resourcelocation).map(p_240875_1_ -> Pair.of((Object)p_240875_1_, (Object)pair.getSecond()));
    }

    public <E> DataResult<SimpleRegistry<E>> func_241797_a_(SimpleRegistry<E> simpleRegistry, RegistryKey<? extends Registry<E>> registryKey, Codec<E> mapCodec) {
        Collection<ResourceLocation> collection = this.field_244332_c.func_241880_a(registryKey);
        DataResult dataresult = DataResult.success(simpleRegistry, (Lifecycle)Lifecycle.stable());
        String s = registryKey.func_240901_a_().func_110623_a() + "/";
        for (ResourceLocation resourcelocation : collection) {
            String s1 = resourcelocation.func_110623_a();
            if (!s1.endsWith(".json")) {
                field_240870_b_.warn("Skipping resource {} since it is not a json file", (Object)resourcelocation);
                continue;
            }
            if (!s1.startsWith(s)) {
                field_240870_b_.warn("Skipping resource {} since it does not have a registry name prefix", (Object)resourcelocation);
                continue;
            }
            String s2 = s1.substring(s.length(), s1.length() - ".json".length());
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.func_110624_b(), s2);
            dataresult = dataresult.flatMap(p_240885_4_ -> this.func_241805_a_(registryKey, (MutableRegistry)p_240885_4_, mapCodec, resourcelocation1).map(p_240877_1_ -> p_240885_4_));
        }
        return dataresult.setPartial(simpleRegistry);
    }

    private <E> DataResult<java.util.function.Supplier<E>> func_241805_a_(RegistryKey<? extends Registry<E>> registryKey, MutableRegistry<E> mutableRegistry, Codec<E> mapCodec, ResourceLocation id) {
        RegistryKey registrykey = RegistryKey.func_240903_a_(registryKey, id);
        ResultMap<E> resultmap = this.func_240884_a_(registryKey);
        DataResult dataresult = (DataResult)((ResultMap)resultmap).field_240893_a_.get(registrykey);
        if (dataresult != null) {
            return dataresult;
        }
        Supplier supplier = Suppliers.memoize(() -> {
            Object e = mutableRegistry.func_230516_a_(registrykey);
            if (e == null) {
                throw new RuntimeException("Error during recursive registry parsing, element resolved too early: " + registrykey);
            }
            return e;
        });
        ((ResultMap)resultmap).field_240893_a_.put(registrykey, DataResult.success((Object)supplier));
        DataResult dataresult1 = this.field_244332_c.func_241879_a((DynamicOps<JsonElement>)this.field_244333_f, registryKey, registrykey, mapCodec);
        Optional optional = dataresult1.result();
        if (optional.isPresent()) {
            Pair pair = (Pair)optional.get();
            mutableRegistry.func_241874_a((OptionalInt)pair.getSecond(), registrykey, pair.getFirst(), dataresult1.lifecycle());
        }
        DataResult dataresult2 = !optional.isPresent() && mutableRegistry.func_230516_a_(registrykey) != null ? DataResult.success(() -> mutableRegistry.func_230516_a_(registrykey), (Lifecycle)Lifecycle.stable()) : dataresult1.map(p_244339_2_ -> () -> mutableRegistry.func_230516_a_(registrykey));
        ((ResultMap)resultmap).field_240893_a_.put(registrykey, dataresult2);
        return dataresult2;
    }

    private <E> ResultMap<E> func_240884_a_(RegistryKey<? extends Registry<E>> key) {
        return this.field_240873_e_.computeIfAbsent(key, p_244344_0_ -> new ResultMap());
    }

    protected <E> DataResult<Registry<E>> func_244340_a(RegistryKey<? extends Registry<E>> registryKey) {
        return this.field_240872_d_.func_230521_a_(registryKey).map(p_244337_0_ -> DataResult.success((Object)p_244337_0_, (Lifecycle)p_244337_0_.func_241875_b())).orElseGet(() -> DataResult.error((String)("Unknown registry: " + registryKey)));
    }

    static final class ResultMap<E> {
        private final Map<RegistryKey<E>, DataResult<java.util.function.Supplier<E>>> field_240893_a_ = Maps.newIdentityHashMap();

        private ResultMap() {
        }
    }

    public static interface IResourceAccess {
        public Collection<ResourceLocation> func_241880_a(RegistryKey<? extends Registry<?>> var1);

        public <E> DataResult<Pair<E, OptionalInt>> func_241879_a(DynamicOps<JsonElement> var1, RegistryKey<? extends Registry<E>> var2, RegistryKey<E> var3, Decoder<E> var4);

        public static IResourceAccess func_244345_a(final IResourceManager manager) {
            return new IResourceAccess(){

                @Override
                public Collection<ResourceLocation> func_241880_a(RegistryKey<? extends Registry<?>> registryKey) {
                    return manager.func_199003_a(registryKey.func_240901_a_().func_110623_a(), p_244348_0_ -> p_244348_0_.endsWith(".json"));
                }

                /*
                 * Exception decompiling
                 */
                @Override
                public <E> DataResult<Pair<E, OptionalInt>> func_241879_a(DynamicOps<JsonElement> jsonOps, RegistryKey<? extends Registry<E>> registryKey, RegistryKey<E> objectKey, Decoder<E> decoder) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                public String toString() {
                    return "ResourceAccess[" + manager + "]";
                }

                private static /* synthetic */ Pair lambda$decode$1(Object p_244347_0_) {
                    return Pair.of((Object)p_244347_0_, (Object)OptionalInt.empty());
                }
            };
        }

        public static final class RegistryAccess
        implements IResourceAccess {
            private final Map<RegistryKey<?>, JsonElement> field_244349_a = Maps.newIdentityHashMap();
            private final Object2IntMap<RegistryKey<?>> field_244350_b = new Object2IntOpenCustomHashMap(Util.func_212443_g());
            private final Map<RegistryKey<?>, Lifecycle> field_244351_c = Maps.newIdentityHashMap();

            public <E> void func_244352_a(DynamicRegistries.Impl dynamicRegistries, RegistryKey<E> key, Encoder<E> encoder, int id, E instance, Lifecycle lifecycle) {
                DataResult dataresult = encoder.encodeStart((DynamicOps)WorldGenSettingsExport.func_240896_a_((DynamicOps)JsonOps.INSTANCE, (DynamicRegistries)dynamicRegistries), instance);
                Optional optional = dataresult.error();
                if (optional.isPresent()) {
                    field_240870_b_.error("Error adding element: {}", (Object)((DataResult.PartialResult)optional.get()).message());
                } else {
                    this.field_244349_a.put(key, (JsonElement)dataresult.result().get());
                    this.field_244350_b.put(key, id);
                    this.field_244351_c.put(key, lifecycle);
                }
            }

            @Override
            public Collection<ResourceLocation> func_241880_a(RegistryKey<? extends Registry<?>> registryKey) {
                return this.field_244349_a.keySet().stream().filter(p_244355_1_ -> p_244355_1_.func_244356_a(registryKey)).map(p_244354_1_ -> new ResourceLocation(p_244354_1_.func_240901_a_().func_110624_b(), registryKey.func_240901_a_().func_110623_a() + "/" + p_244354_1_.func_240901_a_().func_110623_a() + ".json")).collect(Collectors.toList());
            }

            @Override
            public <E> DataResult<Pair<E, OptionalInt>> func_241879_a(DynamicOps<JsonElement> jsonOps, RegistryKey<? extends Registry<E>> registryKey, RegistryKey<E> objectKey, Decoder<E> decoder) {
                JsonElement jsonelement = this.field_244349_a.get(objectKey);
                if (jsonelement != null) {
                    jsonelement.getAsJsonObject().addProperty("forge:registry_name", objectKey.func_240901_a_().toString());
                }
                return jsonelement == null ? DataResult.error((String)("Unknown element: " + objectKey)) : decoder.parse(jsonOps, (Object)jsonelement).setLifecycle(this.field_244351_c.get(objectKey)).map(p_244353_2_ -> Pair.of((Object)p_244353_2_, (Object)OptionalInt.of(this.field_244350_b.getInt((Object)objectKey))));
            }
        }
    }
}

