/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.SkipableEncoderException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class NettyPacketEncoder
extends MessageToByteEncoder<IPacket<?>> {
    private static final Logger field_150798_a = LogManager.getLogger();
    private static final Marker field_150797_b = MarkerManager.getMarker((String)"PACKET_SENT", (Marker)NetworkManager.field_150738_b);
    private final PacketDirection field_152500_c;

    public NettyPacketEncoder(PacketDirection direction) {
        this.field_152500_c = direction;
    }

    protected void encode(ChannelHandlerContext p_encode_1_, IPacket<?> p_encode_2_, ByteBuf p_encode_3_) throws Exception {
        ProtocolType protocoltype = (ProtocolType)p_encode_1_.channel().attr(NetworkManager.field_150739_c).get();
        if (protocoltype == null) {
            throw new RuntimeException("ConnectionProtocol unknown: " + p_encode_2_);
        }
        Integer integer = protocoltype.func_179246_a(this.field_152500_c, p_encode_2_);
        if (field_150798_a.isDebugEnabled()) {
            field_150798_a.debug(field_150797_b, "OUT: [{}:{}] {}", p_encode_1_.channel().attr(NetworkManager.field_150739_c).get(), (Object)integer, (Object)p_encode_2_.getClass().getName());
        }
        if (integer == null) {
            throw new IOException("Can't serialize unregistered packet");
        }
        PacketBuffer packetbuffer = new PacketBuffer(p_encode_3_);
        packetbuffer.func_150787_b(integer);
        try {
            p_encode_2_.func_148840_b(packetbuffer);
        }
        catch (Throwable throwable) {
            field_150798_a.error("Error encoding packet", throwable);
            if (p_encode_2_.func_211402_a()) {
                throw new SkipableEncoderException(throwable);
            }
            throw throwable;
        }
    }
}

