/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ShulkerAABBHelper;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class ShulkerEntity
extends GolemEntity
implements IMob {
    private static final UUID field_184703_bv = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier field_184704_bw = new AttributeModifier(field_184703_bv, "Covered armor bonus", 20.0, AttributeModifier.Operation.ADDITION);
    protected static final DataParameter<Direction> field_184700_a = EntityDataManager.func_187226_a(ShulkerEntity.class, DataSerializers.field_187202_l);
    protected static final DataParameter<Optional<BlockPos>> field_184701_b = EntityDataManager.func_187226_a(ShulkerEntity.class, DataSerializers.field_187201_k);
    protected static final DataParameter<Byte> field_184702_c = EntityDataManager.func_187226_a(ShulkerEntity.class, DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> field_190770_bw = EntityDataManager.func_187226_a(ShulkerEntity.class, DataSerializers.field_187191_a);
    private float field_184705_bx;
    private float field_184706_by;
    private BlockPos field_184707_bz = null;
    private int field_184708_bA;

    public ShulkerEntity(EntityType<? extends ShulkerEntity> p_i50196_1_, World p_i50196_2_) {
        super(p_i50196_1_, p_i50196_2_);
        this.field_70728_aV = 5;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new PeekGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackNearestGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new DefenseAttackGoal(this));
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187773_eO;
    }

    public void func_70642_aH() {
        if (!this.func_184686_df()) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187781_eS;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_184686_df() ? SoundEvents.field_187785_eU : SoundEvents.field_187783_eT;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184700_a, Direction.DOWN);
        this.field_70180_af.func_187214_a(field_184701_b, Optional.empty());
        this.field_70180_af.func_187214_a(field_184702_c, (byte)0);
        this.field_70180_af.func_187214_a(field_190770_bw, (byte)16);
    }

    public static AttributeModifierMap.MutableAttribute func_234300_m_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0);
    }

    protected BodyController func_184650_s() {
        return new BodyHelperController((MobEntity)((Object)this));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(field_184700_a, Direction.func_82600_a(compound.func_74771_c("AttachFace")));
        this.field_70180_af.func_187227_b(field_184702_c, compound.func_74771_c("Peek"));
        this.field_70180_af.func_187227_b(field_190770_bw, compound.func_74771_c("Color"));
        if (compound.func_74764_b("APX")) {
            int i = compound.func_74762_e("APX");
            int j = compound.func_74762_e("APY");
            int k = compound.func_74762_e("APZ");
            this.field_70180_af.func_187227_b(field_184701_b, Optional.of(new BlockPos(i, j, k)));
        } else {
            this.field_70180_af.func_187227_b(field_184701_b, Optional.empty());
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("AttachFace", (byte)this.field_70180_af.func_187225_a(field_184700_a).func_176745_a());
        compound.func_74774_a("Peek", this.field_70180_af.func_187225_a(field_184702_c));
        compound.func_74774_a("Color", this.field_70180_af.func_187225_a(field_190770_bw));
        BlockPos blockpos = this.func_184699_da();
        if (blockpos != null) {
            compound.func_74768_a("APX", blockpos.func_177958_n());
            compound.func_74768_a("APY", blockpos.func_177956_o());
            compound.func_74768_a("APZ", blockpos.func_177952_p());
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos blockpos = this.field_70180_af.func_187225_a(field_184701_b).orElse(null);
        if (blockpos == null && !this.field_70170_p.field_72995_K) {
            blockpos = this.func_233580_cy_();
            this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockpos));
        }
        if (this.func_184218_aH()) {
            float f;
            blockpos = null;
            this.field_70177_z = f = this.func_184187_bx().field_70177_z;
            this.field_70761_aq = f;
            this.field_70760_ar = f;
            this.field_184708_bA = 0;
        } else if (!this.field_70170_p.field_72995_K) {
            Direction direction4;
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            if (!blockstate.isAir((IBlockReader)((Object)this.field_70170_p), blockpos)) {
                if (blockstate.func_203425_a(Blocks.field_196603_bb)) {
                    Direction direction = (Direction)((Object)blockstate.func_177229_b((Property)PistonBlock.field_176387_N));
                    if (this.field_70170_p.func_175623_d(blockpos.func_177972_a(direction))) {
                        blockpos = blockpos.func_177972_a(direction);
                        this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockpos));
                    } else {
                        this.func_184689_o();
                    }
                } else if (blockstate.func_203425_a(Blocks.field_150332_K)) {
                    Direction direction3 = (Direction)((Object)blockstate.func_177229_b((Property)PistonHeadBlock.field_176387_N));
                    if (this.field_70170_p.func_175623_d(blockpos.func_177972_a(direction3))) {
                        blockpos = blockpos.func_177972_a(direction3);
                        this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockpos));
                    } else {
                        this.func_184689_o();
                    }
                } else {
                    this.func_184689_o();
                }
            }
            if (!this.func_234298_a_(blockpos, direction4 = this.func_184696_cZ())) {
                Direction direction1 = this.func_234299_g_(blockpos);
                if (direction1 != null) {
                    this.field_70180_af.func_187227_b(field_184700_a, direction1);
                } else {
                    this.func_184689_o();
                }
            }
        }
        float f1 = (float)this.func_184684_db() * 0.01f;
        this.field_184705_bx = this.field_184706_by;
        if (this.field_184706_by > f1) {
            this.field_184706_by = MathHelper.func_76131_a((float)(this.field_184706_by - 0.05f), (float)f1, (float)1.0f);
        } else if (this.field_184706_by < f1) {
            this.field_184706_by = MathHelper.func_76131_a((float)(this.field_184706_by + 0.05f), (float)0.0f, (float)f1);
        }
        if (blockpos != null) {
            List list;
            if (this.field_70170_p.field_72995_K) {
                if (this.field_184708_bA > 0 && this.field_184707_bz != null) {
                    --this.field_184708_bA;
                } else {
                    this.field_184707_bz = blockpos;
                }
            }
            this.func_226286_f_((double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5);
            double d2 = 0.5 - (double)MathHelper.func_76126_a((float)((0.5f + this.field_184706_by) * (float)Math.PI)) * 0.5;
            double d0 = 0.5 - (double)MathHelper.func_76126_a((float)((0.5f + this.field_184705_bx) * (float)Math.PI)) * 0.5;
            if (this.isAddedToWorld() && this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_217464_b((Entity)((Object)this));
            }
            Direction direction2 = this.func_184696_cZ().func_176734_d();
            this.func_174826_a(new AxisAlignedBB(this.func_226277_ct_() - 0.5, this.func_226278_cu_(), this.func_226281_cx_() - 0.5, this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + 0.5).func_72321_a((double)direction2.func_82601_c() * d2, (double)direction2.func_96559_d() * d2, (double)direction2.func_82599_e() * d2));
            double d1 = d2 - d0;
            if (d1 > 0.0 && !(list = this.field_70170_p.func_72839_b((Entity)((Object)this), this.func_174813_aQ())).isEmpty()) {
                for (Entity entity : list) {
                    if (entity instanceof ShulkerEntity || entity.field_70145_X) continue;
                    entity.func_213315_a(MoverType.SHULKER, new Vector3d(d1 * (double)direction2.func_82601_c(), d1 * (double)direction2.func_96559_d(), d1 * (double)direction2.func_82599_e()));
                }
            }
        }
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        if (typeIn == MoverType.SHULKER_BOX) {
            this.func_184689_o();
        } else {
            super.func_213315_a(typeIn, pos);
        }
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.field_70180_af != null && this.field_70173_aa != 0) {
            Optional<BlockPos> optional1;
            Optional<BlockPos> optional = this.field_70180_af.func_187225_a(field_184701_b);
            if (this.isAddedToWorld() && this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_217464_b((Entity)((Object)this));
            }
            if (!(optional1 = Optional.of(new BlockPos(x, y, z))).equals(optional)) {
                this.field_70180_af.func_187227_b(field_184701_b, optional1);
                this.field_70180_af.func_187227_b(field_184702_c, (byte)0);
                this.field_70160_al = true;
            }
        }
    }

    @Nullable
    protected Direction func_234299_g_(BlockPos p_234299_1_) {
        for (Direction direction : Direction.values()) {
            if (!this.func_234298_a_(p_234299_1_, direction)) continue;
            return direction;
        }
        return null;
    }

    private boolean func_234298_a_(BlockPos p_234298_1_, Direction p_234298_2_) {
        return this.field_70170_p.func_234929_a_(p_234298_1_.func_177972_a(p_234298_2_), (Entity)((Object)this), p_234298_2_.func_176734_d()) && this.field_70170_p.func_226665_a__((Entity)((Object)this), ShulkerAABBHelper.func_233539_a_((BlockPos)p_234298_1_, (Direction)p_234298_2_.func_176734_d()));
    }

    protected boolean func_184689_o() {
        if (!this.func_175446_cd() && this.func_70089_S()) {
            BlockPos blockpos = this.func_233580_cy_();
            for (int i = 0; i < 5; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(8 - this.field_70146_Z.nextInt(17), 8 - this.field_70146_Z.nextInt(17), 8 - this.field_70146_Z.nextInt(17));
                if (blockpos1.func_177956_o() <= 0 || !this.field_70170_p.func_175623_d(blockpos1) || !this.field_70170_p.func_175723_af().func_177746_a(blockpos1) || !this.field_70170_p.func_226665_a__((Entity)((Object)this), new AxisAlignedBB(blockpos1))) continue;
                Direction direction = this.func_234299_g_(blockpos1);
                if (direction != null) {
                    EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)((Object)this), (double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p(), 0.0f);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        direction = null;
                    }
                    blockpos1 = new BlockPos(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                }
                if (direction == null) continue;
                this.field_70180_af.func_187227_b(field_184700_a, direction);
                this.func_184185_a(SoundEvents.field_187791_eX, 1.0f, 1.0f);
                this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockpos1));
                this.field_70180_af.func_187227_b(field_184702_c, (byte)0);
                this.func_70624_b(null);
                return true;
            }
            return false;
        }
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_213317_d(Vector3d.field_186680_a);
        if (!this.func_175446_cd()) {
            this.field_70760_ar = 0.0f;
            this.field_70761_aq = 0.0f;
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        BlockPos blockpos;
        if (field_184701_b.equals(key) && this.field_70170_p.field_72995_K && !this.func_184218_aH() && (blockpos = this.func_184699_da()) != null) {
            if (this.field_184707_bz == null) {
                this.field_184707_bz = blockpos;
            } else {
                this.field_184708_bA = 6;
            }
            this.func_226286_f_((double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5);
        }
        super.func_184206_a(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.field_70716_bi = 0;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity;
        if (this.func_184686_df() && (entity = source.func_76364_f()) instanceof AbstractArrowEntity) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.5 && this.field_70146_Z.nextInt(4) == 0) {
                this.func_184689_o();
            }
            return true;
        }
        return false;
    }

    private boolean func_184686_df() {
        return this.func_184684_db() == 0;
    }

    public boolean func_241845_aY() {
        return this.func_70089_S();
    }

    public Direction func_184696_cZ() {
        return this.field_70180_af.func_187225_a(field_184700_a);
    }

    @Nullable
    public BlockPos func_184699_da() {
        return this.field_70180_af.func_187225_a(field_184701_b).orElse(null);
    }

    public void func_184694_g(@Nullable BlockPos pos) {
        this.field_70180_af.func_187227_b(field_184701_b, Optional.ofNullable(pos));
    }

    public int func_184684_db() {
        return this.field_70180_af.func_187225_a(field_184702_c).byteValue();
    }

    public void func_184691_a(int p_184691_1_) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(Attributes.field_233826_i_).func_111124_b(field_184704_bw);
            if (p_184691_1_ == 0) {
                this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(field_184704_bw);
                this.func_184185_a(SoundEvents.field_187779_eR, 1.0f, 1.0f);
            } else {
                this.func_184185_a(SoundEvents.field_187787_eV, 1.0f, 1.0f);
            }
        }
        this.field_70180_af.func_187227_b(field_184702_c, (byte)p_184691_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_184688_a(float p_184688_1_) {
        return MathHelper.func_219799_g((float)p_184688_1_, (float)this.field_184705_bx, (float)this.field_184706_by);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_184693_dc() {
        return this.field_184708_bA;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos func_184692_dd() {
        return this.field_184707_bz;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.5f;
    }

    public int func_70646_bf() {
        return 180;
    }

    public int func_184649_cE() {
        return 180;
    }

    public void func_70108_f(Entity entityIn) {
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_184697_de() {
        return this.field_184707_bz != null && this.func_184699_da() != null;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public DyeColor func_190769_dn() {
        Byte obyte = this.field_70180_af.func_187225_a(field_190770_bw);
        return obyte != 16 && obyte <= 15 ? DyeColor.func_196056_a(obyte.byteValue()) : null;
    }

    class PeekGoal
    extends Goal {
        private int field_188522_b;

        private PeekGoal() {
        }

        public boolean func_75250_a() {
            return ShulkerEntity.this.func_70638_az() == null && ShulkerEntity.this.field_70146_Z.nextInt(40) == 0;
        }

        public boolean func_75253_b() {
            return ShulkerEntity.this.func_70638_az() == null && this.field_188522_b > 0;
        }

        public void func_75249_e() {
            this.field_188522_b = 20 * (1 + ShulkerEntity.this.field_70146_Z.nextInt(3));
            ShulkerEntity.this.func_184691_a(30);
        }

        public void func_75251_c() {
            if (ShulkerEntity.this.func_70638_az() == null) {
                ShulkerEntity.this.func_184691_a(0);
            }
        }

        public void func_75246_d() {
            --this.field_188522_b;
        }
    }

    static class DefenseAttackGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public DefenseAttackGoal(ShulkerEntity shulker) {
            super((MobEntity)((Object)shulker), LivingEntity.class, 10, true, false, p_200826_0_ -> p_200826_0_ instanceof IMob);
        }

        public boolean func_75250_a() {
            return this.field_75299_d.func_96124_cp() == null ? false : super.func_75250_a();
        }

        protected AxisAlignedBB func_188511_a(double targetDistance) {
            Direction direction = ((ShulkerEntity)((Object)this.field_75299_d)).func_184696_cZ();
            if (direction.func_176740_k() == Direction.Axis.X) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(4.0, targetDistance, targetDistance);
            }
            return direction.func_176740_k() == Direction.Axis.Z ? this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, targetDistance, 4.0) : this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
        }
    }

    class BodyHelperController
    extends BodyController {
        public BodyHelperController(MobEntity p_i50612_2_) {
            super(p_i50612_2_);
        }

        public void func_75664_a() {
        }
    }

    class AttackNearestGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackNearestGoal(ShulkerEntity shulker) {
            super((MobEntity)((Object)shulker), PlayerEntity.class, true);
        }

        public boolean func_75250_a() {
            return ShulkerEntity.this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL ? false : super.func_75250_a();
        }

        protected AxisAlignedBB func_188511_a(double targetDistance) {
            Direction direction = ((ShulkerEntity)((Object)this.field_75299_d)).func_184696_cZ();
            if (direction.func_176740_k() == Direction.Axis.X) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(4.0, targetDistance, targetDistance);
            }
            return direction.func_176740_k() == Direction.Axis.Z ? this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, targetDistance, 4.0) : this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
        }
    }

    class AttackGoal
    extends Goal {
        private int field_188520_b;

        public AttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = ShulkerEntity.this.func_70638_az();
            if (livingentity != null && livingentity.func_70089_S()) {
                return ShulkerEntity.this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL;
            }
            return false;
        }

        public void func_75249_e() {
            this.field_188520_b = 20;
            ShulkerEntity.this.func_184691_a(100);
        }

        public void func_75251_c() {
            ShulkerEntity.this.func_184691_a(0);
        }

        public void func_75246_d() {
            if (ShulkerEntity.this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
                --this.field_188520_b;
                LivingEntity livingentity = ShulkerEntity.this.func_70638_az();
                ShulkerEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, 180.0f, 180.0f);
                double d0 = ShulkerEntity.this.func_70068_e(livingentity);
                if (d0 < 400.0) {
                    if (this.field_188520_b <= 0) {
                        this.field_188520_b = 20 + ShulkerEntity.this.field_70146_Z.nextInt(10) * 20 / 2;
                        ShulkerEntity.this.field_70170_p.func_217376_c((Entity)((Object)new ShulkerBulletEntity(ShulkerEntity.this.field_70170_p, (LivingEntity)((Object)ShulkerEntity.this), livingentity, ShulkerEntity.this.func_184696_cZ().func_176740_k())));
                        ShulkerEntity.this.func_184185_a(SoundEvents.field_187789_eW, 2.0f, (ShulkerEntity.this.field_70146_Z.nextFloat() - ShulkerEntity.this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    }
                } else {
                    ShulkerEntity.this.func_70624_b(null);
                }
                super.func_75246_d();
            }
        }
    }
}

