/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.extensions.IForgeTagBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TagsProvider<T>
implements IDataProvider {
    private static final Logger field_200436_d = LogManager.getLogger();
    private static final Gson field_200437_e = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator field_200433_a;
    protected final Registry<T> field_200435_c;
    protected final Map<ResourceLocation, ITag.Builder> field_200434_b = Maps.newLinkedHashMap();
    protected final String modId;
    protected final String folder;
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;

    @Deprecated
    protected TagsProvider(DataGenerator generatorIn, Registry<T> registryIn) {
        this(generatorIn, registryIn, "vanilla", null);
    }

    protected TagsProvider(DataGenerator generatorIn, Registry<T> registryIn, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this(generatorIn, registryIn, modId, existingFileHelper, null);
    }

    protected TagsProvider(DataGenerator generatorIn, Registry<T> registryIn, String modId, @Nullable ExistingFileHelper existingFileHelper, @Nullable String folder) {
        this.field_200433_a = generatorIn;
        this.field_200435_c = registryIn;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
        if (folder == null) {
            folder = this.getTagFolder();
        }
        this.folder = folder;
        this.resourceType = new ExistingFileHelper.ResourceType(ResourcePackType.SERVER_DATA, ".json", "tags/" + this.folder);
    }

    protected abstract void func_200432_c();

    public void func_200398_a(DirectoryCache cache) {
        this.field_200434_b.clear();
        this.func_200432_c();
        Tag itag = Tag.func_241284_a_();
        Function<ResourceLocation, ITag> function = arg_0 -> this.lambda$act$0((ITag)itag, arg_0);
        Function<ResourceLocation, Object> function1 = p_240527_1_ -> this.field_200435_c.func_241873_b((ResourceLocation)p_240527_1_).orElse(null);
        this.field_200434_b.forEach((p_240524_4_, p_240524_5_) -> {
            List list = p_240524_5_.func_232963_b_(function, function1).filter(this::missing).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", p_240524_4_, list.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonObject jsonobject = p_240524_5_.func_232965_c_();
            Path path = this.func_200431_a((ResourceLocation)p_240524_4_);
            if (path == null) {
                return;
            }
            try {
                String s = field_200437_e.toJson((JsonElement)jsonobject);
                String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(cache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                cache.func_208316_a(path, s1);
            }
            catch (IOException ioexception) {
                field_200436_d.error("Couldn't save tags to {}", (Object)path, (Object)ioexception);
            }
        });
    }

    private boolean missing(ITag.Proxy reference) {
        ITag.ITagEntry entry = reference.func_232968_a_();
        if (entry instanceof ITag.TagEntry) {
            return this.existingFileHelper == null || !this.existingFileHelper.exists(((ITag.TagEntry)entry).getId(), this.resourceType);
        }
        return false;
    }

    protected String getTagFolder() {
        return Registry.field_212617_f.func_177774_c(this.field_200435_c).func_110623_a() + "s";
    }

    protected abstract Path func_200431_a(ResourceLocation var1);

    protected Builder<T> func_240522_a_(ITag.INamedTag<T> tag) {
        ITag.Builder itag$builder = this.func_240525_b_(tag);
        return new Builder(itag$builder, this.field_200435_c, this.modId);
    }

    protected ITag.Builder func_240525_b_(ITag.INamedTag<T> tag) {
        return this.field_200434_b.computeIfAbsent(tag.func_230234_a_(), p_240526_0_ -> {
            this.existingFileHelper.trackGenerated(p_240526_0_, this.resourceType);
            return new ITag.Builder();
        });
    }

    private /* synthetic */ ITag lambda$act$0(ITag itag, ResourceLocation p_240523_2_) {
        return this.field_200434_b.containsKey(p_240523_2_) ? itag : null;
    }

    public static class Builder<T>
    implements IForgeTagBuilder<T> {
        private final ITag.Builder field_240528_a_;
        private final Registry<T> field_240529_b_;
        private final String field_240530_c_;

        private Builder(ITag.Builder builder, Registry<T> registry, String id) {
            this.field_240528_a_ = builder;
            this.field_240529_b_ = registry;
            this.field_240530_c_ = id;
        }

        public Builder<T> func_240532_a_(T item) {
            this.field_240528_a_.func_232961_a_(this.field_240529_b_.func_177774_c(item), this.field_240530_c_);
            return this;
        }

        public Builder<T> func_240531_a_(ITag.INamedTag<T> tag) {
            this.field_240528_a_.func_232964_b_(tag.func_230234_a_(), this.field_240530_c_);
            return this;
        }

        @SafeVarargs
        public final Builder<T> func_240534_a_(T ... toAdd) {
            Stream.of(toAdd).map(this.field_240529_b_::func_177774_c).forEach(p_240533_1_ -> this.field_240528_a_.func_232961_a_((ResourceLocation)p_240533_1_, this.field_240530_c_));
            return this;
        }

        public Builder<T> add(ITag.ITagEntry tag) {
            this.field_240528_a_.func_232955_a_(tag, this.field_240530_c_);
            return this;
        }

        public ITag.Builder getInternalBuilder() {
            return this.field_240528_a_;
        }

        public String getModID() {
            return this.field_240530_c_;
        }
    }
}

