/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.FramebufferConstants;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfig;

@OnlyIn(value=Dist.CLIENT)
public class Framebuffer {
    public int field_147622_a;
    public int field_147620_b;
    public int field_147621_c;
    public int field_147618_d;
    public final boolean field_147619_e;
    public int field_147616_f;
    private int field_147617_g;
    private int field_147624_h;
    public final float[] field_147625_i;
    public int field_147623_j;
    private boolean stencilEnabled = false;

    public Framebuffer(int p_i51175_1_, int p_i51175_2_, boolean p_i51175_3_, boolean p_i51175_4_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.field_147619_e = p_i51175_3_;
        this.field_147616_f = -1;
        this.field_147617_g = -1;
        this.field_147624_h = -1;
        this.field_147625_i = new float[4];
        this.field_147625_i[0] = 1.0f;
        this.field_147625_i[1] = 1.0f;
        this.field_147625_i[2] = 1.0f;
        this.field_147625_i[3] = 0.0f;
        this.func_216491_a(p_i51175_1_, p_i51175_2_, p_i51175_4_);
    }

    public void func_216491_a(int p_216491_1_, int p_216491_2_, boolean p_216491_3_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_227586_d_(p_216491_1_, p_216491_2_, p_216491_3_));
        } else {
            this.func_227586_d_(p_216491_1_, p_216491_2_, p_216491_3_);
        }
    }

    private void func_227586_d_(int p_227586_1_, int p_227586_2_, boolean p_227586_3_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.func_227734_k_();
        if (this.field_147616_f >= 0) {
            this.func_147608_a();
        }
        this.func_216492_b(p_227586_1_, p_227586_2_, p_227586_3_);
        GlStateManager.func_227727_h_(FramebufferConstants.field_227592_a_, 0);
    }

    public void func_147608_a() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.func_147606_d();
        this.func_147609_e();
        if (this.field_147624_h > -1) {
            TextureUtil.func_225679_a_((int)this.field_147624_h);
            this.field_147624_h = -1;
        }
        if (this.field_147617_g > -1) {
            TextureUtil.func_225679_a_((int)this.field_147617_g);
            this.field_147617_g = -1;
        }
        if (this.field_147616_f > -1) {
            GlStateManager.func_227727_h_(FramebufferConstants.field_227592_a_, 0);
            GlStateManager.func_227738_l_(this.field_147616_f);
            this.field_147616_f = -1;
        }
    }

    public void func_237506_a_(Framebuffer p_237506_1_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (GlStateManager.func_237508_S_()) {
            GlStateManager.func_227727_h_(36008, p_237506_1_.field_147616_f);
            GlStateManager.func_227727_h_(36009, this.field_147616_f);
            GlStateManager.func_237510_a_(0, 0, p_237506_1_.field_147622_a, p_237506_1_.field_147620_b, 0, 0, this.field_147622_a, this.field_147620_b, 256, 9728);
        } else {
            GlStateManager.func_227727_h_(FramebufferConstants.field_227592_a_, this.field_147616_f);
            int i = GlStateManager.func_237514_p_();
            if (i != 0) {
                int j = GlStateManager.func_237515_r_();
                GlStateManager.func_227760_t_(i);
                GlStateManager.func_227727_h_(FramebufferConstants.field_227592_a_, p_237506_1_.field_147616_f);
                GlStateManager.func_237509_a_(3553, 0, 0, 0, 0, 0, Math.min(this.field_147622_a, p_237506_1_.field_147622_a), Math.min(this.field_147620_b, p_237506_1_.field_147620_b));
                GlStateManager.func_227760_t_(j);
            }
        }
        GlStateManager.func_227727_h_(FramebufferConstants.field_227592_a_, 0);
    }

    public void func_216492_b(int p_216492_1_, int p_216492_2_, boolean p_216492_3_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.field_147621_c = p_216492_1_;
        this.field_147618_d = p_216492_2_;
        this.field_147622_a = p_216492_1_;
        this.field_147620_b = p_216492_2_;
        this.field_147616_f = GlStateManager.func_227749_p_();
        this.field_147617_g = TextureUtil.func_225678_a_();
        if (this.field_147619_e) {
            this.field_147624_h = TextureUtil.func_225678_a_();
            GlStateManager.func_227760_t_(this.field_147624_h);
            GlStateManager.func_227677_b_(3553, 10241, 9728);
            GlStateManager.func_227677_b_(3553, 10240, 9728);
            GlStateManager.func_227677_b_(3553, 10242, 10496);
            GlStateManager.func_227677_b_(3553, 10243, 10496);
            GlStateManager.func_227677_b_(3553, 34892, 0);
            if (!this.stencilEnabled) {
                GlStateManager.func_227647_a_(3553, 0, 6402, this.field_147622_a, this.field_147620_b, 0, 6402, 5126, null);
            } else {
                GlStateManager.func_227647_a_(3553, 0, 36013, this.field_147622_a, this.field_147620_b, 0, 34041, 36269, null);
            }
        }
        this.func_147607_a(9728);
        GlStateManager.func_227760_t_(this.field_147617_g);
        GlStateManager.func_227647_a_(3553, 0, 32856, this.field_147622_a, this.field_147620_b, 0, 6408, 5121, null);
        GlStateManager.func_227727_h_(FramebufferConstants.field_227592_a_, this.field_147616_f);
        GlStateManager.func_227645_a_(FramebufferConstants.field_227592_a_, FramebufferConstants.field_227594_c_, 3553, this.field_147617_g, 0);
        if (this.field_147619_e) {
            if (!this.stencilEnabled) {
                GlStateManager.func_227645_a_(FramebufferConstants.field_227592_a_, FramebufferConstants.field_227595_d_, 3553, this.field_147624_h, 0);
            } else if (((Boolean)ForgeConfig.CLIENT.useCombinedDepthStencilAttachment.get()).booleanValue()) {
                GlStateManager.func_227645_a_(FramebufferConstants.field_227592_a_, 33306, 3553, this.field_147624_h, 0);
            } else {
                GlStateManager.func_227645_a_(FramebufferConstants.field_227592_a_, 36096, 3553, this.field_147624_h, 0);
                GlStateManager.func_227645_a_(FramebufferConstants.field_227592_a_, 36128, 3553, this.field_147624_h, 0);
            }
        }
        this.func_147611_b();
        this.func_216493_b(p_216492_3_);
        this.func_147606_d();
    }

    public void func_147607_a(int framebufferFilterIn) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.field_147623_j = framebufferFilterIn;
        GlStateManager.func_227760_t_(this.field_147617_g);
        GlStateManager.func_227677_b_(3553, 10241, framebufferFilterIn);
        GlStateManager.func_227677_b_(3553, 10240, framebufferFilterIn);
        GlStateManager.func_227677_b_(3553, 10242, 10496);
        GlStateManager.func_227677_b_(3553, 10243, 10496);
        GlStateManager.func_227760_t_(0);
    }

    public void func_147611_b() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        int i = GlStateManager.func_227741_m_(FramebufferConstants.field_227592_a_);
        if (i != FramebufferConstants.field_227596_e_) {
            if (i == FramebufferConstants.field_227597_f_) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i == FramebufferConstants.field_227598_g_) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i == FramebufferConstants.field_227599_h_) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i == FramebufferConstants.field_227600_i_) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i);
        }
    }

    public void func_147612_c() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.func_227760_t_(this.field_147617_g);
    }

    public void func_147606_d() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.func_227760_t_(0);
    }

    public void func_147610_a(boolean setViewportIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_227585_c_(setViewportIn));
        } else {
            this.func_227585_c_(setViewportIn);
        }
    }

    private void func_227585_c_(boolean setViewportIn) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.func_227727_h_(FramebufferConstants.field_227592_a_, this.field_147616_f);
        if (setViewportIn) {
            GlStateManager.func_227714_e_(0, 0, this.field_147621_c, this.field_147618_d);
        }
    }

    public void func_147609_e() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> GlStateManager.func_227727_h_(FramebufferConstants.field_227592_a_, 0));
        } else {
            GlStateManager.func_227727_h_(FramebufferConstants.field_227592_a_, 0);
        }
    }

    public void func_147604_a(float red, float green, float blue, float alpha) {
        this.field_147625_i[0] = red;
        this.field_147625_i[1] = green;
        this.field_147625_i[2] = blue;
        this.field_147625_i[3] = alpha;
    }

    public void func_147615_c(int width, int height) {
        this.func_178038_a(width, height, true);
    }

    public void func_178038_a(int width, int height, boolean p_178038_3_) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        if (!RenderSystem.isInInitPhase()) {
            RenderSystem.recordRenderCall(() -> this.func_227588_e_(width, height, p_178038_3_));
        } else {
            this.func_227588_e_(width, height, p_178038_3_);
        }
    }

    private void func_227588_e_(int width, int height, boolean p_227588_3_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.func_227668_a_(true, true, true, false);
        GlStateManager.func_227731_j_();
        GlStateManager.func_227667_a_(false);
        GlStateManager.func_227768_x_(5889);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227633_a_(0.0, width, height, 0.0, 1000.0, 3000.0);
        GlStateManager.func_227768_x_(5888);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227688_c_(0.0f, 0.0f, -2000.0f);
        GlStateManager.func_227714_e_(0, 0, width, height);
        GlStateManager.func_227619_H_();
        GlStateManager.func_227722_g_();
        GlStateManager.func_227700_d_();
        if (p_227588_3_) {
            GlStateManager.func_227737_l_();
            GlStateManager.func_227725_h_();
        }
        GlStateManager.func_227702_d_(1.0f, 1.0f, 1.0f, 1.0f);
        this.func_147612_c();
        float f = width;
        float f1 = height;
        float f2 = (float)this.field_147621_c / (float)this.field_147622_a;
        float f3 = (float)this.field_147618_d / (float)this.field_147620_b;
        Tessellator tessellator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_225582_a_(0.0, f1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_181675_d();
        bufferbuilder.func_225582_a_(f, f1, 0.0).func_225583_a_(f2, 0.0f).func_225586_a_(255, 255, 255, 255).func_181675_d();
        bufferbuilder.func_225582_a_(f, 0.0, 0.0).func_225583_a_(f2, f3).func_225586_a_(255, 255, 255, 255).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(0.0f, f3).func_225586_a_(255, 255, 255, 255).func_181675_d();
        tessellator.func_78381_a();
        this.func_147606_d();
        GlStateManager.func_227667_a_(true);
        GlStateManager.func_227668_a_(true, true, true, true);
    }

    public void func_216493_b(boolean onMac) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.func_147610_a(true);
        GlStateManager.func_227673_b_(this.field_147625_i[0], this.field_147625_i[1], this.field_147625_i[2], this.field_147625_i[3]);
        int i = 16384;
        if (this.field_147619_e) {
            GlStateManager.func_227631_a_(1.0);
            i |= 0x100;
        }
        GlStateManager.func_227658_a_(i, onMac);
        this.func_147609_e();
    }

    public void enableStencil() {
        if (this.stencilEnabled) {
            return;
        }
        this.stencilEnabled = true;
        this.func_216491_a(this.field_147621_c, this.field_147618_d, Minecraft.field_142025_a);
    }

    public boolean isStencilEnabled() {
        return this.stencilEnabled;
    }

    public int func_242996_f() {
        return this.field_147617_g;
    }

    public int func_242997_g() {
        return this.field_147624_h;
    }
}

