/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.MavenCoordinateResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LibraryFinder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Path libsPath;

    static Path findLibsPath() {
        if (libsPath == null) {
            Path asm = LibraryFinder.findJarPathFor("org/objectweb/asm/Opcodes.class", "asm");
            Path libs = asm.getParent().getParent().getParent().getParent().getParent().getParent();
            LOGGER.debug(LogMarkers.CORE, "Found probable library path {}", (Object)libs);
            libsPath = libs;
        }
        return libsPath;
    }

    public static Path findJarPathFor(String className, String jarName) {
        URL resource = LibraryFinder.class.getClassLoader().getResource(className);
        return LibraryFinder.findJarPathFor(className, jarName, resource);
    }

    public static Path findJarPathFor(String resourceName, String jarName, URL resource) {
        try {
            URI uri = resource.toURI();
            Path path = uri.getRawSchemeSpecificPart().contains("!") ? Paths.get(new URI(uri.getRawSchemeSpecificPart().split("!")[0])) : Paths.get(new URI("file://" + uri.getRawSchemeSpecificPart().substring(0, uri.getRawSchemeSpecificPart().length() - resourceName.length())));
            LOGGER.debug(LogMarkers.CORE, "Found JAR {} at path {}", (Object)jarName, (Object)path.toString());
            return path;
        }
        catch (NullPointerException | URISyntaxException e) {
            LOGGER.fatal(LogMarkers.CORE, "Failed to find JAR for class {} - {}", (Object)resourceName, (Object)jarName);
            throw new RuntimeException("Unable to locate " + resourceName + " - " + jarName, e);
        }
    }

    static Path getForgeLibraryPath(String mcVersion, String forgeVersion, String forgeGroup) {
        Path forgePath = LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get(forgeGroup, "forge", "", "universal", mcVersion + "-" + forgeVersion));
        LOGGER.debug(LogMarkers.CORE, "Found forge path {} is {}", (Object)forgePath, (Object)LibraryFinder.pathStatus(forgePath));
        return forgePath;
    }

    static String pathStatus(Path path) {
        return Files.exists(path, new LinkOption[0]) ? "present" : "missing";
    }

    static Path[] getMCPaths(String mcVersion, String mcpVersion, String forgeVersion, String forgeGroup, String type) {
        Path srgMcPath = LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get("net.minecraft", type, "", "srg", mcVersion + "-" + mcpVersion));
        Path mcExtrasPath = LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get("net.minecraft", type, "", "extra", mcVersion + "-" + mcpVersion));
        Path patchedBinariesPath = LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get(forgeGroup, "forge", "", type, mcVersion + "-" + forgeVersion));
        LOGGER.debug(LogMarkers.CORE, "SRG MC at {} is {}", (Object)srgMcPath.toString(), (Object)LibraryFinder.pathStatus(srgMcPath));
        LOGGER.debug(LogMarkers.CORE, "MC Extras at {} is {}", (Object)mcExtrasPath.toString(), (Object)LibraryFinder.pathStatus(mcExtrasPath));
        LOGGER.debug(LogMarkers.CORE, "Forge patches at {} is {}", (Object)patchedBinariesPath.toString(), (Object)LibraryFinder.pathStatus(patchedBinariesPath));
        return new Path[]{patchedBinariesPath, mcExtrasPath, srgMcPath};
    }
}

