/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.minecraft.util.concurrent.ITaskQueue;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.ChunkTaskPriorityQueue;
import net.minecraft.world.server.ChunkHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkTaskPriorityQueueSorter
implements AutoCloseable,
ChunkHolder.IListener {
    private static final Logger field_219093_a = LogManager.getLogger();
    private final Map<ITaskExecutor<?>, ChunkTaskPriorityQueue<? extends Function<ITaskExecutor<Unit>, ?>>> field_219094_b;
    private final Set<ITaskExecutor<?>> field_219095_c;
    private final DelegatedTaskExecutor<ITaskQueue.RunnableWithPriority> field_219096_d;

    public ChunkTaskPriorityQueueSorter(List<ITaskExecutor<?>> list, Executor executor, int n) {
        this.field_219094_b = list.stream().collect(Collectors.toMap(Function.identity(), iTaskExecutor -> new ChunkTaskPriorityQueue(iTaskExecutor.func_213142_bd() + "_queue", n)));
        this.field_219095_c = Sets.newHashSet(list);
        this.field_219096_d = new DelegatedTaskExecutor<ITaskQueue.RunnableWithPriority>(new ITaskQueue.Priority(4), executor, "sorter");
    }

    public static FunctionEntry<Runnable> func_219069_a(Runnable runnable, long l, IntSupplier intSupplier) {
        return new FunctionEntry<Runnable>(iTaskExecutor -> () -> {
            runnable.run();
            iTaskExecutor.func_212871_a_(Unit.INSTANCE);
        }, l, intSupplier);
    }

    public static FunctionEntry<Runnable> func_219081_a(ChunkHolder chunkHolder, Runnable runnable) {
        return ChunkTaskPriorityQueueSorter.func_219069_a(runnable, chunkHolder.func_219277_h().func_201841_a(), chunkHolder::func_219281_j);
    }

    public static RunnableEntry func_219073_a(Runnable runnable, long l, boolean bl) {
        return new RunnableEntry(runnable, l, bl);
    }

    public <T> ITaskExecutor<FunctionEntry<T>> func_219087_a(ITaskExecutor<T> iTaskExecutor, boolean bl) {
        return (ITaskExecutor)this.field_219096_d.func_213141_a(iTaskExecutor2 -> new ITaskQueue.RunnableWithPriority(0, () -> {
            this.func_219068_b(iTaskExecutor);
            iTaskExecutor2.func_212871_a_(ITaskExecutor.func_213140_a("chunk priority sorter around " + iTaskExecutor.func_213142_bd(), functionEntry -> this.func_219067_a(iTaskExecutor, ((FunctionEntry)functionEntry).field_219428_a, ((FunctionEntry)functionEntry).field_219429_b, ((FunctionEntry)functionEntry).field_219430_c, bl)));
        })).join();
    }

    public ITaskExecutor<RunnableEntry> func_219091_a(ITaskExecutor<Runnable> iTaskExecutor) {
        return (ITaskExecutor)this.field_219096_d.func_213141_a(iTaskExecutor2 -> new ITaskQueue.RunnableWithPriority(0, () -> iTaskExecutor2.func_212871_a_(ITaskExecutor.func_213140_a("chunk priority sorter around " + iTaskExecutor.func_213142_bd(), runnableEntry -> this.func_219074_a(iTaskExecutor, ((RunnableEntry)runnableEntry).field_219435_b, ((RunnableEntry)runnableEntry).field_219434_a, ((RunnableEntry)runnableEntry).field_219436_c))))).join();
    }

    @Override
    public void func_219066_a(ChunkPos chunkPos, IntSupplier intSupplier, int n, IntConsumer intConsumer) {
        this.field_219096_d.func_212871_a_(new ITaskQueue.RunnableWithPriority(0, () -> {
            int n2 = intSupplier.getAsInt();
            this.field_219094_b.values().forEach(chunkTaskPriorityQueue -> chunkTaskPriorityQueue.func_219407_a(n2, chunkPos, n));
            intConsumer.accept(n);
        }));
    }

    private <T> void func_219074_a(ITaskExecutor<T> iTaskExecutor, long l, Runnable runnable, boolean bl) {
        this.field_219096_d.func_212871_a_(new ITaskQueue.RunnableWithPriority(1, () -> {
            ChunkTaskPriorityQueue chunkTaskPriorityQueue = this.func_219068_b(iTaskExecutor);
            chunkTaskPriorityQueue.func_219416_a(l, bl);
            if (this.field_219095_c.remove(iTaskExecutor)) {
                this.func_219078_a(chunkTaskPriorityQueue, iTaskExecutor);
            }
            runnable.run();
        }));
    }

    private <T> void func_219067_a(ITaskExecutor<T> iTaskExecutor, Function<ITaskExecutor<Unit>, T> function, long l, IntSupplier intSupplier, boolean bl) {
        this.field_219096_d.func_212871_a_(new ITaskQueue.RunnableWithPriority(2, () -> {
            ChunkTaskPriorityQueue chunkTaskPriorityQueue = this.func_219068_b(iTaskExecutor);
            int \u26032 = intSupplier.getAsInt();
            chunkTaskPriorityQueue.func_219412_a(Optional.of(function), l, \u26032);
            if (bl) {
                chunkTaskPriorityQueue.func_219412_a(Optional.empty(), l, \u26032);
            }
            if (this.field_219095_c.remove(iTaskExecutor)) {
                this.func_219078_a(chunkTaskPriorityQueue, iTaskExecutor);
            }
        }));
    }

    private <T> void func_219078_a(ChunkTaskPriorityQueue<Function<ITaskExecutor<Unit>, T>> chunkTaskPriorityQueue, ITaskExecutor<T> iTaskExecutor) {
        this.field_219096_d.func_212871_a_(new ITaskQueue.RunnableWithPriority(3, () -> {
            Stream<Either<Either, Runnable>> stream = chunkTaskPriorityQueue.func_219417_a();
            if (stream == null) {
                this.field_219095_c.add(iTaskExecutor);
            } else {
                Util.func_215079_b(stream.map(either -> (CompletableFuture)either.map(iTaskExecutor::func_213141_a, runnable -> {
                    runnable.run();
                    return CompletableFuture.completedFuture(Unit.INSTANCE);
                })).collect(Collectors.toList())).thenAccept(list -> this.func_219078_a(chunkTaskPriorityQueue, iTaskExecutor));
            }
        }));
    }

    private <T> ChunkTaskPriorityQueue<Function<ITaskExecutor<Unit>, T>> func_219068_b(ITaskExecutor<T> iTaskExecutor) {
        ChunkTaskPriorityQueue<Function<ITaskExecutor<Unit>, T>> chunkTaskPriorityQueue = this.field_219094_b.get(iTaskExecutor);
        if (chunkTaskPriorityQueue == null) {
            throw Util.func_229757_c_(new IllegalArgumentException("No queue for: " + iTaskExecutor));
        }
        return chunkTaskPriorityQueue;
    }

    @VisibleForTesting
    public String func_225396_a() {
        return this.field_219094_b.entrySet().stream().map(entry -> ((ITaskExecutor)entry.getKey()).func_213142_bd() + "=[" + ((ChunkTaskPriorityQueue)entry.getValue()).func_225414_b().stream().map(l -> l + ":" + new ChunkPos((long)l)).collect(Collectors.joining(",")) + "]").collect(Collectors.joining(",")) + ", s=" + this.field_219095_c.size();
    }

    @Override
    public void close() {
        this.field_219094_b.keySet().forEach(ITaskExecutor::close);
    }

    public static final class RunnableEntry {
        private final Runnable field_219434_a;
        private final long field_219435_b;
        private final boolean field_219436_c;

        private RunnableEntry(Runnable runnable, long l, boolean bl) {
            this.field_219434_a = runnable;
            this.field_219435_b = l;
            this.field_219436_c = bl;
        }
    }

    public static final class FunctionEntry<T> {
        private final Function<ITaskExecutor<Unit>, T> field_219428_a;
        private final long field_219429_b;
        private final IntSupplier field_219430_c;

        private FunctionEntry(Function<ITaskExecutor<Unit>, T> function, long l, IntSupplier intSupplier) {
            this.field_219428_a = function;
            this.field_219429_b = l;
            this.field_219430_c = intSupplier;
        }
    }
}

