/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class SetLootTable
extends LootFunction {
    private final ResourceLocation field_215928_a;
    private final long field_215929_c;

    private SetLootTable(ILootCondition[] iLootConditionArray, ResourceLocation resourceLocation, long l) {
        super(iLootConditionArray);
        this.field_215928_a = resourceLocation;
        this.field_215929_c = l;
    }

    @Override
    public LootFunctionType func_230425_b_() {
        return LootFunctionManager.field_237444_q_;
    }

    @Override
    public ItemStack func_215859_a(ItemStack itemStack, LootContext lootContext) {
        if (itemStack.func_190926_b()) {
            return itemStack;
        }
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a("LootTable", this.field_215928_a.toString());
        if (this.field_215929_c != 0L) {
            compoundNBT.func_74772_a("LootTableSeed", this.field_215929_c);
        }
        itemStack.func_196082_o().func_218657_a("BlockEntityTag", compoundNBT);
        return itemStack;
    }

    @Override
    public void func_225580_a_(ValidationTracker validationTracker) {
        if (validationTracker.func_227532_a_(this.field_215928_a)) {
            validationTracker.func_227530_a_("Table " + this.field_215928_a + " is recursively called");
            return;
        }
        super.func_225580_a_(validationTracker);
        LootTable lootTable = validationTracker.func_227539_c_(this.field_215928_a);
        if (lootTable == null) {
            validationTracker.func_227530_a_("Unknown loot table called " + this.field_215928_a);
        } else {
            lootTable.func_227506_a_(validationTracker.func_227531_a_("->{" + this.field_215928_a + "}", this.field_215928_a));
        }
    }

    public static class Serializer
    extends LootFunction.Serializer<SetLootTable> {
        @Override
        public void func_230424_a_(JsonObject jsonObject, SetLootTable setLootTable, JsonSerializationContext jsonSerializationContext) {
            super.func_230424_a_(jsonObject, setLootTable, jsonSerializationContext);
            jsonObject.addProperty("name", setLootTable.field_215928_a.toString());
            if (setLootTable.field_215929_c != 0L) {
                jsonObject.addProperty("seed", (Number)setLootTable.field_215929_c);
            }
        }

        @Override
        public SetLootTable func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "name"));
            long \u26032 = JSONUtils.func_219796_a(jsonObject, "seed", 0L);
            return new SetLootTable(iLootConditionArray, resourceLocation, \u26032);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, iLootConditionArray);
        }
    }
}

