/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.DaylightDetectorTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class DaylightDetectorBlock
extends ContainerBlock {
    public static final IntegerProperty field_176436_a = BlockStateProperties.field_208136_ak;
    public static final BooleanProperty field_196320_b = BlockStateProperties.field_208188_o;
    protected static final VoxelShape field_196321_c = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 6.0, 16.0);

    public DaylightDetectorBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176436_a, 0)).func_206870_a(field_196320_b, false));
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return field_196321_c;
    }

    @Override
    public boolean func_220074_n(BlockState blockState) {
        return true;
    }

    @Override
    public int func_180656_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        return blockState.func_177229_b(field_176436_a);
    }

    public static void func_196319_d(BlockState blockState, World world, BlockPos blockPos) {
        if (!world.func_230315_m_().func_218272_d()) {
            return;
        }
        int \u26034 = world.func_226658_a_(LightType.SKY, blockPos) - world.func_175657_ab();
        float \u26032 = world.func_72929_e(1.0f);
        boolean \u26033 = blockState.func_177229_b(field_196320_b);
        if (\u26033) {
            \u26034 = 15 - \u26034;
        } else if (\u26034 > 0) {
            float f = \u26032 < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            \u26032 += (f - \u26032) * 0.2f;
            \u26034 = Math.round((float)\u26034 * MathHelper.func_76134_b(\u26032));
        }
        \u26034 = MathHelper.func_76125_a(\u26034, 0, 15);
        if (blockState.func_177229_b(field_176436_a) != \u26034) {
            world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_176436_a, \u26034), 3);
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState2, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        BlockState blockState2;
        if (playerEntity.func_175142_cm()) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            BlockState blockState3 = (BlockState)blockState2.func_235896_a_(field_196320_b);
            world.func_180501_a(blockPos, blockState3, 4);
            DaylightDetectorBlock.func_196319_d(blockState3, world, blockPos);
            return ActionResultType.CONSUME;
        }
        return super.func_225533_a_(blockState2, world, blockPos, playerEntity, hand, blockRayTraceResult);
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    @Override
    public boolean func_149744_f(BlockState blockState) {
        return true;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new DaylightDetectorTileEntity();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176436_a, field_196320_b);
    }
}

