/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryKeyCodec;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.gen.settings.ScalingSettings;
import net.minecraft.world.gen.settings.SlideSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public final class DimensionSettings {
    public static final Codec<DimensionSettings> field_236097_a_ = RecordCodecBuilder.create(instance -> instance.group((App)DimensionStructuresSettings.field_236190_a_.fieldOf("structures").forGetter(DimensionSettings::func_236108_a_), (App)NoiseSettings.field_236156_a_.fieldOf("noise").forGetter(DimensionSettings::func_236113_b_), (App)BlockState.field_235877_b_.fieldOf("default_block").forGetter(DimensionSettings::func_236115_c_), (App)BlockState.field_235877_b_.fieldOf("default_fluid").forGetter(DimensionSettings::func_236116_d_), (App)Codec.intRange((int)-20, (int)276).fieldOf("bedrock_roof_position").forGetter(DimensionSettings::func_236117_e_), (App)Codec.intRange((int)-20, (int)276).fieldOf("bedrock_floor_position").forGetter(DimensionSettings::func_236118_f_), (App)Codec.intRange((int)0, (int)255).fieldOf("sea_level").forGetter(DimensionSettings::func_236119_g_), (App)Codec.BOOL.fieldOf("disable_mob_generation").forGetter(DimensionSettings::func_236120_h_)).apply((Applicative)instance, DimensionSettings::new));
    public static final Codec<Supplier<DimensionSettings>> field_236098_b_ = RegistryKeyCodec.func_241794_a_(Registry.field_243549_ar, field_236097_a_);
    private final DimensionStructuresSettings field_236099_c_;
    private final NoiseSettings field_236100_d_;
    private final BlockState field_236101_e_;
    private final BlockState field_236102_f_;
    private final int field_236103_g_;
    private final int field_236104_h_;
    private final int field_236105_i_;
    private final boolean field_236106_j_;
    public static final RegistryKey<DimensionSettings> field_242734_c = RegistryKey.func_240903_a_(Registry.field_243549_ar, new ResourceLocation("overworld"));
    public static final RegistryKey<DimensionSettings> field_242735_d = RegistryKey.func_240903_a_(Registry.field_243549_ar, new ResourceLocation("amplified"));
    public static final RegistryKey<DimensionSettings> field_242736_e = RegistryKey.func_240903_a_(Registry.field_243549_ar, new ResourceLocation("nether"));
    public static final RegistryKey<DimensionSettings> field_242737_f = RegistryKey.func_240903_a_(Registry.field_243549_ar, new ResourceLocation("end"));
    public static final RegistryKey<DimensionSettings> field_242738_g = RegistryKey.func_240903_a_(Registry.field_243549_ar, new ResourceLocation("caves"));
    public static final RegistryKey<DimensionSettings> field_242739_h = RegistryKey.func_240903_a_(Registry.field_243549_ar, new ResourceLocation("floating_islands"));
    private static final DimensionSettings field_242740_q = DimensionSettings.func_242745_a(field_242734_c, DimensionSettings.func_242743_a(new DimensionStructuresSettings(true), false, field_242734_c.func_240901_a_()));

    private DimensionSettings(DimensionStructuresSettings dimensionStructuresSettings, NoiseSettings noiseSettings, BlockState blockState, BlockState blockState2, int n, int n2, int n3, boolean bl) {
        this.field_236099_c_ = dimensionStructuresSettings;
        this.field_236100_d_ = noiseSettings;
        this.field_236101_e_ = blockState;
        this.field_236102_f_ = blockState2;
        this.field_236103_g_ = n;
        this.field_236104_h_ = n2;
        this.field_236105_i_ = n3;
        this.field_236106_j_ = bl;
    }

    public DimensionStructuresSettings func_236108_a_() {
        return this.field_236099_c_;
    }

    public NoiseSettings func_236113_b_() {
        return this.field_236100_d_;
    }

    public BlockState func_236115_c_() {
        return this.field_236101_e_;
    }

    public BlockState func_236116_d_() {
        return this.field_236102_f_;
    }

    public int func_236117_e_() {
        return this.field_236103_g_;
    }

    public int func_236118_f_() {
        return this.field_236104_h_;
    }

    public int func_236119_g_() {
        return this.field_236105_i_;
    }

    @Deprecated
    protected boolean func_236120_h_() {
        return this.field_236106_j_;
    }

    public boolean func_242744_a(RegistryKey<DimensionSettings> registryKey) {
        return Objects.equals(this, WorldGenRegistries.field_243658_j.func_230516_a_(registryKey));
    }

    private static DimensionSettings func_242745_a(RegistryKey<DimensionSettings> registryKey, DimensionSettings dimensionSettings) {
        WorldGenRegistries.func_243664_a(WorldGenRegistries.field_243658_j, registryKey.func_240901_a_(), dimensionSettings);
        return dimensionSettings;
    }

    public static DimensionSettings func_242746_i() {
        return field_242740_q;
    }

    private static DimensionSettings func_242742_a(DimensionStructuresSettings dimensionStructuresSettings, BlockState blockState, BlockState blockState2, ResourceLocation resourceLocation, boolean bl, boolean bl2) {
        return new DimensionSettings(dimensionStructuresSettings, new NoiseSettings(128, new ScalingSettings(2.0, 1.0, 80.0, 160.0), new SlideSettings(-3000, 64, -46), new SlideSettings(-30, 7, 1), 2, 1, 0.0, 0.0, true, false, bl2, false), blockState, blockState2, -10, -10, 0, bl);
    }

    private static DimensionSettings func_242741_a(DimensionStructuresSettings dimensionStructuresSettings, BlockState blockState, BlockState blockState2, ResourceLocation resourceLocation) {
        HashMap hashMap = Maps.newHashMap(DimensionStructuresSettings.field_236191_b_);
        hashMap.put(Structure.field_236372_h_, new StructureSeparationSettings(25, 10, 34222645));
        return new DimensionSettings(new DimensionStructuresSettings(Optional.ofNullable(dimensionStructuresSettings.func_236199_b_()), hashMap), new NoiseSettings(128, new ScalingSettings(1.0, 3.0, 80.0, 60.0), new SlideSettings(120, 3, 0), new SlideSettings(320, 4, -1), 1, 2, 0.0, 0.019921875, false, false, false, false), blockState, blockState2, 0, 0, 32, false);
    }

    private static DimensionSettings func_242743_a(DimensionStructuresSettings dimensionStructuresSettings, boolean bl, ResourceLocation resourceLocation) {
        double d = 0.9999999814507745;
        return new DimensionSettings(dimensionStructuresSettings, new NoiseSettings(256, new ScalingSettings(0.9999999814507745, 0.9999999814507745, 80.0, 160.0), new SlideSettings(-10, 3, 0), new SlideSettings(-30, 0, 0), 1, 2, 1.0, -0.46875, true, true, false, bl), Blocks.field_150348_b.func_176223_P(), Blocks.field_150355_j.func_176223_P(), -10, 0, 63, false);
    }

    static {
        DimensionSettings.func_242745_a(field_242735_d, DimensionSettings.func_242743_a(new DimensionStructuresSettings(true), true, field_242735_d.func_240901_a_()));
        DimensionSettings.func_242745_a(field_242736_e, DimensionSettings.func_242741_a(new DimensionStructuresSettings(false), Blocks.field_150424_aL.func_176223_P(), Blocks.field_150353_l.func_176223_P(), field_242736_e.func_240901_a_()));
        DimensionSettings.func_242745_a(field_242737_f, DimensionSettings.func_242742_a(new DimensionStructuresSettings(false), Blocks.field_150377_bs.func_176223_P(), Blocks.field_150350_a.func_176223_P(), field_242737_f.func_240901_a_(), true, true));
        DimensionSettings.func_242745_a(field_242738_g, DimensionSettings.func_242741_a(new DimensionStructuresSettings(true), Blocks.field_150348_b.func_176223_P(), Blocks.field_150355_j.func_176223_P(), field_242738_g.func_240901_a_()));
        DimensionSettings.func_242745_a(field_242739_h, DimensionSettings.func_242742_a(new DimensionStructuresSettings(true), Blocks.field_150348_b.func_176223_P(), Blocks.field_150355_j.func_176223_P(), field_242739_h.func_240901_a_(), false, false));
    }
}

