/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.datasync;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Pose;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeHooks;

public class DataSerializers {
    private static final IntIdentityHashBiMap<IDataSerializer<?>> field_187204_n = new IntIdentityHashBiMap(16);
    public static final IDataSerializer<Byte> field_187191_a = new IDataSerializer<Byte>(){

        public void func_187160_a(PacketBuffer p_187160_1_, Byte p_187160_2_) {
            p_187160_1_.writeByte(p_187160_2_.byteValue());
        }

        public Byte func_187159_a(PacketBuffer p_187159_1_) {
            return p_187159_1_.readByte();
        }

        public Byte func_192717_a(Byte p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<Integer> field_187192_b = new IDataSerializer<Integer>(){

        public void func_187160_a(PacketBuffer p_187160_1_, Integer p_187160_2_) {
            p_187160_1_.func_150787_b(p_187160_2_);
        }

        public Integer func_187159_a(PacketBuffer p_187159_1_) {
            return p_187159_1_.func_150792_a();
        }

        public Integer func_192717_a(Integer p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<Float> field_187193_c = new IDataSerializer<Float>(){

        public void func_187160_a(PacketBuffer p_187160_1_, Float p_187160_2_) {
            p_187160_1_.writeFloat(p_187160_2_.floatValue());
        }

        public Float func_187159_a(PacketBuffer p_187159_1_) {
            return Float.valueOf(p_187159_1_.readFloat());
        }

        public Float func_192717_a(Float p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<String> field_187194_d = new IDataSerializer<String>(){

        public void func_187160_a(PacketBuffer p_187160_1_, String p_187160_2_) {
            p_187160_1_.func_180714_a(p_187160_2_);
        }

        public String func_187159_a(PacketBuffer p_187159_1_) {
            return p_187159_1_.func_150789_c(Short.MAX_VALUE);
        }

        public String func_192717_a(String p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<ITextComponent> field_187195_e = new IDataSerializer<ITextComponent>(){

        public void func_187160_a(PacketBuffer p_187160_1_, ITextComponent p_187160_2_) {
            p_187160_1_.func_179256_a(p_187160_2_);
        }

        public ITextComponent func_187159_a(PacketBuffer p_187159_1_) {
            return p_187159_1_.func_179258_d();
        }

        public ITextComponent func_192717_a(ITextComponent p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<Optional<ITextComponent>> field_200544_f = new IDataSerializer<Optional<ITextComponent>>(){

        public void func_187160_a(PacketBuffer p_187160_1_, Optional<ITextComponent> p_187160_2_) {
            if (p_187160_2_.isPresent()) {
                p_187160_1_.writeBoolean(true);
                p_187160_1_.func_179256_a(p_187160_2_.get());
            } else {
                p_187160_1_.writeBoolean(false);
            }
        }

        public Optional<ITextComponent> func_187159_a(PacketBuffer p_187159_1_) {
            return p_187159_1_.readBoolean() ? Optional.of(p_187159_1_.func_179258_d()) : Optional.empty();
        }

        public Optional<ITextComponent> func_192717_a(Optional<ITextComponent> p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<ItemStack> field_187196_f = new IDataSerializer<ItemStack>(){

        public void func_187160_a(PacketBuffer p_187160_1_, ItemStack p_187160_2_) {
            p_187160_1_.func_150788_a(p_187160_2_);
        }

        public ItemStack func_187159_a(PacketBuffer p_187159_1_) {
            return p_187159_1_.func_150791_c();
        }

        public ItemStack func_192717_a(ItemStack p_192717_1_) {
            return p_192717_1_.func_77946_l();
        }
    };
    public static final IDataSerializer<Optional<BlockState>> field_187197_g = new IDataSerializer<Optional<BlockState>>(){

        public void func_187160_a(PacketBuffer p_187160_1_, Optional<BlockState> p_187160_2_) {
            if (p_187160_2_.isPresent()) {
                p_187160_1_.func_150787_b(Block.func_196246_j(p_187160_2_.get()));
            } else {
                p_187160_1_.func_150787_b(0);
            }
        }

        public Optional<BlockState> func_187159_a(PacketBuffer p_187159_1_) {
            int i = p_187159_1_.func_150792_a();
            return i == 0 ? Optional.empty() : Optional.of(Block.func_196257_b(i));
        }

        public Optional<BlockState> func_192717_a(Optional<BlockState> p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<Boolean> field_187198_h = new IDataSerializer<Boolean>(){

        public void func_187160_a(PacketBuffer p_187160_1_, Boolean p_187160_2_) {
            p_187160_1_.writeBoolean(p_187160_2_);
        }

        public Boolean func_187159_a(PacketBuffer p_187159_1_) {
            return p_187159_1_.readBoolean();
        }

        public Boolean func_192717_a(Boolean p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<IParticleData> field_198166_i = new IDataSerializer<IParticleData>(){

        public void func_187160_a(PacketBuffer p_187160_1_, IParticleData p_187160_2_) {
            p_187160_1_.func_150787_b(Registry.field_212632_u.func_148757_b(p_187160_2_.func_197554_b()));
            p_187160_2_.func_197553_a(p_187160_1_);
        }

        public IParticleData func_187159_a(PacketBuffer p_187159_1_) {
            return this.func_200543_a(p_187159_1_, (ParticleType)((Object)Registry.field_212632_u.func_148745_a(p_187159_1_.func_150792_a())));
        }

        private <T extends IParticleData> T func_200543_a(PacketBuffer p_200543_1_, ParticleType<T> p_200543_2_) {
            return (T)p_200543_2_.func_197571_g().func_197543_b(p_200543_2_, p_200543_1_);
        }

        public IParticleData func_192717_a(IParticleData p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<Rotations> field_187199_i = new IDataSerializer<Rotations>(){

        public void func_187160_a(PacketBuffer p_187160_1_, Rotations p_187160_2_) {
            p_187160_1_.writeFloat(p_187160_2_.func_179415_b());
            p_187160_1_.writeFloat(p_187160_2_.func_179416_c());
            p_187160_1_.writeFloat(p_187160_2_.func_179413_d());
        }

        public Rotations func_187159_a(PacketBuffer p_187159_1_) {
            return new Rotations(p_187159_1_.readFloat(), p_187159_1_.readFloat(), p_187159_1_.readFloat());
        }

        public Rotations func_192717_a(Rotations p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<BlockPos> field_187200_j = new IDataSerializer<BlockPos>(){

        public void func_187160_a(PacketBuffer p_187160_1_, BlockPos p_187160_2_) {
            p_187160_1_.func_179255_a(p_187160_2_);
        }

        public BlockPos func_187159_a(PacketBuffer p_187159_1_) {
            return p_187159_1_.func_179259_c();
        }

        public BlockPos func_192717_a(BlockPos p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<Optional<BlockPos>> field_187201_k = new IDataSerializer<Optional<BlockPos>>(){

        public void func_187160_a(PacketBuffer p_187160_1_, Optional<BlockPos> p_187160_2_) {
            p_187160_1_.writeBoolean(p_187160_2_.isPresent());
            if (p_187160_2_.isPresent()) {
                p_187160_1_.func_179255_a(p_187160_2_.get());
            }
        }

        public Optional<BlockPos> func_187159_a(PacketBuffer p_187159_1_) {
            return !p_187159_1_.readBoolean() ? Optional.empty() : Optional.of(p_187159_1_.func_179259_c());
        }

        public Optional<BlockPos> func_192717_a(Optional<BlockPos> p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<Direction> field_187202_l = new IDataSerializer<Direction>(){

        public void func_187160_a(PacketBuffer p_187160_1_, Direction p_187160_2_) {
            p_187160_1_.func_179249_a(p_187160_2_);
        }

        public Direction func_187159_a(PacketBuffer p_187159_1_) {
            return p_187159_1_.func_179257_a(Direction.class);
        }

        public Direction func_192717_a(Direction p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<Optional<UUID>> field_187203_m = new IDataSerializer<Optional<UUID>>(){

        public void func_187160_a(PacketBuffer p_187160_1_, Optional<UUID> p_187160_2_) {
            p_187160_1_.writeBoolean(p_187160_2_.isPresent());
            if (p_187160_2_.isPresent()) {
                p_187160_1_.func_179252_a(p_187160_2_.get());
            }
        }

        public Optional<UUID> func_187159_a(PacketBuffer p_187159_1_) {
            return !p_187159_1_.readBoolean() ? Optional.empty() : Optional.of(p_187159_1_.func_179253_g());
        }

        public Optional<UUID> func_192717_a(Optional<UUID> p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<CompoundNBT> field_192734_n = new IDataSerializer<CompoundNBT>(){

        public void func_187160_a(PacketBuffer p_187160_1_, CompoundNBT p_187160_2_) {
            p_187160_1_.func_150786_a(p_187160_2_);
        }

        public CompoundNBT func_187159_a(PacketBuffer p_187159_1_) {
            return p_187159_1_.func_150793_b();
        }

        public CompoundNBT func_192717_a(CompoundNBT p_192717_1_) {
            return p_192717_1_.func_74737_b();
        }
    };
    public static final IDataSerializer<VillagerData> field_218813_q = new IDataSerializer<VillagerData>(){

        public void func_187160_a(PacketBuffer p_187160_1_, VillagerData p_187160_2_) {
            p_187160_1_.func_150787_b(Registry.field_218369_K.func_148757_b((Object)p_187160_2_.func_221129_a()));
            p_187160_1_.func_150787_b(Registry.field_218370_L.func_148757_b((Object)p_187160_2_.func_221130_b()));
            p_187160_1_.func_150787_b(p_187160_2_.func_221132_c());
        }

        public VillagerData func_187159_a(PacketBuffer p_187159_1_) {
            return new VillagerData((VillagerType)Registry.field_218369_K.func_148745_a(p_187159_1_.func_150792_a()), (VillagerProfession)((Object)Registry.field_218370_L.func_148745_a(p_187159_1_.func_150792_a())), p_187159_1_.func_150792_a());
        }

        public VillagerData func_192717_a(VillagerData p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<OptionalInt> field_218814_r = new IDataSerializer<OptionalInt>(){

        public void func_187160_a(PacketBuffer p_187160_1_, OptionalInt p_187160_2_) {
            p_187160_1_.func_150787_b(p_187160_2_.orElse(-1) + 1);
        }

        public OptionalInt func_187159_a(PacketBuffer p_187159_1_) {
            int i = p_187159_1_.func_150792_a();
            return i == 0 ? OptionalInt.empty() : OptionalInt.of(i - 1);
        }

        public OptionalInt func_192717_a(OptionalInt p_192717_1_) {
            return p_192717_1_;
        }
    };
    public static final IDataSerializer<Pose> field_218815_s = new IDataSerializer<Pose>(){

        public void func_187160_a(PacketBuffer p_187160_1_, Pose p_187160_2_) {
            p_187160_1_.func_179249_a((Enum<?>)p_187160_2_);
        }

        public Pose func_187159_a(PacketBuffer p_187159_1_) {
            return p_187159_1_.func_179257_a(Pose.class);
        }

        public Pose func_192717_a(Pose p_192717_1_) {
            return p_192717_1_;
        }
    };

    public static void func_187189_a(IDataSerializer<?> p_187189_0_) {
        if (field_187204_n.func_186808_c(p_187189_0_) >= 256) {
            throw new RuntimeException("Vanilla DataSerializer ID limit exceeded");
        }
    }

    @Nullable
    public static IDataSerializer<?> func_187190_a(int p_187190_0_) {
        return ForgeHooks.getSerializer((int)p_187190_0_, field_187204_n);
    }

    public static int func_187188_b(IDataSerializer<?> p_187188_0_) {
        return ForgeHooks.getSerializerId(p_187188_0_, field_187204_n);
    }

    static {
        DataSerializers.func_187189_a(field_187191_a);
        DataSerializers.func_187189_a(field_187192_b);
        DataSerializers.func_187189_a(field_187193_c);
        DataSerializers.func_187189_a(field_187194_d);
        DataSerializers.func_187189_a(field_187195_e);
        DataSerializers.func_187189_a(field_200544_f);
        DataSerializers.func_187189_a(field_187196_f);
        DataSerializers.func_187189_a(field_187198_h);
        DataSerializers.func_187189_a(field_187199_i);
        DataSerializers.func_187189_a(field_187200_j);
        DataSerializers.func_187189_a(field_187201_k);
        DataSerializers.func_187189_a(field_187202_l);
        DataSerializers.func_187189_a(field_187203_m);
        DataSerializers.func_187189_a(field_187197_g);
        DataSerializers.func_187189_a(field_192734_n);
        DataSerializers.func_187189_a(field_198166_i);
        DataSerializers.func_187189_a(field_218813_q);
        DataSerializers.func_187189_a(field_218814_r);
        DataSerializers.func_187189_a(field_218815_s);
    }
}

