/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.Cancelable;

public class EntityTeleportEvent
extends EntityEvent {
    protected double targetX;
    protected double targetY;
    protected double targetZ;

    public EntityTeleportEvent(Entity entity, double targetX, double targetY, double targetZ) {
        super(entity);
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
    }

    public double getTargetX() {
        return this.targetX;
    }

    public void setTargetX(double targetX) {
        this.targetX = targetX;
    }

    public double getTargetY() {
        return this.targetY;
    }

    public void setTargetY(double targetY) {
        this.targetY = targetY;
    }

    public double getTargetZ() {
        return this.targetZ;
    }

    public void setTargetZ(double targetZ) {
        this.targetZ = targetZ;
    }

    public Vector3d getTarget() {
        return new Vector3d(this.targetX, this.targetY, this.targetZ);
    }

    public double getPrevX() {
        return this.getEntity().func_226277_ct_();
    }

    public double getPrevY() {
        return this.getEntity().func_226278_cu_();
    }

    public double getPrevZ() {
        return this.getEntity().func_226281_cx_();
    }

    public Vector3d getPrev() {
        return this.getEntity().func_213303_ch();
    }

    @Cancelable
    public static class ChorusFruit
    extends EntityTeleportEvent {
        private final LivingEntity entityLiving;

        public ChorusFruit(LivingEntity entity, double targetX, double targetY, double targetZ) {
            super((Entity)entity, targetX, targetY, targetZ);
            this.entityLiving = entity;
        }

        public LivingEntity getEntityLiving() {
            return this.entityLiving;
        }
    }

    @Cancelable
    public static class EnderPearl
    extends EntityTeleportEvent {
        private final ServerPlayerEntity player;
        private final EnderPearlEntity pearlEntity;
        private float attackDamage;

        public EnderPearl(ServerPlayerEntity entity, double targetX, double targetY, double targetZ, EnderPearlEntity pearlEntity, float attackDamage) {
            super((Entity)entity, targetX, targetY, targetZ);
            this.pearlEntity = pearlEntity;
            this.player = entity;
            this.attackDamage = attackDamage;
        }

        public EnderPearlEntity getPearlEntity() {
            return this.pearlEntity;
        }

        public ServerPlayerEntity getPlayer() {
            return this.player;
        }

        public float getAttackDamage() {
            return this.attackDamage;
        }

        public void setAttackDamage(float attackDamage) {
            this.attackDamage = attackDamage;
        }
    }

    @Cancelable
    public static class EnderEntity
    extends EntityTeleportEvent {
        private final LivingEntity entityLiving;

        public EnderEntity(LivingEntity entity, double targetX, double targetY, double targetZ) {
            super((Entity)entity, targetX, targetY, targetZ);
            this.entityLiving = entity;
        }

        public LivingEntity getEntityLiving() {
            return this.entityLiving;
        }
    }

    @Cancelable
    public static class SpreadPlayersCommand
    extends EntityTeleportEvent {
        public SpreadPlayersCommand(Entity entity, double targetX, double targetY, double targetZ) {
            super(entity, targetX, targetY, targetZ);
        }
    }

    @Cancelable
    public static class TeleportCommand
    extends EntityTeleportEvent {
        public TeleportCommand(Entity entity, double targetX, double targetY, double targetZ) {
            super(entity, targetX, targetY, targetZ);
        }
    }
}

