/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public interface IForgePacketBuffer {
    default public PacketBuffer getBuffer() {
        return (PacketBuffer)this;
    }

    default public <T extends IForgeRegistryEntry<T>> void writeRegistryIdUnsafe(@Nonnull IForgeRegistry<T> registry, @Nonnull T entry) {
        ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
        int id = forgeRegistry.getID(entry);
        this.getBuffer().func_150787_b(id);
    }

    default public void writeRegistryIdUnsafe(@Nonnull IForgeRegistry<?> registry, @Nonnull ResourceLocation entryKey) {
        ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
        int id = forgeRegistry.getID(entryKey);
        this.getBuffer().func_150787_b(id);
    }

    default public <T extends IForgeRegistryEntry<T>> T readRegistryIdUnsafe(@Nonnull IForgeRegistry<T> registry) {
        ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
        int id = this.getBuffer().func_150792_a();
        return (T)forgeRegistry.getValue(id);
    }

    default public <T extends IForgeRegistryEntry<T>> void writeRegistryId(@Nonnull T entry) {
        Class<T> regType = Objects.requireNonNull(entry, "Cannot write a null registry entry!").getRegistryType();
        IForgeRegistry<T> retrievedRegistry = RegistryManager.ACTIVE.getRegistry(regType);
        Preconditions.checkArgument((retrievedRegistry != null ? 1 : 0) != 0, (String)"Cannot write registry id for an unknown registry type: %s", (Object)regType.getName());
        ResourceLocation name = retrievedRegistry.getRegistryName();
        Preconditions.checkArgument((boolean)retrievedRegistry.containsValue(entry), (String)"Cannot find %s in %s", entry.getRegistryName() != null ? entry.getRegistryName() : entry, (Object)name);
        ForgeRegistry reg = (ForgeRegistry)retrievedRegistry;
        this.getBuffer().func_192572_a(name);
        this.getBuffer().func_150787_b(reg.getID(entry));
    }

    default public <T extends IForgeRegistryEntry<T>> T readRegistryId() {
        ResourceLocation location = this.getBuffer().func_192575_l();
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(location);
        return (T)registry.getValue(this.getBuffer().func_150792_a());
    }

    default public <T extends IForgeRegistryEntry<T>> T readRegistryIdSafe(Class<? super T> registrySuperType) {
        T value = this.readRegistryId();
        if (!value.getRegistryType().equals(registrySuperType)) {
            throw new IllegalArgumentException("Attempted to read an registryValue of the wrong type from the Buffer!");
        }
        return value;
    }

    default public void writeFluidStack(FluidStack stack) {
        if (stack.isEmpty()) {
            this.getBuffer().writeBoolean(false);
        } else {
            this.getBuffer().writeBoolean(true);
            stack.writeToPacket(this.getBuffer());
        }
    }

    default public FluidStack readFluidStack() {
        return !this.getBuffer().readBoolean() ? FluidStack.EMPTY : FluidStack.readFromPacket(this.getBuffer());
    }
}

