/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.customconverter;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.lang3.StringUtils;

public class ConvertGermanToBoolean<T>
extends AbstractBeanField<T> {
    protected static final String WAHR = "wahr";
    protected static final String FALSCH = "falsch";

    @Override
    protected Object convert(String value) throws CsvDataTypeMismatchException {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        String[] trueStrings = new String[]{WAHR, "ja", "j", "1", "w"};
        String[] falseStrings = new String[]{FALSCH, "nein", "n", "0", "f"};
        BooleanConverter bc = new BooleanConverter(trueStrings, falseStrings);
        try {
            return bc.convert(Boolean.class, (Object)value.trim());
        }
        catch (ConversionException e) {
            CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, this.field.getType(), ResourceBundle.getBundle("convertGermanToBoolean", this.errorLocale).getString("input.not.boolean"));
            csve.initCause(e);
            throw csve;
        }
    }

    @Override
    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        String result = "";
        try {
            if (value != null) {
                Boolean b = (Boolean)value;
                result = b != false ? WAHR : FALSCH;
            }
        }
        catch (ClassCastException e) {
            CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(ResourceBundle.getBundle("convertGermanToBoolean", this.errorLocale).getString("field.not.boolean"));
            csve.initCause(e);
            throw csve;
        }
        return result;
    }
}

