/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.datasync;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityDataManager {
    private static final Logger field_190303_a = LogManager.getLogger();
    private static final Map<Class<? extends Entity>, Integer> field_187232_a = Maps.newHashMap();
    private final Entity field_187233_b;
    private final Map<Integer, DataEntry<?>> field_187234_c = Maps.newHashMap();
    private final ReadWriteLock field_187235_d = new ReentrantReadWriteLock();
    private boolean field_187236_e = true;
    private boolean field_187237_f;

    public EntityDataManager(Entity p_i46840_1_) {
        this.field_187233_b = p_i46840_1_;
    }

    public static <T> DataParameter<T> func_187226_a(Class<? extends Entity> p_187226_0_, IDataSerializer<T> p_187226_1_) {
        int j;
        try {
            Class<?> oclass = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
            if (!oclass.equals(p_187226_0_)) {
                if (field_190303_a.isDebugEnabled()) {
                    field_190303_a.warn("defineId called for: {} from {}", p_187226_0_, oclass, (Object)new RuntimeException());
                } else {
                    field_190303_a.warn("defineId called for: {} from {}", p_187226_0_, oclass);
                }
            }
        }
        catch (ClassNotFoundException oclass) {
            // empty catch block
        }
        if (field_187232_a.containsKey(p_187226_0_)) {
            j = field_187232_a.get(p_187226_0_) + 1;
        } else {
            int i = 0;
            Class<? extends Entity> oclass1 = p_187226_0_;
            while (oclass1 != Entity.class) {
                if (!field_187232_a.containsKey(oclass1 = oclass1.getSuperclass())) continue;
                i = field_187232_a.get(oclass1) + 1;
                break;
            }
            j = i;
        }
        if (j > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + j + "! (Max is " + 254 + ")");
        }
        field_187232_a.put(p_187226_0_, j);
        return p_187226_1_.func_187161_a(j);
    }

    public <T> void func_187214_a(DataParameter<T> p_187214_1_, T p_187214_2_) {
        int i = p_187214_1_.func_187155_a();
        if (i > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i + "! (Max is " + 254 + ")");
        }
        if (this.field_187234_c.containsKey(i)) {
            throw new IllegalArgumentException("Duplicate id value for " + i + "!");
        }
        if (DataSerializers.func_187188_b(p_187214_1_.func_187156_b()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + p_187214_1_.func_187156_b() + " for " + i + "!");
        }
        this.func_187222_c(p_187214_1_, p_187214_2_);
    }

    private <T> void func_187222_c(DataParameter<T> p_187222_1_, T p_187222_2_) {
        DataEntry<T> dataentry = new DataEntry<T>(p_187222_1_, p_187222_2_);
        this.field_187235_d.writeLock().lock();
        this.field_187234_c.put(p_187222_1_.func_187155_a(), dataentry);
        this.field_187236_e = false;
        this.field_187235_d.writeLock().unlock();
    }

    private <T> DataEntry<T> func_187219_c(DataParameter<T> p_187219_1_) {
        DataEntry<?> dataentry;
        this.field_187235_d.readLock().lock();
        try {
            dataentry = this.field_187234_c.get(p_187219_1_.func_187155_a());
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Getting synched entity data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Synched entity data");
            crashreportcategory.func_71507_a("Data ID", p_187219_1_);
            throw new ReportedException(crashreport);
        }
        finally {
            this.field_187235_d.readLock().unlock();
        }
        return dataentry;
    }

    public <T> T func_187225_a(DataParameter<T> p_187225_1_) {
        return this.func_187219_c(p_187225_1_).func_187206_b();
    }

    public <T> void func_187227_b(DataParameter<T> p_187227_1_, T p_187227_2_) {
        DataEntry<T> dataentry = this.func_187219_c(p_187227_1_);
        if (ObjectUtils.notEqual(p_187227_2_, dataentry.func_187206_b())) {
            dataentry.func_187210_a(p_187227_2_);
            this.field_187233_b.func_184206_a(p_187227_1_);
            dataentry.func_187208_a(true);
            this.field_187237_f = true;
        }
    }

    public boolean func_187223_a() {
        return this.field_187237_f;
    }

    public static void func_187229_a(List<DataEntry<?>> p_187229_0_, PacketBuffer p_187229_1_) throws IOException {
        if (p_187229_0_ != null) {
            int j = p_187229_0_.size();
            for (int i = 0; i < j; ++i) {
                EntityDataManager.func_187220_a(p_187229_1_, p_187229_0_.get(i));
            }
        }
        p_187229_1_.writeByte(255);
    }

    @Nullable
    public List<DataEntry<?>> func_187221_b() {
        ArrayList list = null;
        if (this.field_187237_f) {
            this.field_187235_d.readLock().lock();
            for (DataEntry<?> dataentry : this.field_187234_c.values()) {
                if (!dataentry.func_187209_c()) continue;
                dataentry.func_187208_a(false);
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(dataentry.func_192735_d());
            }
            this.field_187235_d.readLock().unlock();
        }
        this.field_187237_f = false;
        return list;
    }

    @Nullable
    public List<DataEntry<?>> func_187231_c() {
        ArrayList list = null;
        this.field_187235_d.readLock().lock();
        for (DataEntry<?> dataentry : this.field_187234_c.values()) {
            if (list == null) {
                list = Lists.newArrayList();
            }
            list.add(dataentry.func_192735_d());
        }
        this.field_187235_d.readLock().unlock();
        return list;
    }

    private static <T> void func_187220_a(PacketBuffer p_187220_0_, DataEntry<T> p_187220_1_) throws IOException {
        DataParameter<T> dataparameter = p_187220_1_.func_187205_a();
        int i = DataSerializers.func_187188_b(dataparameter.func_187156_b());
        if (i < 0) {
            throw new EncoderException("Unknown serializer type " + dataparameter.func_187156_b());
        }
        p_187220_0_.writeByte(dataparameter.func_187155_a());
        p_187220_0_.func_150787_b(i);
        dataparameter.func_187156_b().func_187160_a(p_187220_0_, p_187220_1_.func_187206_b());
    }

    @Nullable
    public static List<DataEntry<?>> func_187215_b(PacketBuffer p_187215_0_) throws IOException {
        short i;
        ArrayList list = null;
        while ((i = p_187215_0_.readUnsignedByte()) != 255) {
            int j;
            IDataSerializer<?> idataserializer;
            if (list == null) {
                list = Lists.newArrayList();
            }
            if ((idataserializer = DataSerializers.func_187190_a(j = p_187215_0_.func_150792_a())) == null) {
                throw new DecoderException("Unknown serializer type " + j);
            }
            list.add(EntityDataManager.func_198167_a(p_187215_0_, i, idataserializer));
        }
        return list;
    }

    private static <T> DataEntry<T> func_198167_a(PacketBuffer p_198167_0_, int p_198167_1_, IDataSerializer<T> p_198167_2_) {
        return new DataEntry<Object>(p_198167_2_.func_187161_a(p_198167_1_), p_198167_2_.func_187159_a(p_198167_0_));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_187218_a(List<DataEntry<?>> p_187218_1_) {
        this.field_187235_d.writeLock().lock();
        for (DataEntry<?> dataentry : p_187218_1_) {
            DataEntry<?> dataentry1 = this.field_187234_c.get(dataentry.func_187205_a().func_187155_a());
            if (dataentry1 == null) continue;
            this.func_187224_a(dataentry1, dataentry);
            this.field_187233_b.func_184206_a(dataentry.func_187205_a());
        }
        this.field_187235_d.writeLock().unlock();
        this.field_187237_f = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private <T> void func_187224_a(DataEntry<T> p_187224_1_, DataEntry<?> p_187224_2_) {
        if (!Objects.equals(((DataEntry)p_187224_2_).field_187211_a.func_187156_b(), ((DataEntry)p_187224_1_).field_187211_a.func_187156_b())) {
            throw new IllegalStateException(String.format("Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", new Object[]{((DataEntry)p_187224_1_).field_187211_a.func_187155_a(), this.field_187233_b, ((DataEntry)p_187224_1_).field_187212_b, ((DataEntry)p_187224_1_).field_187212_b.getClass(), ((DataEntry)p_187224_2_).field_187212_b, ((DataEntry)p_187224_2_).field_187212_b.getClass()}));
        }
        p_187224_1_.func_187210_a(p_187224_2_.func_187206_b());
    }

    public boolean func_187228_d() {
        return this.field_187236_e;
    }

    public void func_187230_e() {
        this.field_187237_f = false;
        this.field_187235_d.readLock().lock();
        for (DataEntry<?> dataentry : this.field_187234_c.values()) {
            dataentry.func_187208_a(false);
        }
        this.field_187235_d.readLock().unlock();
    }

    public static class DataEntry<T> {
        private final DataParameter<T> field_187211_a;
        private T field_187212_b;
        private boolean field_187213_c;

        public DataEntry(DataParameter<T> p_i47010_1_, T p_i47010_2_) {
            this.field_187211_a = p_i47010_1_;
            this.field_187212_b = p_i47010_2_;
            this.field_187213_c = true;
        }

        public DataParameter<T> func_187205_a() {
            return this.field_187211_a;
        }

        public void func_187210_a(T p_187210_1_) {
            this.field_187212_b = p_187210_1_;
        }

        public T func_187206_b() {
            return this.field_187212_b;
        }

        public boolean func_187209_c() {
            return this.field_187213_c;
        }

        public void func_187208_a(boolean p_187208_1_) {
            this.field_187213_c = p_187208_1_;
        }

        public DataEntry<T> func_192735_d() {
            return new DataEntry<Object>(this.field_187211_a, this.field_187211_a.func_187156_b().func_192717_a(this.field_187212_b));
        }
    }
}

