/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.gui.screen.EnchantmentScreen;
import net.minecraft.client.gui.screen.GrindstoneScreen;
import net.minecraft.client.gui.screen.HopperScreen;
import net.minecraft.client.gui.screen.LecternScreen;
import net.minecraft.client.gui.screen.LoomScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.AnvilScreen;
import net.minecraft.client.gui.screen.inventory.BeaconScreen;
import net.minecraft.client.gui.screen.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screen.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screen.inventory.CartographyTableScreen;
import net.minecraft.client.gui.screen.inventory.ChestScreen;
import net.minecraft.client.gui.screen.inventory.CraftingScreen;
import net.minecraft.client.gui.screen.inventory.DispenserScreen;
import net.minecraft.client.gui.screen.inventory.FurnaceScreen;
import net.minecraft.client.gui.screen.inventory.MerchantScreen;
import net.minecraft.client.gui.screen.inventory.ShulkerBoxScreen;
import net.minecraft.client.gui.screen.inventory.SmithingTableScreen;
import net.minecraft.client.gui.screen.inventory.SmokerScreen;
import net.minecraft.client.gui.screen.inventory.StonecutterScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ScreenManager {
    private static final Logger field_216913_a = LogManager.getLogger();
    private static final Map<ContainerType<?>, IScreenFactory<?, ?>> field_216914_b = Maps.newHashMap();

    public static <T extends Container> void func_216909_a(@Nullable ContainerType<T> p_216909_0_, Minecraft p_216909_1_, int p_216909_2_, ITextComponent p_216909_3_) {
        ScreenManager.getScreenFactory(p_216909_0_, p_216909_1_, p_216909_2_, p_216909_3_).ifPresent(f -> f.func_216908_a(p_216909_3_, p_216909_0_, p_216909_1_, p_216909_2_));
    }

    public static <T extends Container> Optional<IScreenFactory<T, ?>> getScreenFactory(@Nullable ContainerType<T> p_216909_0_, Minecraft p_216909_1_, int p_216909_2_, ITextComponent p_216909_3_) {
        if (p_216909_0_ == null) {
            field_216913_a.warn("Trying to open invalid screen with name: {}", (Object)p_216909_3_.getString());
        } else {
            IScreenFactory<T, ?> iscreenfactory = ScreenManager.func_216912_a(p_216909_0_);
            if (iscreenfactory == null) {
                field_216913_a.warn("Failed to create screen for menu type: {}", (Object)Registry.field_218366_G.func_177774_c(p_216909_0_));
            } else {
                return Optional.of(iscreenfactory);
            }
        }
        return Optional.empty();
    }

    @Nullable
    private static <T extends Container> IScreenFactory<T, ?> func_216912_a(ContainerType<T> p_216912_0_) {
        return field_216914_b.get(p_216912_0_);
    }

    public static <M extends Container, U extends Screen> void func_216911_a(ContainerType<? extends M> p_216911_0_, IScreenFactory<M, U> p_216911_1_) {
        IScreenFactory<M, U> iscreenfactory = field_216914_b.put(p_216911_0_, p_216911_1_);
        if (iscreenfactory != null) {
            throw new IllegalStateException("Duplicate registration for " + Registry.field_218366_G.func_177774_c(p_216911_0_));
        }
    }

    public static boolean func_216910_a() {
        boolean flag = false;
        Iterator iterator = Registry.field_218366_G.iterator();
        while (iterator.hasNext()) {
            ContainerType containertype = (ContainerType)((Object)iterator.next());
            if (field_216914_b.containsKey((Object)containertype)) continue;
            field_216913_a.debug("Menu {} has no matching screen", (Object)Registry.field_218366_G.func_177774_c(containertype));
            flag = true;
        }
        return flag;
    }

    static {
        ScreenManager.func_216911_a(ContainerType.field_221507_a, ChestScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221508_b, ChestScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221509_c, ChestScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221510_d, ChestScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221511_e, ChestScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221512_f, ChestScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221513_g, DispenserScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221514_h, AnvilScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221515_i, BeaconScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221516_j, BlastFurnaceScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221517_k, BrewingStandScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221518_l, CraftingScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221519_m, EnchantmentScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221520_n, FurnaceScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221521_o, GrindstoneScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221522_p, HopperScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221523_q, LecternScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221524_r, LoomScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221525_s, MerchantScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221526_t, ShulkerBoxScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_234650_u_, SmithingTableScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221527_u, SmokerScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_226625_v_, CartographyTableScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221529_w, StonecutterScreen::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IScreenFactory<T extends Container, U extends Screen> {
        default public void func_216908_a(ITextComponent p_216908_1_, ContainerType<T> p_216908_2_, Minecraft p_216908_3_, int p_216908_4_) {
            U u = this.create(p_216908_2_.func_221506_a(p_216908_4_, p_216908_3_.field_71439_g.field_71071_by), p_216908_3_.field_71439_g.field_71071_by, p_216908_1_);
            p_216908_3_.field_71439_g.field_71070_bA = ((IHasContainer)u).func_212873_a_();
            p_216908_3_.func_147108_a((Screen)((Object)u));
        }

        public U create(T var1, PlayerInventory var2, ITextComponent var3);
    }
}

