/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ChunkStatus
extends ForgeRegistryEntry<ChunkStatus> {
    private static final EnumSet<Heightmap.Type> field_222618_n = EnumSet.of(Heightmap.Type.OCEAN_FLOOR_WG, Heightmap.Type.WORLD_SURFACE_WG);
    private static final EnumSet<Heightmap.Type> field_222619_o = EnumSet.of(Heightmap.Type.OCEAN_FLOOR, Heightmap.Type.WORLD_SURFACE, Heightmap.Type.MOTION_BLOCKING, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
    private static final ILoadingWorker field_223211_p = (p_222588_0_, p_222588_1_, p_222588_2_, p_222588_3_, p_222588_4_, p_222588_5_) -> {
        if (p_222588_5_ instanceof ChunkPrimer && !p_222588_5_.func_201589_g().func_209003_a(p_222588_0_)) {
            ((ChunkPrimer)p_222588_5_).func_201574_a(p_222588_0_);
        }
        return CompletableFuture.completedFuture(Either.left((Object)p_222588_5_));
    };
    public static final ChunkStatus field_223226_a_ = ChunkStatus.func_223203_a("empty", null, -1, field_222618_n, Type.PROTOCHUNK, (p_223194_0_, p_223194_1_, p_223194_2_, p_223194_3_) -> {});
    public static final ChunkStatus field_222606_b = ChunkStatus.func_223207_a("structure_starts", field_223226_a_, 0, field_222618_n, Type.PROTOCHUNK, (p_222586_0_, p_222586_1_, p_222586_2_, p_222586_3_, p_222586_4_, p_222586_5_, p_222586_6_, p_222586_7_) -> {
        if (!p_222586_7_.func_201589_g().func_209003_a(p_222586_0_)) {
            if (p_222586_1_.func_73046_m().func_240793_aU_().func_230418_z_().func_236222_c_()) {
                p_222586_2_.func_242707_a(p_222586_1_.func_241828_r(), p_222586_1_.func_241112_a_(), p_222586_7_, p_222586_3_, p_222586_1_.func_72905_C());
            }
            if (p_222586_7_ instanceof ChunkPrimer) {
                ((ChunkPrimer)p_222586_7_).func_201574_a(p_222586_0_);
            }
        }
        return CompletableFuture.completedFuture(Either.left((Object)p_222586_7_));
    });
    public static final ChunkStatus field_222607_c = ChunkStatus.func_223203_a("structure_references", field_222606_b, 8, field_222618_n, Type.PROTOCHUNK, (p_222587_0_, p_222587_1_, p_222587_2_, p_222587_3_) -> {
        WorldGenRegion worldgenregion = new WorldGenRegion(p_222587_0_, p_222587_2_);
        p_222587_1_.func_235953_a_((ISeedReader)worldgenregion, p_222587_0_.func_241112_a_().func_241464_a_(worldgenregion), p_222587_3_);
    });
    public static final ChunkStatus field_222608_d = ChunkStatus.func_223203_a("biomes", field_222607_c, 0, field_222618_n, Type.PROTOCHUNK, (p_222594_0_, p_222594_1_, p_222594_2_, p_222594_3_) -> p_222594_1_.func_242706_a(p_222594_0_.func_241828_r().func_243612_b(Registry.field_239720_u_), p_222594_3_));
    public static final ChunkStatus field_222609_e = ChunkStatus.func_223203_a("noise", field_222608_d, 8, field_222618_n, Type.PROTOCHUNK, (p_222592_0_, p_222592_1_, p_222592_2_, p_222592_3_) -> {
        WorldGenRegion worldgenregion = new WorldGenRegion(p_222592_0_, p_222592_2_);
        p_222592_1_.func_230352_b_((IWorld)worldgenregion, p_222592_0_.func_241112_a_().func_241464_a_(worldgenregion), p_222592_3_);
    });
    public static final ChunkStatus field_222610_f = ChunkStatus.func_223203_a("surface", field_222609_e, 0, field_222618_n, Type.PROTOCHUNK, (p_222589_0_, p_222589_1_, p_222589_2_, p_222589_3_) -> p_222589_1_.func_225551_a_(new WorldGenRegion(p_222589_0_, p_222589_2_), p_222589_3_));
    public static final ChunkStatus field_222611_g = ChunkStatus.func_223203_a("carvers", field_222610_f, 0, field_222618_n, Type.PROTOCHUNK, (p_222590_0_, p_222590_1_, p_222590_2_, p_222590_3_) -> p_222590_1_.func_230350_a_(p_222590_0_.func_72905_C(), p_222590_0_.func_225523_d_(), p_222590_3_, GenerationStage.Carving.AIR));
    public static final ChunkStatus field_222612_h = ChunkStatus.func_223203_a("liquid_carvers", field_222611_g, 0, field_222619_o, Type.PROTOCHUNK, (p_222601_0_, p_222601_1_, p_222601_2_, p_222601_3_) -> p_222601_1_.func_230350_a_(p_222601_0_.func_72905_C(), p_222601_0_.func_225523_d_(), p_222601_3_, GenerationStage.Carving.LIQUID));
    public static final ChunkStatus field_222613_i = ChunkStatus.func_223207_a("features", field_222612_h, 8, field_222619_o, Type.PROTOCHUNK, (p_222605_0_, p_222605_1_, p_222605_2_, p_222605_3_, p_222605_4_, p_222605_5_, p_222605_6_, p_222605_7_) -> {
        ChunkPrimer chunkprimer = (ChunkPrimer)p_222605_7_;
        chunkprimer.func_217306_a((WorldLightManager)p_222605_4_);
        if (!p_222605_7_.func_201589_g().func_209003_a(p_222605_0_)) {
            Heightmap.func_222690_a((IChunk)p_222605_7_, EnumSet.of(Heightmap.Type.MOTION_BLOCKING, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, Heightmap.Type.OCEAN_FLOOR, Heightmap.Type.WORLD_SURFACE));
            WorldGenRegion worldgenregion = new WorldGenRegion(p_222605_1_, p_222605_6_);
            p_222605_2_.func_230351_a_(worldgenregion, p_222605_1_.func_241112_a_().func_241464_a_(worldgenregion));
            chunkprimer.func_201574_a(p_222605_0_);
        }
        return CompletableFuture.completedFuture(Either.left((Object)p_222605_7_));
    });
    public static final ChunkStatus field_222614_j = ChunkStatus.func_223196_a("light", field_222613_i, 1, field_222619_o, Type.PROTOCHUNK, (p_222604_0_, p_222604_1_, p_222604_2_, p_222604_3_, p_222604_4_, p_222604_5_, p_222604_6_, p_222604_7_) -> ChunkStatus.func_223206_a(p_222604_0_, p_222604_4_, p_222604_7_), (p_223195_0_, p_223195_1_, p_223195_2_, p_223195_3_, p_223195_4_, p_223195_5_) -> ChunkStatus.func_223206_a(p_223195_0_, p_223195_3_, p_223195_5_));
    public static final ChunkStatus field_222615_k = ChunkStatus.func_223203_a("spawn", field_222614_j, 0, field_222619_o, Type.PROTOCHUNK, (p_222602_0_, p_222602_1_, p_222602_2_, p_222602_3_) -> p_222602_1_.func_230354_a_(new WorldGenRegion(p_222602_0_, p_222602_2_)));
    public static final ChunkStatus field_222616_l = ChunkStatus.func_223203_a("heightmaps", field_222615_k, 0, field_222619_o, Type.PROTOCHUNK, (p_222603_0_, p_222603_1_, p_222603_2_, p_222603_3_) -> {});
    public static final ChunkStatus field_222617_m = ChunkStatus.func_223196_a("full", field_222616_l, 0, field_222619_o, Type.LEVELCHUNK, (p_222598_0_, p_222598_1_, p_222598_2_, p_222598_3_, p_222598_4_, p_222598_5_, p_222598_6_, p_222598_7_) -> (CompletableFuture)p_222598_5_.apply(p_222598_7_), (p_223205_0_, p_223205_1_, p_223205_2_, p_223205_3_, p_223205_4_, p_223205_5_) -> (CompletableFuture)p_223205_4_.apply(p_223205_5_));
    private static final List<ChunkStatus> field_222620_p = ImmutableList.of((Object)((Object)field_222617_m), (Object)((Object)field_222613_i), (Object)((Object)field_222612_h), (Object)((Object)field_222606_b), (Object)((Object)field_222606_b), (Object)((Object)field_222606_b), (Object)((Object)field_222606_b), (Object)((Object)field_222606_b), (Object)((Object)field_222606_b), (Object)((Object)field_222606_b), (Object)((Object)field_222606_b));
    private static final IntList field_222621_q = (IntList)Util.func_200696_a(new IntArrayList(ChunkStatus.func_222582_a().size()), p_223202_0_ -> {
        int i = 0;
        for (int j = ChunkStatus.func_222582_a().size() - 1; j >= 0; --j) {
            while (i + 1 < field_222620_p.size() && j <= field_222620_p.get(i + 1).func_222584_c()) {
                ++i;
            }
            p_223202_0_.add(0, i);
        }
    });
    private final String field_202130_j;
    private final int field_222623_s;
    private final ChunkStatus field_222624_t;
    private final IGenerationWorker field_223212_v;
    private final ILoadingWorker field_225500_w;
    private final int field_202133_m;
    private final Type field_202134_n;
    private final EnumSet<Heightmap.Type> field_222625_x;

    private static CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223206_a(ChunkStatus status, ServerWorldLightManager lightManager, IChunk chunk) {
        boolean flag = ChunkStatus.func_223197_a(status, chunk);
        if (!chunk.func_201589_g().func_209003_a(status)) {
            ((ChunkPrimer)chunk).func_201574_a(status);
        }
        return lightManager.func_215593_a(chunk, flag).thenApply(Either::left);
    }

    private static ChunkStatus func_223203_a(String key, @Nullable ChunkStatus parent, int taskRange, EnumSet<Heightmap.Type> heightmaps, Type type, ISelectiveWorker generationWorker) {
        return ChunkStatus.func_223207_a(key, parent, taskRange, heightmaps, type, generationWorker);
    }

    private static ChunkStatus func_223207_a(String key, @Nullable ChunkStatus parent, int taskRange, EnumSet<Heightmap.Type> heightmaps, Type type, IGenerationWorker generationWorker) {
        return ChunkStatus.func_223196_a(key, parent, taskRange, heightmaps, type, generationWorker, field_223211_p);
    }

    private static ChunkStatus func_223196_a(String key, @Nullable ChunkStatus parent, int taskRange, EnumSet<Heightmap.Type> heightmaps, Type type, IGenerationWorker generationWorker, ILoadingWorker loadingWorker) {
        return Registry.func_218325_a(Registry.field_218360_A, key, new ChunkStatus(key, parent, taskRange, heightmaps, type, generationWorker, loadingWorker));
    }

    public static List<ChunkStatus> func_222582_a() {
        ChunkStatus chunkstatus;
        ArrayList list = Lists.newArrayList();
        for (chunkstatus = field_222617_m; chunkstatus.func_222593_e() != chunkstatus; chunkstatus = chunkstatus.func_222593_e()) {
            list.add(chunkstatus);
        }
        list.add(chunkstatus);
        Collections.reverse(list);
        return list;
    }

    private static boolean func_223197_a(ChunkStatus status, IChunk chunk) {
        return chunk.func_201589_g().func_209003_a(status) && chunk.func_217310_r();
    }

    public static ChunkStatus func_222581_a(int id) {
        if (id >= field_222620_p.size()) {
            return field_223226_a_;
        }
        return id < 0 ? field_222617_m : field_222620_p.get(id);
    }

    public static int func_222600_b() {
        return field_222620_p.size();
    }

    public static int func_222599_a(ChunkStatus status) {
        return field_222621_q.getInt(status.func_222584_c());
    }

    public ChunkStatus(String nameIn, @Nullable ChunkStatus parentIn, int taskRangeIn, EnumSet<Heightmap.Type> heightmapsIn, Type typeIn, IGenerationWorker generationWorkerIn, ILoadingWorker loadingWorkerIn) {
        this.field_202130_j = nameIn;
        this.field_222624_t = parentIn == null ? this : parentIn;
        this.field_223212_v = generationWorkerIn;
        this.field_225500_w = loadingWorkerIn;
        this.field_202133_m = taskRangeIn;
        this.field_202134_n = typeIn;
        this.field_222625_x = heightmapsIn;
        this.field_222623_s = parentIn == null ? 0 : parentIn.func_222584_c() + 1;
    }

    public int func_222584_c() {
        return this.field_222623_s;
    }

    public String func_222596_d() {
        return this.field_202130_j;
    }

    public ChunkStatus func_222593_e() {
        return this.field_222624_t;
    }

    public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223198_a(ServerWorld worldIn, ChunkGenerator chunkGeneratorIn, TemplateManager templateManagerIn, ServerWorldLightManager lightManager, Function<IChunk, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>> loadingFunction, List<IChunk> chunks) {
        return this.field_223212_v.doWork(this, worldIn, chunkGeneratorIn, templateManagerIn, lightManager, loadingFunction, chunks, chunks.get(chunks.size() / 2));
    }

    public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223201_a(ServerWorld worldIn, TemplateManager templateManagerIn, ServerWorldLightManager lightManager, Function<IChunk, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>> loadingFunction, IChunk loadingChunk) {
        return this.field_225500_w.doWork(this, worldIn, templateManagerIn, lightManager, loadingFunction, loadingChunk);
    }

    public int func_202128_c() {
        return this.field_202133_m;
    }

    public Type func_202129_d() {
        return this.field_202134_n;
    }

    public static ChunkStatus func_222591_a(String location) {
        return (ChunkStatus)((Object)Registry.field_218360_A.func_82594_a(ResourceLocation.func_208304_a(location)));
    }

    public EnumSet<Heightmap.Type> func_222595_h() {
        return this.field_222625_x;
    }

    public boolean func_209003_a(ChunkStatus status) {
        return this.func_222584_c() >= status.func_222584_c();
    }

    public String toString() {
        return Registry.field_218360_A.func_177774_c((Object)this).toString();
    }

    public static enum Type {
        PROTOCHUNK,
        LEVELCHUNK;

    }

    static interface ISelectiveWorker
    extends IGenerationWorker {
        @Override
        default public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> doWork(ChunkStatus p_doWork_1_, ServerWorld p_doWork_2_, ChunkGenerator p_doWork_3_, TemplateManager p_doWork_4_, ServerWorldLightManager p_doWork_5_, Function<IChunk, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>> p_doWork_6_, List<IChunk> p_doWork_7_, IChunk p_doWork_8_) {
            if (!p_doWork_8_.func_201589_g().func_209003_a(p_doWork_1_)) {
                this.doWork(p_doWork_2_, p_doWork_3_, p_doWork_7_, p_doWork_8_);
                if (p_doWork_8_ instanceof ChunkPrimer) {
                    ((ChunkPrimer)p_doWork_8_).func_201574_a(p_doWork_1_);
                }
            }
            return CompletableFuture.completedFuture(Either.left((Object)p_doWork_8_));
        }

        public void doWork(ServerWorld var1, ChunkGenerator var2, List<IChunk> var3, IChunk var4);
    }

    static interface ILoadingWorker {
        public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> doWork(ChunkStatus var1, ServerWorld var2, TemplateManager var3, ServerWorldLightManager var4, Function<IChunk, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>> var5, IChunk var6);
    }

    static interface IGenerationWorker {
        public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> doWork(ChunkStatus var1, ServerWorld var2, ChunkGenerator var3, TemplateManager var4, ServerWorldLightManager var5, Function<IChunk, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>> var6, List<IChunk> var7, IChunk var8);
    }
}

