/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.level.ColorResolver;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IWorldReader
extends IBlockDisplayReader,
ICollisionReader,
BiomeManager.IBiomeReader {
    @Nullable
    public IChunk func_217353_a(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    public boolean func_217354_b(int var1, int var2);

    public int func_201676_a(Heightmap.Type var1, int var2, int var3);

    public int func_175657_ab();

    public BiomeManager func_225523_d_();

    default public Biome func_226691_t_(BlockPos pos) {
        return this.func_225523_d_().func_226836_a_(pos);
    }

    default public Stream<BlockState> func_234939_c_(AxisAlignedBB aabb) {
        int j1;
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)aabb.field_72336_d);
        int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int l = MathHelper.func_76128_c((double)aabb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        return this.func_217344_a(i, k, i1, j, l, j1 = MathHelper.func_76128_c((double)aabb.field_72334_f)) ? this.func_234853_a_(aabb) : Stream.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int func_225525_a_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        return colorResolverIn.getColor(this.func_226691_t_(blockPosIn), (double)blockPosIn.func_177958_n(), (double)blockPosIn.func_177952_p());
    }

    default public Biome func_225526_b_(int x, int y, int z) {
        IChunk ichunk = this.func_217353_a(x >> 2, z >> 2, ChunkStatus.field_222608_d, false);
        return ichunk != null && ichunk.func_225549_i_() != null ? ichunk.func_225549_i_().func_225526_b_(x, y, z) : this.func_225604_a_(x, y, z);
    }

    public Biome func_225604_a_(int var1, int var2, int var3);

    public boolean func_201670_d();

    @Deprecated
    public int func_181545_F();

    public DimensionType func_230315_m_();

    default public BlockPos func_205770_a(Heightmap.Type heightmapType, BlockPos pos) {
        return new BlockPos(pos.func_177958_n(), this.func_201676_a(heightmapType, pos.func_177958_n(), pos.func_177952_p()), pos.func_177952_p());
    }

    default public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).isAir((IBlockReader)((Object)this), pos);
    }

    default public boolean func_175710_j(BlockPos pos) {
        if (pos.func_177956_o() >= this.func_181545_F()) {
            return this.func_226660_f_(pos);
        }
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), this.func_181545_F(), pos.func_177952_p());
        if (!this.func_226660_f_(blockpos)) {
            return false;
        }
        BlockPos blockpos1 = blockpos.func_177977_b();
        while (blockpos1.func_177956_o() > pos.func_177956_o()) {
            BlockState blockstate = this.func_180495_p(blockpos1);
            if (blockstate.func_200016_a((IBlockReader)((Object)this), blockpos1) > 0 && !blockstate.func_185904_a().func_76224_d()) {
                return false;
            }
            blockpos1 = blockpos1.func_177977_b();
        }
        return true;
    }

    @Deprecated
    default public float func_205052_D(BlockPos pos) {
        return this.func_230315_m_().func_236021_a_(this.func_201696_r(pos));
    }

    default public int func_175627_a(BlockPos pos, Direction direction) {
        return this.func_180495_p(pos).func_185893_b((IBlockReader)((Object)this), pos, direction);
    }

    default public IChunk func_217349_x(BlockPos pos) {
        return this.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    default public IChunk func_212866_a_(int chunkX, int chunkZ) {
        return this.func_217353_a(chunkX, chunkZ, ChunkStatus.field_222617_m, true);
    }

    default public IChunk func_217348_a(int chunkX, int chunkZ, ChunkStatus requiredStatus) {
        return this.func_217353_a(chunkX, chunkZ, requiredStatus, true);
    }

    @Nullable
    default public IBlockReader func_225522_c_(int chunkX, int chunkZ) {
        return this.func_217353_a(chunkX, chunkZ, ChunkStatus.field_223226_a_, false);
    }

    default public boolean func_201671_F(BlockPos pos) {
        return this.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
    }

    default public boolean func_72953_d(AxisAlignedBB bb) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockState blockstate = this.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(k1, l1, i2));
                    if (blockstate.func_204520_s().func_206888_e()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    default public int func_201696_r(BlockPos pos) {
        return this.func_205049_d(pos, this.func_175657_ab());
    }

    default public int func_205049_d(BlockPos pos, int amount) {
        return pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000 ? this.func_226659_b_(pos, amount) : 15;
    }

    @Deprecated
    default public boolean func_175667_e(BlockPos pos) {
        return this.func_217354_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    default public boolean isAreaLoaded(BlockPos center, int range) {
        return this.func_175707_a(center.func_177982_a(-range, -range, -range), center.func_177982_a(range, range, range));
    }

    @Deprecated
    default public boolean func_175707_a(BlockPos from, BlockPos to) {
        return this.func_217344_a(from.func_177958_n(), from.func_177956_o(), from.func_177952_p(), to.func_177958_n(), to.func_177956_o(), to.func_177952_p());
    }

    @Deprecated
    default public boolean func_217344_a(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        if (toY >= 0 && fromY < 256) {
            fromZ >>= 4;
            toX >>= 4;
            toZ >>= 4;
            for (int i = fromX >>= 4; i <= toX; ++i) {
                for (int j = fromZ; j <= toZ; ++j) {
                    if (this.func_217354_b(i, j)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

