/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math.vector;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.IForgeTransformationMatrix;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
public final class TransformationMatrix
implements IForgeTransformationMatrix {
    private final Matrix4f field_227976_a_;
    private boolean field_227977_b_;
    @Nullable
    private Vector3f field_227978_c_;
    @Nullable
    private Quaternion field_227979_d_;
    @Nullable
    private Vector3f field_227980_e_;
    @Nullable
    private Quaternion field_227981_f_;
    private static final TransformationMatrix field_227982_g_ = Util.func_199748_a(() -> {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.func_226591_a_();
        TransformationMatrix transformationmatrix = new TransformationMatrix(matrix4f);
        transformationmatrix.func_227989_d_();
        return transformationmatrix;
    });
    private Matrix3f normalTransform = null;

    public TransformationMatrix(@Nullable Matrix4f matrixIn) {
        this.field_227976_a_ = matrixIn == null ? TransformationMatrix.field_227982_g_.field_227976_a_ : matrixIn;
    }

    public TransformationMatrix(@Nullable Vector3f translationIn, @Nullable Quaternion rotationLeftIn, @Nullable Vector3f scaleIn, @Nullable Quaternion rotationRightIn) {
        this.field_227976_a_ = TransformationMatrix.func_227986_a_(translationIn, rotationLeftIn, scaleIn, rotationRightIn);
        this.field_227978_c_ = translationIn != null ? translationIn : new Vector3f();
        this.field_227979_d_ = rotationLeftIn != null ? rotationLeftIn : Quaternion.field_227060_a_.func_227068_g_();
        this.field_227980_e_ = scaleIn != null ? scaleIn : new Vector3f(1.0f, 1.0f, 1.0f);
        this.field_227981_f_ = rotationRightIn != null ? rotationRightIn : Quaternion.field_227060_a_.func_227068_g_();
        this.field_227977_b_ = true;
    }

    public static TransformationMatrix func_227983_a_() {
        return field_227982_g_;
    }

    public TransformationMatrix func_227985_a_(TransformationMatrix matrixIn) {
        Matrix4f matrix4f = this.func_227988_c_();
        matrix4f.func_226595_a_(matrixIn.func_227988_c_());
        return new TransformationMatrix(matrix4f);
    }

    @Nullable
    public TransformationMatrix func_227987_b_() {
        if (this == field_227982_g_) {
            return this;
        }
        Matrix4f matrix4f = this.func_227988_c_();
        return matrix4f.func_226600_c_() ? new TransformationMatrix(matrix4f) : null;
    }

    private void func_227990_e_() {
        if (!this.field_227977_b_) {
            Pair<Matrix3f, Vector3f> pair = TransformationMatrix.func_227984_a_(this.field_227976_a_);
            Triple<Quaternion, Vector3f, Quaternion> triple = ((Matrix3f)pair.getFirst()).func_226116_b_();
            this.field_227978_c_ = (Vector3f)pair.getSecond();
            this.field_227979_d_ = (Quaternion)triple.getLeft();
            this.field_227980_e_ = (Vector3f)triple.getMiddle();
            this.field_227981_f_ = (Quaternion)triple.getRight();
            this.field_227977_b_ = true;
        }
    }

    private static Matrix4f func_227986_a_(@Nullable Vector3f translation, @Nullable Quaternion rotationLeft, @Nullable Vector3f scale, @Nullable Quaternion rotationRight) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.func_226591_a_();
        if (rotationLeft != null) {
            matrix4f.func_226595_a_(new Matrix4f(rotationLeft));
        }
        if (scale != null) {
            matrix4f.func_226595_a_(Matrix4f.func_226593_a_(scale.func_195899_a(), scale.func_195900_b(), scale.func_195902_c()));
        }
        if (rotationRight != null) {
            matrix4f.func_226595_a_(new Matrix4f(rotationRight));
        }
        if (translation != null) {
            matrix4f.field_226578_d_ = translation.func_195899_a();
            matrix4f.field_226582_h_ = translation.func_195900_b();
            matrix4f.field_226586_l_ = translation.func_195902_c();
        }
        return matrix4f;
    }

    public static Pair<Matrix3f, Vector3f> func_227984_a_(Matrix4f matrixIn) {
        matrixIn.func_226592_a_(1.0f / matrixIn.field_226590_p_);
        Vector3f vector3f = new Vector3f(matrixIn.field_226578_d_, matrixIn.field_226582_h_, matrixIn.field_226586_l_);
        Matrix3f matrix3f = new Matrix3f(matrixIn);
        return Pair.of((Object)matrix3f, (Object)vector3f);
    }

    public Matrix4f func_227988_c_() {
        return this.field_227976_a_.func_226601_d_();
    }

    public Quaternion func_227989_d_() {
        this.func_227990_e_();
        return this.field_227979_d_.func_227068_g_();
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            TransformationMatrix transformationmatrix = (TransformationMatrix)p_equals_1_;
            return Objects.equals(this.field_227976_a_, transformationmatrix.field_227976_a_);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.field_227976_a_);
    }

    public Vector3f getTranslation() {
        this.func_227990_e_();
        return this.field_227978_c_.func_229195_e_();
    }

    public Vector3f getScale() {
        this.func_227990_e_();
        return this.field_227980_e_.func_229195_e_();
    }

    public Quaternion getRightRot() {
        this.func_227990_e_();
        return this.field_227981_f_.func_227068_g_();
    }

    public Matrix3f getNormalMatrix() {
        this.checkNormalTransform();
        return this.normalTransform;
    }

    private void checkNormalTransform() {
        if (this.normalTransform == null) {
            this.normalTransform = new Matrix3f(this.field_227976_a_);
            this.normalTransform.func_226123_f_();
            this.normalTransform.func_226110_a_();
        }
    }
}

