/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class RegistryKey<T>
implements Comparable<RegistryKey<?>> {
    private static final Map<String, RegistryKey<?>> field_240898_a_ = Collections.synchronizedMap(Maps.newIdentityHashMap());
    private final ResourceLocation field_240899_b_;
    private final ResourceLocation field_240900_c_;

    public static <T> RegistryKey<T> func_240903_a_(RegistryKey<? extends Registry<T>> parent, ResourceLocation location) {
        return RegistryKey.func_240905_a_(parent.field_240900_c_, location);
    }

    public static <T> RegistryKey<Registry<T>> func_240904_a_(ResourceLocation location) {
        return RegistryKey.func_240905_a_(Registry.field_239706_f_, location);
    }

    private static <T> RegistryKey<T> func_240905_a_(ResourceLocation parent, ResourceLocation location) {
        String s = (parent + ":" + location).intern();
        return field_240898_a_.computeIfAbsent(s, p_240906_2_ -> new RegistryKey(parent, location));
    }

    private RegistryKey(ResourceLocation parent, ResourceLocation location) {
        this.field_240899_b_ = parent;
        this.field_240900_c_ = location;
    }

    public String toString() {
        return "ResourceKey[" + this.field_240899_b_ + " / " + this.field_240900_c_ + ']';
    }

    public boolean func_244356_a(RegistryKey<? extends Registry<?>> key) {
        return this.field_240899_b_.equals(key.func_240901_a_());
    }

    public ResourceLocation func_240901_a_() {
        return this.field_240900_c_;
    }

    public static <T> Function<ResourceLocation, RegistryKey<T>> func_240902_a_(RegistryKey<? extends Registry<T>> parent) {
        return p_240907_1_ -> RegistryKey.func_240903_a_(parent, p_240907_1_);
    }

    public ResourceLocation getRegistryName() {
        return this.field_240899_b_;
    }

    @Override
    public int compareTo(RegistryKey<?> o) {
        int ret = this.getRegistryName().compareTo(o.getRegistryName());
        if (ret == 0) {
            ret = this.func_240901_a_().compareTo(o.func_240901_a_());
        }
        return ret;
    }
}

