/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;

public interface ITagCollection<T> {
    public Map<ResourceLocation, ITag<T>> func_241833_a();

    @Nullable
    default public ITag<T> func_199910_a(ResourceLocation resourceLocationIn) {
        return this.func_241833_a().get(resourceLocationIn);
    }

    public ITag<T> func_241834_b(ResourceLocation var1);

    @Nullable
    public ResourceLocation func_232973_a_(ITag<T> var1);

    default public ResourceLocation func_232975_b_(ITag<T> tag) {
        ResourceLocation resourcelocation = this.func_232973_a_(tag);
        if (resourcelocation == null) {
            throw new IllegalStateException("Unrecognized tag");
        }
        return resourcelocation;
    }

    default public Collection<ResourceLocation> func_199908_a() {
        return this.func_241833_a().keySet();
    }

    default public Collection<ResourceLocation> func_199913_a(T itemIn) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, ITag<T>> entry : this.func_241833_a().entrySet()) {
            if (!entry.getValue().func_230235_a_(itemIn)) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    default public void func_242203_a(PacketBuffer buffer, DefaultedRegistry<T> defaulted) {
        Map<ResourceLocation, ITag<T>> map = this.func_241833_a();
        buffer.func_150787_b(map.size());
        for (Map.Entry<ResourceLocation, ITag<T>> entry : map.entrySet()) {
            buffer.func_192572_a(entry.getKey());
            buffer.func_150787_b(entry.getValue().func_230236_b_().size());
            for (T t : entry.getValue().func_230236_b_()) {
                buffer.func_150787_b(defaulted.func_148757_b(t));
            }
        }
    }

    public static <T> ITagCollection<T> func_242204_a(PacketBuffer buffer, Registry<T> registry) {
        HashMap map = Maps.newHashMap();
        int i = buffer.func_150792_a();
        for (int j = 0; j < i; ++j) {
            ResourceLocation resourcelocation = buffer.func_192575_l();
            int k = buffer.func_150792_a();
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int l = 0; l < k; ++l) {
                builder.add(registry.func_148745_a(buffer.func_150792_a()));
            }
            map.put(resourcelocation, ITag.func_232946_a_(builder.build()));
        }
        return ITagCollection.func_242202_a(map);
    }

    public static <T> ITagCollection<T> func_242205_c() {
        return ITagCollection.func_242202_a(ImmutableBiMap.of());
    }

    public static <T> ITagCollection<T> func_242202_a(Map<ResourceLocation, ITag<T>> idTagMap) {
        ImmutableBiMap bimap = ImmutableBiMap.copyOf(idTagMap);
        return new ITagCollection<T>((BiMap)bimap){
            private final ITag<T> field_242207_b = Tag.func_241284_a_();
            final /* synthetic */ BiMap val$bimap;
            {
                this.val$bimap = biMap;
            }

            @Override
            public ITag<T> func_241834_b(ResourceLocation id) {
                return (ITag)this.val$bimap.getOrDefault((Object)id, this.field_242207_b);
            }

            @Override
            @Nullable
            public ResourceLocation func_232973_a_(ITag<T> tag) {
                return tag instanceof ITag.INamedTag ? ((ITag.INamedTag)tag).func_230234_a_() : (ResourceLocation)this.val$bimap.inverse().get(tag);
            }

            @Override
            public Map<ResourceLocation, ITag<T>> func_241833_a() {
                return this.val$bimap;
            }
        };
    }
}

