/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;

public interface ITag<T> {
    public static <T> Codec<ITag<T>> func_232947_a_(Supplier<ITagCollection<T>> collectionSupplier) {
        return ResourceLocation.field_240908_a_.flatXmap(p_232949_1_ -> Optional.ofNullable(((ITagCollection)collectionSupplier.get()).func_199910_a((ResourceLocation)p_232949_1_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + p_232949_1_))), p_232948_1_ -> Optional.ofNullable(((ITagCollection)collectionSupplier.get()).func_232973_a_(p_232948_1_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + p_232948_1_))));
    }

    public boolean func_230235_a_(T var1);

    public List<T> func_230236_b_();

    default public T func_205596_a(Random random) {
        List<T> list = this.func_230236_b_();
        return list.get(random.nextInt(list.size()));
    }

    public static <T> ITag<T> func_232946_a_(Set<T> elements) {
        return Tag.func_241286_a_(elements);
    }

    public static class TagEntry
    implements ITagEntry {
        private final ResourceLocation field_200163_a;

        public TagEntry(ResourceLocation resourceLocationIn) {
            this.field_200163_a = resourceLocationIn;
        }

        @Override
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> resourceTagFunction, Function<ResourceLocation, T> resourceElementFunction, Consumer<T> elementConsumer) {
            ITag<T> itag = resourceTagFunction.apply(this.field_200163_a);
            if (itag == null) {
                return false;
            }
            itag.func_230236_b_().forEach(elementConsumer);
            return true;
        }

        @Override
        public void func_230237_a_(JsonArray jsonArray) {
            jsonArray.add("#" + this.field_200163_a);
        }

        public String toString() {
            return "#" + this.field_200163_a;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof TagEntry && Objects.equals(this.field_200163_a, ((TagEntry)o).field_200163_a);
        }

        public ResourceLocation getId() {
            return this.field_200163_a;
        }
    }

    public static class Proxy {
        private final ITagEntry field_232966_a_;
        private final String field_232967_b_;

        private Proxy(ITagEntry entry, String identifier) {
            this.field_232966_a_ = entry;
            this.field_232967_b_ = identifier;
        }

        public ITagEntry func_232968_a_() {
            return this.field_232966_a_;
        }

        public String toString() {
            return this.field_232966_a_.toString() + " (from " + this.field_232967_b_ + ")";
        }
    }

    public static class OptionalTagEntry
    implements ITagEntry {
        private final ResourceLocation field_242201_a;

        public OptionalTagEntry(ResourceLocation id) {
            this.field_242201_a = id;
        }

        @Override
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> resourceTagFunction, Function<ResourceLocation, T> resourceElementFunction, Consumer<T> elementConsumer) {
            ITag<T> itag = resourceTagFunction.apply(this.field_242201_a);
            if (itag != null) {
                itag.func_230236_b_().forEach(elementConsumer);
            }
            return true;
        }

        @Override
        public void func_230237_a_(JsonArray jsonArray) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("id", "#" + this.field_242201_a);
            jsonobject.addProperty("required", Boolean.valueOf(false));
            jsonArray.add((JsonElement)jsonobject);
        }

        public String toString() {
            return "#" + this.field_242201_a + "?";
        }
    }

    public static class OptionalItemEntry
    implements ITagEntry {
        private final ResourceLocation field_242200_a;

        public OptionalItemEntry(ResourceLocation id) {
            this.field_242200_a = id;
        }

        @Override
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> resourceTagFunction, Function<ResourceLocation, T> resourceElementFunction, Consumer<T> elementConsumer) {
            T t = resourceElementFunction.apply(this.field_242200_a);
            if (t != null) {
                elementConsumer.accept(t);
            }
            return true;
        }

        @Override
        public void func_230237_a_(JsonArray jsonArray) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("id", this.field_242200_a.toString());
            jsonobject.addProperty("required", Boolean.valueOf(false));
            jsonArray.add((JsonElement)jsonobject);
        }

        public String toString() {
            return this.field_242200_a.toString() + "?";
        }
    }

    public static class ItemEntry
    implements ITagEntry {
        private final ResourceLocation field_232969_a_;

        public ItemEntry(ResourceLocation identifier) {
            this.field_232969_a_ = identifier;
        }

        @Override
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> resourceTagFunction, Function<ResourceLocation, T> resourceElementFunction, Consumer<T> elementConsumer) {
            T t = resourceElementFunction.apply(this.field_232969_a_);
            if (t == null) {
                return false;
            }
            elementConsumer.accept(t);
            return true;
        }

        @Override
        public void func_230237_a_(JsonArray jsonArray) {
            jsonArray.add(this.field_232969_a_.toString());
        }

        public String toString() {
            return this.field_232969_a_.toString();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ItemEntry && Objects.equals(this.field_232969_a_, ((ItemEntry)o).field_232969_a_);
        }
    }

    public static interface ITagEntry {
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> var1, Function<ResourceLocation, T> var2, Consumer<T> var3);

        public void func_230237_a_(JsonArray var1);
    }

    public static interface INamedTag<T>
    extends ITag<T> {
        public ResourceLocation func_230234_a_();
    }

    public static class Builder {
        private final List<Proxy> field_232953_a_ = Lists.newArrayList();
        private boolean replace = false;

        public static Builder func_200047_a() {
            return new Builder();
        }

        public Builder func_232954_a_(Proxy proxyTag) {
            this.field_232953_a_.add(proxyTag);
            return this;
        }

        public Builder func_232955_a_(ITagEntry tagEntry, String identifier) {
            return this.func_232954_a_(new Proxy(tagEntry, identifier));
        }

        public Builder func_232961_a_(ResourceLocation registryName, String identifier) {
            return this.func_232955_a_(new ItemEntry(registryName), identifier);
        }

        public Builder func_232964_b_(ResourceLocation tag, String identifier) {
            return this.func_232955_a_(new TagEntry(tag), identifier);
        }

        public Builder replace(boolean value) {
            this.replace = value;
            return this;
        }

        public Builder replace() {
            return this.replace(true);
        }

        public <T> Optional<ITag<T>> func_232959_a_(Function<ResourceLocation, ITag<T>> resourceTagFunction, Function<ResourceLocation, T> resourceElementFunction) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Proxy itag$proxy : this.field_232953_a_) {
                if (itag$proxy.func_232968_a_().func_230238_a_(resourceTagFunction, resourceElementFunction, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0))) continue;
                return Optional.empty();
            }
            return Optional.of(ITag.func_232946_a_(builder.build()));
        }

        public Stream<Proxy> func_232962_b_() {
            return this.field_232953_a_.stream();
        }

        public <T> Stream<Proxy> func_232963_b_(Function<ResourceLocation, ITag<T>> resourceTagFunction, Function<ResourceLocation, T> resourceElementFunction) {
            return this.func_232962_b_().filter(p_232960_2_ -> !p_232960_2_.func_232968_a_().func_230238_a_(resourceTagFunction, resourceElementFunction, p_232957_0_ -> {}));
        }

        public Builder func_232956_a_(JsonObject json, String identifier) {
            JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)"values");
            ArrayList list = Lists.newArrayList();
            for (JsonElement jsonelement : jsonarray) {
                list.add(Builder.func_242199_a(jsonelement));
            }
            if (JSONUtils.func_151209_a((JsonObject)json, (String)"replace", (boolean)false)) {
                this.field_232953_a_.clear();
            }
            ForgeHooks.deserializeTagAdditions((List)list, (JsonObject)json, this.field_232953_a_);
            list.forEach(p_232958_2_ -> this.field_232953_a_.add(new Proxy((ITagEntry)p_232958_2_, identifier)));
            return this;
        }

        private static ITagEntry func_242199_a(JsonElement json) {
            boolean flag;
            String s;
            if (json.isJsonObject()) {
                JsonObject jsonobject = json.getAsJsonObject();
                s = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"id");
                flag = JSONUtils.func_151209_a((JsonObject)jsonobject, (String)"required", (boolean)true);
            } else {
                s = JSONUtils.func_151206_a((JsonElement)json, (String)"id");
                flag = true;
            }
            if (s.startsWith("#")) {
                ResourceLocation resourcelocation1 = new ResourceLocation(s.substring(1));
                return flag ? new TagEntry(resourcelocation1) : new OptionalTagEntry(resourcelocation1);
            }
            ResourceLocation resourcelocation = new ResourceLocation(s);
            return flag ? new ItemEntry(resourcelocation) : new OptionalItemEntry(resourcelocation);
        }

        public JsonObject func_232965_c_() {
            JsonObject jsonobject = new JsonObject();
            JsonArray jsonarray = new JsonArray();
            for (Proxy itag$proxy : this.field_232953_a_) {
                itag$proxy.func_232968_a_().func_230237_a_(jsonarray);
            }
            jsonobject.addProperty("replace", Boolean.valueOf(this.replace));
            jsonobject.add("values", (JsonElement)jsonarray);
            return jsonobject;
        }
    }
}

