/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;

public class SheepEntity
extends AnimalEntity
implements IShearable,
IForgeShearable {
    private static final DataParameter<Byte> field_184774_bv = EntityDataManager.func_187226_a(SheepEntity.class, DataSerializers.field_187191_a);
    private static final Map<DyeColor, IItemProvider> field_200206_bz = Util.func_200696_a(Maps.newEnumMap(DyeColor.class), p_203402_0_ -> {
        p_203402_0_.put(DyeColor.WHITE, Blocks.field_196556_aL);
        p_203402_0_.put(DyeColor.ORANGE, Blocks.field_196557_aM);
        p_203402_0_.put(DyeColor.MAGENTA, Blocks.field_196558_aN);
        p_203402_0_.put(DyeColor.LIGHT_BLUE, Blocks.field_196559_aO);
        p_203402_0_.put(DyeColor.YELLOW, Blocks.field_196560_aP);
        p_203402_0_.put(DyeColor.LIME, Blocks.field_196561_aQ);
        p_203402_0_.put(DyeColor.PINK, Blocks.field_196562_aR);
        p_203402_0_.put(DyeColor.GRAY, Blocks.field_196563_aS);
        p_203402_0_.put(DyeColor.LIGHT_GRAY, Blocks.field_196564_aT);
        p_203402_0_.put(DyeColor.CYAN, Blocks.field_196565_aU);
        p_203402_0_.put(DyeColor.PURPLE, Blocks.field_196566_aV);
        p_203402_0_.put(DyeColor.BLUE, Blocks.field_196567_aW);
        p_203402_0_.put(DyeColor.BROWN, Blocks.field_196568_aX);
        p_203402_0_.put(DyeColor.GREEN, Blocks.field_196569_aY);
        p_203402_0_.put(DyeColor.RED, Blocks.field_196570_aZ);
        p_203402_0_.put(DyeColor.BLACK, Blocks.field_196602_ba);
    });
    private static final Map<DyeColor, float[]> field_175514_bm = Maps.newEnumMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(p_200204_0_ -> p_200204_0_, SheepEntity::func_192020_c)));
    private int field_70899_e;
    private EatGrassGoal field_146087_bs;

    private static float[] func_192020_c(DyeColor dyeColorIn) {
        if (dyeColorIn == DyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = dyeColorIn.func_193349_f();
        float f = 0.75f;
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float[] func_175513_a(DyeColor dyeColor) {
        return field_175514_bm.get((Object)dyeColor);
    }

    public SheepEntity(EntityType<? extends SheepEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_146087_bs = new EatGrassGoal((MobEntity)((Object)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a(Items.field_151015_O), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)this.field_146087_bs);
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
    }

    @Override
    protected void func_70619_bc() {
        this.field_70899_e = this.field_146087_bs.func_151499_f();
        super.func_70619_bc();
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70899_e = Math.max(0, this.field_70899_e - 1);
        }
        super.func_70636_d();
    }

    public static AttributeModifierMap.MutableAttribute func_234225_eI_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.23f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184774_bv, (byte)0);
    }

    public ResourceLocation func_184647_J() {
        if (this.func_70892_o()) {
            return this.func_200600_R().func_220348_g();
        }
        switch (this.func_175509_cj()) {
            default: {
                return LootTables.field_186404_L;
            }
            case ORANGE: {
                return LootTables.field_186405_M;
            }
            case MAGENTA: {
                return LootTables.field_186406_N;
            }
            case LIGHT_BLUE: {
                return LootTables.field_186407_O;
            }
            case YELLOW: {
                return LootTables.field_186408_P;
            }
            case LIME: {
                return LootTables.field_186409_Q;
            }
            case PINK: {
                return LootTables.field_186410_R;
            }
            case GRAY: {
                return LootTables.field_186411_S;
            }
            case LIGHT_GRAY: {
                return LootTables.field_197738_Y;
            }
            case CYAN: {
                return LootTables.field_186413_U;
            }
            case PURPLE: {
                return LootTables.field_186414_V;
            }
            case BLUE: {
                return LootTables.field_186415_W;
            }
            case BROWN: {
                return LootTables.field_186416_X;
            }
            case GREEN: {
                return LootTables.field_186417_Y;
            }
            case RED: {
                return LootTables.field_186418_Z;
            }
            case BLACK: 
        }
        return LootTables.field_186376_aa;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.field_70899_e = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70894_j(float p_70894_1_) {
        if (this.field_70899_e <= 0) {
            return 0.0f;
        }
        if (this.field_70899_e >= 4 && this.field_70899_e <= 36) {
            return 1.0f;
        }
        return this.field_70899_e < 4 ? ((float)this.field_70899_e - p_70894_1_) / 4.0f : -((float)(this.field_70899_e - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70890_k(float p_70890_1_) {
        if (this.field_70899_e > 4 && this.field_70899_e <= 36) {
            float f = ((float)(this.field_70899_e - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.field_70899_e > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    @Override
    public void func_230263_a_(SoundCategory category) {
        this.field_70170_p.func_217384_a(null, (Entity)((Object)this), SoundEvents.field_187763_eJ, category, 1.0f, 1.0f);
        this.func_70893_e(true);
        int i = 1 + this.field_70146_Z.nextInt(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = this.func_199702_a(field_200206_bz.get((Object)this.func_175509_cj()), 1);
            if (itementity == null) continue;
            itementity.func_213317_d(itementity.func_213322_ci().func_72441_c((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f, this.field_70146_Z.nextFloat() * 0.05f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f));
        }
    }

    @Override
    public boolean func_230262_K__() {
        return this.func_70089_S() && !this.func_70892_o() && !this.func_70631_g_();
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Sheared", this.func_70892_o());
        compound.func_74774_a("Color", (byte)this.func_175509_cj().func_196059_a());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_70893_e(compound.func_74767_n("Sheared"));
        this.func_175512_b(DyeColor.func_196056_a(compound.func_74771_c("Color")));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public DyeColor func_175509_cj() {
        return DyeColor.func_196056_a(this.field_70180_af.func_187225_a(field_184774_bv) & 0xF);
    }

    public void func_175512_b(DyeColor color) {
        byte b0 = this.field_70180_af.func_187225_a(field_184774_bv);
        this.field_70180_af.func_187227_b(field_184774_bv, (byte)(b0 & 0xF0 | color.func_196059_a() & 0xF));
    }

    public boolean func_70892_o() {
        return (this.field_70180_af.func_187225_a(field_184774_bv) & 0x10) != 0;
    }

    public void func_70893_e(boolean sheared) {
        byte b0 = this.field_70180_af.func_187225_a(field_184774_bv);
        if (sheared) {
            this.field_70180_af.func_187227_b(field_184774_bv, (byte)(b0 | 0x10));
        } else {
            this.field_70180_af.func_187227_b(field_184774_bv, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    public static DyeColor func_175510_a(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return DyeColor.BLACK;
        }
        if (i < 10) {
            return DyeColor.GRAY;
        }
        if (i < 15) {
            return DyeColor.LIGHT_GRAY;
        }
        if (i < 18) {
            return DyeColor.BROWN;
        }
        return random.nextInt(500) == 0 ? DyeColor.PINK : DyeColor.WHITE;
    }

    public SheepEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        SheepEntity sheepentity = (SheepEntity)p_241840_2_;
        SheepEntity sheepentity1 = EntityType.field_200737_ac.func_200721_a(p_241840_1_);
        sheepentity1.func_175512_b(this.func_175511_a(this, sheepentity));
        return sheepentity1;
    }

    public void func_70615_aA() {
        this.func_70893_e(false);
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_175512_b(SheepEntity.func_175510_a(worldIn.func_201674_k()));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private DyeColor func_175511_a(AnimalEntity father, AnimalEntity mother) {
        DyeColor dyecolor = ((SheepEntity)father).func_175509_cj();
        DyeColor dyecolor1 = ((SheepEntity)mother).func_175509_cj();
        CraftingInventory craftinginventory = SheepEntity.func_213611_a(dyecolor, dyecolor1);
        return this.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, craftinginventory, this.field_70170_p).map(p_213614_1_ -> p_213614_1_.func_77572_b((IInventory)craftinginventory)).map(ItemStack::func_77973_b).filter(DyeItem.class::isInstance).map(DyeItem.class::cast).map(DyeItem::func_195962_g).orElseGet(() -> this.field_70170_p.field_73012_v.nextBoolean() ? dyecolor : dyecolor1);
    }

    private static CraftingInventory func_213611_a(DyeColor color, DyeColor color1) {
        CraftingInventory craftinginventory = new CraftingInventory(new Container((ContainerType)null, -1){

            @Override
            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, 2, 1);
        craftinginventory.func_70299_a(0, new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)color)));
        craftinginventory.func_70299_a(1, new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)color1)));
        return craftinginventory;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.95f * sizeIn.field_220316_b;
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return this.func_230262_K__();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)((Object)this), SoundEvents.field_187763_eJ, player == null ? SoundCategory.BLOCKS : SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            this.func_70893_e(true);
            int i = 1 + this.field_70146_Z.nextInt(3);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < i; ++j) {
                items.add(new ItemStack(field_200206_bz.get((Object)this.func_175509_cj())));
            }
            return items;
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void lambda$func_230254_b_$2(Hand p_230254_2_, PlayerEntity p_213613_1_) {
        p_213613_1_.func_213334_d(p_230254_2_);
    }
}

