/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.model.ShulkerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.BannerTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.BedTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.BellTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.CampfireTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ChestTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ConduitTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EnchantmentTableTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EndGatewayTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EndPortalTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.LecternTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.MobSpawnerTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.PistonTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ShulkerBoxTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.SignTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.StructureTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityRendererDispatcher {
    private final Map<TileEntityType<?>, TileEntityRenderer<?>> field_147559_m = Maps.newHashMap();
    public static final TileEntityRendererDispatcher field_147556_a = new TileEntityRendererDispatcher();
    private final BufferBuilder field_228849_g_ = new BufferBuilder(256);
    public FontRenderer field_147557_n;
    public TextureManager field_147553_e;
    public World field_147550_f;
    public ActiveRenderInfo field_217666_g;
    public RayTraceResult field_190057_j;

    private TileEntityRendererDispatcher() {
        this.func_228854_a_((TileEntityType)TileEntityType.field_200978_i, (TileEntityRenderer)new SignTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_200979_j, (TileEntityRenderer)new MobSpawnerTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200980_k, new PistonTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200972_c, new ChestTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200974_e, new ChestTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200973_d, new ChestTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_200982_m, (TileEntityRenderer)new EnchantmentTableTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_222485_C, (TileEntityRenderer)new LecternTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_200983_n, (TileEntityRenderer)new EndPortalTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_200991_v, (TileEntityRenderer)new EndGatewayTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_200984_o, (TileEntityRenderer)new BeaconTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_200985_p, (TileEntityRenderer)new SkullTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_200989_t, (TileEntityRenderer)new BannerTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_200990_u, (TileEntityRenderer)new StructureTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_200993_x, (TileEntityRenderer)new ShulkerBoxTileEntityRenderer(new ShulkerModel(), this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_200994_y, (TileEntityRenderer)new BedTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_205166_z, (TileEntityRenderer)new ConduitTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_222486_D, (TileEntityRenderer)new BellTileEntityRenderer(this));
        this.func_228854_a_((TileEntityType)TileEntityType.field_222488_F, (TileEntityRenderer)new CampfireTileEntityRenderer(this));
    }

    private <E extends TileEntity> void func_228854_a_(TileEntityType<E> typeIn, TileEntityRenderer<E> rendererIn) {
        this.field_147559_m.put(typeIn, rendererIn);
    }

    @Nullable
    public <E extends TileEntity> TileEntityRenderer<E> func_147547_b(E tileEntityIn) {
        return this.field_147559_m.get(tileEntityIn.func_200662_C());
    }

    public void func_217665_a(World worldIn, TextureManager textureManagerIn, FontRenderer fontRendererIn, ActiveRenderInfo activeRenderInfoIn, RayTraceResult rayTraceResultIn) {
        if (this.field_147550_f != worldIn) {
            this.func_147543_a(worldIn);
        }
        this.field_147553_e = textureManagerIn;
        this.field_217666_g = activeRenderInfoIn;
        this.field_147557_n = fontRendererIn;
        this.field_190057_j = rayTraceResultIn;
    }

    public <E extends TileEntity> void func_228850_a_(E tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        TileEntityRenderer tileentityrenderer;
        if (Vector3d.func_237489_a_((Vector3i)tileEntityIn.func_174877_v()).func_237488_a_(this.field_217666_g.func_216785_c(), tileEntityIn.func_145833_n()) && (tileentityrenderer = this.func_147547_b(tileEntityIn)) != null && tileEntityIn.func_145830_o() && tileEntityIn.func_200662_C().func_223045_a(tileEntityIn.func_195044_w().func_177230_c())) {
            TileEntityRendererDispatcher.func_228853_a_(tileEntityIn, () -> TileEntityRendererDispatcher.func_228855_a_(tileentityrenderer, tileEntityIn, partialTicks, matrixStackIn, bufferIn));
        }
    }

    private static <T extends TileEntity> void func_228855_a_(TileEntityRenderer<T> rendererIn, T tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        World world = tileEntityIn.func_145831_w();
        int i = world != null ? WorldRenderer.func_228421_a_((IBlockDisplayReader)world, tileEntityIn.func_174877_v()) : 0xF000F0;
        rendererIn.func_225616_a_(tileEntityIn, partialTicks, matrixStackIn, bufferIn, i, OverlayTexture.field_229196_a_);
    }

    public <E extends TileEntity> boolean func_228852_a_(E tileEntityIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        TileEntityRenderer tileentityrenderer = this.func_147547_b(tileEntityIn);
        if (tileentityrenderer == null) {
            return true;
        }
        TileEntityRendererDispatcher.func_228853_a_(tileEntityIn, () -> tileentityrenderer.func_225616_a_(tileEntityIn, 0.0f, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn));
        return false;
    }

    private static void func_228853_a_(TileEntity tileEntityIn, Runnable runnableIn) {
        try {
            runnableIn.run();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Rendering Block Entity");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block Entity Details");
            tileEntityIn.func_145828_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    public void func_147543_a(@Nullable World worldIn) {
        this.field_147550_f = worldIn;
        if (worldIn == null) {
            this.field_217666_g = null;
        }
    }

    public FontRenderer func_147548_a() {
        return this.field_147557_n;
    }

    public synchronized <T extends TileEntity> void setSpecialRendererInternal(TileEntityType<T> tileEntityType, TileEntityRenderer<? super T> specialRenderer) {
        this.field_147559_m.put(tileEntityType, specialRenderer);
    }
}

