/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalSize;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NetherPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> field_176550_a = BlockStateProperties.field_208199_z;
    protected static final VoxelShape field_185683_b = Block.func_208617_a(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape field_185684_c = Block.func_208617_a(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);

    public NetherPortalBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176550_a, (Comparable)((Object)Direction.Axis.X))));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)((Object)state.func_177229_b((Property)field_176550_a))) {
            case Z: {
                return field_185684_c;
            }
        }
        return field_185683_b;
    }

    @Override
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (worldIn.func_230315_m_().func_236043_f_() && worldIn.func_82736_K().func_223586_b(GameRules.field_223601_d) && random.nextInt(2000) < worldIn.func_175659_aa().func_151525_a()) {
            ZombifiedPiglinEntity entity;
            while (worldIn.func_180495_p(pos).func_203425_a(this)) {
                pos = pos.func_177977_b();
            }
            if (worldIn.func_180495_p(pos).func_215688_a((IBlockReader)((Object)worldIn), pos, EntityType.field_233592_ba_) && (entity = EntityType.field_233592_ba_.func_220342_a(worldIn, null, null, null, pos.func_177984_a(), SpawnReason.STRUCTURE, false, false)) != null) {
                ((Entity)((Object)entity)).func_242279_ag();
            }
        }
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.func_176740_k();
        Direction.Axis direction$axis1 = (Direction.Axis)((Object)stateIn.func_177229_b((Property)field_176550_a));
        boolean flag = direction$axis1 != direction$axis && direction$axis.func_176722_c();
        return !flag && !facingState.func_203425_a(this) && !new PortalSize(worldIn, currentPos, direction$axis1).func_208508_f() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU()) {
            entityIn.func_181015_d(pos);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble();
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (!worldIn.func_180495_p(pos.func_177976_e()).func_203425_a(this) && !worldIn.func_180495_p(pos.func_177974_f()).func_203425_a(this)) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
        }
    }

    @Override
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)((Object)state.func_177229_b((Property)field_176550_a))) {
                    case Z: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176550_a, (Comparable)((Object)Direction.Axis.X)));
                    }
                    case X: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176550_a, (Comparable)((Object)Direction.Axis.Z)));
                    }
                }
                return state;
            }
        }
        return state;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176550_a});
    }
}

