/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractPlantBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public abstract class AbstractTopPlantBlock
extends AbstractPlantBlock
implements IGrowable {
    public static final IntegerProperty field_235502_d_ = BlockStateProperties.field_208172_Y;
    private final double field_235503_e_;

    protected AbstractTopPlantBlock(AbstractBlock.Properties properties, Direction direction, VoxelShape shape, boolean waterloggable, double growthChance) {
        super(properties, direction, shape, waterloggable);
        this.field_235503_e_ = growthChance;
        this.func_180632_j((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_235502_d_, Integer.valueOf(0))));
    }

    public BlockState func_235504_a_(IWorld world) {
        return (BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_235502_d_, Integer.valueOf(world.func_201674_k().nextInt(25))));
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)field_235502_d_) < 25;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        BlockPos blockpos;
        if ((Integer)state.func_177229_b((Property)field_235502_d_) < 25 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos.func_177972_a(this.field_235498_a_), (BlockState)worldIn.func_180495_p(pos.func_177972_a(this.field_235498_a_)), (random.nextDouble() < this.field_235503_e_ ? 1 : 0) != 0) && this.func_230334_h_(worldIn.func_180495_p(blockpos = pos.func_177972_a(this.field_235498_a_)))) {
            worldIn.func_175656_a(blockpos, (BlockState)((Object)state.func_235896_a_((Property)field_235502_d_)));
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)blockpos, (BlockState)worldIn.func_180495_p(blockpos));
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == this.field_235498_a_.func_176734_d() && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        if (facing != this.field_235498_a_ || !facingState.func_203425_a((Block)((Object)this)) && !facingState.func_203425_a(this.func_230330_d_())) {
            if (this.field_235499_b_) {
                worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            }
            return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return this.func_230330_d_().func_176223_P();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_235502_d_});
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return this.func_230334_h_(worldIn.func_180495_p(pos.func_177972_a(this.field_235498_a_)));
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.func_177972_a(this.field_235498_a_);
        int i = Math.min((Integer)state.func_177229_b((Property)field_235502_d_) + 1, 25);
        int j = this.func_230332_a_(rand);
        for (int k = 0; k < j && this.func_230334_h_(worldIn.func_180495_p(blockpos)); ++k) {
            worldIn.func_175656_a(blockpos, (BlockState)((Object)state.func_206870_a((Property)field_235502_d_, Integer.valueOf(i))));
            blockpos = blockpos.func_177972_a(this.field_235498_a_);
            i = Math.min(i + 1, 25);
        }
    }

    protected abstract int func_230332_a_(Random var1);

    protected abstract boolean func_230334_h_(BlockState var1);

    protected AbstractTopPlantBlock func_230331_c_() {
        return this;
    }
}

