/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.PortalSize;
import net.minecraft.block.SoulFireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractFireBlock
extends Block {
    private final float field_235325_g_;
    protected static final VoxelShape field_235320_b_ = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);

    public AbstractFireBlock(AbstractBlock.Properties properties, float fireDamage) {
        super(properties);
        this.field_235325_g_ = fireDamage;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return AbstractFireBlock.func_235326_a_((IBlockReader)((Object)context.func_195991_k()), context.func_195995_a());
    }

    public static BlockState func_235326_a_(IBlockReader reader, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = reader.func_180495_p(blockpos);
        return SoulFireBlock.func_235577_c_((Block)blockstate.func_177230_c()) ? Blocks.field_235335_bO_.func_176223_P() : ((FireBlock)Blocks.field_150480_ab).func_196448_a(reader, pos);
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return field_235320_b_;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        block12: {
            block11: {
                BlockPos blockpos;
                BlockState blockstate;
                if (rand.nextInt(24) == 0) {
                    worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
                }
                if (this.func_196446_i(blockstate = worldIn.func_180495_p(blockpos = pos.func_177977_b())) || blockstate.func_224755_d((IBlockReader)((Object)worldIn), blockpos, Direction.UP)) break block11;
                if (this.func_196446_i(worldIn.func_180495_p(pos.func_177976_e()))) {
                    for (int j = 0; j < 2; ++j) {
                        double d3 = (double)pos.func_177958_n() + rand.nextDouble() * (double)0.1f;
                        double d8 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d13 = (double)pos.func_177952_p() + rand.nextDouble();
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d3, d8, d13, 0.0, 0.0, 0.0);
                    }
                }
                if (this.func_196446_i(worldIn.func_180495_p(pos.func_177974_f()))) {
                    for (int k = 0; k < 2; ++k) {
                        double d4 = (double)(pos.func_177958_n() + 1) - rand.nextDouble() * (double)0.1f;
                        double d9 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d14 = (double)pos.func_177952_p() + rand.nextDouble();
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d4, d9, d14, 0.0, 0.0, 0.0);
                    }
                }
                if (this.func_196446_i(worldIn.func_180495_p(pos.func_177978_c()))) {
                    for (int l = 0; l < 2; ++l) {
                        double d5 = (double)pos.func_177958_n() + rand.nextDouble();
                        double d10 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d15 = (double)pos.func_177952_p() + rand.nextDouble() * (double)0.1f;
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d5, d10, d15, 0.0, 0.0, 0.0);
                    }
                }
                if (this.func_196446_i(worldIn.func_180495_p(pos.func_177968_d()))) {
                    for (int i1 = 0; i1 < 2; ++i1) {
                        double d6 = (double)pos.func_177958_n() + rand.nextDouble();
                        double d11 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d16 = (double)(pos.func_177952_p() + 1) - rand.nextDouble() * (double)0.1f;
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d6, d11, d16, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.func_196446_i(worldIn.func_180495_p(pos.func_177984_a()))) break block12;
                for (int j1 = 0; j1 < 2; ++j1) {
                    double d7 = (double)pos.func_177958_n() + rand.nextDouble();
                    double d12 = (double)(pos.func_177956_o() + 1) - rand.nextDouble() * (double)0.1f;
                    double d17 = (double)pos.func_177952_p() + rand.nextDouble();
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d7, d12, d17, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)pos.func_177958_n() + rand.nextDouble();
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pos.func_177952_p() + rand.nextDouble();
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected abstract boolean func_196446_i(BlockState var1);

    @Override
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_230279_az_()) {
            entityIn.func_241209_g_(entityIn.func_223314_ad() + 1);
            if (entityIn.func_223314_ad() == 0) {
                entityIn.func_70015_d(8);
            }
            entityIn.func_70097_a(DamageSource.field_76372_a, this.field_235325_g_);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c())) {
            if (AbstractFireBlock.func_242649_a(worldIn)) {
                Optional optional = PortalSize.func_242964_a(worldIn, pos, Direction.Axis.X);
                if ((optional = ForgeEventFactory.onTrySpawnPortal((IWorld)worldIn, (BlockPos)pos, optional)).isPresent()) {
                    ((PortalSize)optional.get()).func_150859_c();
                    return;
                }
            }
            if (!state.func_196955_c((IWorldReader)((Object)worldIn), pos)) {
                worldIn.func_217377_a(pos, false);
            }
        }
    }

    private static boolean func_242649_a(World world) {
        return world.func_234923_W_() == World.field_234918_g_ || world.func_234923_W_() == World.field_234919_h_;
    }

    @Override
    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.func_201670_d()) {
            worldIn.func_217378_a(null, 1009, pos, 0);
        }
    }

    public static boolean func_241465_a_(World world, BlockPos pos, Direction direction) {
        BlockState blockstate = world.func_180495_p(pos);
        if (!blockstate.func_196958_f()) {
            return false;
        }
        return AbstractFireBlock.func_235326_a_((IBlockReader)((Object)world), pos).func_196955_c((IWorldReader)((Object)world), pos) || AbstractFireBlock.func_241466_b_(world, pos, direction);
    }

    private static boolean func_241466_b_(World world, BlockPos pos, Direction directionIn) {
        if (!AbstractFireBlock.func_242649_a(world)) {
            return false;
        }
        BlockPos.Mutable blockpos$mutable = pos.func_239590_i_();
        boolean flag = false;
        for (Direction direction : Direction.values()) {
            if (!world.func_180495_p((BlockPos)blockpos$mutable.func_189533_g((Vector3i)pos).func_189536_c(direction)).func_203425_a(Blocks.field_150343_Z)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        Direction.Axis direction$axis = directionIn.func_176740_k().func_176722_c() ? directionIn.func_176735_f().func_176740_k() : Direction.Plane.HORIZONTAL.func_244803_b(world.field_73012_v);
        return PortalSize.func_242964_a(world, pos, direction$axis).isPresent();
    }
}

