/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.AdvancementLoadFix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementList {
    private static final Logger field_192091_a = LogManager.getLogger();
    private final Map<ResourceLocation, Advancement> field_192092_b = Maps.newHashMap();
    private final Set<Advancement> field_192093_c = Sets.newLinkedHashSet();
    private final Set<Advancement> field_192094_d = Sets.newLinkedHashSet();
    private IListener field_192095_e;

    @OnlyIn(value=Dist.CLIENT)
    private void func_192090_a(Advancement advancementIn) {
        for (Advancement advancement : advancementIn.func_192069_e()) {
            this.func_192090_a(advancement);
        }
        field_192091_a.info("Forgot about advancement {}", (Object)advancementIn.func_192067_g());
        this.field_192092_b.remove(advancementIn.func_192067_g());
        if (advancementIn.func_192070_b() == null) {
            this.field_192093_c.remove(advancementIn);
            if (this.field_192095_e != null) {
                this.field_192095_e.func_191928_b(advancementIn);
            }
        } else {
            this.field_192094_d.remove(advancementIn);
            if (this.field_192095_e != null) {
                this.field_192095_e.func_191929_d(advancementIn);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_192085_a(Set<ResourceLocation> ids) {
        for (ResourceLocation resourcelocation : ids) {
            Advancement advancement = this.field_192092_b.get(resourcelocation);
            if (advancement == null) {
                field_192091_a.warn("Told to remove advancement {} but I don't know what that is", (Object)resourcelocation);
                continue;
            }
            this.func_192090_a(advancement);
        }
    }

    public void func_192083_a(Map<ResourceLocation, Advancement.Builder> advancementsIn) {
        Function function = Functions.forMap(this.field_192092_b, (Object)null);
        while (!advancementsIn.isEmpty()) {
            boolean flag = false;
            Iterator<Map.Entry<ResourceLocation, Advancement.Builder>> iterator = advancementsIn.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, Advancement.Builder> entry = iterator.next();
                ResourceLocation resourcelocation = entry.getKey();
                Advancement.Builder advancement$builder = entry.getValue();
                if (!advancement$builder.func_192058_a((java.util.function.Function<ResourceLocation, Advancement>)function)) continue;
                Advancement advancement = advancement$builder.func_192056_a(resourcelocation);
                this.field_192092_b.put(resourcelocation, advancement);
                flag = true;
                iterator.remove();
                if (advancement.func_192070_b() == null) {
                    this.field_192093_c.add(advancement);
                    if (this.field_192095_e == null) continue;
                    this.field_192095_e.func_191931_a(advancement);
                    continue;
                }
                this.field_192094_d.add(advancement);
                if (this.field_192095_e == null) continue;
                this.field_192095_e.func_191932_c(advancement);
            }
            if (flag) continue;
            for (Map.Entry<ResourceLocation, Advancement.Builder> entry1 : advancementsIn.entrySet()) {
                field_192091_a.error("Couldn't load advancement {}: {}", (Object)entry1.getKey(), (Object)entry1.getValue());
            }
        }
        AdvancementLoadFix.buildSortedTrees(this.field_192093_c);
        field_192091_a.info("Loaded {} advancements", (Object)this.field_192092_b.size());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_192087_a() {
        this.field_192092_b.clear();
        this.field_192093_c.clear();
        this.field_192094_d.clear();
        if (this.field_192095_e != null) {
            this.field_192095_e.func_191930_a();
        }
    }

    public Iterable<Advancement> func_192088_b() {
        return this.field_192093_c;
    }

    public Collection<Advancement> func_195651_c() {
        return this.field_192092_b.values();
    }

    @Nullable
    public Advancement func_192084_a(ResourceLocation id) {
        return this.field_192092_b.get(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_192086_a(@Nullable IListener listenerIn) {
        this.field_192095_e = listenerIn;
        if (listenerIn != null) {
            for (Advancement advancement : this.field_192093_c) {
                listenerIn.func_191931_a(advancement);
            }
            for (Advancement advancement1 : this.field_192094_d) {
                listenerIn.func_191932_c(advancement1);
            }
        }
    }

    public static interface IListener {
        public void func_191931_a(Advancement var1);

        @OnlyIn(value=Dist.CLIENT)
        public void func_191928_b(Advancement var1);

        public void func_191932_c(Advancement var1);

        @OnlyIn(value=Dist.CLIENT)
        public void func_191929_d(Advancement var1);

        @OnlyIn(value=Dist.CLIENT)
        public void func_191930_a();
    }
}

