/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class AbstractFurnaceTileEntity
extends LockableTileEntity
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    private static final int[] field_214015_g = new int[]{0};
    private static final int[] field_214016_h = new int[]{2, 1};
    private static final int[] field_214017_i = new int[]{1};
    protected NonNullList<ItemStack> field_214012_a = NonNullList.func_191197_a((int)3, (Object)((Object)ItemStack.field_190927_a));
    private int field_214018_j;
    private int field_214019_k;
    private int field_214020_l;
    private int field_214021_m;
    protected final IIntArray field_214013_b = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractFurnaceTileEntity.this.field_214018_j;
                }
                case 1: {
                    return AbstractFurnaceTileEntity.this.field_214019_k;
                }
                case 2: {
                    return AbstractFurnaceTileEntity.this.field_214020_l;
                }
                case 3: {
                    return AbstractFurnaceTileEntity.this.field_214021_m;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractFurnaceTileEntity.this.field_214018_j = value;
                    break;
                }
                case 1: {
                    AbstractFurnaceTileEntity.this.field_214019_k = value;
                    break;
                }
                case 2: {
                    AbstractFurnaceTileEntity.this.field_214020_l = value;
                    break;
                }
                case 3: {
                    AbstractFurnaceTileEntity.this.field_214021_m = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> field_214022_n = new Object2IntOpenHashMap();
    protected final IRecipeType<? extends AbstractCookingRecipe> field_214014_c;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected AbstractFurnaceTileEntity(TileEntityType<?> tileTypeIn, IRecipeType<? extends AbstractCookingRecipe> recipeTypeIn) {
        super(tileTypeIn);
        this.field_214014_c = recipeTypeIn;
    }

    @Deprecated
    public static Map<Item, Integer> func_214001_f() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_151129_at, 20000);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_150402_ci, 16000);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_151072_bj, 2400);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_151044_h, 1600);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_196155_l, 1600);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_200038_h, 300);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_199905_b, 300);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_202898_h, 300);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_202899_i, 150);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_212188_k, 300);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_202900_j, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_180407_aO, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_180404_aQ, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_180408_aP, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_180403_aR, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_180406_aS, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_180405_aT, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_180390_bo, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_180392_bq, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_180391_bp, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_180386_br, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_180385_bs, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_180387_bt, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_196586_al, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_150342_X, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_222428_lQ, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_150421_aI, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_150486_ae, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_150447_bR, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_150462_ai, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_150453_bW, 300);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_202901_n, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_151031_f, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_151112_aM, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_150468_ap, 300);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_219773_J, 200);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_151038_n, 200);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_151041_m, 200);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_151017_I, 200);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_151053_p, 200);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_151039_o, 200);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_200154_g, 200);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_202902_o, 1200);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_199904_a, 100);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_200153_d, 100);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_151055_y, 100);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_200037_g, 100);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_151054_z, 100);
        AbstractFurnaceTileEntity.func_213992_a(map, ItemTags.field_200035_e, 67);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_203216_jz, 4001);
        AbstractFurnaceTileEntity.func_213996_a(map, Items.field_222114_py, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_222405_kQ, 50);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_196555_aI, 100);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_222420_lI, 400);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_222421_lJ, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_222422_lK, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_222425_lN, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_222426_lO, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_222429_lR, 300);
        AbstractFurnaceTileEntity.func_213996_a(map, Blocks.field_222436_lZ, 300);
        return map;
    }

    private static boolean func_235644_b_(Item item) {
        return ItemTags.field_232905_P_.func_230235_a_(item);
    }

    private static void func_213992_a(Map<Item, Integer> map, ITag<Item> itemTag, int burnTimeIn) {
        for (Item item : itemTag.func_230236_b_()) {
            if (AbstractFurnaceTileEntity.func_235644_b_(item)) continue;
            map.put(item, burnTimeIn);
        }
    }

    private static void func_213996_a(Map<Item, Integer> map, IItemProvider itemProvider, int burnTimeIn) {
        Item item = itemProvider.func_199767_j();
        if (AbstractFurnaceTileEntity.func_235644_b_(item)) {
            if (SharedConstants.field_206244_b) {
                throw Util.func_229757_c_(new IllegalStateException("A developer tried to explicitly make fire resistant item " + item.func_200295_i(null).getString() + " a furnace fuel. That will not work!"));
            }
        } else {
            map.put(item, burnTimeIn);
        }
    }

    private boolean func_214006_r() {
        return this.field_214018_j > 0;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.field_214012_a = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)((Object)ItemStack.field_190927_a));
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.field_214012_a);
        this.field_214018_j = nbt.func_74762_e("BurnTime");
        this.field_214020_l = nbt.func_74762_e("CookTime");
        this.field_214021_m = nbt.func_74762_e("CookTimeTotal");
        this.field_214019_k = this.func_213997_a((ItemStack)((Object)this.field_214012_a.get(1)));
        CompoundNBT compoundnbt = nbt.func_74775_l("RecipesUsed");
        for (String s : compoundnbt.func_150296_c()) {
            this.field_214022_n.put((Object)new ResourceLocation(s), compoundnbt.func_74762_e(s));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.field_214018_j);
        compound.func_74768_a("CookTime", this.field_214020_l);
        compound.func_74768_a("CookTimeTotal", this.field_214021_m);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.field_214012_a);
        CompoundNBT compoundnbt = new CompoundNBT();
        this.field_214022_n.forEach((p_235643_1_, p_235643_2_) -> compoundnbt.func_74768_a(p_235643_1_.toString(), (int)p_235643_2_));
        compound.func_218657_a("RecipesUsed", compoundnbt);
        return compound;
    }

    public void func_73660_a() {
        boolean flag = this.func_214006_r();
        boolean flag1 = false;
        if (this.func_214006_r()) {
            --this.field_214018_j;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)((Object)this.field_214012_a.get(1));
            if (this.func_214006_r() || !itemstack.func_190926_b() && !((ItemStack)((Object)this.field_214012_a.get(0))).func_190926_b()) {
                IRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(this.field_214014_c, this, this.field_145850_b).orElse(null);
                if (!this.func_214006_r() && this.func_214008_b(irecipe)) {
                    this.field_214019_k = this.field_214018_j = this.func_213997_a(itemstack);
                    if (this.func_214006_r()) {
                        flag1 = true;
                        if (itemstack.hasContainerItem()) {
                            this.field_214012_a.set(1, (Object)itemstack.getContainerItem());
                        } else if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                this.field_214012_a.set(1, (Object)itemstack.getContainerItem());
                            }
                        }
                    }
                }
                if (this.func_214006_r() && this.func_214008_b(irecipe)) {
                    ++this.field_214020_l;
                    if (this.field_214020_l == this.field_214021_m) {
                        this.field_214020_l = 0;
                        this.field_214021_m = this.func_214005_h();
                        this.func_214007_c(irecipe);
                        flag1 = true;
                    }
                } else {
                    this.field_214020_l = 0;
                }
            } else if (!this.func_214006_r() && this.field_214020_l > 0) {
                this.field_214020_l = MathHelper.func_76125_a((int)(this.field_214020_l - 2), (int)0, (int)this.field_214021_m);
            }
            if (flag != this.func_214006_r()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, Boolean.valueOf(this.func_214006_r()))), 3);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    protected boolean func_214008_b(@Nullable IRecipe<?> recipeIn) {
        if (!((ItemStack)((Object)this.field_214012_a.get(0))).func_190926_b() && recipeIn != null) {
            ItemStack itemstack = recipeIn.func_77571_b();
            if (itemstack.func_190926_b()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)((Object)this.field_214012_a.get(2));
            if (itemstack1.func_190926_b()) {
                return true;
            }
            if (!itemstack1.func_77969_a(itemstack)) {
                return false;
            }
            if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
                return true;
            }
            return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
        }
        return false;
    }

    private void func_214007_c(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.func_214008_b(recipe)) {
            ItemStack itemstack = (ItemStack)((Object)this.field_214012_a.get(0));
            ItemStack itemstack1 = recipe.func_77571_b();
            ItemStack itemstack2 = (ItemStack)((Object)this.field_214012_a.get(2));
            if (itemstack2.func_190926_b()) {
                this.field_214012_a.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            if (itemstack.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !((ItemStack)((Object)this.field_214012_a.get(1))).func_190926_b() && ((ItemStack)((Object)this.field_214012_a.get(1))).func_77973_b() == Items.field_151133_ar) {
                this.field_214012_a.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    protected int func_213997_a(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        Item item = fuel.func_77973_b();
        return ForgeHooks.getBurnTime((ItemStack)fuel);
    }

    protected int func_214005_h() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.field_214014_c, this, this.field_145850_b).map(AbstractCookingRecipe::func_222137_e).orElse(200);
    }

    public static boolean func_213991_b(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack) > 0;
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return field_214016_h;
        }
        return side == Direction.UP ? field_214015_g : field_214017_i;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        Item item;
        return direction != Direction.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int func_70302_i_() {
        return this.field_214012_a.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.field_214012_a) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)((Object)this.field_214012_a.get(index));
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.field_214012_a, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.field_214012_a, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)((Object)this.field_214012_a.get(index));
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a(stack, itemstack);
        this.field_214012_a.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.field_214021_m = this.func_214005_h();
            this.field_214020_l = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)((Object)this.field_214012_a.get(1));
        return AbstractFurnaceTileEntity.func_213991_b(stack) || stack.func_77973_b() == Items.field_151133_ar && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    public void func_174888_l() {
        this.field_214012_a.clear();
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.func_199560_c();
            this.field_214022_n.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void func_201560_d(PlayerEntity player) {
    }

    public void func_235645_d_(PlayerEntity player) {
        List<IRecipe<?>> list = this.func_235640_a_(player.field_70170_p, player.func_213303_ch());
        player.func_195065_a(list);
        this.field_214022_n.clear();
    }

    public List<IRecipe<?>> func_235640_a_(World world, Vector3d pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.field_214022_n.object2IntEntrySet()) {
            world.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).ifPresent(p_235642_4_ -> {
                list.add(p_235642_4_);
                AbstractFurnaceTileEntity.func_235641_a_(world, pos, entry.getIntValue(), ((AbstractCookingRecipe)p_235642_4_).func_222138_b());
            });
        }
        return list;
    }

    private static void func_235641_a_(World world, Vector3d pos, int craftedAmount, float experience) {
        int i = MathHelper.func_76141_d((float)((float)craftedAmount * experience));
        float f = MathHelper.func_226164_h_((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrbEntity.func_70527_a(i);
            i -= j;
            world.func_217376_c(new ExperienceOrbEntity(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, j));
        }
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack itemstack : this.field_214012_a) {
            helper.func_194112_a(itemstack);
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

