/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientChunkProvider
extends AbstractChunkProvider {
    private static final Logger field_147436_a = LogManager.getLogger();
    private final Chunk field_73238_a;
    private final WorldLightManager field_217255_c;
    private volatile ChunkArray field_217256_d;
    private final ClientWorld field_73235_d;

    public ClientChunkProvider(ClientWorld clientWorldIn, int viewDistance) {
        this.field_73235_d = clientWorldIn;
        this.field_73238_a = new EmptyChunk((World)clientWorldIn, new ChunkPos(0, 0));
        this.field_217255_c = new WorldLightManager((IChunkLightProvider)this, true, clientWorldIn.func_230315_m_().func_218272_d());
        this.field_217256_d = new ChunkArray(ClientChunkProvider.func_217254_b(viewDistance));
    }

    public WorldLightManager func_212863_j_() {
        return this.field_217255_c;
    }

    private static boolean func_217249_a(@Nullable Chunk chunkIn, int x, int z) {
        if (chunkIn == null) {
            return false;
        }
        ChunkPos chunkpos = chunkIn.func_76632_l();
        return chunkpos.field_77276_a == x && chunkpos.field_77275_b == z;
    }

    public void func_73234_b(int x, int z) {
        int i;
        Chunk chunk;
        if (this.field_217256_d.func_217183_b(x, z) && ClientChunkProvider.func_217249_a(chunk = this.field_217256_d.func_217192_a(i = this.field_217256_d.func_217191_a(x, z)), x, z)) {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((IChunk)chunk));
            this.field_217256_d.func_217190_a(i, chunk, null);
        }
    }

    @Nullable
    public Chunk func_212849_a_(int chunkX, int chunkZ, ChunkStatus requiredStatus, boolean load) {
        Chunk chunk;
        if (this.field_217256_d.func_217183_b(chunkX, chunkZ) && ClientChunkProvider.func_217249_a(chunk = this.field_217256_d.func_217192_a(this.field_217256_d.func_217191_a(chunkX, chunkZ)), chunkX, chunkZ)) {
            return chunk;
        }
        return load ? this.field_73238_a : null;
    }

    public IBlockReader func_212864_k_() {
        return this.field_73235_d;
    }

    @Nullable
    public Chunk func_228313_a_(int chunkX, int chunkZ, @Nullable BiomeContainer biomeContainerIn, PacketBuffer packetIn, CompoundNBT nbtTagIn, int sizeIn, boolean p_228313_7_) {
        if (!this.field_217256_d.func_217183_b(chunkX, chunkZ)) {
            field_147436_a.warn("Ignoring chunk since it's not in the view range: {}, {}", (Object)chunkX, (Object)chunkZ);
            return null;
        }
        int i = this.field_217256_d.func_217191_a(chunkX, chunkZ);
        Chunk chunk = (Chunk)this.field_217256_d.field_217195_b.get(i);
        if (!p_228313_7_ && ClientChunkProvider.func_217249_a(chunk, chunkX, chunkZ)) {
            chunk.func_227073_a_(biomeContainerIn, packetIn, nbtTagIn, sizeIn);
        } else {
            if (biomeContainerIn == null) {
                field_147436_a.warn("Ignoring chunk since we don't have complete data: {}, {}", (Object)chunkX, (Object)chunkZ);
                return null;
            }
            chunk = new Chunk(this.field_73235_d, new ChunkPos(chunkX, chunkZ), biomeContainerIn);
            chunk.func_227073_a_(biomeContainerIn, packetIn, nbtTagIn, sizeIn);
            this.field_217256_d.func_217181_a(i, chunk);
        }
        ChunkSection[] achunksection = chunk.func_76587_i();
        WorldLightManager worldlightmanager = this.func_212863_j_();
        worldlightmanager.func_215571_a(new ChunkPos(chunkX, chunkZ), true);
        for (int j = 0; j < achunksection.length; ++j) {
            ChunkSection chunksection = achunksection[j];
            worldlightmanager.func_215566_a(SectionPos.func_218154_a((int)chunkX, (int)j, (int)chunkZ), ChunkSection.func_222628_a((ChunkSection)chunksection));
        }
        this.field_73235_d.func_228323_e_(chunkX, chunkZ);
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((IChunk)chunk));
        return chunk;
    }

    public void func_217207_a(BooleanSupplier hasTimeLeft) {
    }

    public void func_217251_d(int x, int z) {
        this.field_217256_d.field_217198_e = x;
        this.field_217256_d.field_217199_f = z;
    }

    public void func_217248_a(int viewDistance) {
        int j;
        int i = this.field_217256_d.field_217196_c;
        if (i != (j = ClientChunkProvider.func_217254_b(viewDistance))) {
            ChunkArray clientchunkprovider$chunkarray = new ChunkArray(j);
            clientchunkprovider$chunkarray.field_217198_e = this.field_217256_d.field_217198_e;
            clientchunkprovider$chunkarray.field_217199_f = this.field_217256_d.field_217199_f;
            for (int k = 0; k < this.field_217256_d.field_217195_b.length(); ++k) {
                Chunk chunk = (Chunk)this.field_217256_d.field_217195_b.get(k);
                if (chunk == null) continue;
                ChunkPos chunkpos = chunk.func_76632_l();
                if (!clientchunkprovider$chunkarray.func_217183_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) continue;
                clientchunkprovider$chunkarray.func_217181_a(clientchunkprovider$chunkarray.func_217191_a(chunkpos.field_77276_a, chunkpos.field_77275_b), chunk);
            }
            this.field_217256_d = clientchunkprovider$chunkarray;
        }
    }

    private static int func_217254_b(int p_217254_0_) {
        return Math.max(2, p_217254_0_) + 3;
    }

    public String func_73148_d() {
        return "Client Chunk Cache: " + this.field_217256_d.field_217195_b.length() + ", " + this.func_217252_g();
    }

    public int func_217252_g() {
        return this.field_217256_d.field_217200_g;
    }

    public void func_217201_a(LightType type, SectionPos pos) {
        Minecraft.func_71410_x().field_71438_f.func_215328_b(pos.func_218149_a(), pos.func_218163_b(), pos.func_218148_c());
    }

    public boolean func_222866_a(BlockPos pos) {
        return this.func_73149_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public boolean func_222865_a(ChunkPos pos) {
        return this.func_73149_a(pos.field_77276_a, pos.field_77275_b);
    }

    public boolean func_217204_a(Entity entityIn) {
        return this.func_73149_a(MathHelper.func_76128_c((double)entityIn.func_226277_ct_()) >> 4, MathHelper.func_76128_c((double)entityIn.func_226281_cx_()) >> 4);
    }

    @OnlyIn(value=Dist.CLIENT)
    final class ChunkArray {
        private final AtomicReferenceArray<Chunk> field_217195_b;
        private final int field_217196_c;
        private final int field_217197_d;
        private volatile int field_217198_e;
        private volatile int field_217199_f;
        private int field_217200_g;

        private ChunkArray(int viewDistanceIn) {
            this.field_217196_c = viewDistanceIn;
            this.field_217197_d = viewDistanceIn * 2 + 1;
            this.field_217195_b = new AtomicReferenceArray(this.field_217197_d * this.field_217197_d);
        }

        private int func_217191_a(int x, int z) {
            return Math.floorMod(z, this.field_217197_d) * this.field_217197_d + Math.floorMod(x, this.field_217197_d);
        }

        protected void func_217181_a(int chunkIndex, @Nullable Chunk chunkIn) {
            Chunk chunk = this.field_217195_b.getAndSet(chunkIndex, chunkIn);
            if (chunk != null) {
                --this.field_217200_g;
                ClientChunkProvider.this.field_73235_d.func_217409_a(chunk);
            }
            if (chunkIn != null) {
                ++this.field_217200_g;
            }
        }

        protected Chunk func_217190_a(int chunkIndex, Chunk chunkIn, @Nullable Chunk replaceWith) {
            if (this.field_217195_b.compareAndSet(chunkIndex, chunkIn, replaceWith) && replaceWith == null) {
                --this.field_217200_g;
            }
            ClientChunkProvider.this.field_73235_d.func_217409_a(chunkIn);
            return chunkIn;
        }

        private boolean func_217183_b(int x, int z) {
            return Math.abs(x - this.field_217198_e) <= this.field_217196_c && Math.abs(z - this.field_217199_f) <= this.field_217196_c;
        }

        @Nullable
        protected Chunk func_217192_a(int chunkIndex) {
            return this.field_217195_b.get(chunkIndex);
        }
    }
}

