/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.RealmsMainScreen;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.PreloadedTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class TextureManager
implements IFutureReloadListener,
ITickable,
AutoCloseable {
    private static final Logger field_147646_a = LogManager.getLogger();
    public static final ResourceLocation field_194008_a = new ResourceLocation("");
    private final Map<ResourceLocation, Texture> field_110585_a = Maps.newHashMap();
    private final Set<ITickable> field_110583_b = Sets.newHashSet();
    private final Map<String, Integer> field_110584_c = Maps.newHashMap();
    private final IResourceManager field_110582_d;

    public TextureManager(IResourceManager p_i1284_1_) {
        this.field_110582_d = p_i1284_1_;
    }

    public void func_110577_a(ResourceLocation p_110577_1_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_229269_d_(p_110577_1_));
        } else {
            this.func_229269_d_(p_110577_1_);
        }
    }

    private void func_229269_d_(ResourceLocation p_229269_1_) {
        Texture texture = this.field_110585_a.get(p_229269_1_);
        if (texture == null) {
            texture = new SimpleTexture(p_229269_1_);
            this.func_229263_a_(p_229269_1_, texture);
        }
        texture.func_229148_d_();
    }

    public void func_229263_a_(ResourceLocation p_229263_1_, Texture p_229263_2_) {
        Texture texture = this.field_110585_a.put(p_229263_1_, p_229263_2_ = this.func_230183_b_(p_229263_1_, p_229263_2_));
        if (texture != p_229263_2_) {
            if (texture != null && texture != MissingTextureSprite.func_195676_d()) {
                this.field_110583_b.remove(texture);
                this.func_243505_b(p_229263_1_, texture);
            }
            if (p_229263_2_ instanceof ITickable) {
                this.field_110583_b.add((ITickable)p_229263_2_);
            }
        }
    }

    private void func_243505_b(ResourceLocation p_243505_1_, Texture p_243505_2_) {
        if (p_243505_2_ != MissingTextureSprite.func_195676_d()) {
            try {
                p_243505_2_.close();
            }
            catch (Exception exception) {
                field_147646_a.warn("Failed to close texture {}", (Object)p_243505_1_, (Object)exception);
            }
        }
        p_243505_2_.func_147631_c();
    }

    private Texture func_230183_b_(ResourceLocation p_230183_1_, Texture p_230183_2_) {
        try {
            p_230183_2_.func_195413_a(this.field_110582_d);
            return p_230183_2_;
        }
        catch (IOException ioexception) {
            if (p_230183_1_ != field_194008_a) {
                field_147646_a.warn("Failed to load texture: {}", (Object)p_230183_1_, (Object)ioexception);
            }
            return MissingTextureSprite.func_195676_d();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Registering texture");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Resource location being registered");
            crashreportcategory.func_71507_a("Resource location", p_230183_1_);
            crashreportcategory.func_189529_a("Texture object class", (ICrashReportDetail<String>)((ICrashReportDetail)() -> p_230183_2_.getClass().getName()));
            throw new ReportedException(crashreport);
        }
    }

    @Nullable
    public Texture func_229267_b_(ResourceLocation p_229267_1_) {
        return this.field_110585_a.get(p_229267_1_);
    }

    public ResourceLocation func_110578_a(String p_110578_1_, DynamicTexture p_110578_2_) {
        Integer integer = this.field_110584_c.get(p_110578_1_);
        integer = integer == null ? Integer.valueOf(1) : Integer.valueOf(integer + 1);
        this.field_110584_c.put(p_110578_1_, integer);
        ResourceLocation resourcelocation = new ResourceLocation(String.format("dynamic/%s_%d", p_110578_1_, integer));
        this.func_229263_a_(resourcelocation, (Texture)p_110578_2_);
        return resourcelocation;
    }

    public CompletableFuture<Void> func_215268_a(ResourceLocation p_215268_1_, Executor p_215268_2_) {
        if (!this.field_110585_a.containsKey(p_215268_1_)) {
            PreloadedTexture preloadedtexture = new PreloadedTexture(this.field_110582_d, p_215268_1_, p_215268_2_);
            this.field_110585_a.put(p_215268_1_, (Texture)preloadedtexture);
            return preloadedtexture.func_215248_a().thenRunAsync(() -> this.func_229263_a_(p_215268_1_, (Texture)preloadedtexture), TextureManager::func_229262_a_);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static void func_229262_a_(Runnable p_229262_0_) {
        Minecraft.func_71410_x().execute(() -> RenderSystem.recordRenderCall(p_229262_0_::run));
    }

    public void func_110550_d() {
        for (ITickable itickable : this.field_110583_b) {
            itickable.func_110550_d();
        }
    }

    public void func_147645_c(ResourceLocation p_147645_1_) {
        Texture texture = this.func_229267_b_(p_147645_1_);
        if (texture != null) {
            this.field_110585_a.remove(p_147645_1_);
            TextureUtil.func_225679_a_((int)texture.func_110552_b());
        }
    }

    @Override
    public void close() {
        this.field_110585_a.forEach(this::func_243505_b);
        this.field_110585_a.clear();
        this.field_110583_b.clear();
        this.field_110584_c.clear();
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage p_215226_1_, IResourceManager p_215226_2_, IProfiler p_215226_3_, IProfiler p_215226_4_, Executor p_215226_5_, Executor p_215226_6_) {
        return ((CompletableFuture)CompletableFuture.allOf(MainMenuScreen.func_213097_a(this, p_215226_5_), this.func_215268_a(Widget.field_230687_i_, p_215226_5_)).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)p_215226_1_).func_216872_a(arg_0))).thenAcceptAsync(p_229265_3_ -> {
            MissingTextureSprite.func_195676_d();
            RealmsMainScreen.func_227932_a_((IResourceManager)this.field_110582_d);
            Iterator<Map.Entry<ResourceLocation, Texture>> iterator = this.field_110585_a.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, Texture> entry = iterator.next();
                ResourceLocation resourcelocation = entry.getKey();
                Texture texture = entry.getValue();
                if (texture == MissingTextureSprite.func_195676_d() && !resourcelocation.equals(MissingTextureSprite.func_195675_b())) {
                    iterator.remove();
                    continue;
                }
                texture.func_215244_a(this, p_215226_2_, resourcelocation, p_215226_6_);
            }
        }, p_229266_0_ -> RenderSystem.recordRenderCall(p_229266_0_::run));
    }
}

