/*
 * Decompiled with CFR 0.152.
 */
package org.multimc.onesix;

import java.applet.Applet;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.multimc.Launcher;
import org.multimc.LegacyFrame;
import org.multimc.NotFoundException;
import org.multimc.ParamBucket;
import org.multimc.Utils;

public class OneSixLauncher
implements Launcher {
    private List<String> libraries;
    private List<String> mcparams;
    private List<String> mods;
    private List<String> jarmods;
    private List<String> coremods;
    private List<String> traits;
    private String appletClass;
    private String mainClass;
    private String nativePath;
    private String userName;
    private String sessionId;
    private String windowTitle;
    private String windowParams;
    private String instanceTitle;
    private String instanceIconId;
    private int winSizeW;
    private int winSizeH;
    private boolean maximize;
    private String cwd;
    private String serverAddress;
    private String serverPort;
    private boolean useQuickPlay;
    private String joinWorld;
    private ClassLoader cl;

    private void processParams(ParamBucket paramBucket) throws NotFoundException {
        this.libraries = paramBucket.all("cp");
        this.mcparams = paramBucket.allSafe("param", new ArrayList<String>());
        this.mainClass = paramBucket.firstSafe("mainClass", "net.minecraft.client.Minecraft");
        this.appletClass = paramBucket.firstSafe("appletClass", "net.minecraft.client.MinecraftApplet");
        this.traits = paramBucket.allSafe("traits", new ArrayList<String>());
        this.nativePath = paramBucket.first("natives");
        this.userName = paramBucket.first("userName");
        this.sessionId = paramBucket.first("sessionId");
        this.windowTitle = paramBucket.firstSafe("windowTitle", "Minecraft");
        this.windowParams = paramBucket.firstSafe("windowParams", "854x480");
        this.instanceTitle = paramBucket.firstSafe("instanceTitle", "Minecraft");
        this.instanceIconId = paramBucket.firstSafe("instanceIconId", "default");
        System.setProperty("multimc.instance.title", this.instanceTitle);
        System.setProperty("multimc.instance.icon", this.instanceIconId);
        this.serverAddress = paramBucket.firstSafe("serverAddress", null);
        this.serverPort = paramBucket.firstSafe("serverPort", null);
        this.useQuickPlay = paramBucket.firstSafe("useQuickPlay").startsWith("1");
        this.joinWorld = paramBucket.firstSafe("joinWorld", null);
        this.cwd = System.getProperty("user.dir");
        this.winSizeW = 854;
        this.winSizeH = 480;
        this.maximize = false;
        String[] stringArray = this.windowParams.split("x");
        if (this.windowParams.equalsIgnoreCase("max")) {
            this.maximize = true;
        } else if (stringArray.length == 2) {
            try {
                this.winSizeW = Integer.parseInt(stringArray[0]);
                this.winSizeH = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    int legacyLaunch() {
        String[] stringArray;
        Class<?> clazz;
        try {
            clazz = this.cl.loadClass(this.mainClass);
            stringArray = Utils.getMCPathField(clazz);
            if (stringArray == null) {
                System.err.println("Could not find Minecraft path field.");
            } else {
                stringArray.setAccessible(true);
                stringArray.set(null, new File(this.cwd));
            }
        }
        catch (Exception exception) {
            System.err.println("Could not set base folder. Failed to find/access Minecraft main class:");
            exception.printStackTrace(System.err);
            return -1;
        }
        System.setProperty("minecraft.applet.TargetDirectory", this.cwd);
        if (!this.traits.contains("noapplet")) {
            Utils.log("Launching with applet wrapper...");
            try {
                stringArray = this.cl.loadClass(this.appletClass);
                Applet applet = (Applet)stringArray.newInstance();
                LegacyFrame legacyFrame = new LegacyFrame(this.windowTitle);
                legacyFrame.start(applet, this.userName, this.sessionId, this.winSizeW, this.winSizeH, this.maximize, this.serverAddress, this.serverPort);
                return 0;
            }
            catch (Exception exception) {
                Utils.log("Applet wrapper failed:", "Error");
                exception.printStackTrace(System.err);
                Utils.log();
                Utils.log("Falling back to using main class.");
            }
        }
        stringArray = this.mcparams.toArray(new String[this.mcparams.size()]);
        try {
            Method method = clazz.getMethod("main", String[].class);
            method.setAccessible(true);
            method.invoke(null, new Object[]{stringArray});
            return 0;
        }
        catch (Exception exception) {
            Utils.log("Failed to invoke the Minecraft main class:", "Fatal");
            (exception instanceof InvocationTargetException ? exception.getCause() : exception).printStackTrace(System.err);
            return -1;
        }
    }

    int launchWithMainClass() {
        Method method;
        Class<?> clazz;
        if (!this.maximize) {
            this.mcparams.add("--width");
            this.mcparams.add(Integer.toString(this.winSizeW));
            this.mcparams.add("--height");
            this.mcparams.add(Integer.toString(this.winSizeH));
        }
        if (this.joinWorld != null) {
            this.mcparams.add("--quickPlaySingleplayer");
            this.mcparams.add(this.joinWorld);
        }
        if (this.serverAddress != null) {
            if (this.useQuickPlay) {
                this.mcparams.add("--quickPlayMultiplayer");
                this.mcparams.add(this.serverAddress + ":" + this.serverPort);
            } else {
                this.mcparams.add("--server");
                this.mcparams.add(this.serverAddress);
                this.mcparams.add("--port");
                this.mcparams.add(this.serverPort);
            }
        }
        try {
            clazz = this.cl.loadClass(this.mainClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Failed to find Minecraft main class:");
            classNotFoundException.printStackTrace(System.err);
            return -1;
        }
        try {
            method = clazz.getMethod("main", String[].class);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            System.err.println("Failed to acquire the main method:");
            exception.printStackTrace(System.err);
            return -1;
        }
        String[] stringArray = this.mcparams.toArray(new String[this.mcparams.size()]);
        try {
            method.invoke(null, new Object[]{stringArray});
        }
        catch (Exception exception) {
            System.err.println("Failed to start Minecraft:");
            (exception instanceof InvocationTargetException ? exception.getCause() : exception).printStackTrace(System.err);
            return -1;
        }
        return 0;
    }

    @Override
    public int launch(ParamBucket paramBucket) {
        try {
            this.processParams(paramBucket);
        }
        catch (NotFoundException notFoundException) {
            System.err.println("Not enough arguments.");
            notFoundException.printStackTrace(System.err);
            return -1;
        }
        this.cl = ClassLoader.getSystemClassLoader();
        if (this.traits.contains("legacyLaunch") || this.traits.contains("alphaLaunch")) {
            return this.legacyLaunch();
        }
        return this.launchWithMainClass();
    }
}

