/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Objects;

final class LowLevelLogUtil {
    private static PrintWriter writer = new PrintWriter(System.err, true);

    public static void log(String message) {
        if (message != null) {
            writer.println(message);
        }
    }

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"}, justification="Log4j prints stacktraces only to logs, which should be private.")
    public static void logException(Throwable exception) {
        if (exception != null) {
            exception.printStackTrace(writer);
        }
    }

    public static void logException(String message, Throwable exception) {
        LowLevelLogUtil.log(message);
        LowLevelLogUtil.logException(exception);
    }

    public static void setOutputStream(OutputStream out) {
        writer = new PrintWriter(Objects.requireNonNull(out), true);
    }

    public static void setWriter(Writer writer) {
        LowLevelLogUtil.writer = new PrintWriter(Objects.requireNonNull(writer), true);
    }

    private LowLevelLogUtil() {
    }
}

