/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.game.minecraft.launchwrapper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.FormattedException;
import net.fabricmc.loader.impl.game.minecraft.MinecraftGameProvider;
import net.fabricmc.loader.impl.game.minecraft.launchwrapper.FabricClassTransformer;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.launch.FabricMixinBootstrap;
import net.fabricmc.loader.impl.util.Arguments;
import net.fabricmc.loader.impl.util.FileSystemUtil;
import net.fabricmc.loader.impl.util.LoaderUtil;
import net.fabricmc.loader.impl.util.ManifestUtil;
import net.fabricmc.loader.impl.util.UrlUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.Proxy;

public abstract class FabricTweaker
extends FabricLauncherBase
implements ITweaker {
    private static final LogCategory LOG_CATEGORY = LogCategory.create("GameProvider", "Tweaker");
    protected Arguments arguments;
    private LaunchClassLoader launchClassLoader;
    private final List<Path> classPath = new ArrayList<Path>();
    private boolean isDevelopment;
    private final boolean isPrimaryTweaker = ((List)Launch.blackboard.get("Tweaks")).isEmpty();

    @Override
    public String getEntrypoint() {
        return this.getLaunchTarget();
    }

    @Override
    public String getTargetNamespace() {
        return this.isDevelopment ? "named" : "intermediary";
    }

    public void acceptOptions(List<String> localArgs, File gameDir, File assetsDir, String profile) {
        this.arguments = new Arguments();
        this.arguments.parse(localArgs);
        if (!this.arguments.containsKey("gameDir") && gameDir != null) {
            this.arguments.put("gameDir", gameDir.getAbsolutePath());
        }
        if (this.getEnvironmentType() == EnvType.CLIENT && !this.arguments.containsKey("assetsDir") && assetsDir != null) {
            this.arguments.put("assetsDir", assetsDir.getAbsolutePath());
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader launchClassLoader) {
        this.isDevelopment = Boolean.parseBoolean(System.getProperty("fabric.development", "false"));
        Launch.blackboard.put("fabric.development", this.isDevelopment);
        FabricTweaker.setProperties(Launch.blackboard);
        this.launchClassLoader = launchClassLoader;
        launchClassLoader.addClassLoaderExclusion("org.objectweb.asm.");
        launchClassLoader.addClassLoaderExclusion("org.spongepowered.asm.");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.loader.");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.api.Environment");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.api.EnvType");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.api.ModInitializer");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.api.ClientModInitializer");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.api.DedicatedServerModInitializer");
        try {
            this.init();
        }
        catch (FormattedException e) {
            FabricTweaker.handleFormattedException(e);
        }
    }

    private void init() {
        FabricTweaker.setupUncaughtExceptionHandler();
        this.classPath.clear();
        for (URL url : this.launchClassLoader.getSources()) {
            Path path = UrlUtil.asPath(url);
            if (!Files.exists(path, new LinkOption[0])) continue;
            this.classPath.add(LoaderUtil.normalizeExistingPath(path));
        }
        MinecraftGameProvider provider = new MinecraftGameProvider();
        if (!provider.isEnabled() || !provider.locateGame(this, this.arguments.toArray())) {
            throw new RuntimeException("Could not locate Minecraft: provider locate failed");
        }
        Log.finishBuiltinConfig();
        this.arguments = null;
        provider.initialize(this);
        FabricLoaderImpl loader = FabricLoaderImpl.INSTANCE;
        loader.setGameProvider(provider);
        loader.load();
        loader.freeze();
        this.launchClassLoader.registerTransformer(FabricClassTransformer.class.getName());
        FabricLoaderImpl.INSTANCE.loadAccessWideners();
        MixinBootstrap.init();
        FabricMixinBootstrap.init(this.getEnvironmentType(), FabricLoaderImpl.INSTANCE);
        MixinEnvironment.getDefaultEnvironment().setSide(this.getEnvironmentType() == EnvType.CLIENT ? MixinEnvironment.Side.CLIENT : MixinEnvironment.Side.SERVER);
        provider.unlockClassPath(this);
        try {
            loader.invokeEntrypoints("preLaunch", PreLaunchEntrypoint.class, PreLaunchEntrypoint::onPreLaunch);
        }
        catch (RuntimeException e) {
            throw FormattedException.ofLocalized("exception.initializerFailure", e);
        }
    }

    public String[] getLaunchArguments() {
        return this.isPrimaryTweaker ? FabricLoaderImpl.INSTANCE.getGameProvider().getLaunchArguments(false) : new String[]{};
    }

    @Override
    public void addToClassPath(Path path, String ... allowedPrefixes) {
        try {
            this.launchClassLoader.addURL(UrlUtil.asUrl(path));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAllowedPrefixes(Path path, String ... prefixes) {
    }

    @Override
    public void setValidParentClassPath(Collection<Path> paths) {
    }

    @Override
    public List<Path> getClassPath() {
        return this.classPath;
    }

    @Override
    public boolean isClassLoaded(String name) {
        throw new RuntimeException("TODO isClassLoaded/launchwrapper");
    }

    @Override
    public Class<?> loadIntoTarget(String name) throws ClassNotFoundException {
        return this.launchClassLoader.loadClass(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.launchClassLoader.getResourceAsStream(name);
    }

    @Override
    public ClassLoader getTargetClassLoader() {
        return this.launchClassLoader;
    }

    @Override
    public byte[] getClassByteArray(String name, boolean runTransformers) throws IOException {
        String transformedName = name.replace('/', '.');
        byte[] classBytes = this.launchClassLoader.getClassBytes(name);
        if (runTransformers) {
            for (IClassTransformer transformer : this.launchClassLoader.getTransformers()) {
                if (transformer instanceof Proxy) continue;
                classBytes = transformer.transform(name, transformedName, classBytes);
            }
        }
        return classBytes;
    }

    @Override
    public Manifest getManifest(Path originPath) {
        Manifest manifest;
        block9: {
            if (Files.isDirectory(originPath, new LinkOption[0])) {
                return ManifestUtil.readManifest(originPath);
            }
            FileSystemUtil.FileSystemDelegate jarFs = FileSystemUtil.getJarFileSystem(originPath, false);
            try {
                manifest = ManifestUtil.readManifest(jarFs.get().getRootDirectories().iterator().next());
                if (jarFs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFs != null) {
                        try {
                            jarFs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.warn(LOG_CATEGORY, "Error reading Manifest", e);
                    return null;
                }
            }
            jarFs.close();
        }
        return manifest;
    }

    private void preloadRemappedJar(Path remappedJarFile) throws IOException {
        Map resourceCache = null;
        try {
            Field f = LaunchClassLoader.class.getDeclaredField("resourceCache");
            f.setAccessible(true);
            resourceCache = (Map)f.get(this.launchClassLoader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resourceCache == null) {
            Log.warn(LOG_CATEGORY, "Resource cache not pre-populated - this will probably cause issues...");
            return;
        }
        try (FileInputStream jarFileStream = new FileInputStream(remappedJarFile.toFile());
             JarInputStream jarStream = new JarInputStream(jarFileStream);){
            JarEntry entry;
            while ((entry = jarStream.getNextJarEntry()) != null) {
                if (entry.getName().startsWith("net/minecraft/class_") || !entry.getName().endsWith(".class")) continue;
                String className = entry.getName();
                className = className.substring(0, className.length() - 6).replace('/', '.');
                Log.debug(LOG_CATEGORY, "Appending %s to resource cache...", className);
                resourceCache.put(className, this.toByteArray(jarStream));
            }
        }
    }

    private byte[] toByteArray(InputStream inputStream) throws IOException {
        int len;
        int estimate = inputStream.available();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(estimate < 32 ? 32768 : estimate);
        byte[] buffer = new byte[8192];
        while ((len = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, len);
        }
        return outputStream.toByteArray();
    }

    @Override
    public boolean isDevelopment() {
        return this.isDevelopment;
    }
}

