/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Main {
    private static final Logger a = LogUtils.getLogger();

    /*
     * WARNING - void declaration
     */
    @ac(a="System.out needed before bootstrap")
    @DontObfuscate
    public static void main(String[] $$0) {
        ab.a();
        OptionParser $$1 = new OptionParser();
        OptionSpecBuilder $$2 = $$1.accepts("nogui");
        OptionSpecBuilder $$3 = $$1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder $$4 = $$1.accepts("demo");
        OptionSpecBuilder $$5 = $$1.accepts("bonusChest");
        OptionSpecBuilder $$6 = $$1.accepts("forceUpgrade");
        OptionSpecBuilder $$7 = $$1.accepts("eraseCache");
        OptionSpecBuilder $$8 = $$1.accepts("recreateRegionFiles");
        OptionSpecBuilder $$9 = $$1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec $$10 = $$1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$14 = $$1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder $$15 = $$1.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec $$16 = $$1.accepts("pidFile").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        NonOptionArgumentSpec $$17 = $$1.nonOptions();
        try {
            void $$45;
            Dynamic $$38;
            OptionSet $$18 = $$1.parse($$0);
            if ($$18.has((OptionSpec)$$10)) {
                $$1.printHelpOn((OutputStream)System.err);
                return;
            }
            Path $$19 = (Path)$$18.valueOf((OptionSpec)$$16);
            if ($$19 != null) {
                Main.a($$19);
            }
            o.g();
            if ($$18.has((OptionSpec)$$15)) {
                bpc.f.a(bpa.b);
            }
            akx.a();
            akx.c();
            af.p();
            Path $$20 = Paths.get("server.properties", new String[0]);
            apw $$21 = new apw($$20);
            $$21.b();
            eal.a($$21.a().M);
            Path $$22 = Paths.get("eula.txt", new String[0]);
            alb $$23 = new alb($$22);
            if ($$18.has((OptionSpec)$$3)) {
                a.info("Initialized '{}' and '{}'", (Object)$$20.toAbsolutePath(), (Object)$$22.toAbsolutePath());
                return;
            }
            if (!$$23.a()) {
                a.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File $$24 = new File((String)$$18.valueOf((OptionSpec)$$11));
            alq $$25 = alq.a(new YggdrasilAuthenticationService(Proxy.NO_PROXY), $$24);
            String $$26 = Optional.ofNullable((String)$$18.valueOf((OptionSpec)$$12)).orElse($$21.a().l);
            evg $$27 = evg.b($$24.toPath());
            evg.c $$28 = $$27.d($$26);
            if ($$28.m()) {
                void $$37;
                try {
                    Dynamic<?> $$29 = $$28.h();
                    evh $$30 = $$28.a($$29);
                }
                catch (IOException | ub | uh $$31) {
                    evg.b $$32 = $$28.e();
                    a.warn("Failed to load world data from {}", (Object)$$32.b(), (Object)$$31);
                    a.info("Attempting to use fallback");
                    try {
                        Dynamic<?> $$33 = $$28.i();
                        evh $$34 = $$28.a($$33);
                    }
                    catch (IOException | ub | uh $$35) {
                        a.error("Failed to load world data from {}", (Object)$$32.c(), (Object)$$35);
                        a.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)$$32.b(), (Object)$$32.c());
                        return;
                    }
                    $$28.n();
                }
                if ($$37.d()) {
                    a.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!$$37.r()) {
                    a.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                $$38 = null;
            }
            Dynamic $$39 = $$38;
            boolean $$40 = $$18.has((OptionSpec)$$9);
            if ($$40) {
                a.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            aua $$41 = aud.a($$28);
            try {
                alt.c $$42 = Main.a($$21.a(), $$39, $$40, $$41);
                alu $$43 = (alu)af.c(arg_0 -> Main.a($$42, $$39, $$18, (OptionSpec)$$4, $$21, (OptionSpec)$$5, arg_0)).get();
            }
            catch (Exception $$44) {
                a.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)$$44);
                return;
            }
            kf.b $$46 = $$45.c().a();
            boolean $$47 = $$18.has((OptionSpec)$$8);
            if ($$18.has((OptionSpec)$$6) || $$47) {
                Main.a($$28, bao.a(), $$18.has((OptionSpec)$$7), () -> true, $$46, $$47);
            }
            evm $$48 = $$45.d();
            $$28.a($$46, $$48);
            final apu $$49 = MinecraftServer.a(arg_0 -> Main.a($$28, $$41, (alu)$$45, $$21, $$25, $$18, (OptionSpec)$$13, (OptionSpec)$$4, (OptionSpec)$$14, (OptionSpec)$$2, (OptionSpec)$$17, arg_0));
            Thread $$50 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    $$49.a(true);
                }
            };
            $$50.setUncaughtExceptionHandler(new r(a));
            Runtime.getRuntime().addShutdownHook($$50);
        }
        catch (Exception $$51) {
            a.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)$$51);
        }
    }

    private static void a(Path $$0) {
        try {
            long $$1 = ProcessHandle.current().pid();
            Files.writeString($$0, (CharSequence)Long.toString($$1), new OpenOption[0]);
        }
        catch (IOException $$2) {
            throw new UncheckedIOException($$2);
        }
    }

    private static alt.c a(apv $$0, @Nullable Dynamic<?> $$1, boolean $$2, aua $$3) {
        dhg $$8;
        boolean $$7;
        if ($$1 != null) {
            dhg $$4 = evg.a($$1);
            boolean $$5 = false;
            dhg $$6 = $$4;
        } else {
            $$7 = true;
            $$8 = new dhg($$0.U, crw.h);
        }
        alt.d $$9 = new alt.d($$3, $$8, $$2, $$7);
        return new alt.c($$9, ey.a.b, $$0.A);
    }

    private static void a(evg.c $$0, DataFixer $$1, boolean $$2, BooleanSupplier $$3, kf $$4, boolean $$5) {
        a.info("Forcing world upgrade!");
        try (brz $$6 = new brz($$0, $$1, $$4, $$2, $$5);){
            wp $$7 = null;
            while (!$$6.b()) {
                int $$9;
                wp $$8 = $$6.h();
                if ($$7 != $$8) {
                    $$7 = $$8;
                    a.info($$6.h().getString());
                }
                if (($$9 = $$6.e()) > 0) {
                    int $$10 = $$6.f() + $$6.g();
                    a.info("{}% completed ({} / {} chunks)...", new Object[]{ayz.d((float)$$10 / (float)$$9 * 100.0f), $$10, $$9});
                }
                if (!$$3.getAsBoolean()) {
                    $$6.a();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static /* synthetic */ apu a(evg.c $$0, aua $$1, alu $$2, apw $$3, alq $$4, OptionSet $$5, OptionSpec $$6, OptionSpec $$7, OptionSpec $$8, OptionSpec $$9, OptionSpec $$10, Thread $$11) {
        boolean $$13;
        apu $$12 = new apu($$11, $$0, $$1, $$2, $$3, bao.a(), $$4, arp::b);
        $$12.a((Integer)$$5.valueOf($$6));
        $$12.c($$5.has($$7));
        $$12.b((String)$$5.valueOf($$8));
        boolean bl2 = $$13 = !$$5.has($$9) && !$$5.valuesOf($$10).contains("nogui");
        if ($$13 && !GraphicsEnvironment.isHeadless()) {
            $$12.bt();
        }
        return $$12;
    }

    private static /* synthetic */ CompletableFuture a(alt.c $$0, Dynamic $$1, OptionSet $$2, OptionSpec $$3, apw $$4, OptionSpec $$52, Executor $$6) {
        return alt.a($$0, $$5 -> {
            edo $$14;
            edr $$13;
            dgn $$12;
            ke<eau> $$6 = $$5.d().e(mc.bf);
            if ($$1 != null) {
                evd $$7 = evg.a($$1, $$5.b(), $$6, $$5.c());
                return new alt.b<evm>($$7.a(), $$7.b().b());
            }
            a.info("No existing world data, creating new world");
            if ($$2.has($$3)) {
                dgn $$8 = MinecraftServer.d;
                edr $$9 = edr.b;
                edo $$10 = end.a($$5.c());
            } else {
                apv $$11 = $$4.a();
                $$12 = new dgn($$11.l, $$11.k, $$11.t, $$11.j, false, new dgf($$5.b().b()), $$5.b());
                $$13 = $$2.has($$52) ? $$11.aa.a(true) : $$11.aa;
                $$14 = $$11.a($$5.c());
            }
            edo.b $$15 = $$14.a($$6);
            Lifecycle $$16 = $$15.a().add($$5.c().d());
            return new alt.b<evk>(new evk($$12, $$13, $$15.d(), $$16), $$15.b());
        }, alu::new, af.h(), $$6);
    }
}

