/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.datafixers.optics;

import com.google.common.reflect.TypeToken;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.App2;
import com.mojang.datafixers.kinds.K1;
import com.mojang.datafixers.kinds.K2;
import com.mojang.datafixers.optics.Optics;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public interface Optic<Proof extends K1, S, T, A, B> {
    public <P extends K2> Function<App2<P, A, B>, App2<P, S, T>> eval(App<? extends Proof, P> var1);

    default public <Proof2 extends Proof, A1, B1> Optic<Proof2, S, T, A1, B1> compose(Optic<? super Proof2, A, B, A1, B1> optic) {
        return this.composeUnchecked(optic);
    }

    default public <Proof2 extends K1, A1, B1> Optic<Proof2, S, T, A1, B1> composeUnchecked(Optic<?, A, B, A1, B1> optic) {
        if (Optics.isId(optic)) {
            return this;
        }
        if (Optics.isId(this)) {
            return optic;
        }
        return new CompositionOptic(this, optic);
    }

    default public <Proof2 extends K1> Optional<Optic<? super Proof2, S, T, A, B>> upCast(Set<TypeToken<? extends K1>> proofBounds, TypeToken<Proof2> proof) {
        if (proofBounds.stream().allMatch(bound -> bound.isSupertypeOf(proof))) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    public record CompositionOptic<Proof extends K1, S, T, A, B, A1, B1>(Optic<? super Proof, S, T, A, B> outer, Optic<? super Proof, A, B, A1, B1> inner) implements Optic<Proof, S, T, A1, B1>
    {
        @Override
        public <P extends K2> Function<App2<P, A1, B1>, App2<P, S, T>> eval(App<? extends Proof, P> proof) {
            return this.outer.eval(proof).compose(this.inner.eval(proof));
        }

        @Override
        public String toString() {
            return "(" + this.outer + " \u25e6 " + this.inner + ")";
        }
    }
}

