/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Environment;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public enum YggdrasilEnvironment {
    PROD("https://authserver.mojang.com", "https://api.mojang.com", "https://sessionserver.mojang.com", "https://api.minecraftservices.com"),
    STAGING("https://yggdrasil-auth-staging.mojang.com", "https://api-staging.mojang.com", "https://yggdrasil-auth-session-staging.mojang.zone", "https://api-staging.minecraftservices.com");

    private final Environment environment;

    private YggdrasilEnvironment(String authHost, String accountsHost, String sessionHost, String servicesHost) {
        this.environment = Environment.create(authHost, accountsHost, sessionHost, servicesHost, this.name());
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public static Optional<Environment> fromString(@Nullable String value) {
        return Stream.of(YggdrasilEnvironment.values()).filter(env -> value != null && value.equalsIgnoreCase(env.name())).findFirst().map(YggdrasilEnvironment::getEnvironment);
    }
}

